package rdcPanda;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

import Jampack.JampackException;


public class Loops
{
	//global variables for computing the loops:
	
	//for storing Ramachandran database information
	public Vector vecRamaAla=new Vector();
	public Vector vecRamaGeneral=new Vector();
	public Vector vecRamaPrePro=new Vector();
	public Vector vecRamaPro=new Vector();
	public Vector vecRamaGly=new Vector();
	public Random generator = new Random();
	
	public Vector vecSeq=new Vector();//for storing sequence information
	public Vector vecPdbSSE=new Vector(); //for storing the SSE PDB
	
	public double caliConstant=0.0; //constant for NOE distance calibration
	
	
	public Loops(){ }

	 
	/** 
     * compute the loop using a gradient search approach (like ccd.)
     * 
     @param src location of the input file
     @param strOut location of the output file
     @param strInput  input file name
     @return void
     */       
    public void doCalLoops(String src, String strOut, String strInput)throws JampackException
    {	    	 
    	boolean isDebug=true;
    	Hsqc hqc = new Hsqc();
    	Peak pk = new Peak();
    	
    	ModelRdc mdc = new ModelRdc();    	
    	Assign asg = new Assign();
    	long startTime = System.currentTimeMillis();
    	
    	//the path of rotamer library:
    	String userDir = System.getProperty("user.dir");////
    	String rotSrc= userDir+"/system/rot-lib/";
    	
    	String userDirTemp = System.getProperty("user.dir");////
    	
    	//read the Ramachandran data.
    	String strRamaAla=userDirTemp+"/system/rama_data/pct/rama/rama500-ala-nosec.data";
    	String strRamaGeneral=userDirTemp+"/system/rama_data/pct/rama/rama500-general-nosec.data";
    	String strRamaGly=userDirTemp+"/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
    	String strRamaPro=userDirTemp+"/system/rama_data/pct/rama/rama500-pro.data";
    	String strRamaPrePro=userDirTemp+"/system/rama_data/pct/rama/rama500-prepro.data";
    	vecRamaAla=ReadRamachandranFile(strRamaAla);
    	vecRamaGeneral=ReadRamachandranFile(strRamaGeneral);
    	vecRamaGly=ReadRamachandranFile(strRamaGly);
    	vecRamaPro=ReadRamachandranFile(strRamaPro);
    	vecRamaPrePro=ReadRamachandranFile(strRamaPrePro);
    	
    	/////////////////////////////////////////////
    	/// 1. Read the input files
    	//
    	/////////////////////////////////////////////
    	int i, j;    	
    	Pdb  pp = new Pdb();    	
    	Vector<Map<String, String>> paraVec = asg.ParamReader(src+strInput);
    	double haErr  = 0.0;
    	double h1Err  = 0.0;
    	double c13Err = 0.0;
    	double hnErr  = 0.0;
    	double nErr   = 0.0;
    	
    	int nIs4DNoesy=0;
	    	
    	String    strResNameScheme="",strIsCheckLongAA="",
    		 strBB="",stroutName="",strOutOrFormat="",strSSEBB="",
    		strIsCheck="",strRefPdb="",strRefNameSchem="",strIsWholeStr="",strPdbNameScheme="";
    	int nIsoriginalUp=0; 
    	double Syy=0.0,Szz=0.0,noeLimit=0.0,metCor=0.0;
    	
    	String strReson="",strResFormat="",strSeq="", strNoesy2D="",strHnNoesy3D="",strHaNoesy3D="",str4DNoesy="",
    		strNoesyFormat="",strSSEPDBFile="",strChFile="",strNhFile="",strOutPdb="";
    	
    	for (i=0;i<paraVec.size();i++)
    	{
    		//get the error tolerance for each dimension
    		Map paraMap = paraVec.elementAt(i);
    		if(paraMap.containsKey("HAERR"))
    			 haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
    		if(paraMap.containsKey("H1ERR"))
   			 	h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
    		if(paraMap.containsKey("C13ERR"))
    			c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
    		if(paraMap.containsKey("HNERR"))
    			hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
    		if(paraMap.containsKey("NERR"))
    			nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
    		
    		if(paraMap.containsKey("SEQUENCE"))////////
    			strSeq  =  (String)paraMap.get("SEQUENCE");
    		if(paraMap.containsKey("RESFORMAT"))
    			strResFormat  =  (String)paraMap.get("RESFORMAT");
    		if(paraMap.containsKey("RESONANCE"))
    			strReson  =  (String)paraMap.get("RESONANCE");
    		strReson=strReson.toLowerCase();
    		if(paraMap.containsKey("2D-NOESY"))
    			strNoesy2D  =  (String)paraMap.get("2D-NOESY");
    		
    		if(paraMap.containsKey("3D-N15-NOESY"))
    			strHnNoesy3D  =  (String)paraMap.get("3D-N15-NOESY");
    	
    		if(paraMap.containsKey("3D-C13-NOESY"))
    			strHaNoesy3D  =  (String)paraMap.get("3D-C13-NOESY");
    		
    		if(paraMap.containsKey("PDBNAMESCHEME"))
    			strPdbNameScheme  =  (String)paraMap.get("PDBNAMESCHEME");	
    		if(paraMap.containsKey("OUTNOENAME"))
    			stroutName  =  (String)paraMap.get("OUTNOENAME");   	
    		if(paraMap.containsKey("BACKBONE"))
    			strBB  =  (String)paraMap.get("BACKBONE");
    		if(paraMap.containsKey("SSEBB"))
    			strSSEBB  =  (String)paraMap.get("SSEBB");
    		
    		if(paraMap.containsKey("NOELIMIT"))
    			noeLimit  =  Double.parseDouble((String)paraMap.get("NOELIMIT"));
    		if(paraMap.containsKey("IS4DNOESY"))
    			nIs4DNoesy  =   Integer.parseInt((String)paraMap.get("IS4DNOESY"));
    		
    		if(paraMap.containsKey("4D-NOESY"))
    			str4DNoesy  =  (String)paraMap.get("4D-NOESY");
    		
    		if(paraMap.containsKey("ISORIGINALUP"))
    			nIsoriginalUp  =   Integer.parseInt((String)paraMap.get("ISORIGINALUP"));	
    		if(paraMap.containsKey("RESNAMESCHEME"))
    			strResNameScheme  =  (String)paraMap.get("RESNAMESCHEME");	
    		if(paraMap.containsKey("NOESY-FORMAT"))
    			strNoesyFormat  =  (String)paraMap.get("NOESY-FORMAT");   	
    		if(paraMap.containsKey("ISCHECKLONGAA"))
    			strIsCheckLongAA =  (String)paraMap.get("ISCHECKLONGAA"); 	
    		if(paraMap.containsKey("ISCHECK"))
    			strIsCheck  =  (String)paraMap.get("ISCHECK");   	
    		if(paraMap.containsKey("REFPDB"))
    			strRefPdb  =  (String)paraMap.get("REFPDB");  
    		if(paraMap.containsKey("METHYL-CORRECTION"))
    			metCor  =  Double.parseDouble((String)paraMap.get("METHYL-CORRECTION"));    		
    		if(paraMap.containsKey("REFNAMESCHEME"))
    			strRefNameSchem  =  (String)paraMap.get("REFNAMESCHEME");  
    		if(paraMap.containsKey("ISWHOLESTRUCTURE"))
    			strIsWholeStr  =  (String)paraMap.get("ISWHOLESTRUCTURE");  
    		if(paraMap.containsKey("ISOUTORFORMAT"))
    			strOutOrFormat  =  (String)paraMap.get("ISOUTORFORMAT");
    		
    		////////////////////////
    		if(paraMap.containsKey("SSES"))
    			strSSEPDBFile  =  (String)paraMap.get("SSES");  
    		if(paraMap.containsKey("SYY"))
    			Syy  =  Double.parseDouble((String)paraMap.get("SYY"));
    		if(paraMap.containsKey("SZZ"))
    			Szz  =  Double.parseDouble((String)paraMap.get("SZZ"));    	
    		if(paraMap.containsKey("CHFILE"))
    			strChFile  =  (String)paraMap.get("CHFILE"); 
    		if(paraMap.containsKey("NHFILE"))
    			strNhFile  =  (String)paraMap.get("NHFILE"); 
    		if(paraMap.containsKey("OUTPDBNAME"))
    			strOutPdb  =  (String)paraMap.get("OUTPDBNAME"); 
    	}   
    	
    	//-------------------------------------
    	// (1.1) Read the protein sequence
    	// 
    	//-------------------------------------	    	
    	String seqFile = src + strSeq;
    	//this is the vector of residues (protein sequence)
    	vecSeq=asg.ReaderSeq(seqFile);      	    	
    	
    	//read the sse pdb
    	String ssePdbFile = userDirTemp+strSSEPDBFile;
    	Vector vecPdbSSETemp = pp.readPdb(ssePdbFile);
    	Vector vecSSETemp2= pp.residueNameUpdateNoStr(vecSeq, vecPdbSSETemp); 
    	   	
    	//this.vecPdbSSE= pp.residueNameUpdateNoStr(vecSeq, vecPdbSSETemp); 
    	    	
    	//-------------------------------------
    	// (1.2) Read the resonance list 
    	// 
    	// in the "resonance.prot" format
    	//-------------------------------------
        	
    	//following is for the general case
    	H1CS h1CS=new H1CS();
    	   
    	String assignFile = src+ strReson; 
    	//this is the vector that stores resonance assignments;
    	//each one includes resNo, resName, atomName, csH1(chemical shift value)
    	Vector assignVec=new Vector();
    	if(strResFormat.equalsIgnoreCase("CYANA"))
    		assignVec=h1CS.h1CSReader(assignFile,vecSeq); 
    	else if(strResFormat.equalsIgnoreCase("BMRB"))
    		assignVec=h1CS.h1CSReader_BMRB(assignFile);  
    	else 
    	{
    		System.out.println("unknown format of the resonance file...");
    		System.exit(0);
    	}
    	
    	//all sorted proton resonances
    	Vector allH1Vec = pk.allProtonSorted(assignVec);
    	Collections.sort(allH1Vec, new Peak.csComparator()); 	    	
    	
    	//-------------------------------------
    	// (1.3) Read the NOESY peak list 
    	// in the xeasy format
    	// including 2D NOESY peak list, 3D N15 NOESY and 3D C13 NOESY peak lists
    	//-------------------------------------
    	Noesy noesy = new Noesy();
    	
    	String strNoeFile = ""; 
    	Vector hnNoeVec=new Vector();//for storing 3d n15 NOESY peaks
    	Vector cnoeVec=new Vector();//for storing 3d c13 noesy peaks
    	Vector Noe4DVec=new Vector();//for storing 4d NOESY peaks
    	if (!strNoesy2D.equalsIgnoreCase("NULL"))
    	{
    		//to do: extension to 2d case...
    	}
    	if (!strHnNoesy3D.equalsIgnoreCase("NULL"))
    	{
    		strNoeFile=src+strHnNoesy3D;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			hnNoeVec = noesy.NoesyReader(strNoeFile);
    		else
    			hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);    		
    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
    	
    	if (!strHaNoesy3D.equalsIgnoreCase("NULL"))
    	{
    		strNoeFile=src+strHaNoesy3D;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			cnoeVec = noesy.NoesyReader(strNoeFile);
    		else
    			cnoeVec=noesy.NoesyReaderNMRView(strNoeFile);
    	}
    	
    	//4D NOESY data
    	if (!( str4DNoesy.equalsIgnoreCase("NULL")|| str4DNoesy.equalsIgnoreCase("")) )
    	{
    		strNoeFile=src+str4DNoesy;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			Noe4DVec = noesy.NoesyReader(strNoeFile);// to be changed....
    		else
    			Noe4DVec = noesy.NoesyReaderNMRView4D(strNoeFile);    		
    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
    	
    	Vector vecNoesy=new Vector();
    	vecNoesy.addAll(hnNoeVec);
    	vecNoesy.addAll(cnoeVec);
    	
    	Vector vecNoesy4D=new Vector();
    	vecNoesy4D.addAll(Noe4DVec);//for 4D noesy   
    	
    	///////////////////////////////
    	//distance calibration
    	String pdbSSEFile = userDirTemp+strSSEPDBFile;
    	Vector vecSSE = pp.readPdb(pdbSSEFile);
    	double[] constant=new double[1];
    	//noesy.SetCalibrationN15(vecNoesy,vecSSE,assignVec,constant);
    	noesy.SetCalibrationN15(hnNoeVec,vecSSE,assignVec,constant);
    	this.caliConstant=constant[0];    	
    	///////////////////////////////    		
    	
    	////////////////////////////////////
    	//remove the diagonal NOESY peaks:
    	Vector vecNoesyNoDia=new Vector();
    	for (i=0;i< vecNoesy.size();i++)
    	{
    		Noesy noesy2=(Noesy)vecNoesy.elementAt(i);
    		double cs_h1=noesy2.getH1();
    		double cs_h2=noesy2.getH2();
    		    		    		
    		if (Math.abs(cs_h1-cs_h2)>0.01)//range from 0.01  to 0.05
    			vecNoesyNoDia.add(noesy2);    		
    		
    	}//for (i=0;i< vecNoesy.size();i++)
    	vecNoesy=new Vector();
    	vecNoesy.addAll(vecNoesyNoDia);    	
    	
    	//for 4D
    	vecNoesyNoDia=new Vector();
    	for (i=0;i< vecNoesy4D.size();i++)
    	{
    		Noesy noesy2=(Noesy)vecNoesy4D.elementAt(i);
    		double cs_h1=noesy2.getH1();
    		double cs_h2=noesy2.getH2();
    		double cs_heavy1=noesy2.getHeavy1();
    		double cs_heavy2=noesy2.getHeavy2();   		    		
    		if (Math.abs(cs_h1-cs_h2)>0.04 && Math.abs(cs_heavy1-cs_heavy2)>0.06)//range from 0.01  to 
    			vecNoesyNoDia.add(noesy2);    		
    		
    	}//for (i=0;i< vecNoesy.size();i++)
    	vecNoesy4D=new Vector();
    	vecNoesy4D.addAll(vecNoesyNoDia);   
    	
    	Vector vecNewNoesy=new Vector();    	
    	Vector vecNewNoesy4D=new Vector();	
    	
    	vecNewNoesy.addAll(vecNoesy);
    	vecNewNoesy4D.addAll(vecNoesy4D);
    	////////////////////////////////////
    	
    	//read the RDC data:
    	String strChRdcFile=src+strChFile;
    	String strNhRdcFile=src+strNhFile;
    	Dipolar dd  =  new Dipolar();
		final Vector<Dipolar> vecNhRdc = dd.rdcRead(strNhRdcFile,1.0);
		final Vector<Dipolar> vecChRdc = dd.rdcRead(strChRdcFile,1.0);
		
		//starting and ending residue no
		//this is for test, will be changed in future:
		int noStart=7;
		int noEnd=12;
		double csErrH=0.04;
		double csErrHeavy=0.2;
		
		
		
		//rotate the SSE pdb to let it fit the rdc data
    	double[] rdc1Cal = new double[vecSSETemp2.size()];
    	double[] rdc2Cal = new double[vecSSETemp2.size()];
    	double[] saupe = new double[4]; //for returning Saupe elements
    	PdbRdc pdr=new PdbRdc();
    	
    	Matrix mm = pdr.bestFit(vecSSETemp2, vecNhRdc, vecChRdc, rdc1Cal, rdc2Cal, saupe);
    	Vector<Pdb> vecSSE2 = pp.newPdb(vecSSETemp2, mm);
    	
    	Syy = saupe[0];
     	Szz = saupe[1];
     	//double Sxx=-Syy-Szz;
    	
    	 //add rotamers to the backbone:
	    Vector vecSSE2Rot=pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy,vecSSE2,assignVec,rotSrc,vecNoesy,
    			4.5, 1,this.caliConstant);
	    
	    this.vecPdbSSE=new Vector();
	    this.vecPdbSSE.addAll(vecSSE2Rot);	    	
	    	
		
		
		//coordinates of N, nh, ca of the starting residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 	
		int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator() );
		if (ind<0)
		{
			System.out.println("the starting residue not found...exist.");
			System.exit(0);		 
		}
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(ind);	
		Vector atomVecStart = pdbStart.getAtomVec();
		for (int k=0;k<atomVecStart.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)
    	    	
		boolean isSkipNOE=false;
    	//compute the loop fragments:
    	//Vector vecLoopFrag=calcFragment(Syy, Szz, vecChRdc, vecNhRdc, 
    		//	coordN, coordNH, coordCA, noStart,noEnd, vecNewNoesy, assignVec,
        	//	csErrH, csErrHeavy,isSkipNOE);
    	
    	
    	//for debugging:
    	//read the sse pdb
    	String ssePdbFileDebugging = userDirTemp+"/inputFiles/test.pdb";
    	Vector vecPdbdebug = pp.readPdb(ssePdbFileDebugging);
    	
    	
    	Vector vecFinal=IterativeGradientSearch( vecPdbdebug,Syy, Szz, vecChRdc,vecNhRdc, 
         		  noStart, noEnd,  vecNoesy,  assignVec, csErrH,  csErrHeavy, isSkipNOE);
    	
    	
    	
    	//write the new pdb file:
    	String fileName =strOut+strOutPdb;
    	try
    	{
    		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));    		    		   			
	    	pp.printToFile(vecFinal,fileName, out);		    	
	    	out.println("END");  
	    	out.close();
	    	
		}catch (FileNotFoundException e)
		{
			System.out.println("File not found: " + fileName);
		}catch (IOException e)
		{
			System.out.println("IOException: the stack trace is:");
			e.printStackTrace();
		}     
		
		
		long endTime = System.currentTimeMillis() ;
		double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
		if(Const.isDebug)
			System.out.println("The total time for computing loop fragments is:  "+ totalTime +" minutes");  	
    	
    }
    public Vector IterativeGradientSearch(Vector vecPrePdb,double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, 
      		 int noStart,int noEnd, Vector vecNoesy, Vector asgVec,double csErrH, double csErrHeavy,boolean isSkipNOE)
    {
    	Vector vecPrePdbTemp=new Vector();
    	vecPrePdbTemp.addAll(vecPrePdb);
    	double[] endDist=new double[1];
    	int counter=0;
    	while(true)
    	{
    		System.out.println("interation= "+counter);
    		//iterate from starting residue to ending residue:
    		for(int i=noStart;i<=noEnd;i++)
    		{    			
    			Vector vecPdbTemp= ResidueGradientSearch(vecPrePdbTemp,i,Syy, Szz, vecChRdc, vecNhRdc, 
    			   		 noStart,noEnd, vecNoesy,  asgVec,csErrH, csErrHeavy,endDist,isSkipNOE);
    			vecPrePdbTemp=new Vector();
    	    	vecPrePdbTemp.addAll(vecPdbTemp);
    	    	System.out.println("res No= "+ i+ "     ending dist= "+endDist[0]);
    	    	
    	    	if(endDist[0]<0.8)
    	    		break;
    		}//for(int i=noStart;i<=noEnd;i++)
    		
    		if(endDist[0]<0.8)
    			break;
    		
    		counter++;
    	}//while(true)
    	
    	return vecPrePdbTemp;
    	
    }
	/**
	 * 
	 * @param vecPrePdb the whole structure computed in previous round
	 * @param curResNo current residue number 
	 * @param Syy Alignment tensor
	 * @param Szz Alignment tensor
	 * @param vecChRdc ch rdcs
	 * @param vecNhRdc nh rdcs
	 * @param noStart the first residue number in the loop fragment
	 * @param noEnd  the end residue number in the loop fragment
	 * @param vecNoesy NOESY cross peaks
	 * @param asgVec resonance assignment list
	 * @param csErrH error for proton chemical shift
	 * @param csErrHeavy error for heavy atom chemical shift
	 * @param endDist distance between ending points
	 * @param isSkipNOE whether skip the NOE matching score in the scoring function
	 * @return
	 */
    public Vector ResidueGradientSearch(Vector vecPrePdb,int curResNo,double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, 
   		 int noStart,int noEnd, Vector vecNoesy, Vector asgVec,double csErrH, double csErrHeavy,double[] endDist, boolean isSkipNOE)
    {
    	double resolution=5.0;//resolution in the grid search
    	Pdb pp=new Pdb();
    	ModelRdc mdc=new ModelRdc();
    	int nTotalRes=Math.abs(noEnd-noStart)+1; //total number of residues in the loop fragment
    	double[] phiS = new double[nTotalRes]; 
		double[] psiS = new double[nTotalRes]; 
		double[] phiSave = new double[nTotalRes]; 
		double[] psiSave = new double[nTotalRes]; 
		
		//the path of rotamer library:
    	String userDir = System.getProperty("user.dir");////
    	String rotSrc= userDir+"/system/rot-lib/";
    	
		//The CA coordinates of the end residue in the original SSE structure
    	int indEndOrg = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
    	Pdb pdbEndOrg = (Pdb)this.vecPdbSSE.elementAt(indEndOrg);
    	Vector atomVecEndOrg = pdbEndOrg.getAtomVec();
    	double [] caEndOrg = new double[3];
    	double [] nEndOrg = new double[3];
    	double [] hnEndOrg = new double[3];
    	for (int j=0;j<atomVecEndOrg.size();j++)
    	{
    		Cartesian cc = (Cartesian)atomVecEndOrg.elementAt(j);
    	    String atom = cc.getAtom();
    	    if (atom.equals("CA"))
    	    	caEndOrg=cc.getXYZ();
    	    
    	    if (atom.equalsIgnoreCase("N"))
    	    	nEndOrg = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	hnEndOrg = cc.getXYZ();	
    	    
    	}
    	
    	//coordinates of N, nh, ca of current residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 	
		int ind = Collections.binarySearch(vecPrePdb, new Pdb(curResNo), new Pdb.PdbComparator() );
		if (ind<0)
		{
			System.out.println("the current residue number not found...exist.");
			System.exit(0);		 
		}
		Pdb pdbCur = (Pdb)vecPrePdb.elementAt(ind);	
		Vector atomVecCur = pdbCur.getAtomVec();
		for (int k=0;k<atomVecCur.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecCur.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		
		
    	//extract the loop fragment:
    	Vector vecPdbFragment=new Vector();//for storing loop fragment
    	Vector vecPdbSSE=new Vector();//for storing SSE
    	for(int i=0;i<vecPrePdb.size();i++)
    	{
    		Pdb pdb=(Pdb)vecPrePdb.elementAt(i);
    		if( ( pdb.getResidueNo()>=noStart ) && (pdb.getResidueNo() <= noEnd)   )
    			vecPdbFragment.add(pdb);
    		else
    			vecPdbSSE.add(pdb);
    	}//for(int i=0;i<vecPrePdb.size();i++)
    	
    	//get the phi,psi angles from previous structure template 
    	Vector vecPhiPsi=new Vector();
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbFragment);
    	for(int i=0;i<vecPhiPsiTemp.size();i++)
    	{
    		PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(i);
    		phiS[i]=phipsi.getPhi();
    		psiS[i]=phipsi.getPsi(); 
    		if(phipsi.getResidueNo()==curResNo)
    			continue;
    		vecPhiPsi.add(phipsi);    		
    	}//for(int i=0;i<vecPhiPsiTemp.size();i++)	
    	
    	//weighting factors:
    	double wtNoeScore=10.0;
		double wtRamaScore=1.0;
		double wtDist=5.0;
		double wtClash=0.0;
		boolean isFound=false;
		int numClashes=0;
		double rT = 100000.0, rTotal = 100000.0;
    	for (int k=0;k<360/resolution;k++)
		{
			double phiValue=k*resolution* Math.PI / 180.0;
			System.out.println("k="+k+" phiValue="+phiValue);
	    	for (int j=0;j<360/resolution;j++)
			{
	    		double rama_score=0.0;
	    		
	    		double psiValue=j*resolution* Math.PI / 180.0;
    			System.out.println("j="+j+" psiPreValue="+psiValue);
    			phiS[curResNo-noStart]=phiValue;
    			psiS[curResNo-noStart]=psiValue;
    			
    			//compute the Ramachandaran score:
    			String curResName=GetResNameFromSequence(this.vecSeq,curResNo);
    	    	String nextResName=GetResNameFromSequence(this.vecSeq,curResNo+1);
    	    	boolean isPrePro=false;
    	    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    	    		isPrePro=true;
    	    	
 			    boolean isGeneral=false;
 			    if(curResName.equalsIgnoreCase("ALA"))
 			    	rama_score=CompRamachandranScore(phiValue,psiValue,vecRamaAla);
 			    else if(curResName.equalsIgnoreCase("GLY"))
 			    	rama_score=CompRamachandranScore(phiValue,psiValue,vecRamaGly);
 			    else if(curResName.equalsIgnoreCase("PRO"))
 			    	rama_score=CompRamachandranScore(phiValue,psiValue,vecRamaPro);
 			    else if(isPrePro)
 			    	rama_score=CompRamachandranScore(phiValue,psiValue,this.vecRamaPrePro);
 			    else
 			    {
 			    	rama_score=CompRamachandranScore(phiValue,psiValue,vecRamaGeneral);
 			    	isGeneral=true;
 			    }
 			    rama_score=-Math.log(rama_score);
 			    
    			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
    			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, noStart, true);//first    			
    			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);     			
    			
    			//compute the RDC RMSD using SVD (using the whole structure)
    			Vector vecAllPdbTemp=new Vector();
    			vecAllPdbTemp.addAll(this.vecPdbSSE);
    			vecAllPdbTemp.addAll(pdbFragTemp);
    			Collections.sort(vecAllPdbTemp, new Pdb.PdbComparator());   
    			
    	    	double[] rdc1Cal = new double[vecAllPdbTemp.size()];
    	    	double[] rdc2Cal = new double[vecAllPdbTemp.size()];
    	    	double[] saupe = new double[4]; //for returning Saupe elements
    	    	PdbRdc pdr=new PdbRdc();
    	    	Matrix mm = pdr.bestFit(vecAllPdbTemp, vecNhRdc, vecChRdc, rdc1Cal, rdc2Cal, saupe);
    			double chRdcRmsd=saupe[2];
    			double nhRdcRmsd=saupe[3];
    			
    		   	//CA coordinates of the end residue 
    		   	int indEndNew = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
    	    	Pdb pdbEndNew = (Pdb)pdbFragTemp.elementAt(indEndNew);
    	    	Vector atomVecEndNew = pdbEndNew.getAtomVec();
    	    	double [] caEndNew = new double[3];
    	    	for (int t=0;t<atomVecEndNew.size();t++)
    	    	{
    	    		Cartesian cc = (Cartesian)atomVecEndNew.elementAt(t);
    	    	    String atom = cc.getAtom();
    	    	    if (atom.equals("CA"))
    	    	    	caEndNew=cc.getXYZ();
    	    	}
    		   	double distance= Math.sqrt((caEndNew[0] - caEndOrg[0]) * (caEndNew[0] - caEndOrg[0]) 
						+ (caEndNew[1] - caEndOrg[1]) * (caEndNew[1] - caEndOrg[1]) 
						+ (caEndNew[2] - caEndOrg[2]) * (caEndNew[2] - caEndOrg[2]));
    		   	
    		  	//if(distance >1.5)
    		   		//continue;
    		   	
    		   	//combine SSE with loop:
    		    Vector vecPdbTemp=CombineSSEandLoop(this.vecPdbSSE,pdbFragTemp);
    		   	
    		    /*
    		    //compute vdw score:
    			Vector vdwVec = new Vector();
    			Vector vdwVecA = new Vector();
    			Vector vdwVecB = new Vector();
    			
    			Vector pdbVecSSE_tempA = pp.residueNameUpdate(vecSeq, this.vecPdbSSE);
    		    //Vector  ppVecTALA_A=pp.AlaninizeStructureResName(pdbVecSSE_tempA,rotSrc);  			    	
		    	vdwVecA = vander.convert2VDW(pdbVecSSE_tempA);
		    	
		    	Vector pdbVecSSE_tempB = pp.residueNameUpdate(vecSeq, pdbFragTemp);
    		    Vector  ppVecTALA_B=pp.AlaninizeStructureResName(pdbVecSSE_tempB,rotSrc);  			    	
		    	vdwVecB = vander.convert2VDW(ppVecTALA_B);
		    	//////////
		    	int numClashes=vander.countStericClashBetweenTwo(vdwVecA,vdwVecB, vdwValue, vdwLevel, printVDWViolation, true,0.5);
	        	*/
		    	
    		    double noeScore=0.0;
    		    if(! isSkipNOE)
    		    {
				    //add rotamers to the backbone:
				    Vector vecRotStructure=pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy,vecPdbTemp,asgVec,rotSrc,vecNoesy,
			    			4.5, 1,this.caliConstant);
				   	
				   	//compute the NOE pattern score for the loop fragment:....
				    noeScore=CompNoePatternScoreBetwSSEAndLoop(csErrH,csErrHeavy,vecRotStructure,4.5,asgVec,vecNoesy);
				   	noeScore=-Math.log(noeScore);
    		    }
    		    else
    		    	noeScore=0.0;
    		    
    		    rT = chRdcRmsd + nhRdcRmsd+wtNoeScore*noeScore
    		    	+wtRamaScore*rama_score+wtDist*distance+wtClash*numClashes;/////for NH rdc, we start from i+1...
    		    // rT=distance;//for debugging
    		    if (rT < rTotal)
    		    {
	    		    //isChanged=true;
    		    	isFound=true;
	    			rTotal = rT;
	    			System.out.println( "Phi = "+ (k*resolution)+"psi= " +(j*resolution) +": "+ chRdcRmsd+"  "+ nhRdcRmsd+"  noe score: "+ wtNoeScore*noeScore+ 
	    					"  rama score: "+ wtRamaScore*rama_score +"  dist: "+ wtDist*distance+" clash: "+wtClash*numClashes +";  "+", RT = "+rTotal);
	    			System.arraycopy(phiS, 0, phiSave, 0, nTotalRes);
	    			System.arraycopy(psiS, 0, psiSave, 0, nTotalRes);	
	    			endDist[0]=distance;
    		    }//if (rT < rTotal)   			
			}//for (int j=0;j<360/resolution;j++)
		}//for (int k=0;k<360/resolution;k++)
    	
    	if(isFound)
    		System.out.println("debugging...resNo=" +curResNo +"...yes...we at least found one...");
    	
    	Vector<PhiPsi> phiPsiVec  = new Vector<PhiPsi>();
	  	for (int i=0; i<nTotalRes; i++)  //build the model
       	    phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
	   	Vector<Pdb> pdbFragTemp = new Vector<Pdb>();
	   	
	   	pdbFragTemp= mdc.modelBuild(phiSave, psiSave, nEndOrg, hnEndOrg,caEndOrg, noStart, true);
		//combine SSE with loop:
	    Vector vecPdbTemp=CombineSSEandLoop(this.vecPdbSSE,pdbFragTemp);
	    
		Vector pdbFragTempNew= pp.residueNameUpdateNoStr(this.vecSeq, vecPdbTemp);
		return pdbFragTempNew;
	   	
    }
   /**Compute the structure fragment that best fits the RDC and NOESY data.
     * Fitness core is calculated based on RDC RMSD and NOE pattern matching score.	  
     * For missing RDCs, randomly sample the dihedral angels.
     *    
     @param Syy, Szz: the Saupe element
     @param vecChRdc  an array of CH RDCs for the fragment.
     @param vecNhRdc  an array of NH RDCs for the fragment.
     @param n1  the direction cosine for amide nitrogen of the first residue.
     @param nh1 the direction cosine for amide proton.
     @param ca1 the direction cosine for Ca.
     @param noStart the residue number of the first residue of a fragment.
     @param noEnd the residue number of the end residue of a fragment.
     @param vecNoesy  NOESY peak list.
     @param asgVec  resonance list
     @param csErrH, csErrHeavy error window for protons and heavy atoms (i.e. C13 or N15)
     @param isSkipNOE whether skip the NOE matching score in the scoring function
     @return a vector of Pdb object.
    */
    public Vector calcFragment(double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, 
    		double[] n1, double[] nh1, double[] ca1, int noStart,int noEnd, Vector vecNoesy, Vector asgVec,
    		double csErrH, double csErrHeavy,boolean isSkipNOE)throws JampackException
    {
    	int nTotalRes=Math.abs(noEnd-noStart)+1; 
    	int numChRDCs =0,numNhRDCs =0;
    	vdw vander = new vdw();
    	Pdb pp=new Pdb();
    	 
    	//The CA coordinates of the end residue in the original SSE structure
    	int indEndOrg = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
    	Pdb pdbEndOrg = (Pdb)this.vecPdbSSE.elementAt(indEndOrg);
    	Vector atomVecEndOrg = pdbEndOrg.getAtomVec();
    	double [] caEndOrg = new double[3];
    	for (int j=0;j<atomVecEndOrg.size();j++)
    	{
    		Cartesian cc = (Cartesian)atomVecEndOrg.elementAt(j);
    	    String atom = cc.getAtom();
    	    if (atom.equals("CA"))
    	    	caEndOrg=cc.getXYZ();
    	}
    	
    	
    	//the path of rotamer library:
    	String userDir = System.getProperty("user.dir");////
    	String rotSrc= userDir+"/system/rot-lib/";
    	
    	//////////////////////////////////////////
    	//identify the missing RDCs:
    	double [] rdcChExp = new double[nTotalRes]; //store the experimental values in the array
    	double [] rdcNhExp = new double[nTotalRes];
    	int [] seqNosCH = new int[nTotalRes];//an array indicating whether experimental RDC is available.
    	int [] seqNosNH = new int[nTotalRes];
    	for (int j = 0; j < nTotalRes; j++)  
    	{
    	    int no = noStart+j;
    	    int index = Collections.binarySearch(vecChRdc, new Dipolar(no), new Dipolar.rdcComparator());
    	    if (index > - 1)
    	    {
    	    	rdcChExp[j] = ((Dipolar)vecChRdc.elementAt(index)).getRdc();	    	    	
    	    	seqNosCH[j] = 1;
    	    	numChRDCs++;
    	    }else 
    	    {
    	    	rdcChExp[j] =  -99999.9;//
    	    	seqNosCH[j] = 0;	    	    	
    	    }
    	    
    	    index = Collections.binarySearch(vecNhRdc, new Dipolar(no), new Dipolar.rdcComparator());
    	    if (index > - 1)
    	    {
    	    	rdcNhExp[j] = ((Dipolar)vecNhRdc.elementAt(index)).getRdc();
    	    	seqNosNH[j] = 1;
    	    	numNhRDCs++;
    	    }else
    	    {
    	    	rdcNhExp[j] = -99999.9;
    	    	seqNosNH[j] = 0;	    	    	
    	    }
    	}//for (int j = 0; j < nTotalRes; j++)
	    	
    	//compute the orientation of the first plane
    	ModelRdc mdc=new ModelRdc();
    	double[] nToNHVec = mdc.internuclearVec(n1, nh1);
        double[] nToCAVec = mdc.internuclearVec(n1, ca1);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);   	
    	
        //parameters for computing the vdw score:
	    double[] vdwValue = new double[1];
    	boolean hasVDW = false;
    	double vdwLevel = 0.05;
    	boolean printVDWViolation = false;
    	
    	
    	////////////////////////////////////////////////
    	//Gaussian sampling the RDC interval
    	int nCycles=2;//number of sampling cycles
    	double deviation=3.0;//deviation for RDC sampling.
    	int depth0 = 0;
    	long seed =66668; 	    	
		Random rr = new Random(seed);
		double [] rdcCHArr = new double[nTotalRes]; //CH RDCs, sampled based on Gaussina Dis, use array for efficient 
		double [] rdcNHArr = new double[nTotalRes]; //NH RDCs, use array for efficient 
		PhiPsi ff = new PhiPsi();
		Vector<Double> ppVec = new Vector<Double>();
		boolean depthFlag = true;
		boolean rightHand = true;
		double[] ppS  = new double[2*nTotalRes]; 
		int noOfSln = 0;
		double[] phiS = new double[nTotalRes]; 
		double[] psiS = new double[nTotalRes]; 
		double[] phiSave = new double[nTotalRes]; 
		double[] psiSave = new double[nTotalRes]; 
		double[] rdcCHSave = new double[nTotalRes];   //CH Rdcs
		double[] rdcNHSave = new double[nTotalRes]; 
		double rT = 100000.0, rTotal = 100000.0;
		//Pdb pp=new Pdb();
		double wtNoeScore=10.0;
		double wtRamaScore=5.0;
		double wtDist=5.0;
		double wtClash=0.0;
		boolean isFound=false;
		int numClashes=0;
    	for (int mmm =0; mmm < nCycles; mmm++)
    	{     	
    		System.out.println("debugging...mmm=: "+mmm);
    	    
    		double rRdc_ch = 0.0;
    		double rRdc_nh = 0.0;
    		for (int j = 0; j < nTotalRes; j++)
    		{      			
    			rdcCHArr[j] = rdcChExp[j] + deviation * rr.nextGaussian();
    		   	rdcNHArr[j] = rdcNhExp[j] +deviation * rr.nextGaussian() ;
    		    double rms_ch = Math.abs(rdcCHArr[j] - rdcChExp[j]);
    		    rRdc_ch+= rms_ch * rms_ch * seqNosCH[j] ;
    		    double rms_nh = Math.abs(rdcNHArr[j] - rdcNhExp[j]);
    		    rRdc_nh += rms_nh * rms_nh * seqNosNH[j] ; 
    		}//for (int j = 0; j < nTotalRes; j++)
    		
	    		//if ( (rRdc11 > rRdcFinal1) || (rRdc12 > rRdcFinal2) )////
	    		 //   flag1 = false;
	    		//else flag1 = true;
    		//}//end of while
    		
    	    ppVec = new Vector<Double>();
    	    depthFlag = false;
    	    		
        	depthFlag = phiPsiChainAll(rdcCHArr, rdcNHArr, seqNosCH, seqNosNH, mat, Syy, Szz, depth0, noStart, nTotalRes - 1, ppS, ppVec, rightHand,noStart); 
        	        
        	
        	if (ppVec.size() > 0 )
        	{
        		//System.out.println("debugging...111111......");
        		
	    		noOfSln = (int)ppVec.size() / (2*nTotalRes);  //the total number of solutions for this rdc set	    		
	    		for(int k=0; k < noOfSln; k++)
	    		{   	    
	    			double rama_score=0.0;
	    			double sum_rama_score=0.0;
	    		    for (int n = k* 2 * nTotalRes; n < (k+1)* 2 *nTotalRes; n += 2)
	    		    { 
		    			double phi_value = ppVec.elementAt(n).doubleValue();
		    			double psi_value = ppVec.elementAt(n+1).doubleValue();
		    			phiS[(int)(n - k* 2 * nTotalRes) / 2] = phi_value;
		    			psiS[(int)(n - k* 2 * nTotalRes) / 2] = psi_value;	 
		    			
		    			//compute the Ramachandran score
		    			int cur_no=(int)(n - k* 2 * nTotalRes) / 2;
		    			
		    		    String curResName=GetResNameFromSequence(vecSeq,noStart+cur_no);
		    	    	String nextResName=GetResNameFromSequence(vecSeq,noStart+cur_no+1);
		    	    	boolean isPrePro=false;
		    	    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
		    	    		isPrePro=true;
		    	    	
		 			    boolean isGeneral=false;
		 			    if(curResName.equalsIgnoreCase("ALA"))
		 			    	rama_score=CompRamachandranScore(phi_value,psi_value,vecRamaAla);
		 			    else if(curResName.equalsIgnoreCase("GLY"))
		 			    	rama_score=CompRamachandranScore(phi_value,psi_value,vecRamaGly);
		 			    else if(curResName.equalsIgnoreCase("PRO"))
		 			    	rama_score=CompRamachandranScore(phi_value,psi_value,vecRamaPro);
		 			    else if(isPrePro)
		 			    	rama_score=CompRamachandranScore(phi_value,psi_value,this.vecRamaPrePro);
		 			    else
		 			    {
		 			    	rama_score=CompRamachandranScore(phi_value,psi_value,vecRamaGeneral);
		 			    	isGeneral=true;
		 			    }
		 			    sum_rama_score=sum_rama_score+rama_score;
	    		    }// for (int n = k* 2 * nTotalRes; n < (k+1)* 2 *nTotalRes; n += 2)
	    		    sum_rama_score=(double)(sum_rama_score/nTotalRes);
	    		   
	    		    
	    		    Vector<PhiPsi> phiPsiVec  = new Vector<PhiPsi>();
	    		  	for (int i=0; i<nTotalRes; i++)  //build the model
    		       	    phiPsiVec.add(new PhiPsi(i, "ALA", phiS[i], psiS[i]));
	    		   	Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();
	    		   	
	    		   	pdbFragTemp0= mdc.modelBuild(phiS, psiS, n1, nh1, ca1, noStart, true);//first?
	    		   
	    		   	Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
	    		   	
	    		   	//CA coordinates of the end residue 
	    		   	int indEndNew = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
	    	    	Pdb pdbEndNew = (Pdb)pdbFragTemp.elementAt(indEndNew);
	    	    	Vector atomVecEndNew = pdbEndNew.getAtomVec();
	    	    	double [] caEndNew = new double[3];
	    	    	for (int j=0;j<atomVecEndNew.size();j++)
	    	    	{
	    	    		Cartesian cc = (Cartesian)atomVecEndNew.elementAt(j);
	    	    	    String atom = cc.getAtom();
	    	    	    if (atom.equals("CA"))
	    	    	    	caEndNew=cc.getXYZ();
	    	    	}
	    		   	double distance= Math.sqrt((caEndNew[0] - caEndOrg[0]) * (caEndNew[0] - caEndOrg[0]) 
    						+ (caEndNew[1] - caEndOrg[1]) * (caEndNew[1] - caEndOrg[1]) 
    						+ (caEndNew[2] - caEndOrg[2]) * (caEndNew[2] - caEndOrg[2]));
	    		   	
	    		  	//if(distance >1.5)
	    		   		//continue;
	    		   	
	    		   	//combine SSE with loop:
	    		    Vector vecPdbTemp=CombineSSEandLoop(this.vecPdbSSE,pdbFragTemp);
	    		   	
	    		    /*
	    		    //compute vdw score:
	    			Vector vdwVec = new Vector();
	    			Vector vdwVecA = new Vector();
	    			Vector vdwVecB = new Vector();
	    			
	    			Vector pdbVecSSE_tempA = pp.residueNameUpdate(vecSeq, this.vecPdbSSE);
	    		    //Vector  ppVecTALA_A=pp.AlaninizeStructureResName(pdbVecSSE_tempA,rotSrc);  			    	
			    	vdwVecA = vander.convert2VDW(pdbVecSSE_tempA);
			    	
			    	Vector pdbVecSSE_tempB = pp.residueNameUpdate(vecSeq, pdbFragTemp);
	    		    Vector  ppVecTALA_B=pp.AlaninizeStructureResName(pdbVecSSE_tempB,rotSrc);  			    	
			    	vdwVecB = vander.convert2VDW(ppVecTALA_B);
			    	//////////
			    	int numClashes=vander.countStericClashBetweenTwo(vdwVecA,vdwVecB, vdwValue, vdwLevel, printVDWViolation, true,0.5);
		        	*/
			    	
	    		    double noeScore=0.0;
	    		    if(! isSkipNOE)
	    		    {
					    //add rotamers to the backbone:
					    Vector vecRotStructure=pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy,vecPdbTemp,asgVec,rotSrc,vecNoesy,
				    			4.5, 1,this.caliConstant);
					   	
					   	//compute the NOE pattern score for the loop fragment:....
					    noeScore=CompNoePatternScoreBetwSSEAndLoop(csErrH,csErrHeavy,vecRotStructure,4.5,asgVec,vecNoesy);
					   	noeScore=-Math.log(noeScore);
	    		    }
	    		    else
	    		    	noeScore=0.0;
	    		    
	    		    sum_rama_score=-Math.log(sum_rama_score);
	    		   	
	    		    rT = Math.sqrt(rRdc_ch / numChRDCs ) +  (Math.sqrt(rRdc_nh / (numNhRDCs - 1) ))+wtNoeScore*noeScore
	    		    	+wtRamaScore*sum_rama_score+wtDist*distance+wtClash*numClashes;/////for NH rdc, we start from i+1...
	    		   // rT=distance;//for debugging
	    		    if (rT < rTotal)
	    		    {
		    		    //isChanged=true;
	    		    	isFound=true;
		    			rTotal = rT;
		    			System.out.println( mmm +": "+Math.sqrt(rRdc_ch / numChRDCs )+"  "+ Math.sqrt(rRdc_nh / (numNhRDCs - 1) )+"  noe score: "+ wtNoeScore*noeScore+ 
		    					"  rama score: "+ wtRamaScore*rama_score +"  dist: "+ wtDist*distance+" clash: "+wtClash*numClashes +";  "+", RT = "+rTotal);
		    			System.arraycopy(phiS, 0, phiSave, 0, nTotalRes);
		    			System.arraycopy(psiS, 0, psiSave, 0, nTotalRes);
		    			System.arraycopy(rdcCHArr, 0, rdcCHSave, 0, nTotalRes);
		    			System.arraycopy(rdcNHArr, 0, rdcNHSave, 0, nTotalRes);
	    		    }
	    		}//for(int k=0; k < noOfSln; k++)
    		}//if (ppVec.size() > 0 )
    	}//for (int mmm =0; mmm < nCycles; mmm++)

    	if(isFound)
    		System.out.println("debugging...yes...we at least found one...");
    	
    	Vector<PhiPsi> phiPsiVec  = new Vector<PhiPsi>();
	  	for (int i=0; i<nTotalRes; i++)  //build the model
       	    phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
	   	Vector<Pdb> pdbFragTemp = new Vector<Pdb>();
	   	
	   	pdbFragTemp= mdc.modelBuild(phiSave, psiSave, n1, nh1, ca1, noStart, true);
		//combine SSE with loop:
	    Vector vecPdbTemp=CombineSSEandLoop(this.vecPdbSSE,pdbFragTemp);
	    
		Vector pdbFragTempNew= pp.residueNameUpdateNoStr(this.vecSeq, vecPdbTemp);   	
	   	
		//add rotamers to the backbone:
	    Vector pdbFragTempNewRot=pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy,vecPdbTemp,asgVec,rotSrc,vecNoesy,
    			4.5, 1,this.caliConstant);
	    
	    
	   	return pdbFragTempNewRot;
	    	
    }//end of the function "calcFragment()"
    
    /**compute NOE pattern between SSE and loops. 
     * 
     * @param errH, errHeavy: error windows.
     * @param vecPdbLoop loop Pdb
     * @param vecPdbSSE SSE Pdb
     * @param distBound upper bound limit for back-computed NOEs
     * @param asgVec resonance assigment list
     * @param vecNOESY NOESY cross peak list
     * @return
     */
    public double CompNoePatternScoreBetwSSEAndLoop(double errH, double errHeavy, Vector vecPdbCombin,double distBound,Vector asgVec,Vector vecNOESY)
    {
    	//0.extract SSE and loop fragments:
    	Vector vecPdbLoop=new Vector();
    	Vector vecPdbSSETemp=new Vector();
    	for(int i=0;i<vecPdbCombin.size();i++)
    	{
    		Pdb pp=(Pdb)vecPdbCombin.elementAt(i);
    		int resNo=pp.getResidueNo();
    		boolean isInSSE=false;
    		for(int j=0;j<this.vecPdbSSE.size();j++)
    		{
    			Pdb ppSSE=(Pdb)this.vecPdbSSE.elementAt(j);
    			int resNoSSE=ppSSE.getResidueNo();
    			if(resNo==resNoSSE)
    				isInSSE=true;
    		}//for(int j=0;j<this.vecPdbSSE.size();j++)
    		if(isInSSE)
    			vecPdbSSETemp.add(pp);
    		else
    			vecPdbLoop.add(pp);
    	}//for(int i=0;i<vecPdbCombin.size();i++)
    	
    	//1. compute the set of NOE distances 
    	double [] coordLoop = {0.0, 0.0, 0.0};
    	double [] coordSSE = {0.0, 0.0, 0.0};
    	Peak pk=new Peak();
    	Vector vecHdist =new Vector();
    	
    	for(int i=0;i<vecPdbLoop.size();i++)
    	{
    		Pdb pdbLoop=(Pdb)vecPdbLoop.elementAt(i);
    		String resLoop=pdbLoop.getResidue();
    		Vector vecAtomLoop=pdbLoop.getAtomVec();
    		int resNoLoop=pdbLoop.getResidueNo();
    		for(int j=0;j<vecAtomLoop.size();j++)
    		{
    			Cartesian ccLoop=(Cartesian)vecAtomLoop.elementAt(j);
    			coordLoop=ccLoop.getXYZ();
    			String atomLoop=ccLoop.getAtom();
    			if(! atomLoop.substring(0,1).equalsIgnoreCase("H"))
    				continue;
    			String heavyAtom=pk.GetHeavyAtomFromProton(resLoop,atomLoop);
    			if( ! (heavyAtom.substring(0,1).equalsIgnoreCase("C") || heavyAtom.substring(0,1).equalsIgnoreCase("N") ) )
    				continue;
    			
    			for(int k=0;k<vecPdbSSETemp.size();k++)
    			{
    				Pdb pdbSSE=(Pdb)vecPdbSSETemp.elementAt(k);
    				String resSSE=pdbSSE.getResidue();
    				Vector vecAtomSSE=pdbSSE.getAtomVec();
    				int resNoSSE=pdbSSE.getResidueNo();
    				for(int h=0;h<vecAtomSSE.size();h++)
    				{
    					Cartesian ccSSE=(Cartesian)vecAtomSSE.elementAt(h);
    					coordSSE=ccSSE.getXYZ();
    					String atomSSE=ccSSE.getAtom();
    					if(! atomSSE.substring(0, 1).equalsIgnoreCase("H"))
    						continue;
    					String heavyAtomSSE=pk.GetHeavyAtomFromProton(resSSE,atomSSE);
    					if( ! (heavyAtomSSE.substring(0,1).equalsIgnoreCase("C") || heavyAtomSSE.substring(0,1).equalsIgnoreCase("N") ) )
    	    				continue;
    					
    					double distance= Math.sqrt((coordLoop[0] - coordSSE[0]) * (coordLoop[0] - coordSSE[0]) 
	    						+ (coordLoop[1] - coordSSE[1]) * (coordLoop[1] - coordSSE[1]) 
	    						+ (coordLoop[2] - coordSSE[2]) * (coordLoop[2] - coordSSE[2]));
    					if (distance < distBound)
	    				{
	    					vecHdist.add(new Hdist(ccLoop,resNoLoop,resLoop,atomLoop, ccSSE,resNoSSE,resSSE,atomSSE,distance));	    					
	    					vecHdist.add(new Hdist(ccSSE,resNoSSE,resSSE,atomSSE,ccLoop,resNoLoop,resLoop,atomLoop,distance));	
	    				}
    					
    				}//for(int h=0;h<vecAtomSSE.size();h++)
    				
    			}//for(int k=0;k<vecPdbSSE.size();k++)
    			
    			
    		}//for(int j=0;j<vecAtomLoop.size();j++)
    		
    	}//for(int i=0;i<vecPdbLoop.size();i++)
    	
    	//2.the set of back-computed NOEs:
    	Vector vecBackNoe=new Vector();
    	RotaPattern rotPattern=new RotaPattern();
    	BackNoe bn=new BackNoe();
    	for (int i=0;i<vecHdist.size();i++)
    	{
    		Hdist hdist=(Hdist)vecHdist.elementAt(i);   		
    		BackNoe backNoe=rotPattern.BackCompNOEPeak(asgVec,hdist);    		
    		vecBackNoe.add(backNoe);
    		
    	}//for (i=0;i<vecHDist.size();i++)
    	
    	Vector vecBackNoeNoRepeat=bn.DeleteRepeat(vecBackNoe);
    	
    	//3.compute the matching score:
    	Assign asg=new Assign();
    	int [] numPeaks=new int[1];
    	double dbScore=asg.NoePatternMatchScoreWCali(errH,errHeavy, errHeavy,vecBackNoeNoRepeat,vecNOESY, numPeaks,false,this.caliConstant);
		
    	return dbScore;
    	
    }//end of function "CompNoePatternsBetweenSseAndLoop"
    /**combine the sse pdb with the loop pdb. For overlap residues, always keep SSE ones.
     * 
     * @param vecSSEPdb SSE pdb
     * @param vecLoopPdb loop pdb
     * @return the pdb after combination
     */
    public Vector CombineSSEandLoop(Vector vecSSEPdb, Vector vecLoopPdb)
    {
    	Vector vecNewPdb=new Vector();
    	vecNewPdb.addAll(vecSSEPdb);
    	for(int i=0;i<vecLoopPdb.size();i++)
    	{
    		boolean isInSSE=false;
    		Pdb pp=(Pdb)vecLoopPdb.elementAt(i);
    		int resNo=pp.getResidueNo();
    		for(int j=0;j<vecSSEPdb.size();j++)
    		{
    			Pdb ppSSE=(Pdb)vecSSEPdb.elementAt(j);
    			int resNoSSE=ppSSE.getResidueNo();
    			if(resNoSSE==resNo)
    				isInSSE=true;    			
    		}//for(int j=0;j<vecSSEPdb.size();j++)
    		if(isInSSE)
    			continue;
    		vecNewPdb.add(pp);    		
    	}//for(int i=0;i<vecLoopPdb.size();i++)    	
    	Collections.sort(vecNewPdb,new Pdb.PdbComparator() );
    	return vecNewPdb;
    }
    
    /**Randomly sample the (Phi, Psi) angles according to distribution 
     * from Ramachandran.
     * @param resNo residue number 
     * @param vecSeq sequence information
     * 
     */    
    public PhiPsi PhiPsiRandomFromRamachandran(Vector vecSeq,int resNo)
    {
    	long seed=11111;
    	Random rand = new Random(seed);
    	String curResName=GetResNameFromSequence(vecSeq,resNo);
    	String nextResName=GetResNameFromSequence(vecSeq,resNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
    	Vector vecRama=new Vector();
    	if(curResName.equalsIgnoreCase("ALA"))
    		vecRama.addAll(this.vecRamaAla);
    	else if(curResName.equalsIgnoreCase("GLY"))
    		vecRama.addAll(this.vecRamaGly);
    	else if(curResName.equalsIgnoreCase("PRO"))
    		 vecRama.addAll(this.vecRamaPro);
	    else if(isPrePro)
	    	vecRama.addAll(this.vecRamaPrePro);
	    else
	    	vecRama.addAll(this.vecRamaGeneral);
    	
    	int[] circle=new int[10000];
    	int sum=0;
    	int current=0;
    	
    	//putting index numbers on a Roulette
    	for(int i=0;i<vecRama.size();i++)
    	{
    		PhiPsi phipsi=(PhiPsi)vecRama.elementAt(i);
    		double prob=phipsi.getRamaScore();
    		int nProb=(int) Math.round(prob*1000);
    		for(int k=current;k<nProb;k++)
    		{
    			circle[k]=i;
    			sum++;
    		}
    		current=current+nProb;
    		
    	}//for(int i=0;i<vecRama.size();i++)
		    	
		int randomN=rand.nextInt(sum);
		int index=circle[randomN];
		PhiPsi phipsi_out=(PhiPsi)vecRama.elementAt(index);
		
		return phipsi_out;   	
    }
    
    /** A recusive function to compute all the backbone (phi, psi) angles for a fragment. 
      * Modefied from PhiPsi.phiPsiChain();
      * 
     @param rdcArrCH  an array of CH RDCs for the fragment
     @param rdcArrNH  an array of NH RDCs for the fragment
     @param isChRDC,isNhRDC an array indicating whether RDC is available (i.e. not missing).
     @param rg  a matrix to rotate the POF to a coodinate system defined in the first peptide plane.
     @param Syy Saupe elements computed from both NH and CH rdcs
     @param Szz  Saupe elements computed from both NH and CH rdcs
     @param i    the current depth of the depth-first search. Begin the call with i = 0; 
     @param resNo residue number of current residue;
     @param N the total depth of the depth-first search.
     @param ppS a temporary array for saving intermediate (\phi, \psi) angles.
     @param ppVec an array for saving and returning final (\phi, \psi) angles.     
     @param rightHand make sure the computed rg has the same handedness as the rotating matrix by the SVD method
     @param resNoStart starting residue index
    */     
    public boolean phiPsiChainAll (double[] rdcArrCH, double[] rdcArrNH, int[] isChRDC, int[] isNhRDC, Matrix rg, double Syy, double Szz, 
    		int i, int resNo, final int N, double[] ppS, Vector ppVec, boolean rightHand,int resNoStart)
    {
    	String curResName=GetResNameFromSequence(vecSeq,resNo);
    	String nextResName=GetResNameFromSequence(vecSeq,resNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
    	PhiPsi ff=new PhiPsi();
        double u, v; //for CH and NH RDC respectively
	 	Vector phiVec = new Vector();
	 	Vector psiVec = new Vector();
	 	double phi = 0.0, psi = 0.0;
	 	Matrix mat = new Matrix(3,3);
	 	final double ratio = Const.nhRatio;
 	    if (i > N - 1)
 	    {
 	    	if(isChRDC[i]==0)
 	    	{//CH RDC is missing. We randomly sample the Phi angle space: 	    		
 	    		
 	    		//old method: uniformly sample one between  [-180, 180]
 	    		double phiTemp=generator.nextDouble()*Math.PI*2 - Math.PI;//between [-180, 180]
 	    		phiVec.add(new Double(phiTemp));
 	    		
 	    		//new method: sample according to the Ramachandran distribution
 	    		///PhiPsi phipsi=this.PhiPsiRandomFromRamachandran(this.vecSeq,resNoStart+i );
 	    		///double phiTemp=phipsi.getPhi();
 	    		///phiVec.add(new Double(phiTemp));
 	    	}
 	    	else
 	    	{
		 	    u = rdcArrCH[i];
		 	    phiVec = phiCalAll(Syy, Szz, u, rg);
 	    	}
	 	    if (!phiVec.isEmpty())
	 	    {
	 	    	for (int m = 0; m < phiVec.size(); m++)
	 	    	{ 		    
	 	    		for (int j=0; j<2*N; j++)
		 		    {
		 		    	ppVec.addElement(new Double(ppS[j]));
		 		    }
	 	    		ppVec.addElement(phiVec.elementAt(m));
 		  
	 	    		//old method: uniformly sample one between  [-180, 180]
	 	    		//The last half residue is meaningless. we randomly generate a psi angle.
	 	    		///double psiTemp=generator.nextDouble()*Math.PI*2 - Math.PI;//between [-180, 180]
	 	    		///ppVec.addElement(new Double(psiTemp)); 
	 	    		
	 	    		//new method: sample according to the Ramachandran distribution
	 	    		PhiPsi phipsi=this.PhiPsiRandomFromRamachandran(this.vecSeq,resNoStart+i );
	 	    		double psiTemp=phipsi.getPsi();
	 	    		ppVec.addElement(new Double(psiTemp)); 
		 		   	    
	 	    	}
	 	    	return true;
	 	    }else return false;
	 	    
 	    }else
 	    {
 	    	if(isChRDC[i]==0)
 	    	{//CH RDC is missing. We randomly sample the Phi angle space: 	
 	    		//old method: uniformly sample one between  [-180, 180]
 	    		///double phiTemp=generator.nextDouble()*Math.PI*2 - Math.PI;//between [-180, 180]
 	    		///phiVec.add(new Double(phiTemp));
 	    		
 	    		//new method: sample according to the Ramachandran distribution
 	    		PhiPsi phipsi=this.PhiPsiRandomFromRamachandran(this.vecSeq,resNoStart+i );
 	    		double phiTemp=phipsi.getPhi();
 	    		phiVec.add(new Double(phiTemp));
 	    	}
 	    	else
 	    	{
 	    		u = rdcArrCH[i];
 	 	    	phiVec = phiCalAll(Syy, Szz, u, rg);
 	    	}
 	    	
 	    	if (!phiVec.isEmpty())
 	    	{
 	    		Vector vecPhiPsiTemp=new Vector();//for storing temp phi/psi angles in order to cluster
 	    		
 	    		for (int j =0; j<phiVec.size(); j++)
 	    		{
 	    			phi = ((Double)phiVec.elementAt(j)).doubleValue();
 	    			if(isNhRDC[i+1]==0)
 	    			{
 	    				//old method: uniformly sample one between  [-180, 180]
 	    				//NH RDC is missing. We randomly sample the Psi angle space: 
 	    				double psiTemp=generator.nextDouble()*Math.PI*2 - Math.PI;//between [-180, 180]
 	    				psiVec.add(new Double(psiTemp));
 	    				
 	    				//new method: sample according to the Ramachandran distribution
 	    				///PhiPsi phipsi=this.PhiPsiRandomFromRamachandran(this.vecSeq,resNoStart+i );
 		 	    		////double psiTemp=phipsi.getPsi();
 		 	    		///psiVec.add(new Double(psiTemp));
 	    			}
 	    			else
 	    			{
 	    				v = rdcArrNH[i+1] / ratio; //
 	 	    			psiVec = psiCalAll(Syy, Szz, v, phi,  rg);
 	    			}
 	    			

 	    			if (!psiVec.isEmpty())
 	    			{
 	    				for (int k =0; k<psiVec.size(); k++)
 	    				{
			 			    psi = ((Double)psiVec.elementAt(k)).doubleValue();
			 			    
			 			    //we prune those phi/psi angles in  disallowed region of Ramachandran
			 			    double rama_score=0.0;
			 			    boolean isGeneral=false;
			 			    if(curResName.equalsIgnoreCase("ALA"))
			 			    	rama_score=CompRamachandranScore(phi,psi,vecRamaAla);
			 			    else if(curResName.equalsIgnoreCase("GLY"))
			 			    	rama_score=CompRamachandranScore(phi,psi,vecRamaGly);
			 			    else if(curResName.equalsIgnoreCase("PRO"))
			 			    	rama_score=CompRamachandranScore(phi,psi,vecRamaPro);
			 			    else if(isPrePro)
			 			    	rama_score=CompRamachandranScore(phi,psi,this.vecRamaPrePro);
			 			    else
			 			    {
			 			    	rama_score=CompRamachandranScore(phi,psi,vecRamaGeneral);
			 			    	isGeneral=true;
			 			    }
			 			    double cutoff=0.002;
			 			    if(isGeneral)
			 			    	cutoff=0.0005;
			 			    if(rama_score<cutoff)
			 			    	continue;
			 			    
			 			    PhiPsi ffTemp=new PhiPsi(phi,psi,0.0);
			 			    if( isInPhiPsiClusters(vecPhiPsiTemp,ffTemp,5.0) ) //check whether it is in cluster
			 			    	continue;
			 			    
			 			    vecPhiPsiTemp.add(ffTemp);
			 			    ppS[2*i] = phi;
			 			    ppS[2*i+1] = psi;
			 			    mat = ff.newRG(phi, psi, rg, rightHand); //compute a new rotation matrix rg
			 			    phiPsiChainAll(rdcArrCH, rdcArrNH,isChRDC,isNhRDC, mat, Syy, Szz, i+1,resNo+1, N, ppS, ppVec, rightHand,resNoStart);
 	    				}
 	    			}
 	    		}
 	    	} //
 	     
	 	}
	 	return false;
	 }//end of function "phiPsiChain"    
    
    /**
     * Read the Ramachandran probability score based on Richardsons' top500 structures. 
     @param vecRamachandran vector of Ramachandran database information
     @param phi  input phi angle value
     @param psi  input psi angle value     
     @return Vector of PhiPsi objects that store the probabilities of the (phi, psi) angle in the database
    **/
    public Vector<PhiPsi> ReadRamachandranFile(String ssePdbFile)
    {
    	String ss ="";
    	StringTokenizer st = new StringTokenizer("");    
    	String firstStr="",secStr="",thirdStr="";
    	double phiT=0.0,psiT=0.0,score=0.0;
    	Vector vecPhiPsi=new Vector();
    	try
    	{
    		BufferedReader in = new BufferedReader(new FileReader(ssePdbFile));	
    		ss = in.readLine();    		
    		stop:
    			while(true) 
    			{   			    
    				st = new StringTokenizer(ss);
    				
    				if (st.hasMoreTokens())
    					firstStr = st.nextToken().trim();
    				if (st.hasMoreTokens())
    					secStr = st.nextToken().trim();
    				if (st.hasMoreTokens())
    					thirdStr = st.nextToken().trim();
    				if( !firstStr.substring(0,1).equalsIgnoreCase("#"))
    				{
    					phiT=new Double(firstStr).doubleValue();
    					phiT=phiT*(Math.PI/180.0);
    					psiT=new Double(secStr).doubleValue();
    					psiT=psiT*(Math.PI/180.0);
    					score=new Double(thirdStr).doubleValue();
    					vecPhiPsi.add(new PhiPsi(phiT,psiT,score) );
    				}//end of if( !firstStr.substring(0,1).equalsIgnoreCase("#"))
    				
    				if ((ss = in.readLine()) == null)
    				{
    					break stop;
    				}
    			}//end of while(true) 
    	}catch (FileNotFoundException e) {
    		System.out.println("File not found: " + ssePdbFile);
    	}catch (IOException e) 
    	{
    		System.out.println("IOException: the stack trace is:");
    		e.printStackTrace();
    	}
    	return vecPhiPsi;    	
    }
    
    /**
     * Compute the Ramachandran probability score based on Richardsons' top500 structures. 
     @param vecRamachandran vector of Ramachandran database information
     @param phi  input phi angle value, in radian unit
     @param psi  input psi angle value,  in radian unit
     @return the probability of the (phi, psi) angle in the database
    **/
    public double CompRamachandranScore(double phi, double psi, Vector vecRamachandran)
    {
    	double Threshold=2.0* Math.PI / 180.0;//convert into radian unit
    	
    	if(phi>=180*Math.PI / 180.0)
    		phi=phi-360*Math.PI / 180.0;//convert into radian unit
    	if(psi>=180*Math.PI / 180.0)
    		psi=psi-360*Math.PI / 180.0;//convert into radian unit
    	
    	for(int i=0;i<vecRamachandran.size();i++)
    	{
    		PhiPsi phipsi=(PhiPsi)vecRamachandran.elementAt(i);
    		double phiT=phipsi.getPhi();
    		double psiT=phipsi.getPsi();
    		double score=phipsi.getRamaScore();
    		if(Math.abs(phi-phiT)< Threshold && Math.abs(psi-psiT)<Threshold)
    		{
    			return score;
    		}    		
    	}//for(int i=0;i<vecRamachandran.size();i++)
    	return 0.0;
    }//end of function "CompRamachandranScore".
    
    
     /**
      * Compute the Phi angles from RDC equations. 
      * Note: Modified from PhiPsi.phiCal(); The difference is that here we don't use the 
      * SSE Ramachandran regions to prune phi/psi angles. 
      *  
      @param rdc  Rdc data of CH vector
      @param rg  the rotation matrix rotate a POF to a frame defined in the peptine plane $i$
      @param Syy diagonilized Saupe elements computed by SVD with both CH and NH RDCs.
      @param Szz diagonilized Saupe elements 
      @return a set of solutions for \phi angles: if the set empty ==> no solution
     **/
     public Vector phiCalAll(double Syy, double Szz, double rdc, Matrix Rg)
	 {	    	 
    	 PhiPsi ff=new PhiPsi();
		 Matrix M = Const.r9y1x.times(Rg); //The "M" Matrix as appeared in the Math derivation
    	 double [][] mat = M.getArray();
		 Matrix r2y     = new Matrix(3, 3);  //M.rotationMat(phiAve, "+y"); 
		 Vector phiVec  = new Vector();
		 double phiHigh = 0.0;
		 double phiLow = 0.0;
		 phiHigh=999.9;
		 phiLow=-9999.9;
		 /*
	 	 if(isHelix)
	 	 {
	 		 phiHigh = Const.phiHighHelix;
	 		 phiLow  = Const.phiLowHelix;
	 	 }else
	 	 {
	 	    phiHigh = Const.phiHighBeta;
	 	    phiLow  = Const.phiLowBeta;
	 	 }*/
	 	 double[] coefs = new double[14]; //used for returning the coefficents from the quartic equation.
	 	 boolean coefFlag = ff.quarticCoefPhi(Syy,  Szz,  rdc,  mat, coefs);
	 	 if(!coefFlag)
		 {       //can not compute coefficients
		 	 return phiVec;
		 }else
		 {
			 Vector rootVec = ff.quarticSolve(coefs);
			 if (rootVec.isEmpty())
		 	 {  //no solution
		 		return phiVec;
		 	 }else
		 	 { //Compute the Phi angle
		 		 double x = 0.0, y = 0.0, z = 0.0;
		 		 double [] bondVector = new double[3]; //three directional cosines for a bind vector
		 		 double tmp1 = 0.0, tmp2 = 0.0, sinPhi = 0.0, cosPhi = 0.0, phi = 0.0;
		 		 double cSquare = ff.dirCosCH[0] *ff.dirCosCH[0] +ff.dirCosCH[2] * ff.dirCosCH[2]; //Cx^2+Cz^2
		 		
			 	 double[] bondDir = new double[3];
			 	 final double eps = 1.0E-7;
			 	 for (int i=0; i<rootVec.size(); i++)
			 	 {
			 		 bondVector = (double[])(rootVec.elementAt(i));
			 		 x = bondVector[0];
			 		 y = bondVector[1];
			 		 z = bondVector[2];
			 		 tmp1 = ff.dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) 
			 			+ ff.dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
		
			 		 tmp2 = ff.dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) 
			 				- ff.dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
			 		 if ( cSquare != 0.0)
			 		 {
			 			 cosPhi = tmp1 / cSquare;
			 			 sinPhi = tmp2 / cSquare;
			 			 if ( cosPhi >= 0.0 )
			 				 phi = Math.asin(sinPhi);
			 			 else if ( cosPhi < 0 )
			 				phi = Math.PI - Math.asin(sinPhi);
		 			 } 
			 		 else 
		 		     {
		 		    	System.out.println("both Cx and Cz are zero");
		 		    	System.exit(1);
		 		     }
		 		     if (phi > Math.PI)
		 		    	phi = phi - 2.0*Math.PI;
		 		     if ( phi < phiHigh && phi > phiLow )
		 		     {
		 		    	 r2y = M.rotationMat(phi, "+y");  //The computed phi angle: and check the solutions
		 		    	 bondDir = (Const.rHA2HA1).times(r2y.times(M.times(bondVector)));
		 		    	 if(Math.abs(bondDir[0] - 0.0) < eps && Math.abs(bondDir[1] - 0.0) < eps 
			 					&& Math.abs(bondDir[2] - 1.0) < eps)
		 		    	 {
			 				 phiVec.add(new Double(phi));
		 		    	 }
		 		      } //
		 		     }//for (int i=0; i<rootVec.size(); i++)
			 		 return  phiVec;
		 		}
		 	}
	     }//end of function "phiCal"
     
    /**get the residue name from the sequence information, given the residue number.
      * 
      * @param vecSeqence sequence information
      * @param res_no residue number
      * @return
    */
    public String GetResNameFromSequence(Vector vecSequence,int res_no)
    {
    	for(int i=0;i<vecSequence.size();i++)
    	{
    		Assign asg=(Assign)vecSequence.elementAt(i);
    		int no=asg.getResidueNo();
    		String resName=asg.getResidueType();
    		if(res_no==no)
    			return resName;
    	}//for(int i=0;i<vecSequence.size();i++)
    	return "";
    }
     
    /**
      * Compute the Psi angles. This is a test method to see if it can
      * reproduce the directional cosines of the CH vector and the \phi angle.
      @param rdc  Rdc data of NH vector
      @param phi  the computed \phi value for the same residue
      @param rg  the rotation matrix rotate a POF to a frame defined in the peptine plane $i$
      @param Syy diagonilized Saupe elements computed by SVD with both CH and NH RDCs.
      @param Szz diagonilized Saupe elements 
      @return a set of solutions for \psi angles: if the set empty ==> no solution
    **/
    public Vector psiCalAll(double Syy, double Szz, double rdc, double phi, Matrix rg)
    {
    	PhiPsi ff=new PhiPsi();
	 	Matrix r2y = rg.rotationMat(phi, "+y"); 
	 	//The Matrix M as appeared in the Mth derivation
	 	Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
	 	double [][] mat = M.getArray();
	 	double[] coefs = new double[14];
	 	Vector psiVec = new Vector();
	 	final double eps = 1.0E-7;
	 	double psiHigh = 0.0;
	 	double psiLow = 0.0;
	 	psiHigh=9999.9;
	 	psiLow=-9999.9;
	 	/*
	 	if(isHelix)
	 	{
	 	    psiHigh = Const.psiHighHelix;
	 	    psiLow  = Const.psiLowHelix;
	 	}else{
	 	    psiHigh = Const.psiHighBeta;
	 	    psiLow  = Const.psiLowBeta;
	 	}*/
	 	boolean coefFlag = ff.quarticCoefPsi(Syy,  Szz,  rdc,  mat,  coefs);
	 	if(!coefFlag)
	 	{ //can not compute coefficients
	 	    System.out.println("can not compute coefficients for the quartic equation");
	 	    return psiVec;
	 	}else{
 	    Vector rootVec = ff.quarticSolve(coefs);
 	    if ( rootVec.isEmpty() )
 	    {  //no solution
 	    	return psiVec;
 	    }else
 	    {
	 		double x = 0.0, y = 0.0, z = 0.0;
	 		double [] bondVector = new double[3]; //three directional cosines for a bind vector
	 		double tmp1 = 0.0, tmp2 = 0.0, sinPsi = 0.0, cosPsi = 0.0,  psi=0.0;
	 		double cSquare = ff.dirCosNH[0] * ff.dirCosNH[0] + ff.dirCosNH[1] * ff.dirCosNH[1];

	 		Matrix rPsiz = new Matrix(3,3);
	 		double[] bondDir = new double[3];

	 		for (int i=0; i<rootVec.size(); i++)
	 		{
	 		    bondVector = (double[])(rootVec.elementAt(i)); //IN this case it is NH vector
	 		    x = bondVector[0];
	 		    y = bondVector[1];
	 		    z = bondVector[2];
	 		    tmp1 = ff.dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) 
	 		    	+ ff.dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
	 		    tmp2 = ff.dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) 
	 		    - ff.dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
	 		    if ( cSquare != 0.0)
	 		    {
		 			sinPsi = tmp2 / cSquare;
		 			cosPsi = -tmp1 / cSquare;
		 			if ( cosPsi >= 0.0 )
		 				psi = Math.asin(sinPsi);
		 			else if ( cosPsi < 0 )
		 				psi = Math.PI - Math.asin(sinPsi);
	 		    	}else
	 		    	{
			 			System.out.println("Both Cx or Cz are zero");
			 			System.exit(1);
	 		    	}
	 		    	if (psi < -Math.PI)  //in order to bring \Psi angle to be in [0, PI] for Beta, Sheet
	 		    		psi = psi + 2.0*Math.PI;

		 		    //here we prune bad angles using ramachandran plot
		  		    if ( psi < psiHigh && psi > psiLow)
		  		    {
			 			rPsiz = M.rotationMat(psi + Math.PI, "+z");  //check the solutions before squaring
			 			bondDir = (Const.r7x6y5x).times(rPsiz.times(M.times(bondVector)));			
			 			if(Math.abs(bondDir[0] - 0.0) < eps && Math.abs(bondDir[1] - 0.0) < eps 
			 			   && Math.abs(bondDir[2] + 1.0) < eps)
			 			{			 
			 				psiVec.add(new Double(psi));
			 			}
		  		    }
	 			}	
	 			return  psiVec;
 	    	}
	 	}
     }
    
    /**
     * tell whether a point is within the clusters of previous ensemble
     * 
     @param vecPoints ensemble of point to 
     @param cc the obj point
     @param resolution resolution of the clustering
     @return rmsd
     */
    public boolean isInPhiPsiClusters(Vector vecPhiPsi, PhiPsi ff,  double resolution)
    {
    	boolean isInClusters=false;    	
    	for(int i=0;i< vecPhiPsi.size();i++)
    	{
    		PhiPsi ffTemp=(PhiPsi)vecPhiPsi.elementAt(i);
    		
    		//compute the l2 distance:
    		double phiA=ffTemp.getPhi();
    		double psiA=ffTemp.getPsi();
    		double phiB=ff.getPhi();
    		double psiB=ff.getPsi();
    		double dist=Math.sqrt( (phiA-phiB)*(phiA-phiB)+(psiA-psiB)*(psiA-psiB)  );    	
    		if(dist< resolution)
    			isInClusters=true;    		
    	}//for(int i=0;i< vecEnsemblePdb.size();i++)
    	return isInClusters;
    }
    
   
   
    
}
