package NascaGUI;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
public class Global {
	//user parameters:
	public static String strBBPdbFile=""; //backbone PDB file name
	public static String strBBCSFile=""; //backbone chemical shift file name
	public static String strAliNoesyFile=""; //aliphatic NOESY file name;
	public static String strAroNoesyFile=""; //aromatic NOESY file name;
	public static String strN15NoesyFile=""; //N15 NOESY file name;
	
	//system parameters:
	
	//parameters of error windows in each dimension
	//in the ppm unit
	public static double haErr  = 0.04;
	public static double h1Err  = 0.04;
	public static double c13Err = 0.4;
	public static double hnErr  = 0.04;
	public static double nErr   = 0.4; 
	
	//distance threashold for contructing edges between proton labels
	public static double noeDistLimit=5.0;

	
	public static String userDir = System.getProperty("user.dir");
	public static String strInput=userDir+"/inputFiles/";  //default input file directory		
	public static String strOut=userDir+"/inputFiles/"; //default output file directory
	public static String strDefaultInputSessionName="/inputFiles/Nasca.input";//default input session file name
	
	public static void updateInputFilePath(String strIn){
		strInput=getCorrectFilePathAndName(strIn);
	}
	
	public static void updateOutputFilePath(String strOut){
		strOut=getCorrectFilePathAndName(strOut);
	}
	public static void updateDefaultInputSessionName(String fileName){
		strDefaultInputSessionName=getCorrectFilePathAndName(fileName);
	}
	
	public static String getInputFilePath(){
		return strInput;
	}
	public static String getOutputFilePath(){
		return strOut;
	}
	public static String getDefaultInputSessionName(){
		return strDefaultInputSessionName;
	}
	
	public static String getCorrectFilePathAndName(String strOriginal){
		int index=-1;
		if(strOriginal==null)
			return strOriginal+"/";
			index=strOriginal.indexOf(":");
		if(index>0) //absolute path name
			return strOriginal;
		else{   //relative path name
			String userDir = System.getProperty("user.dir");
			return userDir+strOriginal;
		}
		
	}

	/////////////////////////
	//other global variables:

	//added variable for storing final resonance and NOE assignments:
	public static Assignment finalAssignments=new Assignment();
	
	//the status of the program. 
	//-1, if there is some problem with the input files;
	//0, if the program is killed by user.
    //1, if the program runs and finishes successfully.
	public static int status=1;
	public static String stopMessage="The program has been terminated, probably because the input files were not fed to the program properly..." + "\n" + "No assignment has been computed."; //status=-1
	public static String stopByUserMessage="The program has been killed by user..."+"\n"+"No assignment has been computed.";//status=0
	public static String successMessage="The program has been run successfully."+ "\n" +"The side-chain resonance assignments and NOE assignments have been computed.";
	
}
