package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Collections;
import java.util.Vector;

import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;



public class AStar {
	
	/**Apply the A* search algorithm to find the optimal side-chain resonances.
     * 
     * note: unassigned case is possoble for a node; stereo protons can be assigned to 
     * the same resonance node.
     @param vecResonGraph resonance graph 
     @param vecHPositions structure graph   
     @param Map mapping matrix between two graphs  
     @param MapScore mapping score matrix
     @param vecNewNoesy noesy cross peak list
     @param vecBMRBNew BMRB information
     @param
     @return 
     */
	public Vector<H1CS> AStarSearchForSCAsgs(Vector<GraphNode> vecResonGraph,Vector<ProtonLabel> vecHPositions, int [][] Map,double [][] MapScore, 
			Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew)
	{			
		Peak pk=new Peak();
		BackNoe bkNoe=new BackNoe();
		Assign asg=new Assign();
		H1CS h1cs=new H1CS();
		//Noesy noesy=new Noesy();
		NascaNew nasca=new NascaNew();
		double csErrH=0.04; double csErrN=0.3;double csErrCA=0.3;
				
		while(true)
		{
			boolean isAllAsg=true;
			double maxScore=-99999.9;
			int maxID=-1;
			int maxMapID=-1;
			for(int j=0;j<vecHPositions.size();j++)
			{    						
				ProtonLabel label=(ProtonLabel)vecHPositions.elementAt(j);
				String res=label.getResName();
				String atom=label.getAtomName();
				String heavName=pk.GetHeavyAtomFromProton(res,atom);
				
				
				int resNo=label.getResNo();				
				Vector<GraphNode> vecMapSet=label.getMappingSet();
				Vector<ProtonLabel> vecAdj=label.getAdjVec();
				if(label.getIsAssigned())
					continue;
				
				////////////
				//if( ! heavName.equalsIgnoreCase("CB"))
				//	continue;
				////////////
				
				for(int k=0;k<vecMapSet.size();k++)
				{
					GraphNode nodeMap=(GraphNode)vecMapSet.elementAt(k);					
					if(nodeMap.asgedId>=0 )//////////
					{
						ProtonLabel nodeTemp=(ProtonLabel)vecHPositions.elementAt(nodeMap.asgedId);
						if(nodeTemp.stereoID!=label.getID())
							continue;
						else if(nodeMap.vecStereoSymSet.size()>0)
							continue;							////
					}        ///////////////////////
					Vector<H1CS> vecOneSCAsg=new Vector<H1CS> ();
					Vector<BackNoe> vecBackNoe=new Vector<BackNoe>();
					Vector<Noesy> vecNoesyTwo=new Vector<Noesy>();	
					Vector<Noesy> vecNoesy=nodeMap.vecAdjNOESY;
					vecNoesyTwo.addAll(vecNoesy);
					double cs_proton=nodeMap.getCSProton();
					double cs_heavy=nodeMap.getCSHeavy();
					
					if(label.stereoID>=0)
					{
						ProtonLabel nodeStereo=(ProtonLabel)vecHPositions.elementAt(label.stereoID);
					
						if(nodeStereo.asgedId>=0)
						{
							GraphNode ndStereoReson=(GraphNode)vecResonGraph.elementAt(nodeStereo.asgedId);
							if(Math.abs(ndStereoReson.getCSHeavy()-cs_heavy) >0.15)//0.15
								continue;
						}
					}//if(node2.stereoID>=0)
					vecOneSCAsg.add(new H1CS(resNo,res,atom,cs_proton));			
					vecOneSCAsg.add(new H1CS(resNo,res,heavName,cs_heavy));		
					
					for(int t=0;t<vecAdj.size();t++)
					{
						ProtonLabel nodeAdj=(ProtonLabel)vecAdj.elementAt(t);
						if(!(nodeAdj.getIsAssigned() && (nodeAdj.asgedId>=0)  ))
							continue;
						
						GraphNode nodeAdjReson=(GraphNode)vecResonGraph.elementAt(nodeAdj.asgedId);
						vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
						
						int resNoSec=nodeAdj.getResNo();
						String resSec=nodeAdj.getResName();
						String atomSec=nodeAdj.getAtomName();
						String heavyNameSec=pk.GetHeavyAtomFromProton(resSec,atomSec);
						double cs_protonSec=nodeAdjReson.getCSProton();
						double cs_heavySec=nodeAdjReson.getCSHeavy();
						vecOneSCAsg.add(new H1CS(resNoSec,resSec,atomSec,cs_protonSec));
						vecOneSCAsg.add(new H1CS(resNoSec,resSec,heavyNameSec,cs_heavySec));
						double distUp=6.0;
						if(nasca.isInCloseAdj(nodeAdj,label))
							distUp=2.7;
						vecBackNoe.add(new BackNoe(cs_proton,cs_heavy,cs_protonSec,distUp,0.0,resNo,resNoSec,res,resSec,atom,heavName,atomSec ));
						vecBackNoe.add(new BackNoe(cs_protonSec,cs_heavySec,cs_proton,distUp,0.0,resNoSec,resNo,resSec,res,atomSec,heavyNameSec,atom ));
					
					}//for(int t=0;t<vecAdj.size();t++)	
					
					Vector<BackNoe> vecBackNoeNew=bkNoe.DeleteRepeat(vecBackNoe);
					//Vector vecNoesyTwoNew=noesy.DeleteRepeatedNoesy3D(vecNoesyTwo);
					int [] numPeaks=new int[1];
					double dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoeNew,vecNoesyTwo, numPeaks,true);
					dbScore=dbScore*vecBackNoeNew.size();//the more number of matched nodes, the better
					Vector<H1CS> vecOneSCAsgNew=h1cs.DeleteRepeatAsg(vecOneSCAsg);
					double asgScore=h1cs.BMRBSatisticsScore(vecOneSCAsgNew,vecBMRBNew);
					
					//compute the actual cost, i.e. from first to current step:
					double gScore=dbScore+asgScore;//*0.5*vecBackNoeNew.size();//current score.		
					
					//////////////////////////////
					//compute the esitmated cost, i.e. from current step to the end:
					double hScore=ComputeAStarEstimatedCost(vecResonGraph,vecHPositions,vecBMRBNew,j);
					
					double fScore=gScore+hScore;
					//////////////////////////////
					
					if(fScore>maxScore)
					{
						maxScore=fScore;
						maxID=j;
						maxMapID=k;
					}
				}//for(int k=0;k<vecMapSet.size();k++)
				isAllAsg=false;
				
			}//for(int j=0;j<vecGraph.size();j++)			
			if(isAllAsg || maxID<=0)
				break;				
			
			//update the most confident node:
			System.out.print("Current expansion node: ID="+maxID+", ");
			
			ProtonLabel label=(ProtonLabel)vecHPositions.elementAt(maxID);
			Vector<GraphNode> vecMapSet=label.getMappingSet();
			GraphNode nodeMap=(GraphNode)vecMapSet.elementAt(maxMapID);
			label.asgedId=nodeMap.getID();
			nodeMap.asgedId=label.getID();
			label.setIsAssigned(true);
			nodeMap.setIsAssigned(true);
			System.out.println(label.getResNo()+label.getResName()+" - "+label.getAtomName()+": " + nodeMap.getCSProton()+" , "+ nodeMap.getCSHeavy());
			
			//try to assign the stereo proton node:
			///int stereoProtonID=label.stereoID;
			if(label.stereoID>0)
			{
				ProtonLabel ndStereoProton=(ProtonLabel)vecHPositions.elementAt(label.stereoID);
				Vector<GraphNode> vecStereoReson=nodeMap.vecStereoSymSet;
				if(vecStereoReson.size()>0)
				{
					if(vecStereoReson.size()==1)
					{
						GraphNode ndStereoReson=(GraphNode)vecStereoReson.elementAt(0);
						ndStereoProton.asgedId=ndStereoReson.getID();
						ndStereoReson.asgedId=ndStereoProton.getID();
						ndStereoProton.setIsAssigned(true);
						ndStereoReson.setIsAssigned(true);
					}
					else
					{
						Vector<GraphNode> vecStereoProtonMap=ndStereoProton.getMappingSet();
						vecStereoProtonMap=new Vector<GraphNode>();
						vecStereoProtonMap.addAll(vecMapSet);
					}
				}
			}//if(node2.stereoID>0)
			
		}//while(true)		
			
		Vector<H1CS> vecAsg=new Vector<H1CS>();
		for(int j=0;j<vecHPositions.size();j++)
		{    						
			ProtonLabel node2=(ProtonLabel)vecHPositions.elementAt(j);
			String resName=node2.getResName();
			String atomName=node2.getAtomName();
			String heavName=pk.GetHeavyAtomFromProton(resName,atomName);
			int resNo=node2.getResNo();
			
			int resonID=node2.asgedId;
			if(resonID<0)
				continue;
			GraphNode nodeResonAsg=(GraphNode)vecResonGraph.elementAt(resonID);
			double cs_proton=nodeResonAsg.getCSProton();
			double cs_heavy=nodeResonAsg.getCSHeavy();
			vecAsg.add(new H1CS(resNo,resName,atomName,cs_proton));
			vecAsg.add(new H1CS(resNo,resName,heavName,cs_heavy));
		}//for(int j=0;j<vecGraph.size();j++)
		
		return vecAsg;
	}


	/**compute the estimated cost in A* search.
	 @param vecResonGraph resonance graph. 
    @param vecStructGraph structure graph.
    @param vecBMRBNew BMRB information.  
    @param curIndex current index.
	 * @return
	 */
	public double ComputeAStarEstimatedCost(Vector<GraphNode> vecResonGraph,Vector<ProtonLabel> vecLabels,Vector<H1CS> vecBMRBNew, int curIndex)
	{
		Peak pk=new Peak();
		//BackNoe bkNoe=new BackNoe();
		//Assign asg=new Assign();
		H1CS h1cs=new H1CS();
		//double csErrH=0.04; double csErrN=0.3;double csErrCA=0.3;
		double est_cost=0.0;
		for(int j=0;j<vecLabels.size();j++)
		{    						
			ProtonLabel label=(ProtonLabel)vecLabels.elementAt(j);
			String res=label.getResName();
			String atom=label.getAtomName();
			String heavName=pk.GetHeavyAtomFromProton(res,atom);
			int resNo=label.getResNo();				
			Vector<GraphNode> vecMapSet=label.getMappingSet();
			//Vector<ProtonLabel> vecAdj=label.getAdjVec();
			if(label.getIsAssigned() || curIndex==j)
				continue;
			double maxScore=-99999.9;
			int maxMapID=-1;
			for(int k=0;k<vecMapSet.size();k++)
			{
				GraphNode nodeMap=(GraphNode)vecMapSet.elementAt(k);					
				if(nodeMap.asgedId>=0 )//////////
				{
					ProtonLabel nodeTemp=(ProtonLabel)vecLabels.elementAt(nodeMap.asgedId);
					if(nodeTemp.stereoID!=label.getID())
						continue;
					else if(nodeMap.vecStereoSymSet.size()>0)
						continue;							////
				}        ///////////////////////
				Vector<H1CS> vecOneSCAsg=new Vector<H1CS>();
				//Vector<BackNoe> vecBackNoe=new Vector<BackNoe>();
				Vector<Noesy> vecNoesyTwo=new Vector<Noesy>();	
				Vector<Noesy> vecNoesy=nodeMap.vecAdjNOESY;
				vecNoesyTwo.addAll(vecNoesy);
				double cs_proton=nodeMap.getCSProton();
				double cs_heavy=nodeMap.getCSHeavy();
				
				if(label.stereoID>=0)
				{
					ProtonLabel nodeStereo=(ProtonLabel)vecLabels.elementAt(label.stereoID);
				
					if(nodeStereo.asgedId>=0)
					{
						GraphNode ndStereoReson=(GraphNode)vecResonGraph.elementAt(nodeStereo.asgedId);
						if(Math.abs(ndStereoReson.getCSHeavy()-cs_heavy) >0.15)//0.15
							continue;
					}
				}//if(node2.stereoID>=0)
				vecOneSCAsg.add(new H1CS(resNo,res,atom,cs_proton));			
				vecOneSCAsg.add(new H1CS(resNo,res,heavName,cs_heavy));		
				
				//Here we don't use the pairwise energy becoz it is quite slow to estimate it.
				/*
				for(int t=0;t<vecAdj.size();t++)
				{
					Node nodeAdj=(Node)vecAdj.elementAt(t);
					if(!nodeAdj.getIsAssigned())
						continue;
					Node nodeAdjReson=(Node)vecResonGraph.elementAt(nodeAdj.asgedId);
					vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
					
					int resNoSec=nodeAdj.getResNo();
					String resSec=nodeAdj.getResName();
					String atomSec=nodeAdj.getAtomName();
					String heavyNameSec=pk.GetHeavyAtomFromProton(resSec,atomSec);
					double cs_protonSec=nodeAdjReson.getProtonCS();
					double cs_heavySec=nodeAdjReson.getHeavyCS();
					vecOneSCAsg.add(new H1CS(resNoSec,resSec,atomSec,cs_protonSec));
					vecOneSCAsg.add(new H1CS(resNoSec,resSec,heavyNameSec,cs_heavySec));
					double distUp=6.0;
					if(isInCloseAdj(nodeAdj,node2))
						distUp=2.7;
					vecBackNoe.add(new BackNoe(cs_proton,cs_heavy,cs_protonSec,distUp,0.0,resNo,resNoSec,res,resSec,atom,heavName,atomSec ));
					vecBackNoe.add(new BackNoe(cs_protonSec,cs_heavySec,cs_proton,distUp,0.0,resNoSec,resNo,resSec,res,atomSec,heavyNameSec,atom ));
				
				}//for(int t=0;t<vecAdj.size();t++)	
				*/
				//Vector vecBackNoeNew=bkNoe.DeleteRepeat(vecBackNoe);
				
				//int [] numPeaks=new int[1];
				//double dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoeNew,vecNoesyTwo, numPeaks,true);
				//dbScore=dbScore*vecBackNoeNew.size();//the more number of matched nodes, the better
				Vector<H1CS> vecOneSCAsgNew=h1cs.DeleteRepeatAsg(vecOneSCAsg);
				double asgScore=h1cs.BMRBSatisticsScore(vecOneSCAsgNew,vecBMRBNew);				
				
				double score=asgScore;//dbScore+asgScore;//*0.5*vecBackNoeNew.size();//current score.					
				if(score>maxScore)
				{
					maxScore=score;					
					maxMapID=k;
				}
			}//for(int k=0;k<vecMapSet.size();k++)
			if(maxMapID>=0)
				est_cost=est_cost+maxScore;
			
		}//for(int j=0;j<vecGraph.size();j++)			
		return est_cost;
	}

	/**Apply the A* search algorithm to find the optimal side-chain resonances.
     * 
     * note: unassigned case is possoble for a node; stereo protons can be assigned to 
     * the same resonance node.
     @param vecResonGraph resonance graph 
     @param vecHPositions structure graph   
     @param Map mapping matrix between two graphs  
     @param MapScore mapping score matrix
     @param vecNewNoesy noesy cross peak list
     @param vecBMRBNew BMRB information
     @param
     @return 
     */
	public void AStarSearchForSCAsgsNew(Vector<GraphNode> vecResonGraph,Vector<ProtonLabel> vecHPositions, int [][] Map,double [][] MapScore, 
			Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew)	{	
		
		//initialization:
		Vector<TreeNode> vecTNodeQueue=new Vector<TreeNode>();
		int MAX_ID=2000;
		double bestScoreMatrix[][]=new double[MAX_ID][MAX_ID];
		for(int i=0;i<MAX_ID;i++)
			for(int j=0;j<MAX_ID;j++)
				bestScoreMatrix[i][j]=0;
		PairwiseScoreMatrix pwScoreMatrix=new PairwiseScoreMatrix();
		pwScoreMatrix.computBestScoreMatrix(vecResonGraph,vecHPositions,vecBMRBNew,bestScoreMatrix);
		
		Vector<GraphNode> vecResonQueue=new Vector<GraphNode>();
		for(int i=0;i<vecResonGraph.size();i++){
			GraphNode node=(GraphNode)vecResonGraph.elementAt(i);
			if(node.getIsAssigned())
				continue;
			if(node.getMappingSet().size()==0) //we remove the isolated resonance node
				continue;
			vecResonQueue.add(node);
		}//for(int i=0;i<vecResonGraph.size();i++){
		
		//Vector<GraphNode> vecResonQueueOrig=new Vector<GraphNode>();
		//vecResonQueueOrig.addAll(vecResonQueue);//check this...
			
		Collections.sort(vecResonQueue, new GraphNode.scoreComparator());
		
		GraphNode firstResonNode=(GraphNode)vecResonQueue.elementAt(0);
		//vecResonQueue.remove(0);
		
		TreeNode treeRoot=null;//new TreeNode();
	    Vector<ProtonLabel> vecMapSet=firstResonNode.getMappingSet();
		for(int i=0;i<vecMapSet.size();i++){
			ProtonLabel label=(ProtonLabel)vecMapSet.elementAt(i);
			
			TreeNode tree_node=new TreeNode();
		    //treeRoot.vecChildNode.add(tree_node);
		    tree_node.pNode=treeRoot;
			
		    tree_node.resonNode=firstResonNode;
		    tree_node.labelNode=label;
		    tree_node.level=1;
		    tree_node.vecUnsgedNodes=computUnassignedNodes(tree_node,vecResonQueue);//double check??
		    
		    double h_score=computEstimateScore(tree_node,vecResonQueue);
 		    double g_score=computActualScore(tree_node,vecHPositions,vecBMRBNew);
			tree_node.setActualScore(g_score);
			tree_node.setEstimateScore(h_score);
			tree_node.setTotalScore();
			vecTNodeQueue.add(tree_node);
			
			//deal with the stereo assignment:			
			if(label.stereoID>0){
				ProtonLabel ndStereoProton=(ProtonLabel)vecHPositions.elementAt(label.stereoID);
				Vector<GraphNode> vecStereoReson=firstResonNode.vecStereoSymSet;
				if(vecStereoReson.size()>0)
				{
					if(vecStereoReson.size()==1){
						GraphNode ndStereoReson=(GraphNode)vecStereoReson.elementAt(0);
						TreeNode stereoUnasgTNode=locateOneFromRemainUnasgedNodes(ndStereoReson,tree_node.vecUnsgedNodes);
						stereoUnasgTNode.labelNode=ndStereoProton;							
					}
					else{  //need to double check this step
						for(int h=0;h<vecStereoReson.size();h++){
							GraphNode tempResonNode=(GraphNode)vecStereoReson.elementAt(h);
							Vector<ProtonLabel> vecStereoTemp=tempResonNode.getMappingSet();
							vecStereoTemp=new Vector<ProtonLabel>();
							vecStereoTemp.addAll(vecMapSet);
						}//for(int h=0;h<vecStereoReson.size();h++)
						
					}
				}
			}//if(label.stereoID>0)		    
			
		}//for(int i=0;i<vecMapSet.size();i++){
		
		//starting the A* search;
		//TreeNode tnode=new TreeNode();
		TreeNode leafNode=new TreeNode();
		int curTreeLevel=1;
		int maxTreeLevel=1;
		while(maxTreeLevel <vecResonQueue.size()){
			Collections.sort(vecTNodeQueue, new TreeNode.fscoreComparator());
			TreeNode expanTNode=vecTNodeQueue.elementAt(0);
			curTreeLevel=expanTNode.level;
			
			//if(curTreeLevel==87)
				//System.out.println("debugging...current level=: "+ curTreeLevel);
			
			if(curTreeLevel==maxTreeLevel)
				maxTreeLevel++;			
			
			GraphNode currentResonNode=(GraphNode)vecResonQueue.elementAt(curTreeLevel);
									
			if( Math.abs(currentResonNode.getCSHeavy()-29.522) <0.1 && Math.abs(currentResonNode.getCSProton()-1.992) <0.04 )
				System.out.println("debugging...here");
			
			TreeNode curTNode=locateOneFromRemainUnasgedNodes(currentResonNode,expanTNode.vecUnsgedNodes);
			if(curTNode.labelNode!=null){ //it has been assigned based on previous stereo assignment.
				TreeNode tree_node=new TreeNode();
				expanTNode.vecChildNode.add(tree_node);
			    tree_node.pNode=expanTNode;
			    
			    tree_node.resonNode=currentResonNode;
			    tree_node.labelNode=curTNode.labelNode;
			    tree_node.level=curTreeLevel+1;			   			    
			    Vector<TreeNode> vecPreUnasgNodes=expanTNode.vecUnsgedNodes;
			    tree_node.vecUnsgedNodes=computUnassignedNodesFromPre(tree_node,vecPreUnasgNodes);
			    double h_score=computEstimateScore(tree_node,vecResonQueue);
			    double g_score=computActualScore(tree_node,vecHPositions,vecBMRBNew);
			    tree_node.setActualScore(g_score);
				tree_node.setEstimateScore(h_score);
				tree_node.setTotalScore();
				vecTNodeQueue.add(tree_node);
				if(maxTreeLevel == (vecResonQueue.size()-1) )
					leafNode=tree_node;				
			}//if(curTNode.resonNode!=null)
			else{
				Vector<ProtonLabel> vecCurMapSet=currentResonNode.getMappingSet();			
				double maxScore=-9999.9;
				boolean isStereoAsg=false;
				
				for(int i=0;i<vecCurMapSet.size();i++){
					ProtonLabel label=(ProtonLabel)vecCurMapSet.elementAt(i);
					TreeNode tree_node=new TreeNode();
					expanTNode.vecChildNode.add(tree_node);
				    tree_node.pNode=expanTNode;
				    
				    tree_node.resonNode=currentResonNode;
				    tree_node.labelNode=label;
				    tree_node.level=curTreeLevel+1;			   			    
				    Vector<TreeNode> vecPreUnasgNodes=expanTNode.vecUnsgedNodes;
				    tree_node.vecUnsgedNodes=computUnassignedNodesFromPre(tree_node,vecPreUnasgNodes);
				   
				    //prune using stereo assignment information
				    boolean isStereoPruned=isPruneMapByStereo(currentResonNode, label, vecResonGraph, vecHPositions,tree_node.vecUnsgedNodes);
				    if (isStereoPruned)
				    	continue;
				    
				    double h_score=computEstimateScore(tree_node,vecResonQueue);
				    double g_score=computActualScore(tree_node,vecHPositions,vecBMRBNew);
				    tree_node.setActualScore(g_score);
					tree_node.setEstimateScore(h_score);
					tree_node.setTotalScore();
					vecTNodeQueue.add(tree_node);		
					if((h_score+g_score)>maxScore){//for locating the final leaf node in order to trace back.
						maxScore=h_score+g_score;
						if(maxTreeLevel == (vecResonQueue.size()-1) )
							leafNode=tree_node;
					}
					
					//deal with the stereo assignment:			
					if(label.stereoID>0){
						ProtonLabel ndStereoProton=(ProtonLabel)vecHPositions.elementAt(label.stereoID);
						Vector<GraphNode> vecStereoReson=currentResonNode.vecStereoSymSet;
						if(vecStereoReson.size()>0)
						{
							if(vecStereoReson.size()==1){
								isStereoAsg=true;
								GraphNode ndStereoReson=(GraphNode)vecStereoReson.elementAt(0);
								TreeNode stereoUnasgTNode=locateOneFromRemainUnasgedNodes(ndStereoReson,tree_node.vecUnsgedNodes);
								stereoUnasgTNode.labelNode=ndStereoProton;							
							}
							else{  //need to double check this step
								for(int h=0;h<vecStereoReson.size();h++){
									GraphNode tempResonNode=(GraphNode)vecStereoReson.elementAt(h);
									Vector<ProtonLabel> vecStereoTemp=tempResonNode.getMappingSet();
									vecStereoTemp=new Vector<ProtonLabel>();
									vecStereoTemp.addAll(vecCurMapSet);
								}//for(int h=0;h<vecStereoReson.size();h++)
								
							}
						}
					}//if(label.stereoID>0)		    
					
				}//for(int i=0;i<vecCurMapSet.size();i++)
				
				if(isStereoAsg) //delete non stereo assignment branches
					deleNonStereoBranches(expanTNode,vecTNodeQueue);
				
			}//else
			
			vecTNodeQueue.remove(0);
		}//while(maxTreeLevel <=vecResonQueue.size()){
		
		//update the GMEC sc assignments:
		for(int i=0;i<vecResonGraph.size();i++)
			for(int j=0;j<vecHPositions.size();j++)
				Map[i][j]=0;
		TreeNode tempTNode=leafNode;
		while(tempTNode!=null){
			GraphNode resonNode=(GraphNode)tempTNode.resonNode;
			ProtonLabel labelNode=(ProtonLabel)tempTNode.labelNode;
			Map[resonNode.getID()][labelNode.getID()]=1; //double check whether ID is equal to the index
			tempTNode=tempTNode.pNode;
		}
	}
	/**delete none stereo assignemnet branches at the current level of A* search tree.
     *  
     @param curTreeNode current tree node 
     @param vecAllResonNodes all resonance nodes
     @return h score
     */
	public void deleNonStereoBranches(TreeNode parentNode,Vector<TreeNode> vecTNodeQueue){
		Vector<TreeNode> vecChildTreeNodes=parentNode.vecChildNode;
		for(int i=0;i<vecChildTreeNodes.size();i++){
			TreeNode tempTNode=(TreeNode)vecChildTreeNodes.elementAt(i);
			if(tempTNode.labelNode.stereoID<0){//delete this branch
				vecChildTreeNodes.remove(i);
				i--;
				for(int j=0;j<vecTNodeQueue.size();j++){
					TreeNode qNode=(TreeNode)vecTNodeQueue.elementAt(j);
					if( (qNode.resonNode.getID()==tempTNode.resonNode.getID() ) && (qNode.labelNode.getID()==tempTNode.labelNode.getID()) )
						vecTNodeQueue.remove(j);
				}
			}
			
		}//for(int i=0;i<vecChildTreeNodes.size();i++)
	}
	
	/**whether prune mapping based on stereo information.
     *  
     @param curTreeNode current tree node 
     @param vecAllResonNodes all resonance nodes
     @return h score
     */
	public boolean isPruneMapByStereo(GraphNode resonNode, ProtonLabel label, Vector<GraphNode> vecResonNodes, 
			Vector<ProtonLabel> vecLabels,Vector<TreeNode> vecUnasgNodes){
		if(label.stereoID<0)
			return false;
		
		if(resonNode.vecStereoSymSet.size()==1){
			GraphNode stereo_resonNode=vecResonNodes.elementAt(resonNode.stereoID);
			TreeNode stereo_tNode=locateOneFromRemainUnasgedNodes(stereo_resonNode,vecUnasgNodes);
			if(stereo_tNode.labelNode!=null){
				if(stereo_tNode.labelNode.stereoID!=label.getID())
					return true;
			}
			
		}//if(resonNode.vecStereoSymSet.size()==1)
		else{ //double check this step
			for(int i=0;i<vecUnasgNodes.size();i++){
				TreeNode tNode=(TreeNode)vecUnasgNodes.elementAt(i);
				if(tNode.labelNode==null)
					continue;
				if(tNode.labelNode.getID()==label.getID())
					return true;		
			}//for(int i=0;i<vecUnasgNodes.size();i++		
			
		}//else
		
		
		ProtonLabel labelStereo=(ProtonLabel)vecLabels.elementAt(label.stereoID);
		for(int i=0;i<vecUnasgNodes.size();i++){
			TreeNode tNode=(TreeNode)vecUnasgNodes.elementAt(i);
			if(tNode.labelNode==null)
				continue;
			if(labelStereo.getID()==tNode.labelNode.getID()){
				double cs_heavy=resonNode.getCSHeavy();
				if(Math.abs(tNode.resonNode.getCSHeavy()-cs_heavy) >0.15)//0.15
					return true;
			}			
			
		}//for(int i=0;i<vecUnasgNodes.size();i++		
		
		
		return false;		
	}
		
	/**locate one unassigned node in the list
     *  
     @param curTreeNode current tree node 
     @param vecAllResonNodes all resonance nodes
     @return h score
     */
	public TreeNode locateOneFromRemainUnasgedNodes(GraphNode resonNode ,Vector<TreeNode> vecUnasgNodes){
		int resonID=resonNode.getID();
		for(int i=0;i<vecUnasgNodes.size();i++){
			TreeNode tNode=(TreeNode)vecUnasgNodes.elementAt(i);
			GraphNode tempResonNode=tNode.resonNode;
			if(resonID==tempResonNode.getID())
				return tNode;
		}
		return null;			
	}
	/**compute the remaining unassigned nodes. Used for tracking the stereo assignments.
     *  
     @param curTreeNode current tree node 
     @param vecAllResonNodes all resonance nodes
     @return h score
     */
	public Vector<TreeNode> computUnassignedNodesFromPre(TreeNode curTreeNode,Vector<TreeNode> vecPreUnasgNodes){
		Vector<TreeNode> vecUnasgNodes=new Vector<TreeNode>();
		GraphNode curResonNode=curTreeNode.resonNode;
		for(int i=0;i<vecPreUnasgNodes.size();i++){			
			TreeNode t_node=(TreeNode)vecPreUnasgNodes.elementAt(i);
			GraphNode preResonNode=t_node.resonNode;
			if(preResonNode.getID()==curResonNode.getID())
				continue;			
			vecUnasgNodes.add(new TreeNode(t_node));	//double check this		 
		}//for(int i=0;i<vecAllResonNodes.size();i++){		
		return vecUnasgNodes;
	}
	
	/**compute the remaining unassigned nodes. Used for tracking the stereo assignments.
     *  
     @param curTreeNode current tree node 
     @param vecAllResonNodes all resonance nodes
     @return h score
     */
	public Vector<TreeNode> computUnassignedNodes(TreeNode curTreeNode,Vector<GraphNode> vecAllResonNodes){
		Vector<TreeNode> vecUnasgNodes=new Vector<TreeNode>();
		for(int i=0;i<vecAllResonNodes.size();i++){
			 GraphNode node=(GraphNode)vecAllResonNodes.elementAt(i);
			 if(node.getIsAssigned())
				 continue;
			 boolean isExplored=false;
			 TreeNode tempTreeNode=curTreeNode;
			 while(tempTreeNode!=null){
				 GraphNode nodeTemp=tempTreeNode.resonNode;
				 if(nodeTemp.getID()==node.getID()){
					 isExplored=true;
					 break;
				 }
				 tempTreeNode=tempTreeNode.pNode;
			 }//while(tempTreeNode!=null){
			 if(isExplored)
				 continue;
			
			 TreeNode tree_node=new TreeNode();
			 tree_node.resonNode=node;
			 vecUnasgNodes.add(tree_node);
			 
		}//for(int i=0;i<vecAllResonNodes.size();i++){
		
		return vecUnasgNodes;
	}
	/**compute the estimate score h.
     *  
     @param curTreeNode current tree node 
     @param vecResonGraph resonance graph   
     @return h score
     */
	public double computEstimateScore(TreeNode curTreeNode,Vector<GraphNode> vecResonGraph){
		
		double score=0.0;
		for(int i=0;i<vecResonGraph.size();i++){
			 GraphNode node=(GraphNode)vecResonGraph.elementAt(i);
			 if(node.getIsAssigned())
				 continue;
			 boolean isExplored=false;
			 TreeNode tempTreeNode=curTreeNode;
			 while(tempTreeNode!=null){
				 GraphNode nodeTemp=tempTreeNode.resonNode;
				 if(nodeTemp.getID()==node.getID()){
					 isExplored=true;
					 break;
				 }
				 tempTreeNode=tempTreeNode.pNode;
			 }//while(tempTreeNode!=null){
			 if(isExplored)
				 continue;
			// if(node.bestScore<=0)
			// {
			//	 System.out.println("debugging...");
			// }
			 score=score+node.bestScore;
			 
		}//for(int i=0;i<vecResonGraph.size();i++){
		
		return score;	
	}
			
	
	/**compute the actual score g.
     *  
     @param pTreeNode parent tree node 
     @param cur_node current resonance node   
     @param cur_label current proton label node
     @param vecLabels proton label set
     @param vecBMRBNew BMRB statistical information
     @return h score
     */
	public double computActualScore(TreeNode curTreeNode, Vector<ProtonLabel> vecLabels,Vector<H1CS> vecBMRBNew){
		TreeNode pTreeNode=curTreeNode.pNode;
		GraphNode cur_node=curTreeNode.resonNode;
		ProtonLabel cur_label=curTreeNode.labelNode;
		
		TreeNode tnode=new TreeNode();
		Peak pk=new Peak();
		BackNoe bkNoe=new BackNoe();
		Assign asg=new Assign();
		H1CS h1cs=new H1CS();
		NascaNew nasca=new NascaNew();
		double csErrH=0.04; double csErrN=0.3;double csErrCA=0.3;
		tnode.setAsgedIdTemp(curTreeNode);
		
		Vector<Noesy> vecNoesy=cur_node.vecAdjNOESY;
		double cs_proton=cur_node.getCSProton();
		double cs_heavy=cur_node.getCSHeavy();
		Vector<GraphNode> vecAdj=cur_node.getAdjVec();
		
		Vector<H1CS> vecOneSCAsg=new Vector<H1CS>();
		Vector<BackNoe> vecBackNoe=new Vector<BackNoe>();
		String res=cur_label.getResName();
		String atom=cur_label.getAtomName();
		String heavName=pk.GetHeavyAtomFromProton(res,atom);
		int resNo=cur_label.getResNo();		
		
		Vector<Noesy> vecNoesyTwo=new Vector<Noesy>();	
		vecNoesyTwo.addAll(vecNoesy);
		
		vecOneSCAsg.add(new H1CS(resNo,res,atom,cs_proton));			
		vecOneSCAsg.add(new H1CS(resNo,res,heavName,cs_heavy));	
		
		for(int t=0;t<vecAdj.size();t++)
		{
			GraphNode nodeAdj=(GraphNode)vecAdj.elementAt(t);
			if(! ((nodeAdj.getIsAssigned() && (nodeAdj.asgedId>=0)) || nodeAdj.asgedIdTemp>=0) )
				continue;//need to be further tested...
			
			ProtonLabel nodeAdjLabel=new ProtonLabel();
			if(nodeAdj.getIsAssigned() && (nodeAdj.asgedId>=0) )
				nodeAdjLabel=(ProtonLabel)vecLabels.elementAt(nodeAdj.asgedId);				
			else
				if( nodeAdj.asgedIdTemp>=0)
					nodeAdjLabel=(ProtonLabel)vecLabels.elementAt(nodeAdj.asgedIdTemp);				
			
			vecNoesyTwo.addAll(nodeAdj.vecAdjNOESY);
			
			int resNoSec=nodeAdjLabel.getResNo();
			String resSec=nodeAdjLabel.getResName();
			String atomSec=nodeAdjLabel.getAtomName();
			String heavyNameSec=pk.GetHeavyAtomFromProton(resSec,atomSec);
			double cs_protonSec=nodeAdj.getCSProton();
			double cs_heavySec=nodeAdj.getCSHeavy();
			vecOneSCAsg.add(new H1CS(resNoSec,resSec,atomSec,cs_protonSec));
			vecOneSCAsg.add(new H1CS(resNoSec,resSec,heavyNameSec,cs_heavySec));
			double distUp=6.0;
			if(nasca.isInCloseAdj(nodeAdjLabel,cur_label))
				distUp=2.7;
			vecBackNoe.add(new BackNoe(cs_proton,cs_heavy,cs_protonSec,distUp,0.0,resNo,resNoSec,res,resSec,atom,heavName,atomSec ));
			vecBackNoe.add(new BackNoe(cs_protonSec,cs_heavySec,cs_proton,distUp,0.0,resNoSec,resNo,resSec,res,atomSec,heavyNameSec,atom ));
		
		}//for(int t=0;t<vecAdj.size();t++)	
		
		Vector<BackNoe> vecBackNoeNew=bkNoe.DeleteRepeat(vecBackNoe);
		//Vector vecNoesyTwoNew=noesy.DeleteRepeatedNoesy3D(vecNoesyTwo);
		int [] numPeaks=new int[1];
		double dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoeNew,vecNoesyTwo, numPeaks,true);
		dbScore=dbScore*vecBackNoeNew.size();//the more number of matched nodes, the better
		Vector<H1CS> vecOneSCAsgNew=h1cs.DeleteRepeatAsg(vecOneSCAsg);
		double asgScore=h1cs.BMRBSatisticsScore(vecOneSCAsgNew,vecBMRBNew);				
		
		double score=dbScore+asgScore;//*0.5*vecBackNoeNew.size();//current score.		
		double preScore=0.0;
		if(pTreeNode!=null)
			preScore=pTreeNode.gScore;
		return score+preScore;
	}
	
}
