/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.util.Collections;
import java.util.Vector;
import rdcPanda.Model;
import rdcPanda.Noe;
import rdcPanda.Pdb;
import rdcPanda.vdw;

public class Rotamer {
    private String AAName;
    private Vector pdbVec = new Vector();

    public Rotamer() {
        this.AAName = null;
        this.pdbVec = null;
    }

    public Rotamer(String res) {
        this.AAName = res;
        this.pdbVec = null;
    }

    public Rotamer(String res, Vector aa) {
        this.AAName = res;
        this.pdbVec = aa;
    }

    public String getAAName() {
        return this.AAName;
    }

    public Vector getPdbVec() {
        return this.pdbVec;
    }

    public void setAAName(String res) {
        this.AAName = res;
    }

    public void setAtomVec(Vector aVec) {
        this.pdbVec = aVec;
    }

    public boolean pruneRotamers(Vector vecPdb, String rotSrc, Vector noeVec, int curNo, int lastNo, Vector vecEmsemblePdbSave) throws JampackException {
        System.out.println("curNo=: " + curNo);
        if (curNo > lastNo) {
            int i = 0;
            while (i < noeVec.size()) {
                Pdb pp = new Pdb();
                double[][] noeDistance = new double[noeVec.size()][2];
                int noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                String atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                int noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                String atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                double[] dis = new double[1];
                double[] distance = new double[1];
                pp.measurePackDisAllRotamers(vecPdb, vecPdb, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                if (dis[0] > 0.0) {
                    return false;
                }
                ++i;
            }
            vdw vander = new vdw();
            Vector vdwVec = new Vector();
            double[] vdwValue = new double[1];
            boolean hasVDW = false;
            double vdwLevel = 0.05;
            boolean printVDWViolation = false;
            vdwVec = vander.convert2VDW(vecPdb);
            int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
            System.out.println("the number of steric clashes: " + numClashes);
            if (numClashes > 0) {
                return false;
            }
            vecEmsemblePdbSave.add(vecPdb);
            return true;
        }
        Vector pdbRotVec = new Vector();
        Pdb pp = new Pdb();
        int ind = Collections.binarySearch(vecPdb, new Pdb(curNo), new Pdb.PdbComparator());
        if (ind < 0) {
            this.pruneRotamers(vecPdb, rotSrc, noeVec, curNo + 1, lastNo, vecEmsemblePdbSave);
            return false;
        }
        Pdb pdbA = (Pdb)vecPdb.elementAt(ind);
        String resName = pdbA.getResidue();
        if (resName.equalsIgnoreCase("GLY")) {
            pdbRotVec.add(pdbA);
        } else {
            String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
            Vector<Pdb> pdbRotam = pp.readPdb(rotamFile);
            pdbRotVec = pp.nameConvert4SmallRotLibStr(pdbRotam);
        }
        boolean isAtLeaseOne = false;
        int i = 0;
        while (i < pdbRotVec.size()) {
            System.out.println("curNo=: " + curNo);
            System.out.println("rotamer id=: " + i);
            Vector<Pdb> vecRotNew = new Vector<Pdb>();
            Pdb pdb_temp = (Pdb)pdbRotVec.elementAt(i);
            vecRotNew.add(pdb_temp);
            Vector<Pdb> vecTemp = pp.CombinRotBB(vecRotNew, vecPdb, curNo);
            Model md = new Model();
            Vector vecGrowPdbNew = new Vector();
            vecGrowPdbNew = md.BackonbeRotation(vecTemp, vecPdb);
            boolean isContinue = false;
            int j = 0;
            while (j < noeVec.size()) {
                double[][] noeDistance = new double[noeVec.size()][2];
                int noA = ((Noe)noeVec.elementAt(j)).getResidueNoA();
                String atomA = ((Noe)noeVec.elementAt(j)).getAtomA();
                int noB = ((Noe)noeVec.elementAt(j)).getResidueNoB();
                String atomB = ((Noe)noeVec.elementAt(j)).getAtomB();
                noeDistance[j] = ((Noe)noeVec.elementAt(j)).getRange();
                double[] dis = new double[1];
                double[] distance = new double[1];
                boolean isMeasure = pp.measurePackDisAllRotamers(vecGrowPdbNew, vecGrowPdbNew, noA, atomA, noB, atomB, noeDistance[j][0], noeDistance[j][1], dis, distance);
                if (isMeasure && dis[0] > 0.0) {
                    isContinue = true;
                    break;
                }
                ++j;
            }
            if (!isContinue) {
                vdw vander = new vdw();
                Vector vdwVec = new Vector();
                double[] vdwValue = new double[1];
                boolean hasVDW = false;
                double vdwLevel = 0.05;
                boolean printVDWViolation = false;
                vdwVec = vander.convert2VDW(vecGrowPdbNew);
                int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
                if (numClashes <= 0) {
                    this.pruneRotamers(vecGrowPdbNew, rotSrc, noeVec, curNo + 1, lastNo, vecEmsemblePdbSave);
                }
            }
            ++i;
        }
        return false;
    }

    public Vector readRotamer(String rtamerFile) {
        Pdb pp = new Pdb();
        this.pdbVec = pp.readPdb(rtamerFile);
        return this.pdbVec;
    }

    public static void main(String[] argv) throws JampackException {
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String pdbFile = String.valueOf(src) + "H3.pdb";
        Vector<Pdb> vecTempPdb = pp.readPdb(pdbFile);
        Vector<Pdb> vecTempPdbBB = pp.OutputBackbone(vecTempPdb);
        String strManualAsg = "final.upl";
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
        Rotamer rt = new Rotamer();
        Vector vecEnsemblePdbs = new Vector();
        rt.pruneRotamers(vecTempPdbBB, rotSrc, vecManAsg, 10, 76, vecEnsemblePdbs);
        System.out.println("the ensemble size is: " + vecEnsemblePdbs.size());
    }
}

