/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.H1CS;
import rdcPanda.Pdb;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;
import rdcPanda.RdcPanda;
import rdcPanda.vdw;

public class Noe
implements Cloneable {
    private int peakID = 0;
    private int residueNoA;
    private int residueNoB;
    private String resA = "";
    private String resB = "";
    private String atomA;
    private String atomB;
    private double lower;
    private double upper;
    private double ratioEnsem;
    private Vector vecH_A = new Vector();
    private Vector vecH_B = new Vector();

    public Noe() {
        this.residueNoA = 0;
        this.residueNoB = 0;
        this.atomA = null;
        this.atomB = null;
        this.lower = 0.0;
        this.upper = 0.0;
        this.peakID = 0;
        this.ratioEnsem = 0.0;
        this.vecH_A = new Vector();
        this.vecH_B = new Vector();
    }

    public Noe(int NoA, int noB) {
        this.peakID = 0;
        this.residueNoA = NoA;
        this.residueNoB = noB;
        this.atomA = null;
        this.atomB = null;
        this.lower = 0.0;
        this.upper = 0.0;
        this.ratioEnsem = 0.0;
    }

    public Noe(int Ano, int Bno, String res1, String res2, String atom1, String atom2, double low, double up) {
        this.peakID = 0;
        this.residueNoA = Ano;
        this.residueNoB = Bno;
        this.resA = res1;
        this.resB = res2;
        this.atomA = atom1;
        this.atomB = atom2;
        this.lower = low;
        this.upper = up;
        this.ratioEnsem = 0.0;
    }

    public Noe(int pkID, int Ano, int Bno, String res1, String res2, String atom1, String atom2, double low, double up) {
        this.peakID = pkID;
        this.residueNoA = Ano;
        this.residueNoB = Bno;
        this.resA = res1;
        this.resB = res2;
        this.atomA = atom1;
        this.atomB = atom2;
        this.lower = low;
        this.upper = up;
        this.ratioEnsem = 0.0;
    }

    public Noe(int pkID, int Ano, int Bno, String res1, String res2, String atom1, String atom2, double low, double up, double r) {
        this.peakID = pkID;
        this.residueNoA = Ano;
        this.residueNoB = Bno;
        this.resA = res1;
        this.resB = res2;
        this.atomA = atom1;
        this.atomB = atom2;
        this.lower = low;
        this.upper = up;
        this.ratioEnsem = r;
    }

    public Noe(int Ano, String atom1, int Bno, String atom2, double low, double up) {
        this.peakID = 0;
        this.residueNoA = Ano;
        this.residueNoB = Bno;
        this.resA = "";
        this.resB = "";
        this.atomA = atom1;
        this.atomB = atom2;
        this.lower = low;
        this.upper = up;
        this.ratioEnsem = 0.0;
    }

    public Noe(int pkID, Vector vec1, Vector vec2, double low, double up) {
        H1CS h1cs;
        this.peakID = pkID;
        this.vecH_A.addAll(vec1);
        this.vecH_B.addAll(vec2);
        if (vec1.size() > 0) {
            h1cs = (H1CS)this.vecH_A.elementAt(0);
            this.residueNoA = h1cs.getResidueNo();
            this.resA = h1cs.getResidueType();
            this.atomA = h1cs.getAtomName();
        }
        if (vec2.size() > 0) {
            h1cs = (H1CS)this.vecH_B.elementAt(0);
            this.residueNoB = h1cs.getResidueNo();
            this.resB = h1cs.getResidueType();
            this.atomB = h1cs.getAtomName();
        }
        this.lower = low;
        this.upper = up;
        this.ratioEnsem = 0.0;
    }

    public Noe(int pkID, Vector vec1, Vector vec2, Noe noe) {
        this.peakID = pkID;
        this.vecH_A.addAll(vec1);
        this.vecH_B.addAll(vec2);
        this.lower = noe.getLower();
        this.upper = noe.getUpper();
        this.ratioEnsem = noe.getRatioEnsemb();
    }

    public int getResidueNoA() {
        return this.residueNoA;
    }

    public int getResidueNoB() {
        return this.residueNoB;
    }

    public String getResidueA() {
        return this.resA;
    }

    public String getResidueB() {
        return this.resB;
    }

    public String getAtomA() {
        return this.atomA;
    }

    public String getAtomB() {
        return this.atomB;
    }

    public double getRatioEnsemb() {
        return this.ratioEnsem;
    }

    public double[] getRange() {
        return new double[]{this.lower, this.upper};
    }

    public double getLower() {
        return this.lower;
    }

    public int getPeakID() {
        return this.peakID;
    }

    public double getUpper() {
        return this.upper;
    }

    public Vector getVecH_A() {
        return this.vecH_A;
    }

    public Vector getVecH_B() {
        return this.vecH_B;
    }

    public void setDistUpper(double up) {
        this.upper = up;
    }

    public void setDistLower(double lw) {
        this.lower = lw;
    }

    public void setRatioEnsemb(double ratio) {
        this.ratioEnsem = ratio;
    }

    public void setResNameA(String res1) {
        this.resA = res1;
    }

    public void setResNameB(String res2) {
        this.resB = res2;
    }

    public void setAtom1Name(String atom1) {
        this.atomA = atom1;
    }

    public void setAtom2Name(String atom2) {
        this.atomB = atom2;
    }

    public void setPeakID(int id) {
        this.peakID = id;
    }

    public void setResNoA(int n1) {
        this.residueNoA = n1;
    }

    public void setResNoB(int n2) {
        this.residueNoB = n2;
    }

    public void setVecH_A(Vector vec1) {
        this.vecH_A = new Vector();
        this.vecH_A.addAll(vec1);
    }

    public void setVecH_B(Vector vec2) {
        this.vecH_B = new Vector();
        this.vecH_B.addAll(vec2);
    }

    public void addH_A(H1CS h1csA) {
        String atomNew = h1csA.getAtomName();
        int resNoNew = h1csA.getResidueNo();
        boolean isNew = true;
        int i = 0;
        while (i < this.vecH_A.size()) {
            H1CS h1cs = (H1CS)this.vecH_A.elementAt(i);
            String atomName = h1cs.getAtomName();
            int resNo = h1cs.getResidueNo();
            if (resNo == resNoNew && atomName.equalsIgnoreCase(atomNew)) {
                isNew = false;
            }
            ++i;
        }
        if (isNew) {
            this.vecH_A.add(h1csA);
        }
    }

    public void addH_B(H1CS h1csB) {
        String atomNew = h1csB.getAtomName();
        int resNoNew = h1csB.getResidueNo();
        boolean isNew = true;
        int i = 0;
        while (i < this.vecH_B.size()) {
            H1CS h1cs = (H1CS)this.vecH_B.elementAt(i);
            String atomName = h1cs.getAtomName();
            int resNo = h1cs.getResidueNo();
            if (resNo == resNoNew && atomName.equalsIgnoreCase(atomNew)) {
                isNew = false;
            }
            ++i;
        }
        if (isNew) {
            this.vecH_B.add(h1csB);
        }
    }

    public void addProtons(Noe noe) {
        int resNo;
        String atomName;
        H1CS h1cs;
        int resNo1 = noe.getResidueNoA();
        String atom1 = noe.getAtomA();
        String res1 = noe.getResidueA();
        int resNo2 = noe.getResidueNoB();
        String atom2 = noe.getAtomB();
        String res2 = noe.getResidueB();
        H1CS h1cs1 = new H1CS(resNo1, res1, atom1);
        H1CS h1cs2 = new H1CS(resNo2, res2, atom2);
        boolean isNew = true;
        int i = 0;
        while (i < this.vecH_A.size()) {
            h1cs = (H1CS)this.vecH_A.elementAt(i);
            atomName = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (resNo == resNo1 && atomName.equalsIgnoreCase(atom1)) {
                isNew = false;
            }
            ++i;
        }
        if (isNew) {
            this.vecH_A.add(h1cs1);
        }
        isNew = true;
        i = 0;
        while (i < this.vecH_B.size()) {
            h1cs = (H1CS)this.vecH_B.elementAt(i);
            atomName = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (resNo == resNo2 && atomName.equalsIgnoreCase(atom2)) {
                isNew = false;
            }
            ++i;
        }
        if (isNew) {
            this.vecH_B.add(h1cs2);
        }
    }

    public String toString() {
        String desc = String.valueOf(this.residueNoA) + this.atomA + "__" + this.residueNoB + this.atomB + "  " + this.lower + "---" + this.upper;
        return desc;
    }

    protected Object clone() {
        try {
            Object s = super.clone();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Vector ConvertMultiToSingleAsg(Vector vecMultiNoe) {
        Vector<Noe> vecSingleAsg = new Vector<Noe>();
        int i = 0;
        while (i < vecMultiNoe.size()) {
            Noe noe = (Noe)vecMultiNoe.elementAt(i);
            int pkID = noe.getPeakID();
            double distUp = noe.getUpper();
            double distLower = noe.getLower();
            double ratio = noe.getRatioEnsemb();
            Vector vecHa = noe.getVecH_A();
            Vector vecHb = noe.getVecH_B();
            int j = 0;
            while (j < vecHa.size()) {
                H1CS h1csA = (H1CS)vecHa.elementAt(j);
                int resNoA = h1csA.getResidueNo();
                String resA = h1csA.getResidueType();
                String atomA = h1csA.getAtomName();
                int k = 0;
                while (k < vecHb.size()) {
                    H1CS h1csB = (H1CS)vecHb.elementAt(k);
                    int resNoB = h1csB.getResidueNo();
                    String resB = h1csB.getResidueType();
                    String atomB = h1csB.getAtomName();
                    vecSingleAsg.add(new Noe(pkID, resNoA, resNoB, resA, resB, atomA, atomB, distLower, distUp, ratio));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vecSingleAsg;
    }

    public Vector<Noe> ConvertSingleToMultiAsg(Vector<Noe> vecSingleNoe) {
        Vector<Noe> vecMulti = new Vector<Noe>();
        int maxPkID = -999;
        int i = 0;
        while (i < vecSingleNoe.size()) {
            Noe noe = vecSingleNoe.elementAt(i);
            int pkID = noe.getPeakID();
            if (pkID >= maxPkID) {
                maxPkID = pkID;
            }
            ++i;
        }
        i = -maxPkID;
        while (i <= maxPkID) {
            Noe multi_noe = new Noe();
            boolean isSet = false;
            int j = 0;
            while (j < vecSingleNoe.size()) {
                Noe noe2 = vecSingleNoe.elementAt(j);
                int pkID2 = noe2.getPeakID();
                double upDist = noe2.getUpper();
                double lowDist = noe2.getLower();
                double ratio = noe2.getRatioEnsemb();
                String resA = noe2.getResidueA();
                String resB = noe2.getResidueB();
                String atomA = noe2.getAtomA();
                String atomB = noe2.getAtomB();
                int resNoA = noe2.getResidueNoA();
                int resNoB = noe2.getResidueNoB();
                if (pkID2 == i) {
                    isSet = true;
                    multi_noe.setPeakID(pkID2);
                    multi_noe.setRatioEnsemb(ratio);
                    multi_noe.setDistUpper(upDist);
                    multi_noe.setDistLower(lowDist);
                    multi_noe.addProtons(noe2);
                    multi_noe.setResNameA(resA);
                    multi_noe.setResNameB(resB);
                    multi_noe.setAtom1Name(atomA);
                    multi_noe.setAtom2Name(atomB);
                    multi_noe.setResNoA(resNoA);
                    multi_noe.setResNoB(resNoB);
                }
                ++j;
            }
            if (isSet) {
                vecMulti.add(multi_noe);
            }
            ++i;
        }
        Collections.sort(vecMulti, new noeComparatorC());
        return vecMulti;
    }

    public void OutputMultiNOEAsg(Vector vecMultiNoe, String strOutName) {
        String xplorNoeStr = "";
        double[] disUpper = new double[1];
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(strOutName)));
            out.println("!REMARK: Total number of cross peaks is " + vecMultiNoe.size());
            out.println("");
            out.println("");
            int i = 0;
            while (i < vecMultiNoe.size()) {
                String atom1;
                int no1;
                H1CS h1cs;
                Noe noe = (Noe)vecMultiNoe.elementAt(i);
                int pkID = noe.getPeakID();
                double upLimit = noe.getUpper();
                double lowerLimit = noe.getLower();
                out.println("! peak ID : " + pkID);
                Vector vecHA = noe.getVecH_A();
                Vector vecHB = noe.getVecH_B();
                String str = "assign (";
                boolean isFirst = true;
                int k = 0;
                while (k < vecHA.size()) {
                    h1cs = (H1CS)vecHA.elementAt(k);
                    no1 = h1cs.getResidueNo();
                    atom1 = h1cs.getAtomName();
                    if (isFirst) {
                        str = String.valueOf(str) + "( resid " + String.valueOf(no1) + " and name " + atom1 + " )";
                        str = k == vecHA.size() - 1 ? String.valueOf(str) + ")" : String.valueOf(str) + " or";
                        out.println(str);
                        isFirst = false;
                    } else {
                        str = "         ( resid " + String.valueOf(no1) + " and name " + atom1 + " )";
                        str = k == vecHA.size() - 1 ? String.valueOf(str) + ")" : String.valueOf(str) + " or";
                        out.println(str);
                    }
                    ++k;
                }
                isFirst = true;
                str = "                                        (";
                k = 0;
                while (k < vecHB.size()) {
                    h1cs = (H1CS)vecHB.elementAt(k);
                    no1 = h1cs.getResidueNo();
                    atom1 = h1cs.getAtomName();
                    if (isFirst) {
                        str = String.valueOf(str) + "( resid " + String.valueOf(no1) + " and name " + atom1 + " )";
                        str = k == vecHB.size() - 1 ? String.valueOf(str) + ")      " + String.valueOf(upLimit) + "   " + String.valueOf(upLimit - lowerLimit) + "  " + String.valueOf(0.0) : String.valueOf(str) + " or";
                        out.println(str);
                        isFirst = false;
                    } else {
                        str = "                                          ( resid " + String.valueOf(no1) + " and name " + atom1 + " )";
                        str = k == vecHB.size() - 1 ? String.valueOf(str) + ")      " + String.valueOf(upLimit) + "   " + String.valueOf(upLimit - lowerLimit) + "  " + String.valueOf(0.0) : String.valueOf(str) + " or";
                        out.println(str);
                    }
                    ++k;
                }
                ++i;
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + strOutName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + strOutName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void CompareAsgToRefStr(Vector vecNoe, Vector vecPdbRef, double noeLimit, double methylCorrection, double[] number) {
        Noe noe = new Noe();
        Peak pk = new Peak();
        double dist_from_inten = 0.0;
        boolean isFound = false;
        double[] noeDist = new double[2];
        Vector vecRefinedNoe = new Vector();
        int numCorrect = 0;
        int numWrong = 0;
        int numCorrectLong = 0;
        int numWrongLong = 0;
        int i = 0;
        while (i < vecNoe.size()) {
            String secondAtomName;
            noe = (Noe)vecNoe.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            isFound = pk.checkNoeNew(vecPdbRef, firstResNo, firstAtomName, secondResNo, secondAtomName = noe.getAtomB(), dist_from_inten = noe.getUpper(), 2.5, noeDist);
            if (isFound) {
                ++numCorrect;
                if (Math.abs(firstResNo - secondResNo) > 4) {
                    ++numCorrectLong;
                }
            } else {
                ++numWrong;
                if (Math.abs(firstResNo - secondResNo) > 4) {
                    ++numWrongLong;
                }
            }
            ++i;
        }
        number[0] = numCorrect;
        number[1] = numWrong;
        number[2] = numCorrectLong;
        number[3] = numWrongLong;
    }

    public Vector NoeMethylCorrection(Vector vecNoeOld, double metCorrection) throws JampackException {
        Vector<Noe> vecNoeNew = new Vector<Noe>();
        int i = 0;
        while (i < vecNoeOld.size()) {
            Noe noe = (Noe)vecNoeOld.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            String secondAtomName = noe.getAtomB();
            double dist_from_inten = noe.getUpper();
            if (firstAtomName.substring(firstAtomName.length() - 1, firstAtomName.length()).equalsIgnoreCase("#") || secondAtomName.substring(secondAtomName.length() - 1, secondAtomName.length()).equalsIgnoreCase("#")) {
                noe.setDistUpper(Math.min(dist_from_inten + metCorrection, 6.0));
            }
            vecNoeNew.add(noe);
            ++i;
        }
        return vecNoeNew;
    }

    public void doCheckNoeByEnsemble(String src, String strOut, String strInput) throws JampackException {
        Noe noe;
        String strInputFile;
        File myDir;
        String[] contents;
        Assign asg = new Assign();
        boolean isDebug = true;
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String strSeq = "";
        String strInLocation = "";
        String strPdbNameScheme = "";
        String strNoeFormat = "";
        String strIsCheckLongNeighbor = "";
        String strNoeNameScheme = "";
        String strInNoeTable = "";
        String strOutNoeTable = "";
        String strIsOutVioNOEs = "";
        String strIsCheckLongAA = "";
        String strIsMultiAsg = "";
        String strIsOutMultiAsg = "";
        double metCor = 0.0;
        double noeCutOff = 0.0;
        double noeLimit = 0.0;
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("INPUTPDBLOCATION")) {
                strInLocation = paraMap.get("INPUTPDBLOCATION");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOEATOMNAMINGSCHEME")) {
                strNoeNameScheme = paraMap.get("NOEATOMNAMINGSCHEME");
            }
            if (paraMap.containsKey("INPUTNOETABLE")) {
                strInNoeTable = paraMap.get("INPUTNOETABLE");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("NOECUTOFF")) {
                noeCutOff = Double.parseDouble(paraMap.get("NOECUTOFF"));
            }
            if (paraMap.containsKey("OUTNOETABLE")) {
                strOutNoeTable = paraMap.get("OUTNOETABLE");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("ISOUTVIONOES")) {
                strIsOutVioNOEs = paraMap.get("ISOUTVIONOES");
            }
            if (paraMap.containsKey("ISCHECKLONGNEIGHBOR")) {
                strIsCheckLongNeighbor = paraMap.get("ISCHECKLONGNEIGHBOR");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISMULTIASSIGNMENT")) {
                strIsMultiAsg = paraMap.get("ISMULTIASSIGNMENT");
            }
            if (paraMap.containsKey("ISOUTMULTIASGFORMAT")) {
                strIsOutMultiAsg = paraMap.get("ISOUTMULTIASGFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(userDir) + strInNoeTable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, strNoeNameScheme);
            vecManAsgNew.addAll(vecManAsg);
        } else {
            if (strIsMultiAsg.equalsIgnoreCase("1")) {
                vecManAsg = noe_temp.noeReaderMultiAsg(manualAsgFile, vecSeq);
                Vector vecTemp = noe_temp.ConvertMultiToSingleAsg(vecManAsg);
                vecManAsg = new Vector();
                vecManAsg.addAll(vecTemp);
            } else {
                vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0, vecSeq);
            }
            if (strNoeNameScheme.equalsIgnoreCase("BMRB-NEW")) {
                vecManAsg = noe_temp.ConvertNoeFromBMRMToPDB(vecManAsg);
            }
            vecManAsgNew.addAll(vecManAsg);
        }
        Vector<Noe> vecTempDia = new Vector<Noe>();
        i = 0;
        while (i < vecManAsgNew.size()) {
            Noe noe2 = (Noe)vecManAsgNew.elementAt(i);
            int no1 = noe2.getResidueNoA();
            int no2 = noe2.getResidueNoB();
            String atom1 = noe2.getAtomA();
            String atom2 = noe2.getAtomB();
            if (no1 != no2 || !atom1.equalsIgnoreCase(atom2)) {
                vecTempDia.add(noe2);
            }
            ++i;
        }
        vecManAsgNew = new Vector();
        vecManAsgNew.addAll(vecTempDia);
        if (strIsCheckLongAA.equalsIgnoreCase("1")) {
            Peak pk = new Peak();
            Vector<Noe> vecTemp = new Vector<Noe>();
            i = 0;
            while (i < vecManAsgNew.size()) {
                Noe noe3 = (Noe)vecManAsgNew.elementAt(i);
                int firstResNo = noe3.getResidueNoA();
                int secondResNo = noe3.getResidueNoB();
                String firstResName = noe3.getResidueA();
                String secondResName = noe3.getResidueB();
                String atomA = noe3.getAtomA();
                String atomB = noe3.getAtomB();
                String subAtomA = atomA;
                String subAtomB = atomB;
                if (atomA.length() >= 2) {
                    subAtomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    subAtomB = atomB.substring(0, 2);
                }
                if (Math.abs(firstResNo - secondResNo) <= 4) {
                    vecTemp.add(noe3);
                } else {
                    boolean isKeep = true;
                    if (pk.isCharged(firstResName) && pk.isHydrophobic(secondResName)) {
                        isKeep = false;
                    }
                    if (pk.isCharged(secondResName) && pk.isHydrophobic(firstResName)) {
                        isKeep = false;
                    }
                    if ((subAtomB.equalsIgnoreCase("HN") || subAtomB.equalsIgnoreCase("H") || subAtomB.equalsIgnoreCase("HA") || subAtomB.equalsIgnoreCase("HB")) && (subAtomA.equalsIgnoreCase("HN") || subAtomA.equalsIgnoreCase("H") || subAtomA.equalsIgnoreCase("HA") || subAtomA.equalsIgnoreCase("HB"))) {
                        isKeep = true;
                    }
                    if (isKeep) {
                        vecTemp.add(noe3);
                    }
                }
                ++i;
            }
            vecManAsgNew = new Vector();
            vecManAsgNew.addAll(vecTemp);
        }
        if ((contents = (myDir = new File(strInputFile = String.valueOf(userDir) + strInLocation)).list()) == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
        }
        Peak pk = new Peak();
        double[] noeDist = new double[2];
        boolean isFound = false;
        i = 0;
        while (i < vecManAsgNew.size()) {
            Noe noe4 = (Noe)vecManAsgNew.elementAt(i);
            int firstResNo = noe4.getResidueNoA();
            int secondResNo = noe4.getResidueNoB();
            String firstResName = noe4.getResidueA();
            String secondResName = noe4.getResidueB();
            String firstAtomName = noe4.getAtomA();
            String secondAtomName = noe4.getAtomB();
            double dist_from_inten = noe4.getUpper();
            double noeUpperPrune = 0.0;
            int counterPdb = 0;
            int t = 0;
            while (t < contents.length) {
                String filename = contents[t];
                String strEnsemPdb = "";
                strEnsemPdb = String.valueOf(strInputFile) + filename;
                Vector vecEnsemble = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdb);
                Vector<Object> pdbVecSSE = new Vector();
                if (vecEnsemble.size() > 0) {
                    int w = 0;
                    while (w < vecEnsemble.size()) {
                        Vector vecVdw = new Vector();
                        vecVdw = new Vector();
                        vdw Vdw = (vdw)vecEnsemble.elementAt(w);
                        Vector vecPdb = Vdw.getPDB();
                        if (vecPdb.size() >= 1) {
                            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdateNoStr(vecSeq, vecPdb);
                            if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
                                pdbVecSSE = pp.nameConvertOrder(pdbVecSSE_temp2);
                            } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
                                pdbVecSSE = pp.nameConvert2PDBNew(pdbVecSSE_temp2);
                            } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
                                Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecSSE_temp2);
                                pdbVecSSE = pp.nameConvert2PDBNew(pdbVecSSE22);
                            } else {
                                pdbVecSSE.addAll(pdbVecSSE_temp2);
                            }
                            ++counterPdb;
                            noeUpperPrune = noeLimit <= 0.0 ? dist_from_inten : noeLimit;
                            noeUpperPrune += 0.5;
                            if (noeUpperPrune > 6.0) {
                                noeUpperPrune = 6.0;
                            }
                            isFound = pk.checkNoeNew(pdbVecSSE, firstResNo, firstAtomName, secondResNo, secondAtomName, noeUpperPrune, metCor, noeDist);
                            double dbRatio = noe4.getRatioEnsemb() + 1.0;
                            if (isFound) {
                                noe4.setRatioEnsemb(dbRatio);
                            }
                        }
                        ++w;
                    }
                }
                ++t;
            }
            if (counterPdb < 1) {
                System.out.println("No input PDB is found for checking NOEs....");
                return;
            }
            double dbRatio = noe4.getRatioEnsemb();
            noe4.setRatioEnsemb(dbRatio / (double)counterPdb);
            ++i;
        }
        Vector<Noe> vecNoeNew = new Vector<Noe>();
        Vector<Noe> vecDeltNoe = new Vector<Noe>();
        i = 0;
        while (i < vecManAsgNew.size()) {
            noe = (Noe)vecManAsgNew.elementAt(i);
            double dbRatio = noe.getRatioEnsemb();
            if (dbRatio >= noeCutOff) {
                vecNoeNew.add(noe);
            } else {
                vecDeltNoe.add(noe);
            }
            ++i;
        }
        if (strIsCheckLongNeighbor.equalsIgnoreCase("1")) {
            Vector vecRefineLongNOE = new Vector();
            vecRefineLongNOE = pk.CheckLongRangNOE(vecNoeNew, 3);
            vecNoeNew = new Vector();
            vecNoeNew.addAll(vecRefineLongNOE);
        }
        if (!strIsOutMultiAsg.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecNoeNew.size()) {
                noe = (Noe)vecNoeNew.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String firstAtomName = noe.getAtomA();
                String secondAtomName = noe.getAtomB();
                if (secondResNo < firstResNo) {
                    noe.setResNoA(secondResNo);
                    noe.setResNoB(firstResNo);
                    noe.setAtom1Name(secondAtomName);
                    noe.setAtom2Name(firstAtomName);
                    noe.setResNameA(secondResName);
                    noe.setResNameB(firstResName);
                }
                ++i;
            }
            Collections.sort(vecNoeNew, new noeComparatorC());
        }
        String fileName = String.valueOf(userDir) + strOutNoeTable;
        if (strIsOutMultiAsg.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecNoeNew);
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        } else {
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                String res2;
                Noe noe5;
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of original NOEs is " + vecManAsgNew.size());
                out.println("!REMARK: Total number of NOEs is " + vecNoeNew.size());
                out.println("");
                out.println("");
                i = 0;
                while (i < vecNoeNew.size()) {
                    noe5 = vecNoeNew.elementAt(i);
                    int resNo1 = noe5.getResidueNoA();
                    int resNo2 = noe5.getResidueNoB();
                    String res1 = noe5.getResidueA();
                    res2 = noe5.getResidueB();
                    String atom1 = noe5.getAtomA();
                    String atom2 = noe5.getAtomB();
                    double distUpper = noe5.getUpper();
                    double dbRatio = noe5.getRatioEnsemb();
                    if (isDebug) {
                        out.println("!ratio: " + dbRatio);
                    }
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    if (isDebug) {
                        System.out.println(xplorNoeStr);
                    }
                    out.println(xplorNoeStr);
                    ++i;
                }
                out.println("!-------------------------!");
                out.println("! violated NOEs   !!!!!");
                if (isDebug) {
                    System.out.println("!--------! violated NOEs   !!!!!-----------------!");
                }
                if (strIsOutVioNOEs.equalsIgnoreCase("1")) {
                    i = 0;
                    while (i < vecDeltNoe.size()) {
                        noe5 = (Noe)vecDeltNoe.elementAt(i);
                        int resNo1 = noe5.getResidueNoA();
                        int resNo2 = noe5.getResidueNoB();
                        String res1 = noe5.getResidueA();
                        res2 = noe5.getResidueB();
                        String atom1 = noe5.getAtomA();
                        String atom2 = noe5.getAtomB();
                        double distUpper = noe5.getUpper();
                        double dbRatio = noe5.getRatioEnsemb();
                        if (isDebug) {
                            out.println("!ratio: " + dbRatio);
                        }
                        xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                        if (isDebug) {
                            System.out.println("!!!  " + xplorNoeStr);
                        }
                        out.println("!!!  " + xplorNoeStr);
                        ++i;
                    }
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        System.out.println("!REMARK: Total number of original NOEs is " + vecManAsgNew.size());
        System.out.println("!REMARK: Total number of NOEs is " + vecNoeNew.size());
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for CheckNoeByEnsemble is:  " + totalTime + " minutes");
    }

    public void doNoeStatistics(String src, String strOut, String strInput) throws JampackException {
        Assign asg = new Assign();
        boolean isDebug = true;
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        String strSeq = "";
        String strInLocation = "";
        String strPdbNameScheme = "";
        String strNoeFormat = "";
        String strIsCheckLongNeighbor = "";
        String strNoeNameScheme = "";
        String strInNoeTable = "";
        String strOutNoeTable = "";
        String strIsOutVioNOEs = "";
        String strIsCheckLongAA = "";
        String strIsMultiAsg = "";
        String strIsOutMultiAsg = "";
        double metCor = 0.0;
        double noeCutOff = 0.0;
        double noeLimit = 0.0;
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("INPUTPDBLOCATION")) {
                strInLocation = paraMap.get("INPUTPDBLOCATION");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOEATOMNAMINGSCHEME")) {
                strNoeNameScheme = paraMap.get("NOEATOMNAMINGSCHEME");
            }
            if (paraMap.containsKey("INPUTNOETABLE")) {
                strInNoeTable = paraMap.get("INPUTNOETABLE");
            }
            if (paraMap.containsKey("ISMULTIASSIGNMENT")) {
                strIsMultiAsg = paraMap.get("ISMULTIASSIGNMENT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strInNoeTable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, strNoeNameScheme);
            vecManAsgNew.addAll(vecManAsg);
        } else {
            if (strIsMultiAsg.equalsIgnoreCase("1")) {
                vecManAsg = noe_temp.noeReaderMultiAsg(manualAsgFile, vecSeq);
                Vector vecTemp = noe_temp.ConvertMultiToSingleAsg(vecManAsg);
                vecManAsg = new Vector();
                vecManAsg.addAll(vecTemp);
            } else {
                vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0, vecSeq);
            }
            if (strNoeNameScheme.equalsIgnoreCase("BMRB-NEW")) {
                vecManAsg = noe_temp.ConvertNoeFromBMRMToPDB(vecManAsg);
            }
            vecManAsgNew.addAll(vecManAsg);
        }
        int intraNum = 0;
        int seqNum = 0;
        int medNum = 0;
        int longNum = 0;
        i = 0;
        while (i < vecManAsgNew.size()) {
            int resNoB;
            Noe noe = (Noe)vecManAsgNew.elementAt(i);
            int resNoA = noe.getResidueNoA();
            if (resNoA == (resNoB = noe.getResidueNoB())) {
                ++intraNum;
            } else if (Math.abs(resNoA - resNoB) == 1) {
                ++seqNum;
            } else if (Math.abs(resNoA - resNoB) >= 5) {
                ++longNum;
            } else {
                ++medNum;
            }
            ++i;
        }
        System.out.println("!REMARK: Total number of NOEs is " + vecManAsgNew.size());
        System.out.println("!REMARK: Number of Intra-residue NOEs is " + intraNum);
        System.out.println("!REMARK: Number of Sequential NOEs is " + seqNum);
        System.out.println("!REMARK: Number of Medium-range NOEs is " + medNum);
        System.out.println("!REMARK: Number of Long-range NOEs is " + longNum);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for CheckNoeByEnsemble is:  " + totalTime + " minutes");
    }

    public Vector<Noe> NameConvertFromPDBNewToPDBNew(Vector<Noe> vecNoe) {
        Object atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector atomVec = new Vector();
        Pdb pp = new Pdb();
        Noe noe = new Noe();
        Vector<Noe> vecNoeOld = new Vector<Noe>();
        vecNoeOld.addAll(vecNoe);
        Vector<Noe> vecNoeNew = new Vector<Noe>();
        int i = 0;
        while (i < vecNoeOld.size()) {
            noe = (Noe)vecNoeOld.elementAt(i);
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            String atom1New = this.UpdateNOEAtomName(res1, atom1);
            String atom2New = this.UpdateNOEAtomName(res2, atom2);
            noe.setAtom1Name(atom1New);
            noe.setAtom2Name(atom2New);
            vecNoeNew.add(noe);
            ++i;
        }
        return vecNoeNew;
    }

    public Vector<Noe> NameConvertFromBMRBNewToPDBNew(Vector<Noe> vecNoe) {
        Object atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector atomVec = new Vector();
        Pdb pp = new Pdb();
        Noe noe = new Noe();
        Vector<Noe> vecNoeOld = new Vector<Noe>();
        vecNoeOld.addAll(vecNoe);
        Vector<Noe> vecNoeNew = new Vector<Noe>();
        int i = 0;
        while (i < vecNoeOld.size()) {
            noe = (Noe)vecNoeOld.elementAt(i);
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            String atom1NewT = pp.NameFromBMRBToPDB(res1, atom1);
            String atom1New = pp.NameFromPDBToPDB(res1, atom1NewT);
            String atom2NewT = pp.NameFromBMRBToPDB(res2, atom2);
            String atom2New = pp.NameFromPDBToPDB(res2, atom2NewT);
            noe.setAtom1Name(atom1New);
            noe.setAtom2Name(atom2New);
            vecNoeNew.add(noe);
            ++i;
        }
        return vecNoeNew;
    }

    public void CompareAsgToManualAsg(Vector vecAsg, Vector vecManualAsg, double[] number) {
        Pdb pp = new Pdb();
        Noe noe = new Noe();
        Noe noeManual = new Noe();
        int sumCorrect = 0;
        int sumWrong = 0;
        int sumCorrectLong = 0;
        int sumWrongLong = 0;
        boolean isFound = false;
        int i = 0;
        while (i < vecAsg.size()) {
            String atom_temp2;
            noe = (Noe)vecAsg.elementAt(i);
            int resNo1 = noe.getResidueNoA();
            int resNo2 = noe.getResidueNoB();
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom_temp1 = noe.getAtomA();
            if (atom_temp1.equalsIgnoreCase("H")) {
                atom_temp1 = "HN";
            }
            if ((atom_temp2 = noe.getAtomB()).equalsIgnoreCase("H")) {
                atom_temp2 = "HN";
            }
            isFound = false;
            String atom1 = pp.NameFromBMRBToPDB(res1, atom_temp1);
            String atom2 = pp.NameFromBMRBToPDB(res2, atom_temp2);
            double distUpper = noe.getUpper();
            String subAtom1 = atom1.substring(0, 2);
            String subAtom2 = atom2.substring(0, 2);
            int j = 0;
            while (j < vecManualAsg.size()) {
                noeManual = (Noe)vecManualAsg.elementAt(j);
                int manResNo1 = noeManual.getResidueNoA();
                int manResNo2 = noeManual.getResidueNoB();
                String manRes1 = noeManual.getResidueA();
                String manRes2 = noeManual.getResidueB();
                String manAtom1 = noeManual.getAtomA();
                String manAtom2 = noeManual.getAtomB();
                if (manAtom1.equalsIgnoreCase("H")) {
                    manAtom1 = "HN";
                }
                if (manAtom2.equalsIgnoreCase("H")) {
                    manAtom2 = "HN";
                }
                String subManAtom1 = "";
                String subManAtom2 = "";
                subManAtom1 = manAtom1.length() >= 2 ? manAtom1.substring(0, 2) : manAtom1;
                subManAtom2 = manAtom2.length() >= 2 ? manAtom2.substring(0, 2) : manAtom2;
                if (resNo1 == manResNo1 && resNo2 == manResNo2 && atom1.equalsIgnoreCase(manAtom1) && atom2.equalsIgnoreCase(manAtom2)) {
                    ++sumCorrect;
                    if (Math.abs(resNo1 - resNo2) > 4) {
                        ++sumCorrectLong;
                    }
                    isFound = true;
                    break;
                }
                if (resNo1 == manResNo2 && resNo2 == manResNo1 && atom1.equalsIgnoreCase(manAtom2) && atom2.equalsIgnoreCase(manAtom1)) {
                    ++sumCorrect;
                    if (Math.abs(resNo1 - resNo2) > 4) {
                        ++sumCorrectLong;
                    }
                    isFound = true;
                    break;
                }
                if (resNo1 == manResNo1 && resNo2 == manResNo2 && subAtom1.equalsIgnoreCase(subManAtom1) && subAtom2.equalsIgnoreCase(subManAtom2)) {
                    ++sumCorrect;
                    if (Math.abs(resNo1 - resNo2) > 4) {
                        ++sumCorrectLong;
                    }
                    isFound = true;
                    break;
                }
                if (resNo1 == manResNo2 && resNo2 == manResNo1 && subAtom1.equalsIgnoreCase(subManAtom2) && subAtom2.equalsIgnoreCase(subManAtom1)) {
                    ++sumCorrect;
                    if (Math.abs(resNo1 - resNo2) > 4) {
                        ++sumCorrectLong;
                    }
                    isFound = true;
                    break;
                }
                String temp1 = atom1.substring(0, atom1.length() - 1);
                String temp1Man = manAtom1.substring(0, manAtom1.length() - 1);
                String temp2 = atom2.substring(0, atom2.length() - 1);
                String temp2Man = manAtom2.substring(0, manAtom2.length() - 1);
                if (resNo1 == manResNo1 && resNo2 == manResNo2) {
                    if (manAtom1.substring(manAtom1.length() - 1).equalsIgnoreCase("#") && temp1.equalsIgnoreCase(temp1Man) && atom2.equalsIgnoreCase(manAtom2)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                    if (manAtom2.substring(manAtom2.length() - 1).equalsIgnoreCase("#") && temp2.equalsIgnoreCase(temp2Man) && atom1.equalsIgnoreCase(manAtom1)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                    if (manAtom1.substring(manAtom1.length() - 1).equalsIgnoreCase("#") && manAtom2.substring(manAtom2.length() - 1).equalsIgnoreCase("#") && temp1.equalsIgnoreCase(temp1Man) && temp2.equalsIgnoreCase(temp2Man)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                }
                if (resNo1 == manResNo2 && resNo2 == manResNo1) {
                    if (manAtom1.substring(manAtom1.length() - 1).equalsIgnoreCase("#") && temp2.equalsIgnoreCase(temp1Man) && atom1.equalsIgnoreCase(manAtom2)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                    if (manAtom2.substring(manAtom2.length() - 1).equalsIgnoreCase("#") && temp1.equalsIgnoreCase(temp2Man) && atom2.equalsIgnoreCase(manAtom1)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                    if (manAtom1.substring(manAtom1.length() - 1).equalsIgnoreCase("#") && manAtom2.substring(manAtom2.length() - 1).equalsIgnoreCase("#") && temp1.equalsIgnoreCase(temp2Man) && temp2.equalsIgnoreCase(temp1Man)) {
                        ++sumCorrect;
                        if (Math.abs(resNo1 - resNo2) > 4) {
                            ++sumCorrectLong;
                        }
                        isFound = true;
                        break;
                    }
                }
                ++j;
            }
            if (!isFound) {
                ++sumWrong;
                if (Math.abs(resNo1 - resNo2) > 4) {
                    ++sumWrongLong;
                }
                Peak pk = new Peak();
                String string = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
            }
            ++i;
        }
        number[0] = sumCorrect;
        number[1] = sumWrong;
        number[2] = sumCorrectLong;
        number[3] = sumWrongLong;
    }

    public String getResNameFromSequence(Vector vecSeq, int resNo) {
        String resName = "";
        int i = 0;
        while (i < vecSeq.size()) {
            Assign asg = (Assign)vecSeq.elementAt(i);
            int no = asg.getResidueNo();
            String resid = asg.getResidueType().trim();
            if (no == resNo) {
                return resid;
            }
            ++i;
        }
        return resName;
    }

    public boolean[] identifyNoeResidues(Vector vecSseSeq, Vector vecNoeAll, int sseIndex) {
        Noe noe_temp = new Noe();
        Vector vecSSE = (Vector)vecSseSeq.elementAt(sseIndex);
        boolean[] resIndex = new boolean[vecSSE.size()];
        int i = 0;
        while (i < vecSSE.size()) {
            resIndex[i] = false;
            ++i;
        }
        i = 0;
        while (i < vecSseSeq.size()) {
            if (i != sseIndex) {
                Vector vecSseOther = (Vector)vecSseSeq.elementAt(i);
                Vector<Vector> vecSseTemp = new Vector<Vector>();
                vecSseTemp.add(vecSSE);
                vecSseTemp.add(vecSseOther);
                Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecNoeAll, vecSseTemp);
                Vector noeVec = (Vector)vecNoeUpdateOrder.elementAt(0);
                int j = 0;
                while (j < noeVec.size()) {
                    Noe noe = (Noe)noeVec.elementAt(j);
                    int resNo = noe.getResidueNoA();
                    int inRef = Collections.binarySearch(vecSSE, new Pdb(resNo), new Pdb.PdbComparator());
                    if (inRef > -1) {
                        resIndex[inRef] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resIndex;
    }

    public Vector<Noe> noeReader_old_fromLW(String noeFile) {
        Vector<Noe> inputs = new Vector<Noe>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(noeFile));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int noA = (int)in.nval;
                in.nextToken();
                String atomA = in.sval;
                in.nextToken();
                int noB = (int)in.nval;
                in.nextToken();
                String atomB = in.sval;
                in.nextToken();
                this.lower = in.nval;
                in.nextToken();
                this.upper = in.nval;
                inputs.add(new Noe(noA, atomA, noB, atomB, this.lower, this.upper));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector noeReader(String noeFile, double upCorrection) {
        inputs = new Vector<Noe>();
        noA = 0;
        noB = 0;
        atomA = "";
        atomB = "'";
        index = -1;
        ss = "";
        st = new StringTokenizer("");
        dist = 0.0;
        minus = 0.0;
        plus = 0.0;
        lowerDist = 0.0;
        upperDist = 0.0;
        try {
            in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block11: {
                    if ((index = ss.trim().indexOf("assign")) == 0) break block11;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                st.nextToken();
                if (st.hasMoreTokens()) {
                    dist = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    minus = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    plus = new Double(st.nextToken());
                }
                lowerDist = dist - minus;
                upperDist = dist + plus;
                upperDist = upCorrection < 0.0 ? 6.0 : (upperDist += upCorrection);
                inputs.add(new Noe(noA, noB, "", "", atomA, atomB, lowerDist, upperDist));
            } while ((ss = in.readLine()) != null);
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector noeReaderMultiAsg(String noeFile, Vector vecSeq) {
        inputs = new Vector<Noe>();
        noA = false;
        noB = false;
        atomA = "";
        atomB = "'";
        index = -1;
        ss = "";
        st = new StringTokenizer("");
        dist = 0.0;
        minus = 0.0;
        plus = 0.0;
        lowerDist = 0.0;
        upperDist = 0.0;
        noeTemp = new Noe();
        pkID = -1;
        unknownID = -1;
        isPreID = false;
        try {
            in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block17: {
                    block18: {
                        if (!isPreID) {
                            pkID = -1;
                        }
                        if ((index = ss.indexOf("peak ID")) >= 0) {
                            pkID = Integer.parseInt(ss.substring(index + 10, ss.length()).trim());
                            isPreID = true;
                        }
                        if ((index = ss.indexOf("assign")) == 0) break block18;
                        ss = in.readLine();
                        if (ss != null) ** GOTO lbl-1000
                        break;
                    }
                    isPreID = false;
                    noe = new Noe();
                    vecHA = new Vector<H1CS>();
                    vecHB = new Vector<H1CS>();
                    lastEnd = 0;
                    do {
                        indResID = ss.indexOf("resid");
                        indTemp = ss.indexOf("and");
                        lastInd = ss.lastIndexOf("resid");
                        lastIndTemp = ss.lastIndexOf("and");
                        if (indResID != lastInd) {
                            resNoA = Integer.parseInt(ss.substring(indResID + 6, indTemp).trim());
                            indEndA = ss.indexOf(")");
                            atomA = ss.substring(indTemp + 9, indEndA).trim();
                            resA = noeTemp.getResNameFromSequence(vecSeq, resNoA);
                            resNoB = Integer.parseInt(ss.substring(lastInd + 6, lastIndTemp).trim());
                            indEndB = ss.lastIndexOf("))");
                            resB = noeTemp.getResNameFromSequence(vecSeq, resNoB);
                            if (indEndB < 0 || indEndB == ss.indexOf("))")) {
                                indEndB = ss.lastIndexOf(")");
                            }
                            atomB = ss.substring(lastIndTemp + 9, indEndB).trim();
                            vecHA.add(new H1CS(resNoA, resA, atomA));
                            vecHB.add(new H1CS(resNoB, resB, atomB));
                            if (ss.lastIndexOf("))") <= 40) continue;
                            lastEnd = 2 + ss.lastIndexOf("))");
                        } else {
                            if (indResID < 40) {
                                resNoA = Integer.parseInt(ss.substring(indResID + 6, indTemp).trim());
                                indEndA = ss.indexOf(")");
                                atomA = ss.substring(indTemp + 9, indEndA).trim();
                                resA = noeTemp.getResNameFromSequence(vecSeq, resNoA);
                                vecHA.add(new H1CS(resNoA, resA, atomA));
                                continue;
                            }
                            resNoB = Integer.parseInt(ss.substring(lastInd + 6, lastIndTemp).trim());
                            indEndB = ss.lastIndexOf("))");
                            resB = noeTemp.getResNameFromSequence(vecSeq, resNoB);
                            if (indEndB < 0) {
                                indEndB = ss.lastIndexOf(")");
                            }
                            atomB = ss.substring(lastIndTemp + 9, indEndB).trim();
                            vecHB.add(new H1CS(resNoB, resB, atomB));
                            if (ss.indexOf("))") <= 40) continue;
                            lastEnd = 2 + ss.indexOf("))");
                        }
                        break block17;
                    } while ((ss = in.readLine()) != null);
                    break;
                }
                sub_ss = ss.substring(lastEnd, ss.length());
                st = new StringTokenizer(sub_ss);
                if (st.hasMoreTokens()) {
                    dist = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    minus = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    plus = new Double(st.nextToken());
                }
                lowerDist = dist - minus;
                upperDist = dist + plus;
                if (pkID == -1) {
                    pkID = unknownID - 1;
                    --unknownID;
                }
                inputs.add(new Noe(pkID, vecHA, vecHB, lowerDist, upperDist));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector noeReader(String noeFile, double upCorrection, Vector vecSeq) {
        inputs = new Vector<Noe>();
        noA = 0;
        noB = 0;
        atomA = "";
        atomB = "'";
        index = -1;
        ss = "";
        st = new StringTokenizer("");
        dist = 0.0;
        minus = 0.0;
        plus = 0.0;
        lowerDist = 0.0;
        upperDist = 0.0;
        noeTemp = new Noe();
        try {
            in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block11: {
                    if ((index = ss.trim().indexOf("assign")) == 0) break block11;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                st.nextToken();
                if (st.hasMoreTokens()) {
                    dist = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    minus = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    plus = new Double(st.nextToken());
                }
                lowerDist = dist - minus;
                upperDist = dist + plus;
                upperDist = upCorrection < 0.0 ? 6.0 : (upperDist += upCorrection);
                resA = noeTemp.getResNameFromSequence(vecSeq, noA);
                resB = noeTemp.getResNameFromSequence(vecSeq, noB);
                atomA_new = noeTemp.UpdateNOEAtomName(resA, atomA);
                atomB_new = noeTemp.UpdateNOEAtomName(resB, atomB);
                inputs.add(new Noe(noA, noB, resA, resB, atomA_new, atomB_new, lowerDist, upperDist));
            } while ((ss = in.readLine()) != null);
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public String UpdateNOEAtomName(String resName, String atomName) {
        String newAtomName = atomName;
        if (atomName.equalsIgnoreCase("H")) {
            newAtomName = "HN";
            return newAtomName;
        }
        String userDir = System.getProperty("user.dir");
        RdcPanda rdcPan = new RdcPanda();
        String rotSrc = String.valueOf(userDir) + "/system/" + rdcPan.rotLibName + "/";
        Pdb pp = new Pdb();
        String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
        Vector<Pdb> pdbRotam = pp.readPdb(rotamFile);
        Pdb ppNode = pdbRotam.elementAt(0);
        String atomSub = "";
        atomSub = atomName;
        if (atomName.length() >= 2) {
            if (atomName.substring(atomName.length() - 2, atomName.length()).equalsIgnoreCase("##")) {
                atomSub = atomName.substring(0, atomName.length() - 2);
            } else if (atomName.substring(atomName.length() - 1, atomName.length()).equalsIgnoreCase("#")) {
                atomSub = atomName.substring(0, atomName.length() - 1);
            }
        }
        Vector<Cartesian> atomVec = ppNode.getAtomVec();
        int j = 0;
        while (j < atomVec.size()) {
            String atomPPName;
            Cartesian cc = atomVec.elementAt(j);
            String sub_atomPPName = atomPPName = cc.getAtom();
            if (atomPPName.length() >= atomSub.length()) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                if (atomPPName.length() - atomSub.length() == 1) {
                    newAtomName = String.valueOf(atomSub) + "#";
                }
                if (atomPPName.length() - atomSub.length() != 2) break;
                newAtomName = String.valueOf(atomSub) + "##";
                break;
            }
            ++j;
        }
        return newAtomName;
    }

    public String UpdateNOEAtomName2(String resName, String atomName) {
        String newAtomName = atomName;
        if (atomName.equalsIgnoreCase("H")) {
            newAtomName = "HN";
            return newAtomName;
        }
        String userDir = System.getProperty("user.dir");
        RdcPanda rdcPan = new RdcPanda();
        String rotSrc = String.valueOf(userDir) + "/system/" + rdcPan.rotLibName + "/";
        Pdb pp = new Pdb();
        String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
        Vector<Pdb> pdbRotam = pp.readPdb(rotamFile);
        Pdb ppNode = pdbRotam.elementAt(0);
        String atomSub = "";
        atomSub = atomName;
        if (atomName.length() >= 2) {
            if (atomName.substring(atomName.length() - 2, atomName.length()).equalsIgnoreCase("##")) {
                atomSub = atomName.substring(0, atomName.length() - 2);
            } else if (atomName.substring(atomName.length() - 1, atomName.length()).equalsIgnoreCase("#")) {
                atomSub = atomName.substring(0, atomName.length() - 1);
            }
        }
        Vector<Cartesian> atomVec = ppNode.getAtomVec();
        int j = 0;
        while (j < atomVec.size()) {
            String atomPPName;
            Cartesian cc = atomVec.elementAt(j);
            String sub_atomPPName = atomPPName = cc.getAtom();
            if (atomPPName.length() >= atomSub.length()) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                if (atomPPName.length() - atomSub.length() == 1) {
                    newAtomName = atomSub;
                }
                if (atomPPName.length() - atomSub.length() != 2) break;
                newAtomName = atomSub;
                break;
            }
            ++j;
        }
        return newAtomName;
    }

    /*
     * Unable to fully structure code
     */
    public Vector noeReader2(String noeFile, double upCorrection) {
        inputs = new Vector<Noe>();
        noA = 0;
        noB = 0;
        atomA = "";
        atomB = "'";
        index = -1;
        ss = "";
        st = new StringTokenizer("");
        dist = 0.0;
        minus = 0.0;
        plus = 0.0;
        lowerDist = 0.0;
        upperDist = 0.0;
        correction = upCorrection;
        try {
            in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block12: {
                    if ((index = ss.trim().indexOf("assign")) == 0) break block12;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    temp = new String(st.nextToken());
                    atomA = temp.substring(0, temp.length() - 1);
                }
                st.nextToken();
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                st.nextToken();
                st.nextToken();
                if (st.hasMoreTokens()) {
                    temp = new String(st.nextToken());
                    atomB = temp.substring(0, temp.length() - 1);
                }
                if (st.hasMoreTokens()) {
                    dist = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    minus = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    plus = new Double(st.nextToken());
                }
                lowerDist = 1.8;
                upperDist = dist + plus;
                upperDist = upCorrection < 0.0 ? 6.0 : (upperDist += correction);
                inputs.add(new Noe(noA, noB, "", "", atomA, atomB, lowerDist, upperDist));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public boolean CheckNoeHInPdb(Vector vecNoe, Vector vecPdb) {
        System.out.println("--------------------------------------");
        int resNoA = 0;
        int resNoB = 0;
        String resA = "";
        String resB = "";
        String atomA = "";
        String atomB = "";
        int index = -1;
        boolean isIn = false;
        int i = 0;
        while (i < vecNoe.size()) {
            String atom;
            Cartesian cc;
            int j;
            Vector<Cartesian> atomVec;
            Pdb pp;
            Noe noe = (Noe)vecNoe.elementAt(i);
            resNoA = noe.getResidueNoA();
            resA = noe.getResidueA();
            atomA = noe.getAtomA();
            resNoB = noe.getResidueNoB();
            resB = noe.getResidueB();
            atomB = noe.getAtomB();
            index = Collections.binarySearch(vecPdb, new Pdb(resNoA), new Pdb.PdbComparator());
            if (index < 0) {
                isIn = false;
                System.out.println("No NOE in PDB (resNoA): " + resNoA + " " + atomA + "-" + resNoB + " " + atomB);
            } else {
                isIn = false;
                pp = (Pdb)vecPdb.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atomA)) {
                        isIn = true;
                    }
                    ++j;
                }
                if (!isIn) {
                    System.out.println("No NOE in PDB (atomA name): " + resNoA + " " + atomA + "-" + resNoB + " " + atomB);
                }
            }
            index = Collections.binarySearch(vecPdb, new Pdb(resNoB), new Pdb.PdbComparator());
            if (index < 0) {
                isIn = false;
                System.out.println("No NOE in PDB (resNoB): " + resNoA + " " + atomA + "-" + resNoB + " " + atomB);
            } else {
                isIn = false;
                pp = (Pdb)vecPdb.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atomB)) {
                        isIn = true;
                    }
                    ++j;
                }
                if (!isIn) {
                    System.out.println("No NOE in PDB (atomB name): " + resNoA + " " + atomA + "-" + resNoB + " " + atomB);
                }
            }
            ++i;
        }
        System.out.println("--------------------------------------");
        return isIn;
    }

    public Vector UpdatePseudoProton(String resName, String atomName) {
        Vector<String> vecAtomName = new Vector<String>();
        if (!atomName.substring(0, 1).equalsIgnoreCase("Q")) {
            vecAtomName.add(atomName);
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ALA") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB1");
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PHE") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PHE") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD1");
            vecAtomName.add("HD2");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PHE") && atomName.equalsIgnoreCase("QE")) {
            vecAtomName.add("HE1");
            vecAtomName.add("HE2");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("HIS") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("HIS") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD1");
            vecAtomName.add("HD2");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PHE") && atomName.equalsIgnoreCase("QE")) {
            vecAtomName.add("HE1");
            vecAtomName.add("HE2");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("QG2")) {
            vecAtomName.add("HG21");
            vecAtomName.add("HG22");
            vecAtomName.add("HG23");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("QG1")) {
            vecAtomName.add("HG12");
            vecAtomName.add("HG13");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("QD1")) {
            vecAtomName.add("HD11");
            vecAtomName.add("HD12");
            vecAtomName.add("HD13");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD2");
            vecAtomName.add("HD3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("QE")) {
            vecAtomName.add("HE2");
            vecAtomName.add("HE3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("QD1")) {
            vecAtomName.add("HD11");
            vecAtomName.add("HD12");
            vecAtomName.add("HD13");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("QD2")) {
            vecAtomName.add("HD21");
            vecAtomName.add("HD22");
            vecAtomName.add("HD23");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("QE")) {
            vecAtomName.add("HE1");
            vecAtomName.add("HE2");
            vecAtomName.add("HE3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ASN") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PRO") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PRO") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("PRO") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD2");
            vecAtomName.add("HD3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("GLN") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("GLN") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ARG") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD2");
            vecAtomName.add("HD3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ARG") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("ARG") && atomName.equalsIgnoreCase("QG")) {
            vecAtomName.add("HG2");
            vecAtomName.add("HG3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("QG2")) {
            vecAtomName.add("HG21");
            vecAtomName.add("HG22");
            vecAtomName.add("HG23");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("QG2")) {
            vecAtomName.add("HG21");
            vecAtomName.add("HG22");
            vecAtomName.add("HG23");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("QG1")) {
            vecAtomName.add("HG11");
            vecAtomName.add("HG12");
            vecAtomName.add("HG13");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("TRP") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("QB")) {
            vecAtomName.add("HB2");
            vecAtomName.add("HB3");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("QD")) {
            vecAtomName.add("HD1");
            vecAtomName.add("HD2");
            return vecAtomName;
        }
        if (resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("QE")) {
            vecAtomName.add("HE1");
            vecAtomName.add("HE2");
            return vecAtomName;
        }
        return vecAtomName;
    }

    public Vector setSameUpperBounds4All(Vector vecOldNOE, double dbUpper) {
        Vector vecUpdateNOE = new Vector();
        vecUpdateNOE.addAll(vecOldNOE);
        boolean resNoA = false;
        boolean resNoB = false;
        String resA = "";
        String resB = "";
        String atomA = "";
        String atomB = "";
        double lo = 0.0;
        double up = 0.0;
        int i = 0;
        while (i < vecUpdateNOE.size()) {
            Noe noe = (Noe)vecUpdateNOE.elementAt(i);
            double originalUp = noe.getUpper();
            double maxUp = Math.max(dbUpper, originalUp);
            noe.setDistUpper(maxUp);
            ++i;
        }
        return vecUpdateNOE;
    }

    public Vector<Noe> DeleteRepeatNOEs(Vector<Noe> vecOldNOE) {
        Vector<Noe> vecUpdateNOE = new Vector<Noe>();
        int resNoA = 0;
        int resNoB = 0;
        String resA = "";
        String resB = "";
        String atomA = "";
        String atomB = "";
        double lo = 0.0;
        double up = 0.0;
        int i = 0;
        while (i < vecOldNOE.size()) {
            Noe noe = vecOldNOE.elementAt(i);
            resNoA = noe.getResidueNoA();
            resA = noe.getResidueA();
            atomA = noe.getAtomA();
            resNoB = noe.getResidueNoB();
            resB = noe.getResidueB();
            atomB = noe.getAtomB();
            boolean isRepeated = false;
            int j = 0;
            while (j < vecUpdateNOE.size()) {
                Noe noe2 = vecUpdateNOE.elementAt(j);
                int resNoA2 = noe2.getResidueNoA();
                String resA2 = noe2.getResidueA();
                String atomA2 = noe2.getAtomA();
                int resNoB2 = noe2.getResidueNoB();
                String resB2 = noe2.getResidueB();
                String atomB2 = noe2.getAtomB();
                if (resNoA2 == resNoA && resNoB2 == resNoB && atomA2.equalsIgnoreCase(atomA) && atomB2.equalsIgnoreCase(atomB)) {
                    isRepeated = true;
                }
                ++j;
            }
            if (!isRepeated) {
                vecUpdateNOE.add(noe);
            }
            ++i;
        }
        return vecUpdateNOE;
    }

    public void printNoesToFileInXplor(Vector<Noe> vecNoes, String fileName) {
        Peak pk = new Peak();
        String xplorNoeStr = "";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int i = 0;
            while (i < vecNoes.size()) {
                Noe noe = vecNoes.elementAt(i);
                int resNo1 = noe.getResidueNoA();
                int resNo2 = noe.getResidueNoB();
                String res1 = noe.getResidueA();
                String res2 = noe.getResidueB();
                String atom1 = noe.getAtomA();
                String atom2 = noe.getAtomB();
                double distUpper = noe.getUpper();
                xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                out.println(xplorNoeStr);
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void PrintNOE(Vector vecNOE) {
        int resNoA = 0;
        int resNoB = 0;
        String resA = "";
        String resB = "";
        String atomA = "";
        String atomB = "";
        double lo = 0.0;
        double up = 0.0;
        int i = 0;
        while (i < vecNOE.size()) {
            Noe noe = (Noe)vecNOE.elementAt(i);
            resNoA = noe.getResidueNoA();
            resA = noe.getResidueA();
            atomA = noe.getAtomA();
            resNoB = noe.getResidueNoB();
            resB = noe.getResidueB();
            atomB = noe.getAtomB();
            lo = noe.getLower();
            up = noe.getUpper();
            System.out.println(String.valueOf(resNoA) + " " + resA + "  " + atomA + "  " + resNoB + " " + resB + "  " + atomB + "  " + up + " " + " #peak    " + i);
            ++i;
        }
    }

    public Vector UpdateNOE(Vector vecOldNOE, Vector vecSSEOrder) {
        Vector vecUpdateNOE = new Vector();
        vecUpdateNOE.addAll(vecOldNOE);
        int resNoA = 0;
        int resNoB = 0;
        String resA = "";
        String resB = "";
        String atomA = "";
        String atomB = "";
        double lo = 0.0;
        double up = 0.0;
        Vector<Vector<Noe>> vecNOEOrder = new Vector<Vector<Noe>>();
        Vector vecPdbA = new Vector();
        Vector vecPdbB = new Vector();
        Pdb pdb1 = new Pdb();
        Pdb pdb2 = new Pdb();
        vecPdbA.addAll((Vector)vecSSEOrder.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        int i = 1;
        while (i < vecSSEOrder.size()) {
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecSSEOrder.elementAt(i));
            Vector<Noe> vecNoe = new Vector<Noe>();
            Collections.sort(vecPdbB, new Pdb.PdbComparator());
            pdb1 = (Pdb)vecPdbA.elementAt(0);
            pdb2 = (Pdb)vecPdbA.elementAt(vecPdbA.size() - 1);
            int NoA1 = pdb1.getResidueNo();
            int NoA2 = pdb2.getResidueNo();
            pdb1 = (Pdb)vecPdbB.elementAt(0);
            pdb2 = (Pdb)vecPdbB.elementAt(vecPdbB.size() - 1);
            int NoB1 = pdb1.getResidueNo();
            int NoB2 = pdb2.getResidueNo();
            int j = 0;
            while (j < vecUpdateNOE.size()) {
                Noe noe = (Noe)vecUpdateNOE.elementAt(j);
                resNoA = noe.getResidueNoA();
                resA = noe.getResidueA();
                atomA = noe.getAtomA();
                resNoB = noe.getResidueNoB();
                resB = noe.getResidueB();
                atomB = noe.getAtomB();
                lo = noe.getLower();
                up = noe.getUpper();
                int indexAInA = Collections.binarySearch(vecPdbA, new Pdb(resNoA), new Pdb.PdbComparator());
                int indexBInB = Collections.binarySearch(vecPdbB, new Pdb(resNoB), new Pdb.PdbComparator());
                int indexAInB = Collections.binarySearch(vecPdbB, new Pdb(resNoA), new Pdb.PdbComparator());
                int indexBInA = Collections.binarySearch(vecPdbA, new Pdb(resNoB), new Pdb.PdbComparator());
                if (indexAInA > -1 && indexBInB > -1) {
                    vecNoe.add(new Noe(resNoA, resNoB, resA, resB, atomA, atomB, lo, up));
                }
                if (indexAInB > -1 && indexBInA > -1) {
                    vecNoe.add(new Noe(resNoB, resNoA, resB, resA, atomB, atomA, lo, up));
                }
                ++j;
            }
            Collections.sort(vecNoe, new NoeComparator());
            Vector<Noe> vecNoeNew = this.DeleteRepeatNOEs(vecNoe);
            vecNOEOrder.add(vecNoeNew);
            vecPdbA.addAll(vecPdbB);
            Collections.sort(vecPdbA, new Pdb.PdbComparator());
            ++i;
        }
        return vecNOEOrder;
    }

    public Vector LongRangeNoeReaderTestLW(String noeFile) {
        Vector<Noe> inputs = new Vector<Noe>();
        int noA = 0;
        int noB = 0;
        String atomA = "";
        String atomB = "";
        String resA = "";
        String resB = "";
        String ss = "";
        StringTokenizer st = new StringTokenizer("");
        double up_exp = 0.0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do {
                double correction = 0.0;
                double low_correct = 0.0;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resA = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resB = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    up_exp = new Double(st.nextToken());
                }
                if (atomA.substring(0, 1).equalsIgnoreCase("Q")) {
                    if (atomA.substring(0, 2).equalsIgnoreCase("QB")) {
                        atomA = "CB";
                        this.upper = up_exp + 3.0;
                        this.lower = Math.max(1.8, this.upper - 1.5);
                    } else {
                        atomA = "CB";
                        this.upper = 12.0;
                        this.lower = 5.0;
                    }
                } else {
                    this.upper = up_exp + 2.0;
                    this.lower = Math.max(1.8, this.upper - 1.5);
                }
                if (atomB.substring(0, 1).equalsIgnoreCase("Q")) {
                    if (atomB.substring(0, 2).equalsIgnoreCase("QB")) {
                        atomB = "CB";
                        this.upper = up_exp + 3.0;
                        this.lower = Math.max(1.8, this.upper - 1.5);
                    } else {
                        atomB = "CB";
                        this.upper = 12.0;
                        this.lower = 5.0;
                    }
                } else {
                    this.upper = up_exp + 2.0;
                    this.lower = Math.max(1.8, this.upper - 1.5);
                }
                inputs.add(new Noe(noA, noB, resA, resB, atomA, atomB, this.lower, this.upper));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Vector<Noe> vecNoe = new Vector<Noe>();
        int i = 0;
        while (i < inputs.size()) {
            Noe noe = (Noe)inputs.elementAt(i);
            int resno1 = noe.getResidueNoA();
            int resno2 = noe.getResidueNoB();
            boolean isInSSES = true;
            if (resno1 < 6 || resno1 > 131) {
                isInSSES = false;
            }
            if (resno2 < 6 || resno2 > 131) {
                isInSSES = false;
            }
            if (20 < resno1 && resno1 < 30) {
                isInSSES = false;
            }
            if (20 < resno2 && resno2 < 30) {
                isInSSES = false;
            }
            if (38 < resno1 && resno1 < 50) {
                isInSSES = false;
            }
            if (38 < resno2 && resno2 < 50) {
                isInSSES = false;
            }
            if (77 < resno1 && resno1 < 84) {
                isInSSES = false;
            }
            if (77 < resno2 && resno2 < 84) {
                isInSSES = false;
            }
            if (93 < resno1 && resno1 < 95) {
                isInSSES = false;
            }
            if (93 < resno2 && resno2 < 95) {
                isInSSES = false;
            }
            if (105 < resno1 && resno1 < 117) {
                isInSSES = false;
            }
            if (105 < resno2 && resno2 < 117) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 6 && Math.max(resno1, resno2) <= 20) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 30 && Math.max(resno1, resno2) <= 38) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 50 && Math.max(resno1, resno2) <= 77) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 84 && Math.max(resno1, resno2) <= 93) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 95 && Math.max(resno1, resno2) <= 105) {
                isInSSES = false;
            }
            if (Math.min(resno1, resno2) >= 117 && Math.max(resno1, resno2) <= 131) {
                isInSSES = false;
            }
            if (isInSSES) {
                vecNoe.add(noe);
            }
            ++i;
        }
        return vecNoe;
    }

    public String xplorNoeStatement(int no1, String resid1, String nucleus1, int no2, String resid, String nucleus2, double lower, double upper) {
        double lowerLimit = 1.8;
        double middle = 0.0;
        double upLimit = 5.5;
        double methylCorrection = 3.0;
        double strongBound = 2.7;
        double middleBound = 3.5;
        double methylBound = 7.0;
        double methylMin = 4.0;
        double[] noeLimits = new double[3];
        boolean isMethyl = false;
        if (resid1.equalsIgnoreCase("ALA") && nucleus1.equalsIgnoreCase("HB")) {
            nucleus1 = "HB#";
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD2")) {
            nucleus1 = "HD2#";
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG1")) {
            nucleus1 = "HG1#";
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
        } else if (resid1.equalsIgnoreCase("THR") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
        } else {
            if (resid1.equalsIgnoreCase("ARG") || resid1.equalsIgnoreCase("PRO")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
                if (nucleus1.equalsIgnoreCase("HD2")) {
                    nucleus1 = "HD1";
                }
                if (nucleus1.equalsIgnoreCase("HD3")) {
                    nucleus1 = "HD2";
                }
            }
            if (resid1.equalsIgnoreCase("ASP") || resid1.equalsIgnoreCase("CYS") || resid1.equalsIgnoreCase("HIS") || resid1.equalsIgnoreCase("SER") || resid1.equalsIgnoreCase("TRP") || resid1.equalsIgnoreCase("ASN") || resid1.equalsIgnoreCase("LEU") || resid1.equalsIgnoreCase("VAL") || resid1.equalsIgnoreCase("TYR") || resid1.equalsIgnoreCase("PHE")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
            }
            if (resid1.equalsIgnoreCase("GLU") || resid1.equalsIgnoreCase("MET") || resid1.equalsIgnoreCase("GLN")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
            }
            if (resid1.equalsIgnoreCase("GLY")) {
                if (nucleus1.equalsIgnoreCase("HA2")) {
                    nucleus1 = "HA1";
                }
                if (nucleus1.equalsIgnoreCase("HA3")) {
                    nucleus1 = "HA2";
                }
            }
            if (resid1.equalsIgnoreCase("ILE")) {
                if (nucleus1.equalsIgnoreCase("HG12")) {
                    nucleus1 = "HG11";
                }
                if (nucleus1.equalsIgnoreCase("HG13")) {
                    nucleus1 = "HG12";
                }
            }
            if (resid1.equalsIgnoreCase("LYS") || resid1.equalsIgnoreCase("PRO")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
                if (nucleus1.equalsIgnoreCase("HD2")) {
                    nucleus1 = "HD1";
                }
                if (nucleus1.equalsIgnoreCase("HD3")) {
                    nucleus1 = "HD2";
                }
                if (nucleus1.equalsIgnoreCase("HE2")) {
                    nucleus1 = "HE1";
                }
                if (nucleus1.equalsIgnoreCase("HE3")) {
                    nucleus1 = "HE2";
                }
            }
            if (nucleus1.equalsIgnoreCase("H")) {
                nucleus1 = "HN";
            }
        }
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")) {
            nucleus2 = "HB#";
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")) {
            nucleus2 = "HD2#";
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")) {
            nucleus2 = "HG1#";
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
        } else {
            if (resid.equalsIgnoreCase("ARG") || resid.equalsIgnoreCase("PRO")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
                if (nucleus2.equalsIgnoreCase("HD2")) {
                    nucleus2 = "HD1";
                }
                if (nucleus2.equalsIgnoreCase("HD3")) {
                    nucleus2 = "HD2";
                }
            }
            if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("ASN") || resid.equalsIgnoreCase("LEU") || resid.equalsIgnoreCase("VAL") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("PHE")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
            }
            if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET") || resid.equalsIgnoreCase("GLN")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
            }
            if (resid.equalsIgnoreCase("GLY")) {
                if (nucleus2.equalsIgnoreCase("HA2")) {
                    nucleus2 = "HA1";
                }
                if (nucleus2.equalsIgnoreCase("HA3")) {
                    nucleus2 = "HA2";
                }
            }
            if (resid.equalsIgnoreCase("ILE")) {
                if (nucleus2.equalsIgnoreCase("HG12")) {
                    nucleus2 = "HG11";
                }
                if (nucleus2.equalsIgnoreCase("HG13")) {
                    nucleus2 = "HG12";
                }
            }
            if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
                if (nucleus2.equalsIgnoreCase("HD2")) {
                    nucleus2 = "HD1";
                }
                if (nucleus2.equalsIgnoreCase("HD3")) {
                    nucleus2 = "HD2";
                }
                if (nucleus2.equalsIgnoreCase("HE2")) {
                    nucleus2 = "HE1";
                }
                if (nucleus2.equalsIgnoreCase("HE3")) {
                    nucleus2 = "HE2";
                }
            }
            if (nucleus2.equalsIgnoreCase("H")) {
                nucleus2 = "HN";
            }
        }
        lowerLimit = lower;
        middle = 0.0;
        upLimit = upper - lower;
        String str = "assign (resid     " + String.valueOf(no1) + "  and name       " + nucleus1 + ")   (resid     " + String.valueOf(no2) + " and name     " + nucleus2 + ")      " + String.valueOf(lowerLimit) + "   " + String.valueOf(middle) + "  " + String.valueOf(upLimit);
        return str;
    }

    public static void main111(String[] argv) {
        Assign asg = new Assign();
        Noe noe_temp = new Noe();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String noeCyanaFile = String.valueOf(src) + "final.upl";
        Noe noe = new Noe();
        String fileXplorName = String.valueOf(src) + "ff2_noe_xplor.tbl";
        String seqFile = String.valueOf(src) + "ff2.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        Vector vecManAsg = noe_temp.noeReader(fileXplorName, 0.0, vecSeq);
        Noe ne = new Noe();
        Vector vecNoeNewCyana = ne.ConvertXplorAsgToUplFormat(vecManAsg, vecSeq, "BMRB-NEW");
        ne.PrintNOE(vecNoeNewCyana);
    }

    public static void main(String[] argv) {
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String noeFile = String.valueOf(src) + "final.upl";
        Noe noe = new Noe();
        String fileName = String.valueOf(src) + "ff2_noe_xplor.tbl";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            System.out.println("! here is the noe assignment in xplor format:");
            out.println("! here is the noe assignment in xplor format:");
            noe.ConvertCyanNoeAsgToXplor(noeFile, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public static void main11(String[] argv) {
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String noeFile = String.valueOf(src) + "final.upl";
        Noe noe = new Noe();
        String fileName = String.valueOf(src) + "ff2_noe_xplor.tbl";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            System.out.println("! here is the noe assignment in xplor format:");
            out.println("! here is the noe assignment in xplor format:");
            noe.ConvertCyanNoeAsgToXplor(noeFile, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Pdb pp = new Pdb();
        String pdbFile = String.valueOf(src) + "FF2FinalPacking5.pdb";
        Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFile);
        Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
        Vector vecPhiPsi = pp.PhiPsiTotalPdb(vecTempPdbBB2);
        String fileName2 = String.valueOf(src) + "ff2_dihe_xplor.tbl";
        String strTemp1 = "";
        String strTemp2 = "";
        try {
            PrintWriter out2 = new PrintWriter(new BufferedWriter(new FileWriter(fileName2)));
            out2.println("! here is the dihedral angle constraint in xplor format:");
            System.out.println("! here is the dihedral angle constraint in xplor format:");
            int i = 0;
            while (i < vecPhiPsi.size()) {
                PhiPsi phipsi = (PhiPsi)vecPhiPsi.elementAt(i);
                int resNo = phipsi.getResidueNo();
                double phiValue = 57.29577951308232 * phipsi.getPhi();
                double psiValue = 57.29577951308232 * phipsi.getPsi();
                String strPhi1 = "assign (resid     " + String.valueOf(resNo - 1) + "  and name       " + "C" + ")   (resid     " + String.valueOf(resNo) + " and name     " + "N" + ")      ";
                String strPhi2 = "       (resid     " + String.valueOf(resNo) + "  and name       " + "CA" + ")   (resid     " + String.valueOf(resNo) + " and name     " + "C" + ")      " + String.valueOf(1.0) + "   " + String.valueOf(phiValue) + "  " + String.valueOf(10.0) + "  " + String.valueOf(2);
                System.out.println(strPhi1);
                System.out.println(strPhi2);
                out2.println(strPhi1);
                out2.println(strPhi2);
                String strPsi1 = "assign (resid     " + String.valueOf(resNo) + "  and name       " + "N" + ")   (resid     " + String.valueOf(resNo) + " and name     " + "CA" + ")      ";
                String strPsi2 = "       (resid     " + String.valueOf(resNo) + "  and name       " + "C" + ")   (resid     " + String.valueOf(resNo + 1) + " and name     " + "N" + ")      " + String.valueOf(1.0) + "   " + String.valueOf(psiValue) + "  " + String.valueOf(10.0) + "  " + String.valueOf(2);
                System.out.println(strPsi1);
                System.out.println(strPsi2);
                out2.println(strPsi1);
                out2.println(strPsi2);
                System.out.println();
                out2.println();
                ++i;
            }
            noe.ConvertCyanNoeAsgToXplor(noeFile, out2);
            out2.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName2);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public Vector ConvertAllNoeToBBNoe(Vector vecNoeAll, Vector vecSeq) {
        Vector<Noe> vecNoeBB = new Vector<Noe>();
        String atom_A = "";
        String atom_B = "";
        String res_A = "";
        String res_B = "";
        int resNoA = 0;
        int resNoB = 0;
        double low_dist = 0.0;
        double upper_dist = 0.0;
        Pdb pdb = new Pdb();
        double up_correction = 2.5;
        int i = 0;
        while (i < vecNoeAll.size()) {
            double correctionA = 0.0;
            double correctionB = 0.0;
            Noe noe = (Noe)vecNoeAll.elementAt(i);
            atom_A = noe.getAtomA();
            atom_B = noe.getAtomB();
            res_A = noe.getResidueA();
            res_B = noe.getResidueB();
            resNoA = noe.getResidueNoA();
            resNoB = noe.getResidueNoB();
            low_dist = noe.getLower();
            upper_dist = noe.getUpper();
            res_A = this.getResNameFromSequence(vecSeq, resNoA);
            res_B = this.getResNameFromSequence(vecSeq, resNoB);
            String atom_A_new = pdb.NameFromPdbToBMRB(res_A, atom_A);
            String atom_B_new = pdb.NameFromPdbToBMRB(res_B, atom_B);
            if (atom_A_new.length() >= 2) {
                if (atom_A_new.substring(0, 2).equalsIgnoreCase("QQ")) {
                    atom_A_new = "QQ" + atom_A_new.substring(1, atom_A_new.length() - 2);
                } else if (atom_A_new.substring(atom_A_new.length() - 1, atom_A_new.length()).equalsIgnoreCase("#")) {
                    atom_A_new = "Q" + atom_A_new.substring(1, atom_A_new.length() - 1);
                }
            }
            if (atom_B_new.length() >= 2) {
                if (atom_B_new.substring(atom_B_new.length() - 2, atom_B_new.length()).equalsIgnoreCase("##")) {
                    atom_B_new = "QQ" + atom_B_new.substring(1, atom_B_new.length() - 2);
                } else if (atom_B_new.substring(atom_B_new.length() - 1, atom_B_new.length()).equalsIgnoreCase("#")) {
                    atom_B_new = "Q" + atom_B_new.substring(1, atom_B_new.length() - 1);
                }
            }
            vecNoeBB.add(new Noe(resNoA, resNoB, res_A, res_B, atom_A_new, atom_B_new, low_dist, upper_dist));
            ++i;
        }
        return vecNoeBB;
    }

    public Vector ConvertXplorAsgToUplFormat(Vector vecNoeXplor, Vector vecSeq, String nameScheme) {
        Vector<Noe> vecNoeUpl = new Vector<Noe>();
        String atom_A = "";
        String atom_B = "";
        String res_A = "";
        String res_B = "";
        int resNoA = 0;
        int resNoB = 0;
        double low_dist = 0.0;
        double upper_dist = 0.0;
        Pdb pdb = new Pdb();
        double up_correction = 2.0;
        int i = 0;
        while (i < vecNoeXplor.size()) {
            Noe noe = (Noe)vecNoeXplor.elementAt(i);
            atom_A = noe.getAtomA();
            atom_B = noe.getAtomB();
            res_A = noe.getResidueA();
            res_B = noe.getResidueB();
            resNoA = noe.getResidueNoA();
            resNoB = noe.getResidueNoB();
            low_dist = noe.getLower();
            upper_dist = noe.getUpper();
            res_A = this.getResNameFromSequence(vecSeq, resNoA);
            res_B = this.getResNameFromSequence(vecSeq, resNoB);
            String atom_A_new = atom_A;
            String atom_B_new = atom_B;
            if (nameScheme.equalsIgnoreCase("BMRB-NEW")) {
                atom_A_new = pdb.NameFromPdbToBMRB(res_A, atom_A);
                atom_B_new = pdb.NameFromPdbToBMRB(res_B, atom_B);
            }
            if (atom_A_new.length() >= 2) {
                if (atom_A_new.substring(atom_A_new.length() - 2, atom_A_new.length()).equalsIgnoreCase("##")) {
                    atom_A_new = "QQ" + atom_A_new.substring(1, atom_A_new.length() - 2);
                } else if (atom_A_new.substring(atom_A_new.length() - 1, atom_A_new.length()).equalsIgnoreCase("#")) {
                    atom_A_new = "Q" + atom_A_new.substring(1, atom_A_new.length() - 1);
                }
            }
            if (atom_B_new.length() >= 2) {
                if (atom_B_new.substring(atom_B_new.length() - 2, atom_B_new.length()).equalsIgnoreCase("##")) {
                    atom_B_new = "QQ" + atom_B_new.substring(1, atom_B_new.length() - 2);
                } else if (atom_B_new.substring(atom_B_new.length() - 1, atom_B_new.length()).equalsIgnoreCase("#")) {
                    atom_B_new = "Q" + atom_B_new.substring(1, atom_B_new.length() - 1);
                }
            }
            vecNoeUpl.add(new Noe(resNoA, resNoB, res_A, res_B, atom_A_new, atom_B_new, low_dist, upper_dist));
            ++i;
        }
        return vecNoeUpl;
    }

    public Vector ConvertXplorAsgToUplFormatFF2(Vector vecNoeXplor, Vector vecSeq) {
        Vector<Noe> vecNoeUpl = new Vector<Noe>();
        String atom_A = "";
        String atom_B = "";
        String res_A = "";
        String res_B = "";
        int resNoA = 0;
        int resNoB = 0;
        double low_dist = 0.0;
        double upper_dist = 0.0;
        Pdb pdb = new Pdb();
        double up_correction = 2.0;
        int i = 0;
        while (i < vecNoeXplor.size()) {
            Noe noe = (Noe)vecNoeXplor.elementAt(i);
            atom_A = noe.getAtomA();
            atom_B = noe.getAtomB();
            res_A = noe.getResidueA();
            res_B = noe.getResidueB();
            resNoA = noe.getResidueNoA();
            resNoB = noe.getResidueNoB();
            low_dist = noe.getLower();
            upper_dist = noe.getUpper();
            res_A = this.getResNameFromSequence(vecSeq, resNoA);
            res_B = this.getResNameFromSequence(vecSeq, resNoB);
            String atom_A_new = pdb.NameFromPdbToBMRB(res_A, atom_A);
            String atom_B_new = pdb.NameFromPdbToBMRB(res_B, atom_B);
            if (atom_A_new.length() >= 2) {
                if (atom_A_new.substring(atom_A_new.length() - 2, atom_A_new.length()).equalsIgnoreCase("##")) {
                    atom_A_new = "QQ" + atom_A_new.substring(1, atom_A_new.length() - 2);
                } else if (atom_A_new.substring(atom_A_new.length() - 1, atom_A_new.length()).equalsIgnoreCase("#")) {
                    atom_A_new = "Q" + atom_A_new.substring(1, atom_A_new.length() - 1);
                }
            }
            if (atom_B_new.length() >= 2) {
                if (atom_B_new.substring(atom_B_new.length() - 2, atom_B_new.length()).equalsIgnoreCase("##")) {
                    atom_B_new = "QQ" + atom_B_new.substring(1, atom_B_new.length() - 2);
                } else if (atom_B_new.substring(atom_B_new.length() - 1, atom_B_new.length()).equalsIgnoreCase("#")) {
                    atom_B_new = "Q" + atom_B_new.substring(1, atom_B_new.length() - 1);
                }
            }
            vecNoeUpl.add(new Noe(resNoA, resNoB, res_A, res_B, atom_A, atom_B, low_dist, 6.0));
            ++i;
        }
        return vecNoeUpl;
    }

    public void ConvertCyanNoeAsgToXplor(String noeFile, PrintWriter out) {
        Vector inputs = new Vector();
        int noA = 0;
        int noB = 0;
        String atomA = "";
        String atomB = "";
        String resA = "";
        String resB = "";
        String ss = "";
        StringTokenizer st = new StringTokenizer("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do {
                double correction = 1.8;
                double low_correct = 0.0;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resA = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && (atomA = "H" + atomA.substring(1, atomA.length()) + "#").substring(1, 2).equalsIgnoreCase("Q")) {
                    atomA = "H" + atomA.substring(2, atomA.length()) + "#";
                }
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resB = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && (atomB = "H" + atomB.substring(1, atomB.length()) + "#").substring(1, 2).equalsIgnoreCase("Q")) {
                    atomB = "H" + atomB.substring(2, atomB.length()) + "#";
                }
                if (st.hasMoreTokens()) {
                    this.upper = new Double(st.nextToken());
                }
                if (!(this.upper > 1.0)) continue;
                this.upper += correction;
                this.lower = 1.8;
                String xplorNoeStr = "";
                Peak pk = new Peak();
                xplorNoeStr = this.xplorNoeStatement(noA, resA, atomA, noB, resB, atomB, this.lower, this.upper);
                System.out.println(xplorNoeStr);
                out.println(xplorNoeStr);
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public boolean noeSatisfiedScore(Vector noeVec, Vector vecPdb, double[] noeRmsd, double[] noeHarmScore, int[] numConflicts) {
        double[][] noeDistance = new double[noeVec.size()][2];
        int i = 0;
        while (i < noeVec.size()) {
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        Pdb pp = new Pdb();
        double disRms = 0.0;
        double noeHarm = 0.0;
        int counter = 0;
        int i2 = 0;
        while (i2 < noeVec.size()) {
            int noA = ((Noe)noeVec.elementAt(i2)).getResidueNoA();
            String atomA = ((Noe)noeVec.elementAt(i2)).getAtomA();
            int noB = ((Noe)noeVec.elementAt(i2)).getResidueNoB();
            String atomB = ((Noe)noeVec.elementAt(i2)).getAtomB();
            noeDistance[i2] = ((Noe)noeVec.elementAt(i2)).getRange();
            double[] dis = new double[1];
            double[] distance = new double[1];
            pp.measurePackDisAllRotamers(vecPdb, vecPdb, noA, atomA, noB, atomB, noeDistance[i2][0], noeDistance[i2][1], dis, distance);
            if (dis[0] > 100.0) {
                ++counter;
            }
            disRms += dis[0] * dis[0];
            noeHarm += dis[0] * dis[0];
            ++i2;
        }
        noeRmsd[0] = disRms = Math.sqrt(disRms / (double)noeVec.size());
        noeHarmScore[0] = noeHarm /= (double)noeVec.size();
        numConflicts[0] = counter;
        return true;
    }

    public boolean noeSatisfiedScoreFF2(Vector noeVec, Vector vecPdb, double[] noeRmsd, double[] noeHarmScore, int[] numConflicts) {
        double[][] noeDistance = new double[noeVec.size()][2];
        int i = 0;
        while (i < noeVec.size()) {
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        Pdb pp = new Pdb();
        double disRms = 0.0;
        double noeHarm = 0.0;
        double noe_sat = 0.0;
        int counter = 0;
        int count_temp = 0;
        int i2 = 0;
        while (i2 < noeVec.size()) {
            int noA = ((Noe)noeVec.elementAt(i2)).getResidueNoA();
            String atomA = ((Noe)noeVec.elementAt(i2)).getAtomA();
            int noB = ((Noe)noeVec.elementAt(i2)).getResidueNoB();
            String atomB = ((Noe)noeVec.elementAt(i2)).getAtomB();
            noeDistance[i2] = ((Noe)noeVec.elementAt(i2)).getRange();
            noeDistance[i2][1] = 6.0;
            ++count_temp;
            double[] dis = new double[1];
            double[] distance = new double[1];
            pp.measurePackDisAllRotamers(vecPdb, vecPdb, noA, atomA, noB, atomB, noeDistance[i2][0], noeDistance[i2][1], dis, distance);
            if (dis[0] > 100.0) {
                ++counter;
            }
            if (dis[0] < 0.0) {
                System.out.println("error...");
            }
            noe_sat += dis[0];
            disRms += dis[0] * dis[0];
            noeHarm += dis[0] * dis[0];
            ++i2;
        }
        noeHarm /= (double)noeVec.size();
        noeRmsd[0] = disRms = Math.sqrt(disRms / (double)noeVec.size());
        noeHarmScore[0] = noe_sat / (double)count_temp;
        numConflicts[0] = counter;
        return true;
    }

    public Vector ConvertNoeFromBMRMToPDB(Vector vecNoeBMRB) {
        Vector vecNOENew = new Vector();
        Pdb pp = new Pdb();
        int i = 0;
        while (i < vecNoeBMRB.size()) {
            Noe noe = (Noe)vecNoeBMRB.elementAt(i);
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom1_new = pp.NameFromBMRBToPDB(res1, atom1);
            String atom2_new = pp.NameFromBMRBToPDB(res2, atom2);
            noe.setAtom1Name(atom1_new);
            noe.setAtom2Name(atom2_new);
            ++i;
        }
        vecNOENew.addAll(vecNoeBMRB);
        return vecNOENew;
    }

    public Vector LongRangeNoeReader(String noeFile, double upCorrection, String nameScheme) {
        Pdb pp = new Pdb();
        Vector<Noe> inputs = new Vector<Noe>();
        int noA = 0;
        int noB = 0;
        String atomA = "";
        String atomB = "";
        String resA = "";
        String resB = "";
        String ss = "";
        StringTokenizer st = new StringTokenizer("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do {
                double correction = 0.0;
                correction = upCorrection;
                double low_correct = 0.0;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resA = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                if (atomA.length() >= 2) {
                    if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                        atomA = "H" + atomA.substring(2, atomA.length());
                    } else if (atomA.substring(0, 1).equalsIgnoreCase("Q")) {
                        atomA = "H" + atomA.substring(1, atomA.length());
                    }
                }
                if (nameScheme.equalsIgnoreCase("BMRB-NEW")) {
                    atomA = pp.NameFromBMRBToPDB(resA, atomA);
                }
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resB = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                if (atomB.length() >= 2) {
                    if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                        atomB = "H" + atomB.substring(2, atomB.length());
                    } else if (atomB.substring(0, 1).equalsIgnoreCase("Q")) {
                        atomB = "H" + atomB.substring(1, atomB.length());
                    }
                }
                if (nameScheme.equalsIgnoreCase("BMRB-NEW")) {
                    atomB = pp.NameFromBMRBToPDB(resB, atomB);
                }
                if (st.hasMoreTokens()) {
                    this.upper = new Double(st.nextToken());
                }
                this.lower = 1.8;
                this.upper = upCorrection < 0.0 ? 6.0 : (this.upper += correction);
                inputs.add(new Noe(noA, noB, resA, resB, atomA, atomB, this.lower, this.upper));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector LongRangeNoeReader2(String noeFile) {
        Vector<Noe> inputs = new Vector<Noe>();
        int noA = 0;
        int noB = 0;
        String atomA = "";
        String atomB = "";
        String resA = "";
        String resB = "";
        String ss = "";
        StringTokenizer st = new StringTokenizer("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(noeFile));
            ss = in.readLine();
            do {
                double correction = 0.0;
                double low_correct = 0.0;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    noA = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resA = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomA = new String(st.nextToken());
                }
                if (atomA.substring(0, 1).equalsIgnoreCase("Q")) {
                    atomA = "C" + atomA.substring(1, atomA.length());
                }
                if (st.hasMoreTokens()) {
                    noB = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resB = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomB = new String(st.nextToken());
                }
                if (atomB.substring(0, 1).equalsIgnoreCase("Q")) {
                    atomB = "C" + atomB.substring(1, atomB.length());
                }
                if ((atomA.equalsIgnoreCase("CD") || atomA.equalsIgnoreCase("CQD")) && (resA.equalsIgnoreCase("HIS") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TYR"))) {
                    atomA = "CG";
                    correction += 1.1;
                }
                if (atomA.equalsIgnoreCase("CQD") && resA.equalsIgnoreCase("LEU")) {
                    atomA = "CG";
                    correction += 1.5;
                }
                if (atomA.equalsIgnoreCase("CQG") && resA.equalsIgnoreCase("VAL")) {
                    atomA = "CB";
                    correction += 1.5;
                }
                if (atomA.equalsIgnoreCase("CE") && (resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TYR"))) {
                    atomA = "CZ";
                    correction += 1.3;
                }
                if (atomB.equalsIgnoreCase("CD") && (resB.equalsIgnoreCase("PHE") || resB.equalsIgnoreCase("TYR"))) {
                    atomB = "CG";
                    correction += 1.3;
                }
                if (atomB.equalsIgnoreCase("CQD") && resB.equalsIgnoreCase("LEU")) {
                    atomB = "CG";
                    correction += 1.5;
                }
                if (atomB.equalsIgnoreCase("CQG") && resB.equalsIgnoreCase("VAL")) {
                    atomB = "CB";
                    correction += 1.5;
                }
                if (atomB.equalsIgnoreCase("CE") && (resB.equalsIgnoreCase("PHE") || resB.equalsIgnoreCase("TYR"))) {
                    atomB = "CZ";
                    correction += 1.3;
                }
                if (st.hasMoreTokens()) {
                    this.upper = new Double(st.nextToken());
                }
                this.upper += correction;
                this.lower = 1.8;
                inputs.add(new Noe(noA, noB, resA, resB, atomA, atomB, this.lower, 6.0));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + noeFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public static class NoeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            int d2;
            Noe n1 = (Noe)o1;
            Noe n2 = (Noe)o2;
            int d1 = n1.getResidueNoA();
            if (d1 < (d2 = n2.getResidueNoA())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class noeComparatorA
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            Noe n1 = (Noe)o1;
            Noe n2 = (Noe)o2;
            int d1 = n1.getResidueNoA();
            if (d1 < (d2 = n2.getResidueNoA())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class noeComparatorB
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            Noe n1 = (Noe)o1;
            Noe n2 = (Noe)o2;
            int d1 = n1.getResidueNoB();
            if (d1 < (d2 = n2.getResidueNoB())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class noeComparatorC
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Noe n1 = (Noe)o1;
            Noe n2 = (Noe)o2;
            int d1 = n1.getResidueNoA();
            int d2 = n2.getResidueNoA();
            int dA = n1.getResidueNoB();
            int dB = n2.getResidueNoB();
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            if (d1 == d2) {
                if (dA < dB) {
                    return -1;
                }
                if (dA > dB) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

