/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class Hncacb {
    private int peakNo;
    private int residueNo;
    private String residue;
    private double csH1;
    private double csN15;
    private double csC13;
    private double intensity;

    public Hncacb() {
        this.peakNo = 0;
        this.residueNo = 0;
        this.residue = null;
        this.csH1 = 0.0;
        this.csN15 = 0.0;
        this.csC13 = 0.0;
        this.intensity = 0.0;
    }

    public Hncacb(int no) {
        this.peakNo = 0;
        this.residueNo = no;
        this.residue = null;
        this.csH1 = 0.0;
        this.csN15 = 0.0;
        this.csC13 = 0.0;
        this.intensity = 0.0;
    }

    public Hncacb(int pkNo, int no, String resid, double H1, double N15, double c13Vec, double inten) {
        this.peakNo = pkNo;
        this.residueNo = no;
        this.residue = resid;
        this.csH1 = H1;
        this.csN15 = N15;
        this.csC13 = c13Vec;
        this.intensity = inten;
    }

    public int getPeakNo() {
        return this.peakNo;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public double getH1() {
        return this.csH1;
    }

    public double getN15() {
        return this.csN15;
    }

    public double getC13() {
        return this.csC13;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.peakNo)) + "  " + String.valueOf(this.residueNo) + "    " + String.valueOf(this.csH1) + "  " + String.valueOf(this.csN15) + "   " + String.valueOf(this.csC13) + "  " + String.valueOf(this.intensity);
        return desc;
    }

    public Vector hncacbRead(String filename) {
        Vector<Hncacb> inputs = new Vector<Hncacb>();
        Vector csVec = new Vector();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int pkNo = (int)in.nval;
                in.nextToken();
                double csN15 = in.nval;
                in.nextToken();
                in.nextToken();
                in.nextToken();
                this.csC13 = in.nval;
                in.nextToken();
                in.nextToken();
                in.nextToken();
                double csH1 = in.nval;
                in.nextToken();
                in.nextToken();
                in.nextToken();
                double intensity = in.nval;
                in.nextToken();
                in.nextToken();
                inputs.add(new Hncacb(pkNo, 0, "ALA", csH1, csN15, this.csC13, intensity));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec) {
        Vector outVec = new Vector();
        double csValue = 0.0;
        int i = 0;
        while (i < pkVec.size()) {
            if (nucType.equals("H1")) {
                csValue = ((Hncacb)pkVec.elementAt(i)).getH1();
            } else if (nucType.equals("N15")) {
                csValue = ((Hncacb)pkVec.elementAt(i)).getN15();
            }
            if (csValue >= a && csValue <= b) {
                outVec.add(pkVec.elementAt(i));
            }
            ++i;
        }
        return outVec;
    }

    public Vector mergeHNCACB(Vector pkVec) {
        double epsH = 0.02;
        double epsN = 0.05;
        double csH1 = 0.0;
        double csN15 = 0.0;
        double csH1Tmp = 0.0;
        double csN15Tmp = 0.0;
        Vector<Hncacb> outVec = new Vector<Hncacb>();
        Vector<Vector<Hncacb>> allVec = new Vector<Vector<Hncacb>>();
        double csValue = 0.0;
        Hncacb hncc = new Hncacb();
        int i = 0;
        int j = 0;
        Collections.sort(pkVec, new n15Comparator());
        int count = 0;
        int cnt = 0;
        int N = pkVec.size();
        while (count < N) {
            hncc = (Hncacb)pkVec.elementAt(count);
            csH1 = hncc.getH1();
            csN15 = hncc.getN15();
            outVec.add(hncc);
            cnt = 1;
            i = count + 1;
            while (i < N) {
                hncc = (Hncacb)pkVec.elementAt(i);
                csH1Tmp = hncc.getH1();
                csN15Tmp = hncc.getN15();
                if (Math.abs(csH1Tmp - csH1) < epsH && Math.abs(csN15Tmp - csN15) < epsN) {
                    outVec.add(hncc);
                    ++cnt;
                }
                ++i;
            }
            allVec.add(outVec);
            outVec = new Vector();
            count += cnt;
        }
        Vector oneVec = new Vector();
        Vector<Hncacb> oneVecNew = new Vector<Hncacb>();
        Vector<Vector<Hncacb>> allVecNew = new Vector<Vector<Hncacb>>();
        double csCa1 = 0.0;
        double csCa2 = 0.0;
        double intensity1 = 0.0;
        double intensity2 = 0.0;
        Hncacb hncc1 = new Hncacb();
        Hncacb hncc2 = new Hncacb();
        boolean bigger = false;
        i = 0;
        while (i < allVec.size()) {
            oneVec = (Vector)allVec.elementAt(i);
            j = 0;
            while (j < oneVec.size()) {
                hncc1 = (Hncacb)oneVec.elementAt(j);
                csCa1 = hncc1.getC13();
                intensity1 = hncc1.getIntensity();
                bigger = false;
                int k = 0;
                while (k < oneVec.size()) {
                    hncc2 = (Hncacb)oneVec.elementAt(k);
                    csCa2 = hncc2.getC13();
                    intensity2 = hncc2.getIntensity();
                    if (Math.abs(csCa2 - csCa1) < epsN && Math.abs(intensity2) > Math.abs(intensity1)) {
                        bigger = true;
                        hncc = hncc2;
                        csCa1 = hncc.getC13();
                        intensity1 = hncc.getIntensity();
                    }
                    ++k;
                }
                if (!bigger) {
                    if (oneVecNew.indexOf(hncc1) < 0) {
                        oneVecNew.add(hncc1);
                    }
                } else if (oneVecNew.indexOf(hncc) < 0) {
                    oneVecNew.add(hncc);
                }
                ++j;
            }
            allVecNew.add(oneVecNew);
            oneVecNew = new Vector();
            ++i;
        }
        return allVecNew;
    }

    public static class c13Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hncacb n1 = (Hncacb)o1;
            Hncacb n2 = (Hncacb)o2;
            double d1 = n1.getC13();
            if (d1 < (d2 = n2.getC13())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class hnComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hncacb n1 = (Hncacb)o1;
            Hncacb n2 = (Hncacb)o2;
            double d1 = n1.getH1();
            if (d1 < (d2 = n2.getH1())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class n15Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hncacb n1 = (Hncacb)o1;
            Hncacb n2 = (Hncacb)o2;
            double d1 = n1.getN15();
            if (d1 < (d2 = n2.getN15())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class peakNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hncacb n1 = (Hncacb)o1;
            Hncacb n2 = (Hncacb)o2;
            double d1 = n1.getPeakNo();
            if (d1 < (d2 = (double)n2.getPeakNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hncacb n1 = (Hncacb)o1;
            Hncacb n2 = (Hncacb)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

