/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import rdcPanda.SingularValueDecomposition;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
    }

    public Matrix(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                this.A[i][j] = s;
                ++j;
            }
            ++i;
        }
    }

    public Matrix(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        int i = 0;
        while (i < this.m) {
            if (A[i].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
        this.A = A;
    }

    public Matrix(double[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public Matrix(double[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[m][this.n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = vals[i + j * m];
                ++j;
            }
            ++i;
        }
    }

    public Matrix copy() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix rotationMat(double theta, String axis) {
        double[][] a = new double[3][3];
        if (axis.equals("+x")) {
            a[0][0] = 1.0;
            a[0][1] = 0.0;
            a[0][2] = 0.0;
            a[1][0] = 0.0;
            a[1][1] = Math.cos(theta);
            a[1][2] = Math.sin(theta);
            a[2][0] = 0.0;
            a[2][1] = -Math.sin(theta);
            a[2][2] = Math.cos(theta);
        } else if (axis.equals("-x")) {
            a[0][0] = 1.0;
            a[0][1] = 0.0;
            a[0][2] = 0.0;
            a[1][0] = 0.0;
            a[1][1] = Math.cos(theta);
            a[1][2] = -Math.sin(theta);
            a[2][0] = 0.0;
            a[2][1] = Math.sin(theta);
            a[2][2] = Math.cos(theta);
        } else if (axis.equals("+y")) {
            a[0][0] = Math.cos(theta);
            a[0][1] = 0.0;
            a[0][2] = -Math.sin(theta);
            a[1][0] = 0.0;
            a[1][1] = 1.0;
            a[1][2] = 0.0;
            a[2][0] = Math.sin(theta);
            a[2][1] = 0.0;
            a[2][2] = Math.cos(theta);
        } else if (axis.equals("-y")) {
            a[0][0] = Math.cos(theta);
            a[0][1] = 0.0;
            a[0][2] = Math.sin(theta);
            a[1][0] = 0.0;
            a[1][1] = 1.0;
            a[1][2] = 0.0;
            a[2][0] = -Math.sin(theta);
            a[2][1] = 0.0;
            a[2][2] = Math.cos(theta);
        } else if (axis.equals("+z")) {
            a[0][0] = Math.cos(theta);
            a[0][1] = Math.sin(theta);
            a[0][2] = 0.0;
            a[1][0] = -Math.sin(theta);
            a[1][1] = Math.cos(theta);
            a[1][2] = 0.0;
            a[2][0] = 0.0;
            a[2][1] = 0.0;
            a[2][2] = 1.0;
        } else if (axis.equals("-z")) {
            a[0][0] = Math.cos(theta);
            a[0][1] = -Math.sin(theta);
            a[0][2] = 0.0;
            a[1][0] = Math.sin(theta);
            a[1][1] = Math.cos(theta);
            a[1][2] = 0.0;
            a[2][0] = 0.0;
            a[2][1] = 0.0;
            a[2][2] = 1.0;
        }
        return new Matrix(a, 3, 3);
    }

    public Matrix eulerMat(double alpha, double beta, double gamma) {
        double[][] mat = new double[3][3];
        mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
        mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
        mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
        mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
        mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
        mat[1][2] = Math.sin(gamma) * Math.sin(beta);
        mat[2][0] = Math.sin(beta) * Math.cos(alpha);
        mat[2][1] = Math.sin(alpha) * Math.sin(beta);
        mat[2][2] = Math.cos(beta);
        return new Matrix(mat);
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return C;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.A[i][j];
    }

    public void set(int i, int j, double s) {
        this.A[i][j] = s;
    }

    public Matrix transpose() {
        Matrix X = new Matrix(this.n, this.m);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[j][i] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix uminus() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = -this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix plus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] + B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix minus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix times(double s) {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = s * this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix times(Matrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix X = new Matrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        int j = 0;
        while (j < B.n) {
            int k = 0;
            while (k < this.n) {
                Bcolj[k] = B.A[k][j];
                ++k;
            }
            int i = 0;
            while (i < this.m) {
                double[] Arowi = this.A[i];
                double s = 0.0;
                int k2 = 0;
                while (k2 < this.n) {
                    s += Arowi[k2] * Bcolj[k2];
                    ++k2;
                }
                C[i][j] = s;
                ++i;
            }
            ++j;
        }
        return X;
    }

    public double[] times(double[] B) {
        int len = B.length;
        if (len != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        double[] vec = new double[this.m];
        int i = 0;
        while (i < this.m) {
            vec[i] = 0.0;
            ++i;
        }
        int j = 0;
        while (j < this.m) {
            int k = 0;
            while (k < this.n) {
                int n = j;
                vec[n] = vec[n] + this.A[j][k] * B[k];
                ++k;
            }
            ++j;
        }
        return vec;
    }

    public double norm1() {
        double f = 0.0;
        int j = 0;
        while (j < this.n) {
            double s = 0.0;
            int i = 0;
            while (i < this.m) {
                s += Math.abs(this.A[i][j]);
                ++i;
            }
            f = Math.max(f, s);
            ++j;
        }
        return f;
    }

    public double trace() {
        double t = 0.0;
        int i = 0;
        while (i < Math.min(this.m, this.n)) {
            t += this.A[i][i];
            ++i;
        }
        return t;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                String s = format.format(this.A[i][j]);
                int padding = Math.max(1, width - s.length());
                int k = 0;
                while (k < padding) {
                    output.print(' ');
                    ++k;
                }
                output.print(s);
                ++j;
            }
            output.println();
            ++i;
        }
        output.println();
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public static Matrix identity(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return A;
    }

    public static double det(double[][] a) {
        double det = a[0][0] * a[1][1] * a[2][2] + a[0][1] * a[1][2] * a[2][0] + a[0][2] * a[1][0] * a[2][1] - a[0][2] * a[1][1] * a[2][0] - a[0][0] * a[1][2] * a[2][1] - a[0][1] * a[1][0] * a[2][2];
        return det;
    }

    private void checkMatrixDimensions(Matrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

