/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Z;
import Jampack.Z1;
import Jampack.Zchol;
import Jampack.Zdiagmat;
import Jampack.Zhqrd;
import Jampack.Zludpp;

public class Zmat {
    protected int nrow;
    protected int ncol;
    protected int basex;
    protected double[][] re;
    protected double[][] im;
    protected boolean dirty;
    protected Zludpp LU;
    protected Zhqrd HQR;
    protected Zchol CHOL;
    public int bx;
    public int rx;
    public int nr;
    public int cx;
    public int nc;

    public Zmat(double[][] re, double[][] im) throws JampackException {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = re.length;
        this.ncol = re[0].length;
        if (this.nrow != im.length || this.ncol != im[0].length) {
            throw new JampackException("Inconsistent array dimensions");
        }
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                this.re[i][j] = re[i][j];
                this.im[i][j] = im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zmat(Z[][] A) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = A.length;
        this.ncol = A[0].length;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                this.re[i][j] = A[i][j].re;
                this.im[i][j] = A[i][j].im;
                ++j;
            }
            ++i;
        }
    }

    public Zmat(double[][] A) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = A.length;
        this.ncol = A[0].length;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                this.re[i][j] = A[i][j];
                this.im[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public Zmat(Zmat A) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = A.nrow;
        this.ncol = A.ncol;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                this.re[i][j] = A.re[i][j];
                this.im[i][j] = A.im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zmat(Z1 A) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = A.n;
        this.ncol = 1;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            this.re[i][0] = A.re[i];
            this.im[i][0] = A.im[i];
            ++i;
        }
    }

    public Zmat(Zdiagmat D) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = D.n;
        this.ncol = D.n;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            this.re[i][i] = D.re[i];
            this.im[i][i] = D.im[i];
            ++i;
        }
    }

    public Zmat(int nrow, int ncol) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.nrow = nrow;
        this.ncol = ncol;
        this.getProperties();
        this.re = new double[this.nr][this.nc];
        this.im = new double[this.nr][this.nc];
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                this.re[i][j] = 0.0;
                this.im[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void getProperties() {
        this.bx = this.basex;
        this.rx = this.bx + this.nrow - 1;
        this.cx = this.bx + this.ncol - 1;
        this.nr = this.nrow;
        this.nc = this.ncol;
    }

    public double[][] getRe() {
        double[][] A = new double[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                A[i][j] = this.re[i][j];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public double[][] getIm() {
        double[][] A = new double[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                A[i][j] = this.im[i][j];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public Z[][] getZ() {
        Z[][] A = new Z[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                A[i][j] = new Z(this.re[i][j], this.im[i][j]);
                ++j;
            }
            ++i;
        }
        return A;
    }

    public Z get(int ii, int jj) {
        return new Z(this.re[ii - this.basex][jj - this.basex], this.im[ii - this.basex][jj - this.basex]);
    }

    public Z get0(int i, int j) {
        return new Z(this.re[i][j], this.im[i][j]);
    }

    public void put(int ii, int jj, Z a) {
        this.dirty = true;
        this.re[ii - this.basex][jj - this.basex] = a.re;
        this.im[ii - this.basex][jj - this.basex] = a.im;
    }

    public void put0(int i, int j, Z a) {
        this.dirty = true;
        this.re[i][j] = a.re;
        this.im[i][j] = a.im;
    }

    public Zmat get(int ii1, int ii2, int jj1, int jj2) {
        int nrow = ii2 - ii1 + 1;
        int ncol = jj2 - jj1 + 1;
        Zmat A = new Zmat(nrow, ncol);
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                A.re[i][j] = this.re[i + ii1 - this.basex][j + jj1 - this.basex];
                A.im[i][j] = this.im[i + ii1 - this.basex][j + jj1 - this.basex];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void put(int ii1, int ii2, int jj1, int jj2, Zmat A) {
        this.dirty = true;
        int nrow = ii2 - ii1 + 1;
        int ncol = jj2 - jj1 + 1;
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                this.re[i + ii1 - this.basex][j + jj1 - this.basex] = A.re[i][j];
                this.im[i + ii1 - this.basex][j + jj1 - this.basex] = A.im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zmat get(int[] ii, int jj1, int jj2) {
        int nrow = ii.length;
        int ncol = jj2 - jj1 + 1;
        Zmat A = new Zmat(nrow, ncol);
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                A.re[i][j] = this.re[ii[i] - this.basex][j + jj1 - this.basex];
                A.im[i][j] = this.im[ii[i] - this.basex][j + jj1 - this.basex];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void put(int[] ii, int jj1, int jj2, Zmat A) {
        this.dirty = true;
        int nrow = ii.length;
        int ncol = jj2 - jj1 + 1;
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                this.re[ii[i] - this.basex][j + jj1 - this.basex] = A.re[i][j];
                this.im[ii[i] - this.basex][j + jj1 - this.basex] = A.im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zmat get(int ii1, int ii2, int[] jj) {
        int nrow = ii2 - ii1 + 1;
        int ncol = jj.length;
        Zmat A = new Zmat(nrow, ncol);
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                A.re[i][j] = this.re[i + ii1 - this.basex][jj[j] - this.basex];
                A.im[i][j] = this.im[i + ii1 - this.basex][jj[j] - this.basex];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void put(int ii1, int ii2, int[] jj, Zmat A) {
        this.dirty = true;
        int nrow = ii2 - ii1 + 1;
        int ncol = jj.length;
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                this.re[i + ii1 - this.basex][jj[j] - this.basex] = A.re[i][j];
                this.im[i + ii1 - this.basex][jj[j] - this.basex] = A.im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zmat get(int[] ii, int[] jj) {
        int nrow = ii.length;
        int ncol = jj.length;
        Zmat A = new Zmat(nrow, ncol);
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                A.re[i][j] = this.re[ii[i] - this.basex][jj[j] - this.basex];
                A.im[i][j] = this.im[ii[i] - this.basex][jj[j] - this.basex];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void put(int[] ii, int[] jj, Zmat A) {
        this.dirty = true;
        int nrow = ii.length;
        int ncol = jj.length;
        int i = 0;
        while (i < nrow) {
            int j = 0;
            while (j < ncol) {
                this.re[ii[i] - this.basex][jj[j] - this.basex] = A.re[i][j];
                this.im[ii[i] - this.basex][jj[j] - this.basex] = A.im[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Zludpp getLU() {
        this.clean();
        Zludpp temp = this.LU;
        this.LU = null;
        return temp;
    }

    public Zhqrd getHQR() {
        this.clean();
        Zhqrd temp = this.HQR;
        this.HQR = null;
        return temp;
    }

    public Zchol getCHOL() {
        this.clean();
        Zchol temp = this.CHOL;
        this.CHOL = null;
        return temp;
    }

    protected void clean() {
        if (this.dirty) {
            this.LU = null;
            this.HQR = null;
            this.CHOL = null;
            this.dirty = false;
        }
    }
}

