/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Zmat;
import Jampack.Zutmat;

public class Zchol {
    public int n;
    public Zutmat R;

    public Zchol(Zmat A) throws JampackException {
        int j;
        A.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Matrix not square.");
        }
        this.n = A.nr;
        this.R = new Zutmat(A);
        int i = 0;
        while (i < this.n) {
            if (this.R.im[i][i] != 0.0) {
                throw new JampackException("Matrix not Hermitian");
            }
            j = 0;
            while (j < i) {
                if (this.R.re[i][j] != this.R.re[j][i] || this.R.im[i][j] != -this.R.im[j][i]) {
                    throw new JampackException("Matrix not Hermitian");
                }
                this.R.im[i][j] = 0.0;
                this.R.re[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < this.n) {
            if (this.R.re[k][k] <= 0.0) {
                throw new JampackException("Nonpositive diagonal entry during reduction.");
            }
            this.R.re[k][k] = Math.sqrt(this.R.re[k][k]);
            double mu = 1.0 / this.R.re[k][k];
            j = k + 1;
            while (j < this.n) {
                this.R.re[k][j] = mu * this.R.re[k][j];
                this.R.im[k][j] = mu * this.R.im[k][j];
                ++j;
            }
            i = k + 1;
            while (i < this.n) {
                j = i;
                while (j < this.n) {
                    this.R.re[i][j] = this.R.re[i][j] - this.R.re[k][i] * this.R.re[k][j] - this.R.im[k][i] * this.R.im[k][j];
                    this.R.im[i][j] = this.R.im[i][j] - this.R.re[k][i] * this.R.im[k][j] + this.R.im[k][i] * this.R.re[k][j];
                    ++j;
                }
                this.R.im[i][i] = 0.0;
                ++i;
            }
            ++k;
        }
    }
}

