/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.Cartesian;
import rdcPanda.Dipolar;
import rdcPanda.H1CS;
import rdcPanda.Hdist;
import rdcPanda.Hsqc;
import rdcPanda.Loops;
import rdcPanda.Matrix;
import rdcPanda.Model;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;
import rdcPanda.RotaPattern;
import rdcPanda.ppGlobal;

public class Goal {
    public Vector<Assign> vecSeq = new Vector();
    public Vector<Pdb> vecPdbSSE = new Vector();
    public String rotSrc = "";
    public Vector<Assign> vecAsg = new Vector();
    public Vector<Noesy> vecNOESY = new Vector();
    public double caliConstant = 0.0;
    public Vector<Noe> vecAmbNOEs = new Vector();
    public double Syy = 0.0;
    public double Szz = 0.0;
    public boolean isForward = false;
    public boolean isAllGridSearch = false;
    public double gapThreshold = 0.0;
    public double rdcThreshold = 0.0;
    public Vector<Dipolar> vecNhRDC = new Vector();
    public Vector<Dipolar> vecChRDC = new Vector();
    public Vector vecRamaAla = new Vector();
    public Vector vecRamaGeneral = new Vector();
    public Vector vecRamaPrePro = new Vector();
    public Vector vecRamaPro = new Vector();
    public Vector vecRamaGly = new Vector();
    public int maxLeafNodes = 0;

    public Vector<Pdb> SearchSSEAnchors(int topK, int resNoLoop) {
        Assign asgMaxNo = this.vecSeq.elementAt(this.vecSeq.size() - 1);
        int maxResNo = asgMaxNo.getResidueNo();
        int[] numNOEs = new int[maxResNo + 1];
        int i = 0;
        while (i < numNOEs.length) {
            numNOEs[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.vecAmbNOEs.size()) {
            Noe noe = this.vecAmbNOEs.elementAt(i);
            int resNoA = noe.getResidueNoA();
            int resNoB = noe.getResidueNoB();
            if (resNoA == resNoLoop) {
                int n = resNoB;
                numNOEs[n] = numNOEs[n] + 1;
            }
            if (resNoB == resNoLoop) {
                int n = resNoA;
                numNOEs[n] = numNOEs[n] + 1;
            }
            ++i;
        }
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        int i2 = 0;
        while (i2 < this.vecPdbSSE.size()) {
            Pdb pp = this.vecPdbSSE.elementAt(i2);
            int resNo = pp.getResidueNo();
            vecRotTemp.add(new RotaPattern(pp, (double)numNOEs[resNo]));
            ++i2;
        }
        Collections.sort(vecRotTemp, new RotaPattern.scoreComparator());
        Vector<Pdb> vecSSEsAnchors = new Vector<Pdb>();
        int i3 = 0;
        while (i3 < Math.min(topK, vecRotTemp.size())) {
            RotaPattern rotPatn = (RotaPattern)vecRotTemp.elementAt(i3);
            vecSSEsAnchors.add(rotPatn.getPdb());
            ++i3;
        }
        return vecSSEsAnchors;
    }

    public Vector<Pdb> SearchSSEAnchorsTop(int topK, int resNoLoop) {
        Pdb pp;
        Assign asgMaxNo = this.vecSeq.elementAt(this.vecSeq.size() - 1);
        int maxResNo = asgMaxNo.getResidueNo();
        int[] numNOEs = new int[maxResNo + 1];
        int i = 0;
        while (i < numNOEs.length) {
            numNOEs[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.vecAmbNOEs.size()) {
            Noe noe = this.vecAmbNOEs.elementAt(i);
            int resNoA = noe.getResidueNoA();
            int resNoB = noe.getResidueNoB();
            if (resNoA == resNoLoop) {
                int n = resNoB;
                numNOEs[n] = numNOEs[n] + 1;
            }
            if (resNoB == resNoLoop) {
                int n = resNoA;
                numNOEs[n] = numNOEs[n] + 1;
            }
            ++i;
        }
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        int j = 0;
        while (j < numNOEs.length) {
            boolean isInSSE = false;
            int i2 = 0;
            while (i2 < this.vecPdbSSE.size()) {
                pp = this.vecPdbSSE.elementAt(i2);
                int resNo = pp.getResidueNo();
                if (resNo == j) {
                    isInSSE = true;
                    vecRotTemp.add(new RotaPattern(pp, (double)numNOEs[resNo]));
                    break;
                }
                ++i2;
            }
            Pdb ppTemp = new Pdb();
            if (!isInSSE) {
                vecRotTemp.add(new RotaPattern(ppTemp, (double)numNOEs[j]));
            }
            ++j;
        }
        Collections.sort(vecRotTemp, new RotaPattern.scoreComparator());
        Vector<Pdb> vecSSEsAnchors = new Vector<Pdb>();
        int i3 = 0;
        while (i3 < Math.min(topK, vecRotTemp.size())) {
            RotaPattern rotPatn = (RotaPattern)vecRotTemp.elementAt(i3);
            pp = rotPatn.getPdb();
            if (this.vecPdbSSE.contains(pp)) {
                vecSSEsAnchors.add(rotPatn.getPdb());
            }
            ++i3;
        }
        return vecSSEsAnchors;
    }

    public double TranRotGridSearchNew(double[] caSSE, double[] tranX0, double[] tranXn, double[] tranResol, double[] translation, int noStart, int noEnd, int noCur, Vector<RotaPattern> vecCandPos) {
        Pdb pp = new Pdb();
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double lengthRS = 0.0;
        int maxNoes = -9999;
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        int m = 0;
        while ((double)m < Math.abs(tranXn[0] - tranX0[0]) / tranResol[0]) {
            double ranTheta = (tranX0[0] + (double)m * tranResol[0]) * Math.PI / 180.0;
            int j = 0;
            while ((double)j < Math.abs(tranXn[1] - tranX0[1]) / tranResol[1]) {
                double ranPhi = (tranX0[1] + (double)j * tranResol[1]) * Math.PI / 180.0;
                int k = 0;
                while ((double)k < Math.abs(tranXn[2] - tranX0[2]) / tranResol[2]) {
                    boolean isKinConstraint;
                    double lengthR = tranX0[2] + (double)k * tranResol[2];
                    double[] caNewTemp = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                    double[] trans_vec = new double[3];
                    trans_vec = pp.internuclearVec(centerO, caSSE);
                    double[] caNew = new double[]{caNewTemp[0] + trans_vec[0], caNewTemp[1] + trans_vec[1], caNewTemp[2] + trans_vec[2]};
                    boolean isClash = this.CheckClashBtwRotCaNSSEs(caNew);
                    if (!isClash && (isKinConstraint = this.CheckKinConstraint(caNew, noStart, noEnd, noCur))) {
                        int numNoes = this.ComputeNoeSatisfaction(caNew, noCur);
                        if (maxNoes < numNoes) {
                            maxNoes = numNoes;
                            ranThetaS = ranTheta;
                            ranPhiS = ranPhi;
                            lengthRS = lengthR;
                        }
                        vecCandPos.add(new RotaPattern(caNew, (double)numNoes));
                    }
                    ++k;
                }
                ++j;
            }
            ++m;
        }
        translation[0] = ranThetaS * 180.0 / Math.PI;
        translation[1] = ranPhiS * 180.0 / Math.PI;
        translation[2] = lengthRS;
        return maxNoes;
    }

    public double TranRotGridSearch(double[] tranX0, double[] tranXn, double[] rotX0, double[] rotXn, Vector<Pdb> vecRotPdb, double tranResol, double rotResol, boolean isCheckClash, double[] translation, double[] rotation) {
        Pdb pp = new Pdb();
        double scoreS = -99999.9;
        double[] XSave = new double[]{0.0, 0.0, 0.0};
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        Pdb pdbRot = vecRotPdb.elementAt(0);
        Vector<Cartesian> vecAtomRot = pdbRot.getAtomVec();
        double[] ca_rot = new double[3];
        int j = 0;
        while (j < vecAtomRot.size()) {
            Cartesian cc = vecAtomRot.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                ca_rot = cc.getXYZ();
            }
            ++j;
        }
        int i = 0;
        while ((double)i < Math.abs(tranXn[0] - tranX0[0]) / tranResol) {
            double x = tranX0[0] + (double)i * tranResol;
            int j2 = 0;
            while ((double)j2 < Math.abs(tranXn[1] - tranX0[1]) / tranResol) {
                double y = tranX0[1] + (double)j2 * tranResol;
                int k = 0;
                while ((double)k < Math.abs(tranXn[2] - tranX0[2]) / tranResol) {
                    double z = tranX0[2] + (double)k * tranResol;
                    double alpha = 0.0;
                    double beta = 0.0;
                    double gamma = 0.0;
                    double[][] mat = new double[3][3];
                    Matrix A = new Matrix(3, 3);
                    int Ri = 0;
                    while ((double)Ri < Math.abs(rotXn[0] - rotX0[0]) / rotResol) {
                        alpha = (rotX0[0] + (double)Ri * rotResol) * Math.PI / 180.0;
                        int Rj = 0;
                        while ((double)Rj < Math.abs(rotXn[1] - rotX0[1]) / rotResol) {
                            beta = (rotX0[1] + (double)Rj * rotResol) * Math.PI / 180.0;
                            int Rk = 0;
                            while ((double)Rk < Math.abs(rotXn[2] - rotX0[2]) / rotResol) {
                                double distBound;
                                gamma = (rotX0[2] + (double)Rk * rotResol) * Math.PI / 180.0;
                                mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                                mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                                mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                                mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                                mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                                mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                                mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                                mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                                mat[2][2] = Math.cos(beta);
                                A = new Matrix(mat);
                                Vector<Pdb> vecRotNew = pp.newPdb(vecRotPdb, A);
                                double[] caRotNew = new double[]{x, y, z};
                                double[] trans_vec = new double[3];
                                double errH = 0.03;
                                double errHeavy = 0.2;
                                trans_vec = pp.internuclearVec(ca_rot, caRotNew);
                                Vector<Pdb> vecRotTranNew = pp.newPdbByTranslation(vecRotNew, trans_vec);
                                double score = this.CompNoePatternScoreBetwSSEAndLoop(errH, errHeavy, this.vecPdbSSE, vecRotTranNew, distBound = 6.0, this.vecAsg, this.vecNOESY);
                                if (!(score < -100.0) && score > scoreS) {
                                    scoreS = score;
                                    XSave[0] = x;
                                    XSave[1] = y;
                                    XSave[2] = z;
                                    alphaS = alpha;
                                    betaS = beta;
                                    gammaS = gamma;
                                }
                                ++Rk;
                            }
                            ++Rj;
                        }
                        ++Ri;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        translation[0] = XSave[0];
        translation[1] = XSave[1];
        translation[2] = XSave[2];
        rotation[0] = alphaS * 180.0 / Math.PI;
        rotation[1] = betaS * 180.0 / Math.PI;
        rotation[2] = gammaS * 180.0 / Math.PI;
        return scoreS;
    }

    public double CompNoePatternScoreBetwSSEAndLoop(double errH, double errHeavy, Vector<Pdb> vecSSEPdb, Vector<Pdb> vecPdbLoop, double distBound, Vector asgVec, Vector vecNOESY) {
        double[] coordLoop = new double[]{0.0, 0.0, 0.0};
        double[] coordSSE = new double[]{0.0, 0.0, 0.0};
        Peak pk = new Peak();
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        int clashThreshold = 6;
        int numClash = 0;
        int i = 0;
        while (i < vecPdbLoop.size()) {
            Pdb pdbLoop = vecPdbLoop.elementAt(i);
            String resLoop = pdbLoop.getResidue();
            Vector<Cartesian> vecAtomLoop = pdbLoop.getAtomVec();
            int resNoLoop = pdbLoop.getResidueNo();
            int j = 0;
            while (j < vecAtomLoop.size()) {
                String heavyAtom;
                Cartesian ccLoop = vecAtomLoop.elementAt(j);
                coordLoop = ccLoop.getXYZ();
                String atomLoop = ccLoop.getAtom();
                if (atomLoop.substring(0, 1).equalsIgnoreCase("H") && ((heavyAtom = pk.GetHeavyAtomFromProton(resLoop, atomLoop)).substring(0, 1).equalsIgnoreCase("C") || heavyAtom.substring(0, 1).equalsIgnoreCase("N"))) {
                    int k = 0;
                    while (k < vecSSEPdb.size()) {
                        Pdb pdbSSE = vecSSEPdb.elementAt(k);
                        String resSSE = pdbSSE.getResidue();
                        Vector<Cartesian> vecAtomSSE = pdbSSE.getAtomVec();
                        int resNoSSE = pdbSSE.getResidueNo();
                        int h = 0;
                        while (h < vecAtomSSE.size()) {
                            String heavyAtomSSE;
                            Cartesian ccSSE = vecAtomSSE.elementAt(h);
                            coordSSE = ccSSE.getXYZ();
                            String atomSSE = ccSSE.getAtom();
                            if (atomSSE.substring(0, 1).equalsIgnoreCase("H") && ((heavyAtomSSE = pk.GetHeavyAtomFromProton(resSSE, atomSSE)).substring(0, 1).equalsIgnoreCase("C") || heavyAtomSSE.substring(0, 1).equalsIgnoreCase("N"))) {
                                double distance = Math.sqrt((coordLoop[0] - coordSSE[0]) * (coordLoop[0] - coordSSE[0]) + (coordLoop[1] - coordSSE[1]) * (coordLoop[1] - coordSSE[1]) + (coordLoop[2] - coordSSE[2]) * (coordLoop[2] - coordSSE[2]));
                                if (distance < 1.8) {
                                    ++numClash;
                                }
                                if (numClash > clashThreshold) {
                                    return -99999.9;
                                }
                                if (distance < distBound) {
                                    vecHdist.add(new Hdist(ccLoop, resNoLoop, resLoop, atomLoop, ccSSE, resNoSSE, resSSE, atomSSE, distance));
                                    vecHdist.add(new Hdist(ccSSE, resNoSSE, resSSE, atomSSE, ccLoop, resNoLoop, resLoop, atomLoop, distance));
                                }
                            }
                            ++h;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        RotaPattern rotPattern = new RotaPattern();
        BackNoe bn = new BackNoe();
        int i2 = 0;
        while (i2 < vecHdist.size()) {
            Hdist hdist = (Hdist)vecHdist.elementAt(i2);
            BackNoe backNoe = rotPattern.BackCompNOEPeak(asgVec, hdist);
            vecBackNoe.add(backNoe);
            ++i2;
        }
        Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
        Assign asg = new Assign();
        int[] numPeaks = new int[1];
        double dbScore = -999.9;
        if (vecBackNoeNoRepeat.size() > 0) {
            dbScore = asg.NoePatternMatchScoreWCali(errH, errHeavy, errHeavy, vecBackNoeNoRepeat, vecNOESY, numPeaks, false, this.caliConstant);
        }
        return dbScore;
    }

    public boolean CheckStericClashBtwTwoFragments(Vector vecPdbA, Vector vecPdbB) {
        double threshold = 0.8;
        double bound = 1.8;
        int i = 0;
        while (i < vecPdbA.size()) {
            Pdb pdbA = (Pdb)vecPdbA.elementAt(i);
            int resNoA = pdbA.getResidueNo();
            Vector<Cartesian> vecAtomA = pdbA.getAtomVec();
            int j = 0;
            while (j < vecAtomA.size()) {
                Cartesian ccA = vecAtomA.elementAt(j);
                String atomA = ccA.getAtom().substring(0, 1);
                boolean isPossibleHbond = false;
                boolean isBonded = false;
                double[] coordA = new double[3];
                coordA = ccA.getXYZ();
                int k = 0;
                while (k < vecPdbB.size()) {
                    Pdb pdbB = (Pdb)vecPdbB.elementAt(k);
                    Vector<Cartesian> vecAtomB = pdbB.getAtomVec();
                    int resNoB = pdbB.getResidueNo();
                    int t = 0;
                    while (t < vecAtomB.size()) {
                        Cartesian ccB = vecAtomB.elementAt(t);
                        String atomB = ccB.getAtom().substring(0, 1);
                        if (atomA.equalsIgnoreCase("H") && atomB.equalsIgnoreCase("O")) {
                            isPossibleHbond = true;
                        }
                        if (atomB.equalsIgnoreCase("H") && atomA.equalsIgnoreCase("O")) {
                            isPossibleHbond = true;
                        }
                        if (resNoA + 1 == resNoB && (atomA.equalsIgnoreCase("C") || atomA.equalsIgnoreCase("CO")) && atomB.equalsIgnoreCase("N")) {
                            isBonded = true;
                        }
                        if (resNoB + 1 == resNoA && (atomB.equalsIgnoreCase("C") || atomB.equalsIgnoreCase("CO")) && atomA.equalsIgnoreCase("N")) {
                            isBonded = true;
                        }
                        double[] coordB = new double[3];
                        coordB = ccB.getXYZ();
                        double distance = Math.sqrt((coordB[0] - coordA[0]) * (coordB[0] - coordA[0]) + (coordB[1] - coordA[1]) * (coordB[1] - coordA[1]) + (coordB[2] - coordA[2]) * (coordB[2] - coordA[2]));
                        if (distance < bound * threshold && !isPossibleHbond && !isBonded) {
                            return true;
                        }
                        ++t;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean CheckKinConstraint(double[] caPos, int noStart, int noEnd, int noCur) {
        boolean isStartSatisfied = false;
        boolean isEndSatisfied = false;
        double bondLength = 3.8;
        double resolutionError = 0.0;
        int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (ind < 0) {
            System.out.println("the first endpoint residue number not found...exist.");
            System.exit(0);
        }
        Pdb pdbStart = this.vecPdbSSE.elementAt(ind);
        Vector<Cartesian> vecAtomStart = pdbStart.getAtomVec();
        double[] caStart = new double[3];
        int i = 0;
        while (i < vecAtomStart.size()) {
            Cartesian cc = vecAtomStart.elementAt(i);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caStart = cc.getXYZ();
            }
            ++i;
        }
        double distance = Math.sqrt((caStart[0] - caPos[0]) * (caStart[0] - caPos[0]) + (caStart[1] - caPos[1]) * (caStart[1] - caPos[1]) + (caStart[2] - caPos[2]) * (caStart[2] - caPos[2]));
        if (distance < (double)Math.abs(noCur - noStart) * bondLength + resolutionError) {
            isStartSatisfied = true;
        }
        if ((ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator())) < 0) {
            System.out.println("the last endpoint residue number not found...exist.");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(ind);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        double[] caEnd = new double[3];
        int i2 = 0;
        while (i2 < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(i2);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            ++i2;
        }
        distance = Math.sqrt((caEnd[0] - caPos[0]) * (caEnd[0] - caPos[0]) + (caEnd[1] - caPos[1]) * (caEnd[1] - caPos[1]) + (caEnd[2] - caPos[2]) * (caEnd[2] - caPos[2]));
        if (distance < (double)Math.abs(noEnd - noCur) * bondLength + resolutionError) {
            isEndSatisfied = true;
        }
        return isStartSatisfied && isEndSatisfied;
    }

    public double CaDistCorrection(String res, String atom) {
        Pdb pp = new Pdb();
        String rotamFile = String.valueOf(this.rotSrc) + res.toLowerCase() + ".pdb";
        Vector<Object> pdbRotam = new Vector();
        pdbRotam = pp.readRotamerPdb(rotamFile);
        if (atom.length() >= 2) {
            if (atom.substring(atom.length() - 1, atom.length()).equalsIgnoreCase("#")) {
                atom = atom.substring(0, atom.length() - 1);
            }
            if (atom.substring(atom.length() - 2, atom.length()).equalsIgnoreCase("##")) {
                atom = atom.substring(0, atom.length() - 2);
            }
        }
        if (atom.equalsIgnoreCase("H")) {
            atom = "HN";
        }
        double[] ca = new double[3];
        int i = 0;
        while (i < pdbRotam.size()) {
            Pdb pdbRot = (Pdb)pdbRotam.elementAt(i);
            Vector<Cartesian> atomVec = pdbRot.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                Cartesian cc = atomVec.elementAt(j);
                String atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("CA")) {
                    ca = cc.getXYZ();
                }
                ++j;
            }
            ++i;
        }
        double distCor = -9999.9;
        double[] sc = new double[3];
        int i2 = 0;
        while (i2 < pdbRotam.size()) {
            Pdb pdbRot = (Pdb)pdbRotam.elementAt(i2);
            Vector<Cartesian> atomVec = pdbRot.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                double distance;
                Cartesian cc = atomVec.elementAt(j);
                String atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("H")) {
                    atomName = "HN";
                }
                sc = cc.getXYZ();
                if (atomName.length() >= atom.length() && atomName.substring(0, atom.length()).equalsIgnoreCase(atom) && (distance = Math.sqrt((sc[0] - ca[0]) * (sc[0] - ca[0]) + (sc[1] - ca[1]) * (sc[1] - ca[1]) + (sc[2] - ca[2]) * (sc[2] - ca[2]))) > distCor) {
                    distCor = distance;
                }
                ++j;
            }
            ++i2;
        }
        if (distCor < -10.0) {
            System.out.println("Debugging...here we have a bug...");
        }
        return distCor;
    }

    public int ComputeNoeSatisfaction(double[] caPos, int noCur) {
        int counter = 0;
        int i = 0;
        while (i < this.vecAmbNOEs.size()) {
            double distance;
            double[] coord;
            String atomName;
            Cartesian cc;
            int j;
            Vector<Cartesian> vecAtomSSE;
            Pdb pdbSSE;
            int ind;
            double distCor;
            Noe noe = this.vecAmbNOEs.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            String secondAtomName = noe.getAtomB();
            boolean isSatisfied = false;
            if (firstResName.length() >= 2) {
                if (firstResName.substring(firstResName.length() - 1, firstResName.length()).equalsIgnoreCase("#")) {
                    firstResName = firstResName.substring(0, firstResName.length() - 1);
                }
                if (firstResName.substring(firstResName.length() - 2, firstResName.length()).equalsIgnoreCase("##")) {
                    firstResName = firstResName.substring(0, firstResName.length() - 2);
                }
            }
            if (secondAtomName.length() >= 2) {
                if (secondAtomName.substring(secondAtomName.length() - 2, secondAtomName.length()).equalsIgnoreCase("##")) {
                    secondAtomName = secondAtomName.substring(0, secondAtomName.length() - 2);
                } else if (secondAtomName.substring(secondAtomName.length() - 1, secondAtomName.length()).equalsIgnoreCase("#")) {
                    secondAtomName = secondAtomName.substring(0, secondAtomName.length() - 1);
                }
            }
            if (firstResName.equalsIgnoreCase("H")) {
                firstResName = "HN";
            }
            if (secondAtomName.equalsIgnoreCase("H")) {
                secondAtomName = "HN";
            }
            double dist_from_inten = noe.getUpper();
            double noeUpperPrune = 0.0;
            if (firstResNo == noCur) {
                distCor = this.CaDistCorrection(firstResName, firstAtomName);
                ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(secondResNo), new Pdb.PdbComparator());
                if (ind >= 0) {
                    pdbSSE = this.vecPdbSSE.elementAt(ind);
                    vecAtomSSE = pdbSSE.getAtomVec();
                    j = 0;
                    while (j < vecAtomSSE.size()) {
                        cc = vecAtomSSE.elementAt(j);
                        atomName = cc.getAtom();
                        if (atomName.equalsIgnoreCase("H")) {
                            atomName = "HN";
                        }
                        coord = new double[3];
                        coord = cc.getXYZ();
                        if (atomName.length() >= secondAtomName.length() && atomName.substring(0, secondAtomName.length()).equalsIgnoreCase(secondAtomName) && (distance = Math.sqrt((coord[0] - caPos[0]) * (coord[0] - caPos[0]) + (coord[1] - caPos[1]) * (coord[1] - caPos[1]) + (coord[2] - caPos[2]) * (coord[2] - caPos[2]))) < dist_from_inten + distCor) {
                            isSatisfied = true;
                        }
                        ++j;
                    }
                }
            } else if (secondResNo == noCur) {
                distCor = this.CaDistCorrection(secondResName, secondAtomName);
                ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(firstResNo), new Pdb.PdbComparator());
                if (ind >= 0) {
                    pdbSSE = this.vecPdbSSE.elementAt(ind);
                    vecAtomSSE = pdbSSE.getAtomVec();
                    j = 0;
                    while (j < vecAtomSSE.size()) {
                        cc = vecAtomSSE.elementAt(j);
                        atomName = cc.getAtom();
                        coord = new double[3];
                        coord = cc.getXYZ();
                        if (atomName.length() >= firstAtomName.length() && atomName.substring(0, firstAtomName.length()).equalsIgnoreCase(firstAtomName) && (distance = Math.sqrt((coord[0] - caPos[0]) * (coord[0] - caPos[0]) + (coord[1] - caPos[1]) * (coord[1] - caPos[1]) + (coord[2] - caPos[2]) * (coord[2] - caPos[2]))) < dist_from_inten + distCor) {
                            isSatisfied = true;
                        }
                        ++j;
                    }
                }
            } else if (isSatisfied) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public boolean CheckNOEBtwCaNSSEs(Pdb curPdb, Vector vecSSEAnchors, double distUpCa) {
        double[] coordCA_cur = new double[3];
        boolean isSatisfied = false;
        Vector<Cartesian> atomVecCur = curPdb.getAtomVec();
        int t = 0;
        while (t < atomVecCur.size()) {
            Cartesian cc = atomVecCur.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                coordCA_cur = cc.getXYZ();
            }
            ++t;
        }
        int k = 0;
        while (k < vecSSEAnchors.size()) {
            Pdb ppSSE = (Pdb)vecSSEAnchors.elementAt(k);
            Vector<Cartesian> vecAtomSSE = ppSSE.getAtomVec();
            double[] caSSE = new double[3];
            int t2 = 0;
            while (t2 < vecAtomSSE.size()) {
                Cartesian cc = vecAtomSSE.elementAt(t2);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caSSE = cc.getXYZ();
                }
                ++t2;
            }
            double distance = Math.sqrt((caSSE[0] - coordCA_cur[0]) * (caSSE[0] - coordCA_cur[0]) + (caSSE[1] - coordCA_cur[1]) * (caSSE[1] - coordCA_cur[1]) + (caSSE[2] - coordCA_cur[2]) * (caSSE[2] - coordCA_cur[2]));
            if (distance < distUpCa) {
                isSatisfied = true;
                return isSatisfied;
            }
            ++k;
        }
        return isSatisfied;
    }

    public boolean CheckClashBtwRotCaNSSEs(double[] caPos) {
        double threshold = 0.95;
        double bound = 2.03;
        Vector<Pdb> vecPdbB = new Vector<Pdb>();
        vecPdbB.addAll(this.vecPdbSSE);
        int k = 0;
        while (k < vecPdbB.size()) {
            Pdb pdbB = (Pdb)vecPdbB.elementAt(k);
            Vector<Cartesian> vecAtomB = pdbB.getAtomVec();
            int resNoB = pdbB.getResidueNo();
            int t = 0;
            while (t < vecAtomB.size()) {
                Cartesian ccB = vecAtomB.elementAt(t);
                String atom = ccB.getAtom();
                if (atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("O") || atom.equalsIgnoreCase("CB")) {
                    double[] coordB = new double[3];
                    coordB = ccB.getXYZ();
                    double distance = Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) + (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) + (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
                    if (distance < bound * threshold) {
                        return true;
                    }
                }
                ++t;
            }
            ++k;
        }
        return false;
    }

    public boolean CheckClashBtwRotCaNSSEsNew(double[] caPos, int numClashThreshold) {
        double threshold = 0.9;
        double bound = 2.03;
        Vector<Pdb> vecPdbB = new Vector<Pdb>();
        vecPdbB.addAll(this.vecPdbSSE);
        int counter = 0;
        int k = 0;
        while (k < vecPdbB.size()) {
            Pdb pdbB = (Pdb)vecPdbB.elementAt(k);
            Vector<Cartesian> vecAtomB = pdbB.getAtomVec();
            int resNoB = pdbB.getResidueNo();
            int t = 0;
            while (t < vecAtomB.size()) {
                Cartesian ccB = vecAtomB.elementAt(t);
                double[] coordB = new double[3];
                coordB = ccB.getXYZ();
                String atom = ccB.getAtom();
                if (atom.substring(0, 1).equalsIgnoreCase("C") || atom.substring(0, 1).equalsIgnoreCase("N")) {
                    bound = 2.45;
                } else if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                    bound = 2.03;
                }
                double distance = Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) + (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) + (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
                if (distance < bound * threshold) {
                    ++counter;
                }
                if (counter >= numClashThreshold) {
                    return true;
                }
                ++t;
            }
            ++k;
        }
        return false;
    }

    public boolean CheckClashBtwRotCaNSSEsNew(Vector vecPdbB, double[] caPos, int numClashThreshold) {
        double threshold = 0.9;
        double bound = 2.03;
        int counter = 0;
        int k = 0;
        while (k < vecPdbB.size()) {
            Pdb pdbB = (Pdb)vecPdbB.elementAt(k);
            Vector<Cartesian> vecAtomB = pdbB.getAtomVec();
            int resNoB = pdbB.getResidueNo();
            int t = 0;
            while (t < vecAtomB.size()) {
                Cartesian ccB = vecAtomB.elementAt(t);
                double[] coordB = new double[3];
                coordB = ccB.getXYZ();
                String atom = ccB.getAtom();
                if (atom.substring(0, 1).equalsIgnoreCase("C") || atom.substring(0, 1).equalsIgnoreCase("N")) {
                    bound = 2.45;
                } else if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                    bound = 2.03;
                }
                double distance = Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) + (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) + (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
                if (distance < bound * threshold) {
                    ++counter;
                }
                if (counter >= numClashThreshold) {
                    return true;
                }
                ++t;
            }
            ++k;
        }
        return false;
    }

    public boolean CheckClashBtwCaNPdb(Vector vecPdb, int curNo, double[] caPos, int numClashThreshold) {
        double threshold = 1.15;
        double bound = 2.03;
        Vector vecPdbB = new Vector();
        vecPdbB.addAll(vecPdb);
        int counter = 0;
        int k = 0;
        while (k < vecPdbB.size()) {
            Pdb pdbB = (Pdb)vecPdbB.elementAt(k);
            int resNoTemp = pdbB.getResidueNo();
            if (Math.abs(curNo - resNoTemp) > 1) {
                Vector<Cartesian> vecAtomB = pdbB.getAtomVec();
                int resNoB = pdbB.getResidueNo();
                int t = 0;
                while (t < vecAtomB.size()) {
                    Cartesian ccB = vecAtomB.elementAt(t);
                    double[] coordB = new double[3];
                    coordB = ccB.getXYZ();
                    double distance = Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) + (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) + (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
                    if (distance < bound * threshold) {
                        ++counter;
                    }
                    if (counter >= numClashThreshold) {
                        return true;
                    }
                    ++t;
                }
            }
            ++k;
        }
        return false;
    }

    public void KinNeighborSearch(Pdb PrePdb, int curResNo, int noStart, int noEnd) {
        double resolDih = 45.0;
        int nTotalRes = Math.abs(noEnd - noStart) + 1;
        double[] phiS = new double[nTotalRes];
        double[] psiS = new double[nTotalRes];
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (ind < 0) {
            System.out.println("the first endpoint residue number not found...exist.");
            System.exit(0);
        }
        Vector<Cartesian> atomVecCur = PrePdb.getAtomVec();
        int k = 0;
        while (k < atomVecCur.size()) {
            Cartesian cc = atomVecCur.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        Vector<Pdb> vecPrePdb = new Vector<Pdb>();
        vecPrePdb.add(PrePdb);
        Vector<PhiPsi> vecPhiPsi = new Vector<PhiPsi>();
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPrePdb);
        int i = 0;
        while (i < vecPhiPsiTemp.size()) {
            PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(i);
            phiS[i] = phipsi.getPhi();
            psiS[i] = phipsi.getPsi();
            if (phipsi.getResidueNo() != curResNo) {
                vecPhiPsi.add(phipsi);
            }
            ++i;
        }
        int k2 = 0;
        while ((double)k2 < 360.0 / resolDih) {
            double phiValue = (double)k2 * resolDih * Math.PI / 180.0;
            System.out.println("k=" + k2 + " phiValue=" + phiValue);
            int j = 0;
            while ((double)j < 360.0 / resolDih) {
                double psiValue = (double)j * resolDih * Math.PI / 180.0;
                System.out.println("j=" + j + " psiPreValue=" + psiValue);
                phiS[curResNo - noStart] = phiValue;
                psiS[curResNo - noStart] = psiValue;
                Vector pdbFragTemp0 = new Vector();
                pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, noStart, false);
                Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                ind = Collections.binarySearch(pdbFragTemp, new Pdb(curResNo), new Pdb.PdbComparator());
                Pdb curPdb = pdbFragTemp.elementAt(ind);
                Vector<Pdb> vecCurPdb = new Vector<Pdb>();
                vecCurPdb.add(curPdb);
                boolean isClash = this.CheckStericClashBtwTwoFragments(vecCurPdb, this.vecPdbSSE);
                if (isClash) {
                    // empty if block
                }
                ++j;
            }
            ++k2;
        }
    }

    public void RotamerReplacementKin(int noStart, int noEnd) {
        double resolDih = 30.0;
        int i = noStart + 1;
        while (i < noEnd) {
            int curResNo = i;
            int k = 0;
            while ((double)k < 360.0 / resolDih) {
                double phiValue = (double)k * resolDih * Math.PI / 180.0;
                System.out.println("k=" + k + " phiValue=" + phiValue);
                int j = 0;
                while ((double)j < 360.0 / resolDih) {
                    double psiValue = (double)j * resolDih * Math.PI / 180.0;
                    System.out.println("j=" + j + " psiPreValue=" + psiValue);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public Vector LoopLocalGapClosure(Vector vecLoopOldPdb, int noStart, int noEnd) {
        Random generator = new Random(22L);
        int curResNo = noStart;
        double resolution = 5.0;
        int topSSEK = 6;
        double distBtwCa = 8.0;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        Vector<Pdb> vecLoopTemp = new Vector<Pdb>();
        vecLoopTemp.addAll(vecLoopOldPdb);
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart - 1), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: starting residue not found...exist...");
            System.exit(0);
        }
        Pdb prePdbTemp = this.vecPdbSSE.elementAt(index);
        double Sxx = -this.Syy - this.Szz;
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        double[] NhRdcCal = new double[1];
        double[] ChRdcCal = new double[1];
        double[][] mat = new double[3][3];
        Matrix A = new Matrix(3, 3);
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                mat[x][y] = x == y ? 1.0 : 0.0;
                ++y;
            }
            ++x;
        }
        A = new Matrix(mat);
        double rdcRmsdBound = 3.0;
        double[] coordN_start = new double[3];
        double[] coordNH_start = new double[3];
        double[] coordCA_start = new double[3];
        int indStart = Collections.binarySearch(vecLoopTemp, new Pdb(curResNo), new Pdb.PdbComparator());
        if (indStart < 0) {
            System.out.println("error: starting residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbStart = (Pdb)vecLoopTemp.elementAt(indStart);
        Vector<Cartesian> atomVecStart = pdbStart.getAtomVec();
        int k = 0;
        while (k < atomVecStart.size()) {
            Cartesian cc = atomVecStart.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_start = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_start = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_start = cc.getXYZ();
            }
            ++k;
        }
        int indEnd0 = Collections.binarySearch(vecLoopTemp, new Pdb(noEnd), new Pdb.PdbComparator());
        if (indEnd0 < 0) {
            System.out.println("error: end residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd0 = (Pdb)vecLoopTemp.elementAt(indEnd0);
        double[] distTemp = new double[1];
        this.CheckLastResidue(pdbEnd0, noEnd, 100.0, distTemp);
        double minDist = distTemp[0];
        int nIterations = 5;
        int iItera = 0;
        while (iItera < nIterations) {
            curResNo = generator.nextInt(noEnd - noStart) + noStart;
            int counter = 0;
            while (counter < noEnd - noStart) {
                if ((curResNo += counter) >= noEnd) {
                    curResNo -= noEnd - noStart;
                }
                vecLoopTemp.add(prePdbTemp);
                Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
                Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecLoopTemp);
                int nTotalRes = Math.abs(noEnd - noStart);
                double[] phiS = new double[nTotalRes];
                double[] psiS = new double[nTotalRes];
                int i = 0;
                while (i < nTotalRes) {
                    PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(i + 1);
                    phiS[i] = phipsi.getPhi();
                    psiS[i] = phipsi.getPsi();
                    ++i;
                }
                double phiSave = phiS[curResNo - noStart];
                double psiSave = psiS[curResNo - noStart];
                if (curResNo == noStart) {
                    double phiValue = phiS[0];
                    int j = 0;
                    while ((double)j < 360.0 / resolution) {
                        double psiValue;
                        psiS[curResNo - noStart] = psiValue = (double)j * resolution * Math.PI / 180.0;
                        Vector pdbFragTemp0 = new Vector();
                        pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start, coordCA_start, noStart, false);
                        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                        boolean isAllClashFree = true;
                        int resno = curResNo;
                        while (resno < noEnd - 1) {
                            int indTemp = Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
                            if (indTemp < 0) {
                                System.out.println("error: current residue not found...exist...");
                                System.exit(0);
                            }
                            Pdb pdbTemp = pdbFragTemp.elementAt(indTemp);
                            Vector<Cartesian> atomVecNext = pdbTemp.getAtomVec();
                            double[] coordCA_next = new double[3];
                            int t = 0;
                            while (t < atomVecNext.size()) {
                                Cartesian cc = atomVecNext.elementAt(t);
                                String atom = cc.getAtom();
                                if (atom.equalsIgnoreCase("CA")) {
                                    coordCA_next = cc.getXYZ();
                                }
                                ++t;
                            }
                            boolean isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_next, 1);
                            if (isClash) {
                                isAllClashFree = false;
                                break;
                            }
                            ++resno;
                        }
                        if (isAllClashFree) {
                            double[] dist = new double[]{99999.9};
                            double error = 100.0;
                            int indEnd = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
                            if (indEnd < 0) {
                                System.out.println("error: end residue not found...exist...");
                                System.exit(0);
                            }
                            Pdb pdbEnd = pdbFragTemp.elementAt(indEnd);
                            boolean isClose = this.CheckLastResidue(pdbEnd, noEnd, error, dist);
                            double distance = dist[0];
                            if (distance < minDist) {
                                minDist = distance;
                                phiSave = phiValue;
                                psiSave = psiValue;
                            }
                        }
                        ++j;
                    }
                } else {
                    int k2 = 0;
                    while ((double)k2 < 360.0 / resolution) {
                        double phiValue = (double)k2 * resolution * Math.PI / 180.0;
                        int j = 0;
                        while ((double)j < 360.0 / resolution) {
                            double psiValue = (double)j * resolution * Math.PI / 180.0;
                            phiS[curResNo - noStart] = phiValue;
                            psiS[curResNo - noStart] = psiValue;
                            Vector pdbFragTemp0 = new Vector();
                            pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start, coordCA_start, noStart, false);
                            Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                            boolean isAllClashFree = true;
                            int resno = curResNo;
                            while (resno < noEnd - 1) {
                                int indTemp = Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
                                if (indTemp < 0) {
                                    System.out.println("error: current residue not found...exist...");
                                    System.exit(0);
                                }
                                Pdb pdbTemp = pdbFragTemp.elementAt(indTemp);
                                Vector<Cartesian> atomVecNext = pdbTemp.getAtomVec();
                                double[] coordCA_next = new double[3];
                                int t = 0;
                                while (t < atomVecNext.size()) {
                                    Cartesian cc = atomVecNext.elementAt(t);
                                    String atom = cc.getAtom();
                                    if (atom.equalsIgnoreCase("CA")) {
                                        coordCA_next = cc.getXYZ();
                                    }
                                    ++t;
                                }
                                boolean isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_next, 1);
                                if (isClash) {
                                    isAllClashFree = false;
                                    break;
                                }
                                ++resno;
                            }
                            if (isAllClashFree) {
                                double[] dist = new double[]{99999.9};
                                double error = 100.0;
                                int indEnd = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
                                if (indEnd < 0) {
                                    System.out.println("error: end residue not found...exist...");
                                    System.exit(0);
                                }
                                Pdb pdbEnd = pdbFragTemp.elementAt(indEnd);
                                boolean isClose = this.CheckLastResidue(pdbEnd, noEnd, error, dist);
                                double distance = dist[0];
                                if (distance < minDist) {
                                    minDist = distance;
                                    phiSave = phiValue;
                                    psiSave = psiValue;
                                }
                            }
                            ++j;
                        }
                        ++k2;
                    }
                }
                phiS[curResNo - noStart] = phiSave;
                psiS[curResNo - noStart] = psiSave;
                Vector pdbFragTempSave0 = mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start, coordCA_start, noStart, false);
                Vector<Pdb> pdbFragTempSave = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTempSave0);
                vecLoopTemp = new Vector();
                vecLoopTemp.addAll(pdbFragTempSave);
                ++counter;
            }
            ++iItera;
        }
        int indStart0 = Collections.binarySearch(vecLoopTemp, new Pdb(noStart - 1), new Pdb.PdbComparator());
        if (indStart0 > -1) {
            vecLoopTemp.remove(indStart0);
        }
        Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
        System.out.println("REMARK The final gap is: " + minDist);
        return vecLoopTemp;
    }

    public Vector LoopLocalGapClosureBackward(Vector vecLoopOldPdb, int noStart, int noEnd) {
        int ind1;
        int indTemp1;
        double resolution = 10.0;
        double Sxx = -this.Syy - this.Szz;
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        double[] NhRdcCal = new double[1];
        double[] ChRdcCal = new double[1];
        double[][] mat = new double[3][3];
        Matrix A = new Matrix(3, 3);
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                mat[x][y] = x == y ? 1.0 : 0.0;
                ++y;
            }
            ++x;
        }
        A = new Matrix(mat);
        double rdcRmsdBound = 2.0;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        PhiPsi ff = new PhiPsi();
        int indEnd0 = Collections.binarySearch(vecLoopOldPdb, new Pdb(noStart), new Pdb.PdbComparator());
        if (indEnd0 < 0) {
            System.out.println("error: end residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd0 = (Pdb)vecLoopOldPdb.elementAt(indEnd0);
        double[] distTemp = new double[1];
        this.CheckFirstResidue(pdbEnd0, noStart, 1000.0, distTemp);
        double minDist = distTemp[0];
        double[] coordN_fix = new double[3];
        double[] coordNH_fix = new double[3];
        double[] coordCA_fix = new double[3];
        int indFix = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd + 1), new Pdb.PdbComparator());
        if (indFix < 0) {
            System.out.println("error: starting residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbFix = this.vecPdbSSE.elementAt(indFix);
        Vector<Cartesian> atomVecFix = pdbFix.getAtomVec();
        int k = 0;
        while (k < atomVecFix.size()) {
            Cartesian cc = atomVecFix.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_fix = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_fix = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_fix = cc.getXYZ();
            }
            ++k;
        }
        Vector<Pdb> vecLoopTemp = new Vector<Pdb>();
        vecLoopTemp.addAll(vecLoopOldPdb);
        vecLoopTemp.add(pdbFix);
        Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
        int nIterations = 1;
        int iItera = 0;
        while (iItera < nIterations) {
            int curResNo = noEnd;
            while (curResNo >= noStart + 2) {
                Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecLoopTemp);
                double curPhiSave = 0.0;
                double prePhiSave = 0.0;
                double prePsiSave = 0.0;
                boolean isChanged = false;
                int t = 0;
                while ((double)t < 360.0 / resolution) {
                    double phiCur = (double)t * resolution * Math.PI / 180.0;
                    int indCur = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo), new PhiPsi.PPComparator());
                    PhiPsi ffCur = (PhiPsi)vecPhiPsiTemp.elementAt(indCur);
                    ffCur.setPhi(phiCur);
                    Loops lp = new Loops();
                    String curResName = lp.GetResNameFromSequence(this.vecSeq, curResNo);
                    String nextResName = lp.GetResNameFromSequence(this.vecSeq, curResNo + 1);
                    boolean isPrePro = false;
                    if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
                        isPrePro = true;
                    }
                    double rama_score = 0.0;
                    rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(ffCur.getPhi(), ffCur.getPsi(), this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(ffCur.getPhi(), ffCur.getPsi(), this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(ffCur.getPhi(), ffCur.getPsi(), this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(ffCur.getPhi(), ffCur.getPsi(), this.vecRamaPrePro) : lp.CompRamachandranScore(ffCur.getPhi(), ffCur.getPsi(), this.vecRamaGeneral))));
                    if (!(rama_score <= 0.02)) {
                        rama_score = -Math.log(rama_score);
                        int k2 = 0;
                        while ((double)k2 < 360.0 / resolution) {
                            double phiPre = (double)k2 * resolution * Math.PI / 180.0;
                            int j = 0;
                            while ((double)j < 360.0 / resolution) {
                                double psiPre = (double)j * resolution * Math.PI / 180.0;
                                int inPre = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo - 1), new PhiPsi.PPComparator());
                                PhiPsi ffPre = (PhiPsi)vecPhiPsiTemp.elementAt(inPre);
                                ffPre.setPhi(phiPre);
                                ffPre.setPsi(psiPre);
                                curResName = lp.GetResNameFromSequence(this.vecSeq, curResNo - 1);
                                nextResName = lp.GetResNameFromSequence(this.vecSeq, curResNo);
                                isPrePro = false;
                                if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
                                    isPrePro = true;
                                }
                                rama_score = 0.0;
                                rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(ffPre.getPhi(), ffPre.getPsi(), this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(ffPre.getPhi(), ffPre.getPsi(), this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(ffPre.getPhi(), ffPre.getPsi(), this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(ffPre.getPhi(), ffPre.getPsi(), this.vecRamaPrePro) : lp.CompRamachandranScore(ffPre.getPhi(), ffPre.getPsi(), this.vecRamaGeneral))));
                                if (!(rama_score <= 0.02)) {
                                    rama_score = -Math.log(rama_score);
                                    Vector pdbFragTemp0 = new Vector();
                                    pdbFragTemp0 = mdc.modelBuildLoopBackward(vecPhiPsiTemp, coordN_fix, coordNH_fix, coordCA_fix, noStart + 1, noEnd);
                                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                    boolean isAllClashFree = true;
                                    int resno = curResNo;
                                    while (resno > noStart + 1) {
                                        int indTemp = Collections.binarySearch(pdbFragTemp, new Pdb(resno - 1), new Pdb.PdbComparator());
                                        if (indTemp < 0) {
                                            System.out.println("error: current residue not found...exist...");
                                            System.exit(0);
                                        }
                                        Pdb pdbTemp = pdbFragTemp.elementAt(indTemp);
                                        Vector<Cartesian> atomVecPre = pdbTemp.getAtomVec();
                                        double[] coordCA_pre = new double[3];
                                        int h = 0;
                                        while (h < atomVecPre.size()) {
                                            Cartesian cc = atomVecPre.elementAt(h);
                                            String atom = cc.getAtom();
                                            if (atom.equalsIgnoreCase("CA")) {
                                                coordCA_pre = cc.getXYZ();
                                            }
                                            ++h;
                                        }
                                        boolean isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_pre, 1);
                                        if (isClash) {
                                            isAllClashFree = false;
                                            break;
                                        }
                                        --resno;
                                    }
                                    if (isAllClashFree) {
                                        boolean isAllRDCsSatisfied = true;
                                        int resno2 = curResNo;
                                        while (resno2 > noStart) {
                                            double chRms;
                                            double nhRms;
                                            int indNH;
                                            int indTemp = Collections.binarySearch(pdbFragTemp, new Pdb(resno2), new Pdb.PdbComparator());
                                            if (indTemp < 0) {
                                                System.out.println("error: current residue not found...exist...");
                                                System.exit(0);
                                            }
                                            Pdb pdbTemp = pdbFragTemp.elementAt(indTemp);
                                            Vector<Pdb> vecPdbTemp = new Vector<Pdb>();
                                            vecPdbTemp.add(pdbTemp);
                                            double chRdc = -99999.9;
                                            double nhRdc = -99999.9;
                                            int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(resno2), new Dipolar.rdcComparator());
                                            if (indCH > -1) {
                                                chRdc = this.vecChRDC.elementAt(indCH).getRdc();
                                            }
                                            if ((indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(resno2), new Dipolar.rdcComparator())) > -1) {
                                                nhRdc = this.vecNhRDC.elementAt(indNH).getRdc();
                                            }
                                            if (nhRdc > -1000.0 && (nhRms = pdc.BackCalNHOne(vecPdbTemp, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH)) > rdcRmsdBound) {
                                                isAllRDCsSatisfied = false;
                                                break;
                                            }
                                            if (chRdc > -1000.0 && (chRms = pdc.BackCalOne(vecPdbTemp, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH)) > rdcRmsdBound) {
                                                isAllRDCsSatisfied = false;
                                                break;
                                            }
                                            --resno2;
                                        }
                                        if (isAllRDCsSatisfied) {
                                            double[] dist = new double[]{99999.9};
                                            double error = 100.0;
                                            int indStart = Collections.binarySearch(pdbFragTemp, new Pdb(noStart), new Pdb.PdbComparator());
                                            if (indStart < 0) {
                                                System.out.println("error: end residue not found...exist...");
                                                System.exit(0);
                                            }
                                            Pdb pdbStart = pdbFragTemp.elementAt(indStart);
                                            this.CheckFirstResidue(pdbStart, noStart, 1000.0, dist);
                                            double distance = dist[0];
                                            if (distance < minDist) {
                                                minDist = distance;
                                                curPhiSave = phiCur;
                                                prePhiSave = phiPre;
                                                prePsiSave = psiPre;
                                                isChanged = true;
                                            }
                                        }
                                    }
                                }
                                ++j;
                            }
                            ++k2;
                        }
                    }
                    ++t;
                }
                if (isChanged) {
                    int indCur = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo), new PhiPsi.PPComparator());
                    PhiPsi ffCur = (PhiPsi)vecPhiPsiTemp.elementAt(indCur);
                    ffCur.setPhi(curPhiSave);
                    int inPre = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo - 1), new PhiPsi.PPComparator());
                    PhiPsi ffPre = (PhiPsi)vecPhiPsiTemp.elementAt(inPre);
                    ffPre.setPhi(prePhiSave);
                    ffPre.setPsi(prePsiSave);
                    Vector pdbFragTemp0 = new Vector();
                    pdbFragTemp0 = mdc.modelBuildLoopBackward(vecPhiPsiTemp, coordN_fix, coordNH_fix, coordCA_fix, noStart + 1, noEnd);
                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                    vecLoopTemp = new Vector();
                    vecLoopTemp.addAll(pdbFragTemp);
                    vecLoopTemp.add(pdbFix);
                    Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
                }
                --curResNo;
            }
            ++iItera;
        }
        int indTemp0 = Collections.binarySearch(vecLoopTemp, new Pdb(noEnd + 1), new Pdb.PdbComparator());
        if (indTemp0 > -1) {
            vecLoopTemp.remove(indTemp0);
        }
        if ((indTemp1 = Collections.binarySearch(vecLoopTemp, new Pdb(noStart), new Pdb.PdbComparator())) > -1) {
            vecLoopTemp.remove(indTemp1);
        }
        if ((ind1 = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator())) > -1) {
            Pdb pdb1 = this.vecPdbSSE.elementAt(ind1);
            vecLoopTemp.add(pdb1);
        }
        Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
        System.out.println("REMARK The final gap is: " + minDist);
        return vecLoopTemp;
    }

    public boolean LoopCurResPhiPsiGridSearch(Vector vecCurHalfPdb, int curNo, int startResNo, int endResNo, double chRdc, double nhNextRdc, Vector vecCurFullPdb, Vector vecNextHalfPdb, boolean isLast) {
        double resolCluster = 0.4;
        int topNum = 500;
        double rdcRmsdBound = this.rdcThreshold;
        double resolution = 5.0;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 5;
        double distBtwCa = 8.0;
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecNextPdbTemp = new Vector<TreePdb>();
        int i2 = 0;
        while (i2 < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbCurHalf = (TreePdb)vecCurHalfPdb.elementAt(i2);
            TreePdb curParent = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector vecPreChild = curParent.vecChildPdb;
            vecPreChild.remove(pdbCurHalf);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            Vector<Cartesian> atomVecStart = pdbCurHalf.pdb.getAtomVec();
            int k = 0;
            while (k < atomVecStart.size()) {
                Cartesian cc = atomVecStart.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            k = 0;
            while ((double)k < 360.0 / resolution) {
                double phiValue = (double)k * resolution * Math.PI / 180.0;
                int j = 0;
                while ((double)j < 360.0 / resolution) {
                    block26: {
                        double[] distCa;
                        double chRms;
                        double nhRms;
                        double cur_sum_rdc;
                        Pdb nextHalfPdb;
                        Pdb curPdb;
                        double rama_score;
                        block30: {
                            block29: {
                                Matrix A;
                                double[] ChRdcCal;
                                int[] sizeCH;
                                double[] sRmsdCH;
                                Vector<Pdb> vecCurPdb;
                                double Sxx;
                                block28: {
                                    block27: {
                                        boolean isClash;
                                        double psiValue = (double)j * resolution * Math.PI / 180.0;
                                        phiS[0] = phiValue;
                                        psiS[0] = psiValue;
                                        rama_score = 0.0;
                                        rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPrePro) : lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGeneral))));
                                        if (rama_score <= 0.02) break block26;
                                        rama_score = -Math.log(rama_score);
                                        Vector pdbFragTemp0 = new Vector();
                                        pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, curNo, false);
                                        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                        curPdb = pdbFragTemp.elementAt(0);
                                        nextHalfPdb = pdbFragTemp.elementAt(1);
                                        int resNoNext = nextHalfPdb.getResidueNo();
                                        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
                                        double[] coordN_next = new double[3];
                                        double[] coordNH_next = new double[3];
                                        double[] coordCA_next = new double[3];
                                        int t = 0;
                                        while (t < atomVecNext.size()) {
                                            Cartesian cc = atomVecNext.elementAt(t);
                                            String atom = cc.getAtom();
                                            if (atom.equalsIgnoreCase("N")) {
                                                coordN_next = cc.getXYZ();
                                            } else if (atom.equalsIgnoreCase("CA")) {
                                                coordCA_next = cc.getXYZ();
                                            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                                coordNH_next = cc.getXYZ();
                                            }
                                            ++t;
                                        }
                                        if (resNoNext < endResNo && (isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_next, 1))) break block26;
                                        if (resNoNext > endResNo) break block27;
                                        double errorKin = 0.6;
                                        errorKin = resNoNext == endResNo ? this.gapThreshold : 1.0;
                                        boolean isKinChain = this.CheckKinChainRestraint(nextHalfPdb, endResNo, errorKin);
                                        if (!isKinChain) break block26;
                                    }
                                    Sxx = -this.Syy - this.Szz;
                                    vecCurPdb = new Vector<Pdb>();
                                    Vector<Pdb> vecNextPdb = new Vector<Pdb>();
                                    vecCurPdb.add(curPdb);
                                    vecNextPdb.add(nextHalfPdb);
                                    sRmsdCH = new double[1];
                                    sizeCH = new int[1];
                                    double[] sRmsdNH = new double[1];
                                    int[] sizeNH = new int[1];
                                    double[] NhRdcCal = new double[vecCurPdb.size()];
                                    ChRdcCal = new double[vecCurPdb.size()];
                                    double[][] mat = new double[3][3];
                                    A = new Matrix(3, 3);
                                    int x = 0;
                                    while (x < 3) {
                                        int y = 0;
                                        while (y < 3) {
                                            mat[x][y] = x == y ? 1.0 : 0.0;
                                            ++y;
                                        }
                                        ++x;
                                    }
                                    A = new Matrix(mat);
                                    cur_sum_rdc = 0.0;
                                    nhRms = -99999.9;
                                    chRms = -99999.9;
                                    if (!(nhNextRdc > -100.0)) break block28;
                                    nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                                    if (nhRms > rdcRmsdBound) break block26;
                                    cur_sum_rdc += nhRms;
                                }
                                if (!(chRdc > -100.0)) break block29;
                                chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH);
                                if (chRms > rdcRmsdBound) break block26;
                                cur_sum_rdc += chRms;
                            }
                            double[] dist = new double[1];
                            distCa = new double[1];
                            dist[0] = 99999.9;
                            distCa[0] = 99999.9;
                            if (!isLast) break block30;
                            double error = this.gapThreshold;
                            int endNo = curPdb.getResidueNo();
                            boolean isClose = this.CheckLastResidue(curPdb, endNo, error, dist, distCa);
                            if (!isClose) break block26;
                        }
                        TreePdb curTreePdb = new TreePdb(curPdb);
                        curTreePdb.SetNhRdcDif(nhRms);
                        curTreePdb.SetChRdcDif(chRms);
                        curTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                        curTreePdb.SetEndDist(distCa[0]);
                        vecPreChild.add(curTreePdb);
                        curTreePdb.parenPdb.add(curParent);
                        vecCurPdbTemp.add(curTreePdb);
                        TreePdb nextHalfTreePdb = new TreePdb(nextHalfPdb);
                        nextHalfTreePdb.SetNhRdcDif(nhRms);
                        nextHalfTreePdb.SetChRdcDif(chRms);
                        nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        nextHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                        nextHalfTreePdb.SetEndDist(distCa[0]);
                        curTreePdb.vecChildPdb.add(nextHalfTreePdb);
                        nextHalfTreePdb.parenPdb.add(curTreePdb);
                        vecNextPdbTemp.add(nextHalfTreePdb);
                        if (distCa[0] < minDist) {
                            minDist = distCa[0];
                            FinalPdbS = new TreePdb(curTreePdb);
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i2;
        }
        if (curNo == 37) {
            System.out.println("stop here...debugging");
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClustering(resolCluster, vecCurPdbTemp, vecNextPdbTemp);
        if (vecCurPdbTemp.size() > topNum) {
            this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecNextPdbTemp, topNum);
        }
        Vector<TreePdb> vecCurPdbTempSorted = new Vector<TreePdb>();
        vecCurPdbTempSorted.addAll(vecCurPdbTemp);
        Collections.sort(vecCurPdbTempSorted, new TreePdbNOEComparator());
        vecNextHalfPdb.addAll(vecNextPdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return true;
    }

    public boolean CurPhiPsiGridForwardMinRdcRmsd(Vector vecCurHalfPdb, int curNo, int startResNo, int endResNo, double chRdc, double nhNextRdc, Vector vecCurFullPdb, Vector vecNextHalfPdb, boolean isLast, int topNodes) {
        double resolCluster = 0.4;
        int topNum = 500;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        double resolution = 15.0;
        int topSSEK = 5;
        double distBtwCa = 8.0;
        double rdcRmsdBound = 20.0;
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecNextPdbTemp = new Vector<TreePdb>();
        int i2 = 0;
        while (i2 < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbCurHalf = (TreePdb)vecCurHalfPdb.elementAt(i2);
            TreePdb curParent = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector vecPreChild = curParent.vecChildPdb;
            vecPreChild.remove(pdbCurHalf);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            Vector<Cartesian> atomVecStart = pdbCurHalf.pdb.getAtomVec();
            int k = 0;
            while (k < atomVecStart.size()) {
                Cartesian cc = atomVecStart.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            k = 0;
            while ((double)k < 360.0 / resolution) {
                double phiValue = (double)k * resolution * Math.PI / 180.0;
                int j = 0;
                while ((double)j < 360.0 / resolution) {
                    block27: {
                        double[] distCa;
                        double chRms;
                        double nhRms;
                        double cur_sum_rdc;
                        Pdb nextHalfPdb;
                        Pdb curPdb;
                        double rama_score;
                        block30: {
                            block29: {
                                Matrix A;
                                double[] ChRdcCal;
                                int[] sizeCH;
                                double[] sRmsdCH;
                                Vector<Pdb> vecCurPdb;
                                double Sxx;
                                block28: {
                                    boolean isClash;
                                    double psiValue = (double)j * resolution * Math.PI / 180.0;
                                    phiS[0] = phiValue;
                                    psiS[0] = psiValue;
                                    rama_score = 0.0;
                                    rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPrePro) : lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGeneral))));
                                    if (rama_score <= 0.02) break block27;
                                    rama_score = -Math.log(rama_score);
                                    Vector pdbFragTemp0 = new Vector();
                                    pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, curNo, false);
                                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                    curPdb = pdbFragTemp.elementAt(0);
                                    nextHalfPdb = pdbFragTemp.elementAt(1);
                                    Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
                                    double[] coordN_next = new double[3];
                                    double[] coordNH_next = new double[3];
                                    double[] coordCA_next = new double[3];
                                    int t = 0;
                                    while (t < atomVecNext.size()) {
                                        Cartesian cc = atomVecNext.elementAt(t);
                                        String atom = cc.getAtom();
                                        if (atom.equalsIgnoreCase("N")) {
                                            coordN_next = cc.getXYZ();
                                        } else if (atom.equalsIgnoreCase("CA")) {
                                            coordCA_next = cc.getXYZ();
                                        } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                            coordNH_next = cc.getXYZ();
                                        }
                                        ++t;
                                    }
                                    if (!isLast && (isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_next, 1))) break block27;
                                    double errorKin = 0.6;
                                    errorKin = isLast ? this.gapThreshold : 1.0;
                                    boolean isKinChain = this.CheckKinChainRestraint(nextHalfPdb, endResNo, errorKin);
                                    if (!isKinChain) break block27;
                                    Sxx = -this.Syy - this.Szz;
                                    vecCurPdb = new Vector<Pdb>();
                                    Vector<Pdb> vecNextPdb = new Vector<Pdb>();
                                    vecCurPdb.add(curPdb);
                                    vecNextPdb.add(nextHalfPdb);
                                    sRmsdCH = new double[1];
                                    sizeCH = new int[1];
                                    double[] sRmsdNH = new double[1];
                                    int[] sizeNH = new int[1];
                                    double[] NhRdcCal = new double[vecCurPdb.size()];
                                    ChRdcCal = new double[vecCurPdb.size()];
                                    double[][] mat = new double[3][3];
                                    A = new Matrix(3, 3);
                                    int x = 0;
                                    while (x < 3) {
                                        int y = 0;
                                        while (y < 3) {
                                            mat[x][y] = x == y ? 1.0 : 0.0;
                                            ++y;
                                        }
                                        ++x;
                                    }
                                    A = new Matrix(mat);
                                    cur_sum_rdc = 0.0;
                                    nhRms = -99999.9;
                                    chRms = -99999.9;
                                    if (!(nhNextRdc > -100.0)) break block28;
                                    nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                                    if (nhRms > rdcRmsdBound) break block27;
                                    cur_sum_rdc += nhRms;
                                }
                                if (!(chRdc > -100.0)) break block29;
                                chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH);
                                if (chRms > rdcRmsdBound) break block27;
                                cur_sum_rdc += chRms;
                            }
                            double[] dist = new double[1];
                            distCa = new double[1];
                            dist[0] = 99999.9;
                            distCa[0] = 99999.9;
                            if (!isLast) break block30;
                            double error = this.gapThreshold;
                            int endNo = nextHalfPdb.getResidueNo();
                            boolean isClose = this.CheckLastResidue(nextHalfPdb, endNo, error, dist, distCa);
                            if (!isClose) break block27;
                        }
                        TreePdb curTreePdb = new TreePdb(curPdb);
                        curTreePdb.SetNhRdcDif(nhRms);
                        curTreePdb.SetChRdcDif(chRms);
                        curTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                        curTreePdb.SetEndDist(distCa[0]);
                        vecPreChild.add(curTreePdb);
                        curTreePdb.parenPdb.add(curParent);
                        vecCurPdbTemp.add(curTreePdb);
                        TreePdb nextHalfTreePdb = new TreePdb(nextHalfPdb);
                        nextHalfTreePdb.SetNhRdcDif(nhRms);
                        nextHalfTreePdb.SetChRdcDif(chRms);
                        nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        nextHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                        nextHalfTreePdb.SetEndDist(distCa[0]);
                        curTreePdb.vecChildPdb.add(nextHalfTreePdb);
                        nextHalfTreePdb.parenPdb.add(curTreePdb);
                        vecNextPdbTemp.add(nextHalfTreePdb);
                        if (distCa[0] < minDist) {
                            minDist = distCa[0];
                            FinalPdbS = new TreePdb(curTreePdb);
                        }
                        if (vecNextPdbTemp.size() > this.maxLeafNodes) {
                            this.PlaneClusteringBackward(resolCluster, vecCurPdbTemp, vecNextPdbTemp);
                            if (vecCurPdbTemp.size() > topNum) {
                                this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecNextPdbTemp, topNum);
                            }
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i2;
        }
        Vector<TreePdb> vecCurTreePdbNew = new Vector<TreePdb>();
        Collections.sort(vecCurPdbTemp, new TreePdbRDCComparator());
        int i3 = 0;
        while (i3 < Math.min(topNodes, vecCurPdbTemp.size())) {
            TreePdb treePdb = (TreePdb)vecCurPdbTemp.elementAt(i3);
            vecCurTreePdbNew.add(treePdb);
            ++i3;
        }
        Vector<TreePdb> vecNextTreePdbNew = new Vector<TreePdb>();
        Collections.sort(vecNextPdbTemp, new TreePdbRDCComparator());
        int i4 = 0;
        while (i4 < Math.min(topNodes, vecNextPdbTemp.size())) {
            TreePdb treePdb = (TreePdb)vecNextPdbTemp.elementAt(i4);
            vecNextTreePdbNew.add(treePdb);
            ++i4;
        }
        vecNextHalfPdb.addAll(vecNextTreePdbNew);
        vecCurFullPdb.addAll(vecCurTreePdbNew);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return vecCurFullPdb.size() > 0;
    }

    public boolean CurPhiPsiGridBackwardMinRdcRmsd(Vector vecCurHalfPdb, int curNo, int startNo, int lastNo, double chRdc, double nhRdc, Vector vecCurFullPdb, Vector vecPreHalfPdb, boolean isFirst, int topNodes) {
        double resolCluster = 0.4;
        int topNum = 500;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        double resolution = 15.0;
        int topSSEK = 5;
        double distBtwCa = 8.0;
        double rdcRmsdBound = 100.0;
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecPrePdbTemp = new Vector<TreePdb>();
        int i = 0;
        while (i < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbCurHalf = (TreePdb)vecCurHalfPdb.elementAt(i);
            TreePdb curParent = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector vecPreChild = curParent.vecChildPdb;
            vecPreChild.remove(pdbCurHalf);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            TreePdb treePdbNext = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector<Cartesian> atomVecStart = treePdbNext.pdb.getAtomVec();
            int k = 0;
            while (k < atomVecStart.size()) {
                Cartesian cc = atomVecStart.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            k = 0;
            while ((double)k < 360.0 / resolution) {
                double phiValue = (double)k * resolution * Math.PI / 180.0;
                int j = 0;
                while ((double)j < 360.0 / resolution) {
                    block26: {
                        double[] distCa;
                        double chRms;
                        double nhRms;
                        double cur_sum_rdc;
                        Pdb preHalfPdb;
                        Pdb curPdb;
                        double rama_score;
                        block29: {
                            block28: {
                                Matrix A;
                                double[] ChRdcCal;
                                int[] sizeCH;
                                double[] sRmsdCH;
                                Vector<Pdb> vecCurPdb;
                                double Sxx;
                                block27: {
                                    boolean isClash;
                                    double psiValue = (double)j * resolution * Math.PI / 180.0;
                                    rama_score = 0.0;
                                    rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPrePro) : lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGeneral))));
                                    if (rama_score <= 0.02) break block26;
                                    rama_score = -Math.log(rama_score);
                                    Vector pdbFragTemp0 = new Vector();
                                    pdbFragTemp0 = mdc.coordByBackwardNew(phiValue, psiValue, coordN, coordNH, coordCA, curNo);
                                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                    curPdb = pdbFragTemp.elementAt(1);
                                    preHalfPdb = pdbFragTemp.elementAt(0);
                                    Vector<Cartesian> atomVecPre = preHalfPdb.getAtomVec();
                                    double[] coordN_pre = new double[3];
                                    double[] coordNH_pre = new double[3];
                                    double[] coordCA_pre = new double[3];
                                    int t = 0;
                                    while (t < atomVecPre.size()) {
                                        Cartesian cc = atomVecPre.elementAt(t);
                                        String atom = cc.getAtom();
                                        if (atom.equalsIgnoreCase("N")) {
                                            coordN_pre = cc.getXYZ();
                                        } else if (atom.equalsIgnoreCase("CA")) {
                                            coordCA_pre = cc.getXYZ();
                                        } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                            coordNH_pre = cc.getXYZ();
                                        }
                                        ++t;
                                    }
                                    if (!isFirst && (isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_pre, 1))) break block26;
                                    double errorKin = 0.6;
                                    errorKin = isFirst ? this.gapThreshold : 1.0;
                                    boolean isKinChain = this.CheckKinChainRestraintBackward(preHalfPdb, startNo, errorKin);
                                    if (!isKinChain) break block26;
                                    Sxx = -this.Syy - this.Szz;
                                    vecCurPdb = new Vector<Pdb>();
                                    vecCurPdb.add(curPdb);
                                    sRmsdCH = new double[1];
                                    sizeCH = new int[1];
                                    double[] sRmsdNH = new double[1];
                                    int[] sizeNH = new int[1];
                                    double[] NhRdcCal = new double[vecCurPdb.size()];
                                    ChRdcCal = new double[vecCurPdb.size()];
                                    double[][] mat = new double[3][3];
                                    A = new Matrix(3, 3);
                                    int x = 0;
                                    while (x < 3) {
                                        int y = 0;
                                        while (y < 3) {
                                            mat[x][y] = x == y ? 1.0 : 0.0;
                                            ++y;
                                        }
                                        ++x;
                                    }
                                    A = new Matrix(mat);
                                    cur_sum_rdc = 0.0;
                                    nhRms = -99999.9;
                                    chRms = -99999.9;
                                    if (!(nhRdc > -1000.0)) break block27;
                                    nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                                    if (nhRms > rdcRmsdBound) break block26;
                                    cur_sum_rdc += nhRms;
                                }
                                if (!(chRdc > -1000.0)) break block28;
                                chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH);
                                if (chRms > rdcRmsdBound) break block26;
                                cur_sum_rdc += chRms;
                            }
                            double[] dist = new double[1];
                            distCa = new double[1];
                            dist[0] = 99999.9;
                            distCa[0] = 99999.9;
                            if (!isFirst) break block29;
                            double error = this.gapThreshold;
                            int fixNo = preHalfPdb.getResidueNo();
                            boolean isClose = this.CheckFirstResidue(preHalfPdb, fixNo, error, dist, distCa);
                            if (!isClose) break block26;
                        }
                        TreePdb curTreePdb = new TreePdb(curPdb);
                        curTreePdb.SetNhRdcDif(nhRms);
                        curTreePdb.SetChRdcDif(chRms);
                        curTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                        curTreePdb.SetEndDist(distCa[0]);
                        vecPreChild.add(curTreePdb);
                        curTreePdb.parenPdb.add(curParent);
                        vecCurPdbTemp.add(curTreePdb);
                        TreePdb preHalfTreePdb = new TreePdb(preHalfPdb);
                        preHalfTreePdb.SetNhRdcDif(nhRms);
                        preHalfTreePdb.SetChRdcDif(chRms);
                        preHalfTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        preHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                        preHalfTreePdb.SetEndDist(distCa[0]);
                        curTreePdb.vecChildPdb.add(preHalfTreePdb);
                        preHalfTreePdb.parenPdb.add(curTreePdb);
                        vecPrePdbTemp.add(preHalfTreePdb);
                        if (distCa[0] < minDist) {
                            minDist = distCa[0];
                            FinalPdbS = new TreePdb(curTreePdb);
                        }
                        if (vecPrePdbTemp.size() > this.maxLeafNodes) {
                            this.PlaneClusteringBackward(resolCluster, vecCurPdbTemp, vecPrePdbTemp);
                            if (vecCurPdbTemp.size() > topNum) {
                                this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecPrePdbTemp, topNum);
                            }
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        Vector<TreePdb> vecCurTreePdbNew = new Vector<TreePdb>();
        Collections.sort(vecCurPdbTemp, new TreePdbRDCComparator());
        int i2 = 0;
        while (i2 < Math.min(topNodes, vecCurPdbTemp.size())) {
            TreePdb treePdb = (TreePdb)vecCurPdbTemp.elementAt(i2);
            vecCurTreePdbNew.add(treePdb);
            ++i2;
        }
        Vector<TreePdb> vecPreTreePdbNew = new Vector<TreePdb>();
        Collections.sort(vecPrePdbTemp, new TreePdbRDCComparator());
        int i3 = 0;
        while (i3 < Math.min(topNodes, vecPrePdbTemp.size())) {
            TreePdb treePdb = (TreePdb)vecPrePdbTemp.elementAt(i3);
            vecPreTreePdbNew.add(treePdb);
            ++i3;
        }
        vecPreHalfPdb.addAll(vecPreTreePdbNew);
        vecCurFullPdb.addAll(vecCurTreePdbNew);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return vecCurFullPdb.size() > 0;
    }

    public boolean LoopCurResPhiPsiGridSearchBackward(Vector vecCurHalfPdb, int curNo, int startNo, int lastNo, double chRdc, double nhRdc, Vector vecCurFullPdb, Vector vecPreHalfPdb, boolean isFirst) {
        double resolCluster = 0.4;
        int topNum = 500;
        double resolution = 15.0;
        double rdcRmsdBound = this.rdcThreshold;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 5;
        double distBtwCa = 8.0;
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecPrePdbTemp = new Vector<TreePdb>();
        int i = 0;
        while (i < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbCurHalf = (TreePdb)vecCurHalfPdb.elementAt(i);
            TreePdb curParent = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector vecPreChild = curParent.vecChildPdb;
            vecPreChild.remove(pdbCurHalf);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            TreePdb treePdbNext = (TreePdb)pdbCurHalf.parenPdb.elementAt(0);
            Vector<Cartesian> atomVecStart = treePdbNext.pdb.getAtomVec();
            int k = 0;
            while (k < atomVecStart.size()) {
                Cartesian cc = atomVecStart.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            k = 0;
            while ((double)k < 360.0 / resolution) {
                double phiValue = (double)k * resolution * Math.PI / 180.0;
                int j = 0;
                while ((double)j < 360.0 / resolution) {
                    block24: {
                        double[] distCa;
                        double chRms;
                        double nhRms;
                        double cur_sum_rdc;
                        Pdb preHalfPdb;
                        Pdb curPdb;
                        double rama_score;
                        block28: {
                            block27: {
                                Matrix A;
                                double[] ChRdcCal;
                                int[] sizeCH;
                                double[] sRmsdCH;
                                Vector<Pdb> vecCurPdb;
                                double Sxx;
                                block26: {
                                    block25: {
                                        boolean isClash;
                                        double psiValue = (double)j * resolution * Math.PI / 180.0;
                                        rama_score = 0.0;
                                        rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaPrePro) : lp.CompRamachandranScore(phiValue, psiValue, this.vecRamaGeneral))));
                                        if (rama_score <= 0.02) break block24;
                                        rama_score = -Math.log(rama_score);
                                        Vector pdbFragTemp0 = new Vector();
                                        pdbFragTemp0 = mdc.coordByBackwardNew(phiValue, psiValue, coordN, coordNH, coordCA, curNo);
                                        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                        curPdb = pdbFragTemp.elementAt(1);
                                        preHalfPdb = pdbFragTemp.elementAt(0);
                                        int resNoPre = preHalfPdb.getResidueNo();
                                        Vector<Cartesian> atomVecPre = preHalfPdb.getAtomVec();
                                        double[] coordN_pre = new double[3];
                                        double[] coordNH_pre = new double[3];
                                        double[] coordCA_pre = new double[3];
                                        int t = 0;
                                        while (t < atomVecPre.size()) {
                                            Cartesian cc = atomVecPre.elementAt(t);
                                            String atom = cc.getAtom();
                                            if (atom.equalsIgnoreCase("N")) {
                                                coordN_pre = cc.getXYZ();
                                            } else if (atom.equalsIgnoreCase("CA")) {
                                                coordCA_pre = cc.getXYZ();
                                            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                                coordNH_pre = cc.getXYZ();
                                            }
                                            ++t;
                                        }
                                        if (resNoPre > startNo && (isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_pre, 1))) break block24;
                                        if (resNoPre < startNo) break block25;
                                        double errorKin = 0.6;
                                        errorKin = resNoPre == startNo ? this.gapThreshold : 1.0;
                                        boolean isKinChain = this.CheckKinChainRestraintBackward(preHalfPdb, startNo, errorKin);
                                        if (!isKinChain) break block24;
                                    }
                                    Sxx = -this.Syy - this.Szz;
                                    vecCurPdb = new Vector<Pdb>();
                                    vecCurPdb.add(curPdb);
                                    sRmsdCH = new double[1];
                                    sizeCH = new int[1];
                                    double[] sRmsdNH = new double[1];
                                    int[] sizeNH = new int[1];
                                    double[] NhRdcCal = new double[vecCurPdb.size()];
                                    ChRdcCal = new double[vecCurPdb.size()];
                                    double[][] mat = new double[3][3];
                                    A = new Matrix(3, 3);
                                    int x = 0;
                                    while (x < 3) {
                                        int y = 0;
                                        while (y < 3) {
                                            mat[x][y] = x == y ? 1.0 : 0.0;
                                            ++y;
                                        }
                                        ++x;
                                    }
                                    A = new Matrix(mat);
                                    cur_sum_rdc = 0.0;
                                    nhRms = -99999.9;
                                    chRms = -99999.9;
                                    if (!(nhRdc > -1000.0)) break block26;
                                    nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                                    if (nhRms > rdcRmsdBound) break block24;
                                    cur_sum_rdc += nhRms;
                                }
                                if (!(chRdc > -1000.0)) break block27;
                                chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH);
                                if (chRms > rdcRmsdBound) break block24;
                                cur_sum_rdc += chRms;
                            }
                            double[] dist = new double[1];
                            distCa = new double[1];
                            dist[0] = 99999.9;
                            distCa[0] = 99999.9;
                            if (!isFirst) break block28;
                            double error = this.gapThreshold;
                            int fixNo = curPdb.getResidueNo();
                            boolean isClose = this.CheckFirstResidue(curPdb, fixNo, error, dist, distCa);
                            if (!isClose) break block24;
                        }
                        TreePdb curTreePdb = new TreePdb(curPdb);
                        curTreePdb.SetNhRdcDif(nhRms);
                        curTreePdb.SetChRdcDif(chRms);
                        curTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                        curTreePdb.SetEndDist(distCa[0]);
                        vecPreChild.add(curTreePdb);
                        curTreePdb.parenPdb.add(curParent);
                        vecCurPdbTemp.add(curTreePdb);
                        TreePdb preHalfTreePdb = new TreePdb(preHalfPdb);
                        preHalfTreePdb.SetNhRdcDif(nhRms);
                        preHalfTreePdb.SetChRdcDif(chRms);
                        preHalfTreePdb.SetSumRdcDif(pre_sum_rdc + cur_sum_rdc);
                        preHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                        preHalfTreePdb.SetEndDist(distCa[0]);
                        curTreePdb.vecChildPdb.add(preHalfTreePdb);
                        preHalfTreePdb.parenPdb.add(curTreePdb);
                        vecPrePdbTemp.add(preHalfTreePdb);
                        if (distCa[0] < minDist) {
                            minDist = distCa[0];
                            FinalPdbS = new TreePdb(curTreePdb);
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClusteringBackward(resolCluster, vecCurPdbTemp, vecPrePdbTemp);
        if (vecCurPdbTemp.size() > topNum) {
            this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecPrePdbTemp, topNum);
        }
        vecPreHalfPdb.addAll(vecPrePdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return true;
    }

    public Vector SampleFirstHalfPlanes(int resNoFix, boolean isSampleInitPlane) {
        String atom;
        Cartesian cc;
        Vector vecAtomSet = new Vector();
        double distThreshold = 10.6;
        double resolution = 30.0;
        PdbRdc pdc = new PdbRdc();
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(resNoFix), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: fixed residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbFixed = this.vecPdbSSE.elementAt(index);
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        double[] coordNHNew = new double[3];
        double[] coordCANew = new double[3];
        double[] nToNHVec = new double[3];
        double[] nToCAVec = new double[3];
        double[] nToNHVecNew = new double[3];
        double[] nToCAVecNew = new double[3];
        Vector<Cartesian> atomVecFix = pdbFixed.getAtomVec();
        vecAtomSet.add(atomVecFix);
        if (!isSampleInitPlane) {
            return vecAtomSet;
        }
        Vector<Cartesian> vecAtomTemp = new Vector<Cartesian>();
        int k = 0;
        while (k < atomVecFix.size()) {
            cc = atomVecFix.elementAt(k);
            atom = cc.getAtom();
            if (!(atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H"))) {
                vecAtomTemp.add(cc);
            }
            ++k;
        }
        k = 0;
        while (k < atomVecFix.size()) {
            cc = atomVecFix.elementAt(k);
            atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        nToNHVec = pdc.internuclearVec(coordN, coordNH);
        nToCAVec = pdc.internuclearVec(coordN, coordCA);
        double[][] mat = new double[3][3];
        int i = 0;
        while ((double)i < 360.0 / resolution) {
            double alpha = (double)i * resolution * Math.PI / 180.0;
            int j = 0;
            while ((double)j < 180.0 / resolution) {
                double beta = (double)j * resolution * Math.PI / 180.0;
                int k2 = 0;
                while ((double)k2 < 360.0 / resolution) {
                    double gamma = (double)k2 * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    Matrix mm = new Matrix(mat);
                    nToNHVecNew = mm.times(nToNHVec);
                    nToCAVecNew = mm.times(nToCAVec);
                    Vector<Cartesian> vecAtomNew = new Vector<Cartesian>();
                    coordNHNew = pdc.newVecByTranslation(coordN, nToNHVecNew);
                    coordCANew = pdc.newVecByTranslation(coordN, nToCAVecNew);
                    double distHN = Math.sqrt((coordNHNew[0] - coordNH[0]) * (coordNHNew[0] - coordNH[0]) + (coordNHNew[1] - coordNH[1]) * (coordNHNew[1] - coordNH[1]) + (coordNHNew[2] - coordNH[2]) * (coordNHNew[2] - coordNH[2]));
                    double distCA = Math.sqrt((coordCANew[0] - coordCA[0]) * (coordCANew[0] - coordCA[0]) + (coordCANew[1] - coordCA[1]) * (coordCANew[1] - coordCA[1]) + (coordCANew[2] - coordCA[2]) * (coordCANew[2] - coordCA[2]));
                    if (!(distHN > distThreshold) && !(distCA > distThreshold)) {
                        vecAtomNew.addAll(vecAtomTemp);
                        vecAtomNew.add(new Cartesian("HN", coordNHNew));
                        vecAtomNew.add(new Cartesian("CA", coordCANew));
                        vecAtomSet.add(vecAtomNew);
                    }
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        return vecAtomSet;
    }

    public boolean LoopFirstHalfResPsiGridSearch(int startNo, int endResNo, double nhNextRdc, Vector vecCurFullPdb, Vector vecNextHalfPdb) {
        double rdcRmsdBound = this.rdcThreshold;
        double resolution = 2.0;
        double resol = 0.2;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, startNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, startNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 6;
        double distBtwCa = 8.0;
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(startNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: starting residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbStartOrig = this.vecPdbSSE.elementAt(index);
        Pdb prePdbTemp = this.vecPdbSSE.elementAt(index - 1);
        Vector<Pdb> vecPdbStart = new Vector<Pdb>();
        vecPdbStart.add(prePdbTemp);
        vecPdbStart.add(pdbStartOrig);
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbStart);
        PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(1);
        double phiStart = phipsi.getPhi();
        Pdb pdbStart = this.vecPdbSSE.elementAt(index);
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        Vector<Cartesian> atomVecStart = pdbStart.getAtomVec();
        int k = 0;
        while (k < atomVecStart.size()) {
            Cartesian cc = atomVecStart.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecNextPdbTemp = new Vector<TreePdb>();
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        TreePdb RootPrePdb = new TreePdb(prePdbTemp);
        int j = 0;
        while ((double)j < 360.0 / resolution) {
            block22: {
                double nhRms;
                double sum_rdc;
                Pdb nextHalfPdb;
                Pdb curPdb;
                double rama_score;
                block23: {
                    boolean isKinChain;
                    double psiValue = (double)j * resolution * Math.PI / 180.0;
                    phiS[0] = phiStart;
                    psiS[0] = psiValue;
                    rama_score = 0.0;
                    rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiStart, psiValue, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiStart, psiValue, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiStart, psiValue, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiStart, psiValue, this.vecRamaPrePro) : lp.CompRamachandranScore(phiStart, psiValue, this.vecRamaGeneral))));
                    if (rama_score <= 0.02) break block22;
                    rama_score = -Math.log(rama_score);
                    Vector pdbFragTemp0 = new Vector();
                    pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, startNo, false);
                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                    curPdb = pdbFragTemp.elementAt(0);
                    nextHalfPdb = pdbFragTemp.elementAt(1);
                    Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
                    double[] coordN_next = new double[3];
                    double[] coordNH_next = new double[3];
                    double[] coordCA_next = new double[3];
                    int t = 0;
                    while (t < atomVecNext.size()) {
                        Cartesian cc = atomVecNext.elementAt(t);
                        String atom = cc.getAtom();
                        if (atom.equalsIgnoreCase("N")) {
                            coordN_next = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("CA")) {
                            coordCA_next = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                            coordNH_next = cc.getXYZ();
                        }
                        ++t;
                    }
                    boolean isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_next, 1);
                    if (isClash || !(isKinChain = this.CheckKinChainRestraint(nextHalfPdb, endResNo, 1.0))) break block22;
                    double Sxx = -this.Syy - this.Szz;
                    Vector<Pdb> vecCurPdb = new Vector<Pdb>();
                    Vector<Pdb> vecNextPdb = new Vector<Pdb>();
                    vecCurPdb.add(curPdb);
                    vecNextPdb.add(nextHalfPdb);
                    double[] sRmsdCH = new double[1];
                    int[] sizeCH = new int[1];
                    double[] sRmsdNH = new double[1];
                    int[] sizeNH = new int[1];
                    double[] NhRdcCal = new double[vecCurPdb.size()];
                    double[] ChRdcCal = new double[vecCurPdb.size()];
                    double[][] mat = new double[3][3];
                    Matrix A = new Matrix(3, 3);
                    int x = 0;
                    while (x < 3) {
                        int y = 0;
                        while (y < 3) {
                            mat[x][y] = x == y ? 1.0 : 0.0;
                            ++y;
                        }
                        ++x;
                    }
                    A = new Matrix(mat);
                    sum_rdc = 0.0;
                    nhRms = -99999.9;
                    if (!(nhNextRdc > -1000.0)) break block23;
                    nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                    if (nhRms > rdcRmsdBound) break block22;
                    sum_rdc += nhRms;
                }
                TreePdb curTreePdb = new TreePdb(curPdb);
                curTreePdb.SetNhRdcDif(nhRms);
                curTreePdb.SetSumRdcDif(sum_rdc);
                curTreePdb.SetRamaScore(rama_score);
                RootPrePdb.vecChildPdb.add(curTreePdb);
                curTreePdb.parenPdb.add(RootPrePdb);
                vecCurPdbTemp.add(curTreePdb);
                TreePdb nextHalfTreePdb = new TreePdb(nextHalfPdb);
                nextHalfTreePdb.SetNhRdcDif(nhRms);
                nextHalfTreePdb.SetSumRdcDif(sum_rdc);
                nextHalfTreePdb.SetRamaScore(rama_score);
                curTreePdb.vecChildPdb.add(nextHalfTreePdb);
                nextHalfTreePdb.parenPdb.add(curTreePdb);
                vecNextPdbTemp.add(nextHalfTreePdb);
            }
            ++j;
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClustering(resol, vecCurPdbTemp, vecNextPdbTemp);
        vecNextHalfPdb.addAll(vecNextPdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        return true;
    }

    public boolean LoopLastHalfResPsiGridSearch(int startNo, int endResNo, double nhRdc, double chRdc, Vector vecCurFullPdb, Vector vecPreHalfPdb) {
        double rdcRmsdBound = this.rdcThreshold;
        double resol = 0.2;
        double resolution = 2.0;
        Loops lp = new Loops();
        Model md = new Model();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, endResNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, endResNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 6;
        double distBtwCa = 8.0;
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: starting residue not found...exist...");
            System.exit(0);
        }
        Pdb pdbLast = this.vecPdbSSE.elementAt(index);
        Pdb nextPdbTemp = this.vecPdbSSE.elementAt(index + 1);
        Vector<Pdb> vecPdbLast = new Vector<Pdb>();
        vecPdbLast.add(nextPdbTemp);
        vecPdbLast.add(pdbLast);
        Collections.sort(vecPdbLast, new Pdb.PdbComparator());
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbLast);
        PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(0);
        double psiLast = phipsi.getPsi();
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        Vector<Cartesian> atomVecStart = nextPdbTemp.getAtomVec();
        int k = 0;
        while (k < atomVecStart.size()) {
            Cartesian cc = atomVecStart.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecPrePdbTemp = new Vector<TreePdb>();
        TreePdb RootPrePdb = new TreePdb(nextPdbTemp);
        int j = 0;
        while ((double)j < 360.0 / resolution) {
            block21: {
                double chRms;
                double nhRms;
                double sum_rdc;
                Pdb preHalfPdb;
                Pdb curPdb;
                double rama_score;
                block23: {
                    Matrix A;
                    double[] ChRdcCal;
                    int[] sizeCH;
                    double[] sRmsdCH;
                    Vector<Pdb> vecCurPdb;
                    double Sxx;
                    block22: {
                        boolean isKinChain;
                        double phiValue = (double)j * resolution * Math.PI / 180.0;
                        rama_score = 0.0;
                        rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phiValue, psiLast, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phiValue, psiLast, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phiValue, psiLast, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phiValue, psiLast, this.vecRamaPrePro) : lp.CompRamachandranScore(phiValue, psiLast, this.vecRamaGeneral))));
                        if (rama_score <= 0.02) break block21;
                        rama_score = -Math.log(rama_score);
                        Vector pdbFragTemp0 = new Vector();
                        pdbFragTemp0 = mdc.coordByBackwardNew(phiValue, psiLast, coordN, coordNH, coordCA, endResNo);
                        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                        curPdb = pdbFragTemp.elementAt(1);
                        preHalfPdb = pdbFragTemp.elementAt(0);
                        Vector<Cartesian> atomVecPre = preHalfPdb.getAtomVec();
                        double[] coordN_pre = new double[3];
                        double[] coordNH_pre = new double[3];
                        double[] coordCA_pre = new double[3];
                        int t = 0;
                        while (t < atomVecPre.size()) {
                            Cartesian cc = atomVecPre.elementAt(t);
                            String atom = cc.getAtom();
                            if (atom.equalsIgnoreCase("N")) {
                                coordN_pre = cc.getXYZ();
                            } else if (atom.equalsIgnoreCase("CA")) {
                                coordCA_pre = cc.getXYZ();
                            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                coordNH_pre = cc.getXYZ();
                            }
                            ++t;
                        }
                        boolean isClash = this.CheckClashBtwRotCaNSSEsNew(coordCA_pre, 1);
                        if (isClash || !(isKinChain = this.CheckKinChainRestraintBackward(preHalfPdb, startNo, 0.2))) break block21;
                        Sxx = -this.Syy - this.Szz;
                        vecCurPdb = new Vector<Pdb>();
                        vecCurPdb.add(curPdb);
                        sRmsdCH = new double[1];
                        sizeCH = new int[1];
                        double[] sRmsdNH = new double[1];
                        int[] sizeNH = new int[1];
                        double[] NhRdcCal = new double[vecCurPdb.size()];
                        ChRdcCal = new double[vecCurPdb.size()];
                        double[][] mat = new double[3][3];
                        A = new Matrix(3, 3);
                        int x = 0;
                        while (x < 3) {
                            int y = 0;
                            while (y < 3) {
                                mat[x][y] = x == y ? 1.0 : 0.0;
                                ++y;
                            }
                            ++x;
                        }
                        A = new Matrix(mat);
                        sum_rdc = 0.0;
                        nhRms = -99999.9;
                        chRms = -99999.9;
                        if (!(nhRdc > -100.0)) break block22;
                        nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H", A, Sxx, this.Syy, this.Szz, 1.0, NhRdcCal, sRmsdNH, sizeNH);
                        if (nhRms > rdcRmsdBound) break block21;
                        sum_rdc += nhRms;
                    }
                    if (!(chRdc > -100.0)) break block23;
                    chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx, this.Syy, this.Szz, 1.0, ChRdcCal, sRmsdCH, sizeCH);
                    if (chRms > rdcRmsdBound) break block21;
                    sum_rdc += chRms;
                }
                TreePdb curTreePdb = new TreePdb(curPdb);
                curTreePdb.SetNhRdcDif(nhRms);
                curTreePdb.SetChRdcDif(chRms);
                curTreePdb.SetSumRdcDif(sum_rdc);
                curTreePdb.SetRamaScore(rama_score);
                RootPrePdb.vecChildPdb.add(curTreePdb);
                curTreePdb.parenPdb.add(RootPrePdb);
                vecCurPdbTemp.add(curTreePdb);
                TreePdb preHalfTreePdb = new TreePdb(preHalfPdb);
                preHalfTreePdb.SetNhRdcDif(nhRms);
                preHalfTreePdb.SetChRdcDif(chRms);
                preHalfTreePdb.SetSumRdcDif(sum_rdc);
                preHalfTreePdb.SetRamaScore(rama_score);
                curTreePdb.vecChildPdb.add(preHalfTreePdb);
                preHalfTreePdb.parenPdb.add(curTreePdb);
                vecPrePdbTemp.add(preHalfTreePdb);
            }
            ++j;
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClusteringBackward(resol, vecCurPdbTemp, vecPrePdbTemp);
        vecPreHalfPdb.addAll(vecPrePdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        return true;
    }

    public boolean CheckLastResidueOld(Pdb nextHalfPdb, int endResNo, double error, double[] dist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordN_next = new double[3];
        double[] coordNH_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] nEnd = new double[3];
        double[] hnEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_n = Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) + (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) + (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_hn = Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) + (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) + (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
        if (distance_n < error && distance_ca < error && distance_hn < error) {
            isClose = true;
        }
        dist[0] = (distance_n + distance_ca + distance_hn) / 3.0;
        return isClose;
    }

    public boolean CheckLastResidue(Pdb nextHalfPdb, int endResNo, double error, double[] dist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordCO_next = new double[3];
        double[] coordC_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coordCO_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                coordC_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] coEnd = new double[3];
        double[] cEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                cEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_co = Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) + (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) + (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_c = Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) + (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) + (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
        if (distance_co < error && distance_ca < error && distance_c < error) {
            isClose = true;
        }
        dist[0] = (distance_co + distance_ca + distance_c) / 3.0;
        return isClose;
    }

    public boolean CheckLastResidue(Pdb nextHalfPdb, int endResNo, double error, double[] dist, double[] distCa) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordCO_next = new double[3];
        double[] coordC_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coordCO_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                coordC_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] coEnd = new double[3];
        double[] cEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                cEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_co = Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) + (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) + (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_c = Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) + (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) + (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
        if (distance_co < error && distance_ca < error && distance_c < error) {
            isClose = true;
        }
        dist[0] = (distance_co + distance_ca + distance_c) / 3.0;
        distCa[0] = distance_ca;
        return isClose;
    }

    public boolean CheckLastResidueOld(Pdb nextHalfPdb, int endResNo, double error, double[] dist, double[] distCa) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordN_next = new double[3];
        double[] coordNH_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] nEnd = new double[3];
        double[] hnEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_n = Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) + (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) + (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_hn = Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) + (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) + (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
        if (distance_n < error && distance_ca < error && distance_hn < error) {
            isClose = true;
        }
        dist[0] = (distance_n + distance_ca + distance_hn) / 3.0;
        distCa[0] = distance_ca;
        return isClose;
    }

    public boolean CheckFirstResidue(Pdb preHalfPdb, int fixNo, double error, double[] dist, double[] caDist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = preHalfPdb.getAtomVec();
        double[] coordN_next = new double[3];
        double[] coordNH_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] nEnd = new double[3];
        double[] hnEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_n = Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) + (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) + (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_hn = Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) + (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) + (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
        if (distance_n < error && distance_ca < error && distance_hn < error) {
            isClose = true;
        }
        dist[0] = (distance_n + distance_ca + distance_hn) / 3.0;
        caDist[0] = distance_ca;
        return isClose;
    }

    public boolean CheckFirstResidue(Pdb preHalfPdb, int fixNo, double error, double[] dist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = preHalfPdb.getAtomVec();
        double[] coordN_next = new double[3];
        double[] coordNH_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] nEnd = new double[3];
        double[] hnEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_n = Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) + (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) + (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_hn = Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) + (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) + (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
        if (distance_n < error && distance_ca < error && distance_hn < error) {
            isClose = true;
        }
        dist[0] = (distance_n + distance_ca + distance_hn) / 3.0;
        return isClose;
    }

    public boolean CheckFirstResidueOld(Pdb preHalfPdb, int fixNo, double error, double[] dist, double[] caDist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = preHalfPdb.getAtomVec();
        double[] coordCO_next = new double[3];
        double[] coordC_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coordCO_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                coordC_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] coEnd = new double[3];
        double[] cEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                cEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_co = Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) + (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) + (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_c = Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) + (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) + (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
        if (distance_co < error && distance_ca < error && distance_c < error) {
            isClose = true;
        }
        dist[0] = (distance_co + distance_ca + distance_c) / 3.0;
        caDist[0] = distance_ca;
        return isClose;
    }

    public boolean CheckFirstResidueOld(Pdb preHalfPdb, int fixNo, double error, double[] dist) {
        dist[0] = 0.0;
        Vector<Cartesian> atomVecNext = preHalfPdb.getAtomVec();
        double[] coordCO_next = new double[3];
        double[] coordC_next = new double[3];
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coordCO_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                coordC_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        double[] coEnd = new double[3];
        double[] cEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                coEnd = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                cEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isClose = false;
        double distance_co = Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) + (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) + (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        double distance_c = Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) + (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) + (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
        if (distance_co < error && distance_ca < error && distance_c < error) {
            isClose = true;
        }
        dist[0] = (distance_co + distance_ca + distance_c) / 3.0;
        return isClose;
    }

    public boolean CheckKinChainRestraint(Pdb nextHalfPdb, int endResNo, double error) {
        int curNo = nextHalfPdb.getResidueNo();
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isSatisfied = false;
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        if (distance_ca < 3.8 * (double)Math.abs(endResNo - curNo) + error) {
            isSatisfied = true;
        }
        return isSatisfied;
    }

    public boolean CheckKinChainRestraintBackward(Pdb nextHalfPdb, int startResNo, double error) {
        int curNo = nextHalfPdb.getResidueNo();
        Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
        double[] coordCA_next = new double[3];
        int t = 0;
        while (t < atomVecNext.size()) {
            Cartesian cc = atomVecNext.elementAt(t);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                coordCA_next = cc.getXYZ();
            }
            ++t;
        }
        double[] caEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(startResNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbEnd = this.vecPdbSSE.elementAt(index);
        Vector<Cartesian> vecAtomEnd = pdbEnd.getAtomVec();
        int j = 0;
        while (j < vecAtomEnd.size()) {
            Cartesian cc = vecAtomEnd.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caEnd = cc.getXYZ();
            }
            ++j;
        }
        boolean isSatisfied = false;
        double distance_ca = Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) + (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) + (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));
        if (distance_ca < 3.8 * (double)Math.abs(startResNo - curNo) + error) {
            isSatisfied = true;
        }
        return isSatisfied;
    }

    public Vector OutputEnsemblePdbs(Vector vecFinalTreePdb, int noStart, int noEnd, double distUpCa) {
        double ave_nhRMSD = 0.0;
        double ave_chRMSD = 0.0;
        Pdb pp = new Pdb();
        int maxCount = -99999;
        Vector vecPdbSave = new Vector();
        double max_nhRMSD = -99999.9;
        double min_nhRMSD = 99999.9;
        double max_chRMSD = -99999.9;
        double min_chRMSD = 99999.9;
        int i = 0;
        while (i < vecFinalTreePdb.size()) {
            int nhRdcCount = 0;
            int chRdcCount = 0;
            double sum_nhRdc = 0.0;
            double sum_chRdc = 0.0;
            Vector<Pdb> vecLoopFrag = new Vector<Pdb>();
            TreePdb treePdb = (TreePdb)vecFinalTreePdb.elementAt(i);
            double rama_score = treePdb.GetRamaScore();
            double nhRdcDif = treePdb.GetNhRdcDif();
            double chRdcDif = treePdb.GetChRdcDif();
            if (nhRdcDif > -100.0) {
                sum_nhRdc += nhRdcDif * nhRdcDif;
                ++nhRdcCount;
            }
            if (chRdcDif > -100.0) {
                sum_chRdc += chRdcDif * chRdcDif;
                ++chRdcCount;
            }
            double endDist = treePdb.GetEndDist();
            int resNo = treePdb.pdb.getResidueNo();
            TreePdb treePdbEnd = (TreePdb)treePdb.vecChildPdb.elementAt(0);
            while (resNo >= noStart) {
                vecLoopFrag.add(treePdb.pdb);
                if (resNo == noStart) break;
                treePdb = (TreePdb)treePdb.parenPdb.elementAt(0);
                resNo = treePdb.pdb.getResidueNo();
                nhRdcDif = treePdb.GetNhRdcDif();
                chRdcDif = treePdb.GetChRdcDif();
                if (nhRdcDif > -1000.0) {
                    sum_nhRdc += nhRdcDif * nhRdcDif;
                    ++nhRdcCount;
                }
                if (!(chRdcDif > -1000.0)) continue;
                sum_chRdc += chRdcDif * chRdcDif;
                ++chRdcCount;
            }
            Collections.sort(vecLoopFrag, new Pdb.PdbComparator());
            int counter = 0;
            int j = 0;
            while (j < this.vecAmbNOEs.size()) {
                boolean isSatisfied = false;
                Noe noe = this.vecAmbNOEs.elementAt(j);
                int resNoA = noe.getResidueNoA();
                int resNoB = noe.getResidueNoB();
                int k = 0;
                while (k < vecLoopFrag.size()) {
                    Pdb pdbLoop = (Pdb)vecLoopFrag.elementAt(k);
                    int resNoLoop = pdbLoop.getResidueNo();
                    if (resNoLoop == resNoA || resNoLoop == resNoB) {
                        Vector<Cartesian> vecAtomLoop = pdbLoop.getAtomVec();
                        double[] caLoop = new double[3];
                        int kk = 0;
                        while (kk < vecAtomLoop.size()) {
                            Cartesian cc = vecAtomLoop.elementAt(kk);
                            String atom = cc.getAtom();
                            if (atom.equalsIgnoreCase("CA")) {
                                caLoop = cc.getXYZ();
                            }
                            ++kk;
                        }
                        int t = 0;
                        while (t < this.vecPdbSSE.size()) {
                            Pdb pdbSSE = this.vecPdbSSE.elementAt(t);
                            int resNoSSE = pdbSSE.getResidueNo();
                            if (resNoSSE == resNoA || resNoSSE == resNoB) {
                                double distance;
                                Vector<Cartesian> vecAtomSSE = pdbSSE.getAtomVec();
                                double[] caSSE = new double[3];
                                int tt = 0;
                                while (tt < vecAtomSSE.size()) {
                                    Cartesian cc = vecAtomSSE.elementAt(tt);
                                    String atom = cc.getAtom();
                                    if (atom.equalsIgnoreCase("CA")) {
                                        caSSE = cc.getXYZ();
                                    }
                                    ++tt;
                                }
                                if ((resNoSSE == resNoA && resNoLoop == resNoB || resNoSSE == resNoB && resNoLoop == resNoA) && (distance = Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) + (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) + (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]))) < distUpCa) {
                                    isSatisfied = true;
                                    break;
                                }
                            }
                            ++t;
                        }
                        if (isSatisfied) break;
                    }
                    ++k;
                }
                if (isSatisfied) {
                    ++counter;
                }
                ++j;
            }
            boolean isRepeated = false;
            int t = 0;
            while (t < vecPdbSave.size()) {
                Vector vecPdbTemp = (Vector)vecPdbSave.elementAt(t);
                if (vecPdbTemp.equals(vecLoopFrag)) {
                    isRepeated = true;
                    break;
                }
                ++t;
            }
            if (!isRepeated) {
                System.out.println("REMARK number of statisfied NOEs for the " + (i + 1) + " th solution: " + counter);
                System.out.println("REMARK distance between end residues: " + endDist);
                System.out.println("REMARK rama score: " + rama_score);
                System.out.println("REMARK NH RDC RMSD: " + Math.sqrt(sum_nhRdc / (double)nhRdcCount));
                System.out.println("REMARK CH RDC RMSD: " + Math.sqrt(sum_chRdc / (double)chRdcCount));
                System.out.println("REMARK :  =========================  ");
                System.out.println("TER");
                pp.print(vecLoopFrag);
                if (vecLoopFrag.size() > 0) {
                    vecPdbSave.add(vecLoopFrag);
                }
                ave_nhRMSD += Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                ave_chRMSD += Math.sqrt(sum_chRdc / (double)chRdcCount);
                if (max_nhRMSD < Math.sqrt(sum_nhRdc / (double)nhRdcCount)) {
                    max_nhRMSD = Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                }
                if (min_nhRMSD > Math.sqrt(sum_nhRdc / (double)nhRdcCount)) {
                    min_nhRMSD = Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                }
                if (max_chRMSD < Math.sqrt(sum_chRdc / (double)chRdcCount)) {
                    max_chRMSD = Math.sqrt(sum_chRdc / (double)chRdcCount);
                }
                if (min_chRMSD > Math.sqrt(sum_chRdc / (double)chRdcCount)) {
                    min_chRMSD = Math.sqrt(sum_chRdc / (double)chRdcCount);
                }
            }
            ++i;
        }
        System.out.println("REMARK NH RDCs: average RMSD= " + (ave_nhRMSD /= (double)vecFinalTreePdb.size()) + " ; Dev =" + Math.max(Math.abs(ave_nhRMSD - max_nhRMSD), Math.abs(ave_nhRMSD - min_nhRMSD)));
        System.out.println("REMARK CH RDCs: average RMSD= " + (ave_chRMSD /= (double)vecFinalTreePdb.size()) + " ; Dev =" + Math.max(Math.abs(ave_chRMSD - max_chRMSD), Math.abs(ave_chRMSD - min_chRMSD)));
        return vecPdbSave;
    }

    public Vector OutputEnsemblePdbsBackward(Vector vecFinalTreePdb, int noStart, int noEnd, double distUpCa) {
        double ave_nhRMSD = 0.0;
        double ave_chRMSD = 0.0;
        double max_nhRMSD = -99999.9;
        double min_nhRMSD = 99999.9;
        double max_chRMSD = -99999.9;
        double min_chRMSD = 99999.9;
        Pdb pp = new Pdb();
        int maxCount = -99999;
        Vector vecPdbSave = new Vector();
        int i = 0;
        while (i < vecFinalTreePdb.size()) {
            int nhRdcCount = 0;
            int chRdcCount = 0;
            double sum_nhRdc = 0.0;
            double sum_chRdc = 0.0;
            Vector<Pdb> vecLoopFrag = new Vector<Pdb>();
            TreePdb treePdb = (TreePdb)vecFinalTreePdb.elementAt(i);
            double rama_score = treePdb.GetRamaScore();
            double nhRdcDif = treePdb.GetNhRdcDif();
            double chRdcDif = treePdb.GetChRdcDif();
            if (nhRdcDif > -100.0) {
                sum_nhRdc += nhRdcDif * nhRdcDif;
                ++nhRdcCount;
            }
            if (chRdcDif > -100.0) {
                sum_chRdc += chRdcDif * chRdcDif;
                ++chRdcCount;
            }
            double endDist = treePdb.GetEndDist();
            int resNo = treePdb.pdb.getResidueNo();
            TreePdb treePdbEnd = (TreePdb)treePdb.vecChildPdb.elementAt(0);
            while (resNo <= noEnd) {
                vecLoopFrag.add(treePdb.pdb);
                if (resNo == noEnd) break;
                treePdb = (TreePdb)treePdb.parenPdb.elementAt(0);
                resNo = treePdb.pdb.getResidueNo();
                nhRdcDif = treePdb.GetNhRdcDif();
                chRdcDif = treePdb.GetChRdcDif();
                if (nhRdcDif > -100.0) {
                    sum_nhRdc += nhRdcDif * nhRdcDif;
                    ++nhRdcCount;
                }
                if (!(chRdcDif > -100.0)) continue;
                sum_chRdc += chRdcDif * chRdcDif;
                ++chRdcCount;
            }
            Collections.sort(vecLoopFrag, new Pdb.PdbComparator());
            int counter = 0;
            int j = 0;
            while (j < this.vecAmbNOEs.size()) {
                boolean isSatisfied = false;
                Noe noe = this.vecAmbNOEs.elementAt(j);
                int resNoA = noe.getResidueNoA();
                int resNoB = noe.getResidueNoB();
                int k = 0;
                while (k < vecLoopFrag.size()) {
                    Pdb pdbLoop = (Pdb)vecLoopFrag.elementAt(k);
                    int resNoLoop = pdbLoop.getResidueNo();
                    if (resNoLoop == resNoA || resNoLoop == resNoB) {
                        Vector<Cartesian> vecAtomLoop = pdbLoop.getAtomVec();
                        double[] caLoop = new double[3];
                        int kk = 0;
                        while (kk < vecAtomLoop.size()) {
                            Cartesian cc = vecAtomLoop.elementAt(kk);
                            String atom = cc.getAtom();
                            if (atom.equalsIgnoreCase("CA")) {
                                caLoop = cc.getXYZ();
                            }
                            ++kk;
                        }
                        int t = 0;
                        while (t < this.vecPdbSSE.size()) {
                            Pdb pdbSSE = this.vecPdbSSE.elementAt(t);
                            int resNoSSE = pdbSSE.getResidueNo();
                            if (resNoSSE == resNoA || resNoSSE == resNoB) {
                                double distance;
                                Vector<Cartesian> vecAtomSSE = pdbSSE.getAtomVec();
                                double[] caSSE = new double[3];
                                int tt = 0;
                                while (tt < vecAtomSSE.size()) {
                                    Cartesian cc = vecAtomSSE.elementAt(tt);
                                    String atom = cc.getAtom();
                                    if (atom.equalsIgnoreCase("CA")) {
                                        caSSE = cc.getXYZ();
                                    }
                                    ++tt;
                                }
                                if ((resNoSSE == resNoA && resNoLoop == resNoB || resNoSSE == resNoB && resNoLoop == resNoA) && (distance = Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) + (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) + (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]))) < distUpCa) {
                                    isSatisfied = true;
                                    break;
                                }
                            }
                            ++t;
                        }
                        if (isSatisfied) break;
                    }
                    ++k;
                }
                if (isSatisfied) {
                    ++counter;
                }
                ++j;
            }
            boolean isRepeated = false;
            int t = 0;
            while (t < vecPdbSave.size()) {
                Vector vecPdbTemp = (Vector)vecPdbSave.elementAt(t);
                if (vecPdbTemp.equals(vecLoopFrag)) {
                    isRepeated = true;
                    break;
                }
                ++t;
            }
            if (!isRepeated) {
                System.out.println("REMARK number of statisfied NOEs for the " + (i + 1) + " th solution: " + counter);
                System.out.println("REMARK distance between end residues: " + endDist);
                System.out.println("REMARK rama score: " + rama_score);
                System.out.println("REMARK NH RDC RMSD: " + Math.sqrt(sum_nhRdc / (double)nhRdcCount));
                System.out.println("REMARK CH RDC RMSD: " + Math.sqrt(sum_chRdc / (double)chRdcCount));
                System.out.println("REMARK :  =========================  ");
                System.out.println("TER");
                pp.print(vecLoopFrag);
                System.out.println("TER");
                if (vecLoopFrag.size() > 0) {
                    vecPdbSave.add(vecLoopFrag);
                }
                ave_nhRMSD += Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                ave_chRMSD += Math.sqrt(sum_chRdc / (double)chRdcCount);
                if (max_nhRMSD < Math.sqrt(sum_nhRdc / (double)nhRdcCount)) {
                    max_nhRMSD = Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                }
                if (min_nhRMSD > Math.sqrt(sum_nhRdc / (double)nhRdcCount)) {
                    min_nhRMSD = Math.sqrt(sum_nhRdc / (double)nhRdcCount);
                }
                if (max_chRMSD < Math.sqrt(sum_chRdc / (double)chRdcCount)) {
                    max_chRMSD = Math.sqrt(sum_chRdc / (double)chRdcCount);
                }
                if (min_chRMSD > Math.sqrt(sum_chRdc / (double)chRdcCount)) {
                    min_chRMSD = Math.sqrt(sum_chRdc / (double)chRdcCount);
                }
            }
            ++i;
        }
        System.out.println("REMARK NH RDCs: average RMSD= " + (ave_nhRMSD /= (double)vecFinalTreePdb.size()) + " ; Dev =" + Math.max(Math.abs(ave_nhRMSD - max_nhRMSD), Math.abs(ave_nhRMSD - min_nhRMSD)));
        System.out.println("REMARK CH RDCs: average RMSD= " + (ave_chRMSD /= (double)vecFinalTreePdb.size()) + " ; Dev =" + Math.max(Math.abs(ave_chRMSD - max_chRMSD), Math.abs(ave_chRMSD - min_chRMSD)));
        return vecPdbSave;
    }

    public Vector LoopAllComputation(int noStart, int noEnd) {
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        Vector vecPdbLoop = new Vector();
        String resStart = "";
        String resEnd = "";
        Vector<Object> vecAtomStart = new Vector();
        Vector vecAtomEnd = new Vector();
        double[] caStart = new double[3];
        double[] nStart = new double[3];
        double[] hnStart = new double[3];
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbStart = this.vecPdbSSE.elementAt(index);
        resStart = pdbStart.getResidue();
        vecAtomStart = pdbStart.getAtomVec();
        int j = 0;
        while (j < vecAtomStart.size()) {
            Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caStart = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nStart = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnStart = cc.getXYZ();
            }
            ++j;
        }
        Pdb prePdbTemp = this.vecPdbSSE.elementAt(index - 1);
        Vector<Pdb> vecPdbStart = new Vector<Pdb>();
        vecPdbStart.add(prePdbTemp);
        vecPdbStart.add(pdbStart);
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbStart);
        PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(1);
        phiS[0] = phipsi.getPhi();
        psiS[0] = phipsi.getPsi();
        Vector pdbFragTemp0 = mdc.modelBuild(phiS, psiS, nStart, hnStart, caStart, noStart, false);
        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
        Pdb curHalfPdb = pdbFragTemp.elementAt(1);
        Vector vecAllPdbs = new Vector();
        Vector<TreePdb> vecCurHalfPdb = new Vector<TreePdb>();
        TreePdb startTreePdb = new TreePdb(pdbStart);
        TreePdb curHalfTreePdb = new TreePdb(curHalfPdb);
        startTreePdb.vecChildPdb.add(curHalfTreePdb);
        curHalfTreePdb.parenPdb.add(startTreePdb);
        Vector vecFinalPdb = new Vector();
        vecCurHalfPdb.add(curHalfTreePdb);
        int curResNo = noStart;
        Vector vecNextHalfPdb = new Vector();
        Vector vecCurFullPdb = new Vector();
        boolean isLast = false;
        boolean isSolution = false;
        while (curResNo <= noEnd) {
            int indNH;
            if (curResNo == noEnd) {
                isLast = true;
            }
            vecNextHalfPdb = new Vector();
            vecCurFullPdb = new Vector();
            boolean isMissing = false;
            double chRdc = -99999.9;
            double nhNextRdc = -99999.9;
            int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
            if (indCH > -1) {
                chRdc = this.vecChRDC.elementAt(indCH).getRdc();
            }
            if ((indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo + 1), new Dipolar.rdcComparator())) > -1) {
                nhNextRdc = this.vecNhRDC.elementAt(indNH).getRdc();
            }
            if (curResNo == noStart) {
                isSolution = this.LoopFirstHalfResPsiGridSearch(curResNo, noEnd, nhNextRdc, vecCurFullPdb, vecNextHalfPdb);
            } else if (this.isAllGridSearch) {
                isSolution = this.LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast);
            } else if (indCH < 0 || indNH < 0) {
                isSolution = this.LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast);
            } else {
                isSolution = this.LoopCurResPhiPsiExactSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast);
                if (!isSolution) {
                    isSolution = this.LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast);
                }
            }
            vecAllPdbs.add(vecCurFullPdb);
            vecCurHalfPdb = new Vector();
            vecCurHalfPdb.addAll(vecNextHalfPdb);
            vecNextHalfPdb = new Vector();
            if (!isSolution) {
                System.out.println("Solution not found for forward computation...");
                return vecPdbLoop;
            }
            System.out.println("debugging...residue num: " + curResNo);
            System.out.println("debugging...num of soutions: " + vecCurFullPdb.size());
            ++curResNo;
        }
        Vector vecLoopsNew2 = new Vector();
        if (isSolution) {
            Vector vecFinalTreePdb = (Vector)vecAllPdbs.elementAt(vecAllPdbs.size() - 1);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are the ensemble of structures computed in a forward way. ");
            System.out.println("REMARK :  =========================  ");
            vecLoopsNew2 = this.OutputEnsemblePdbs(vecFinalTreePdb, noStart, noEnd, 8.0);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are the fixed SSEs: ");
            System.out.println("REMARK :  =========================  ");
            System.out.println("TER");
            System.out.println("END");
        } else {
            System.out.println("No solution is found...");
        }
        return vecLoopsNew2;
    }

    public Vector LoopAllComputationBiDirection(int noStart, int noEnd) {
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        Vector vecPdbLoop = new Vector();
        String resStart = "";
        String resEnd = "";
        Vector<Object> vecAtomStart = new Vector();
        Vector vecAtomEnd = new Vector();
        double[] caStart = new double[3];
        double[] nStart = new double[3];
        double[] hnStart = new double[3];
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbStart = this.vecPdbSSE.elementAt(index);
        resStart = pdbStart.getResidue();
        vecAtomStart = pdbStart.getAtomVec();
        int j = 0;
        while (j < vecAtomStart.size()) {
            Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caStart = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nStart = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnStart = cc.getXYZ();
            }
            ++j;
        }
        Pdb prePdbTemp = this.vecPdbSSE.elementAt(index - 1);
        Vector<Pdb> vecPdbStart = new Vector<Pdb>();
        vecPdbStart.add(prePdbTemp);
        vecPdbStart.add(pdbStart);
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbStart);
        PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(1);
        phiS[0] = phipsi.getPhi();
        psiS[0] = phipsi.getPsi();
        Vector pdbFragTemp0 = mdc.modelBuild(phiS, psiS, nStart, hnStart, caStart, noStart, false);
        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
        Pdb curHalfPdb = pdbFragTemp.elementAt(1);
        Vector vecAllPdbs = new Vector();
        Vector<TreePdb> vecCurHalfPdb = new Vector<TreePdb>();
        TreePdb startTreePdb = new TreePdb(pdbStart);
        TreePdb curHalfTreePdb = new TreePdb(curHalfPdb);
        startTreePdb.vecChildPdb.add(curHalfTreePdb);
        curHalfTreePdb.parenPdb.add(startTreePdb);
        Vector vecFinalPdb = new Vector();
        vecCurHalfPdb.add(curHalfTreePdb);
        int curResNo = noStart;
        Vector vecNextHalfPdb = new Vector();
        Vector vecCurFullPdb = new Vector();
        boolean isLast = false;
        boolean isSolution = false;
        while (curResNo < noEnd) {
            int indNH;
            if (curResNo == noEnd - 1) {
                isLast = true;
            }
            vecNextHalfPdb = new Vector();
            vecCurFullPdb = new Vector();
            boolean isMissing = false;
            double chRdc = -99999.9;
            double nhNextRdc = -99999.9;
            int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
            if (indCH > -1) {
                chRdc = this.vecChRDC.elementAt(indCH).getRdc();
            }
            if ((indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo + 1), new Dipolar.rdcComparator())) > -1) {
                nhNextRdc = this.vecNhRDC.elementAt(indNH).getRdc();
            }
            isSolution = curResNo == noStart ? this.LoopFirstHalfResPsiGridSearch(curResNo, noEnd, nhNextRdc, vecCurFullPdb, vecNextHalfPdb) : (indCH < 0 || indNH < 0 ? this.LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast) : this.LoopCurResPhiPsiExactSearch(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhNextRdc, vecCurFullPdb, vecNextHalfPdb, isLast));
            vecAllPdbs.add(vecCurFullPdb);
            vecCurHalfPdb = new Vector();
            vecCurHalfPdb.addAll(vecNextHalfPdb);
            vecNextHalfPdb = new Vector();
            if (!isSolution) {
                System.out.println("No solution found for forward computation for residue: " + curResNo);
                break;
            }
            System.out.println("debugging...residue num: " + curResNo);
            System.out.println("debugging...num of soutions: " + vecCurFullPdb.size());
            ++curResNo;
        }
        Vector vecLoopsNew = new Vector();
        if (isSolution) {
            Vector vecFinalTreePdb = (Vector)vecAllPdbs.elementAt(vecAllPdbs.size() - 1);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are ensemble of structures computed in a forward way. ");
            System.out.println("REMARK :  =========================  ");
            vecLoopsNew = this.OutputEnsemblePdbs(vecFinalTreePdb, noStart, noEnd, 8.0);
        }
        isSolution = false;
        boolean isFirst = false;
        curResNo = noEnd;
        Vector vecAllPdbsBackward = new Vector();
        while (curResNo > noStart) {
            int indNH;
            if (curResNo == noStart + 1) {
                isFirst = true;
            }
            vecNextHalfPdb = new Vector();
            vecCurFullPdb = new Vector();
            boolean isMissing = false;
            double chRdc = -99999.9;
            double nhRdc = -99999.9;
            int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
            if (indCH > -1) {
                chRdc = this.vecChRDC.elementAt(indCH).getRdc();
            }
            if ((indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo), new Dipolar.rdcComparator())) > -1) {
                nhRdc = this.vecNhRDC.elementAt(indNH).getRdc();
            }
            isSolution = curResNo == noEnd ? this.LoopLastHalfResPsiGridSearch(noStart, noEnd, nhRdc, chRdc, vecCurFullPdb, vecNextHalfPdb) : (indCH < 0 || indNH < 0 ? this.LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst) : this.LoopCurResPhiPsiExactSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst));
            vecAllPdbsBackward.add(vecCurFullPdb);
            vecCurHalfPdb = new Vector();
            vecCurHalfPdb.addAll(vecNextHalfPdb);
            vecNextHalfPdb = new Vector();
            if (!isSolution) {
                System.out.println("No solution found for backward computation for residue: " + curResNo);
                break;
            }
            System.out.println("debugging...residue num: " + curResNo);
            System.out.println("debugging...num of soutions: " + vecCurFullPdb.size());
            --curResNo;
        }
        Vector vecLoopsNew2 = new Vector();
        if (isSolution) {
            Vector vecFinalTreePdbBackward = (Vector)vecAllPdbsBackward.elementAt(vecAllPdbsBackward.size() - 1);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are ensemble of structures computed in a Backward way. ");
            System.out.println("REMARK :  =========================  ");
            vecLoopsNew2 = this.OutputEnsemblePdbsBackward(vecFinalTreePdbBackward, noStart, noEnd, 8.0);
        }
        System.out.println("REMARK :  =========================  ");
        System.out.println("REMARK : Here are ensemble of combined structures. ");
        System.out.println("REMARK :  =========================  ");
        int noMiddle = (noEnd + noStart) / 2;
        Vector vecFinalEnsemble = new Vector();
        if (vecLoopsNew.size() > 0 && vecLoopsNew2.size() > 0) {
            vecFinalEnsemble = vecLoopsNew.size() > vecLoopsNew2.size() ? this.MergeTwoFragmentIntoOne(vecLoopsNew2, vecLoopsNew, 0.2, noStart, noEnd, noMiddle, false) : this.MergeTwoFragmentIntoOne(vecLoopsNew, vecLoopsNew2, 0.2, noStart, noEnd, noMiddle, true);
        } else if (vecLoopsNew.size() > 0) {
            vecFinalEnsemble.addAll(vecLoopsNew);
        } else {
            vecFinalEnsemble.addAll(vecLoopsNew2);
        }
        pp.print(this.vecPdbSSE);
        System.out.println("TER");
        int i2 = 0;
        while (i2 < vecFinalEnsemble.size()) {
            Vector vecPdb = (Vector)vecFinalEnsemble.elementAt(i2);
            pp.print(vecPdb);
            System.out.println("TER");
            ++i2;
        }
        System.out.println("END");
        return vecPdbLoop;
    }

    public Vector LoopAllComputationBackward(int noStart, int noEnd) {
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        String resStart = "";
        String resEnd = "";
        Vector<Object> vecAtomStart = new Vector();
        Vector vecAtomEnd = new Vector();
        double[] caStart = new double[3];
        double[] nStart = new double[3];
        double[] hnStart = new double[3];
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: loop ends not found...exist...");
            System.exit(0);
        }
        Pdb pdbStart = this.vecPdbSSE.elementAt(index);
        resStart = pdbStart.getResidue();
        vecAtomStart = pdbStart.getAtomVec();
        int j = 0;
        while (j < vecAtomStart.size()) {
            Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("CA")) {
                caStart = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nStart = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnStart = cc.getXYZ();
            }
            ++j;
        }
        Pdb prePdbTemp = this.vecPdbSSE.elementAt(index - 1);
        Vector<Pdb> vecPdbStart = new Vector<Pdb>();
        vecPdbStart.add(prePdbTemp);
        vecPdbStart.add(pdbStart);
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbStart);
        PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(1);
        phiS[0] = phipsi.getPhi();
        psiS[0] = phipsi.getPsi();
        Vector pdbFragTemp0 = mdc.modelBuild(phiS, psiS, nStart, hnStart, caStart, noStart, false);
        Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
        Pdb curHalfPdb = pdbFragTemp.elementAt(1);
        Vector vecAllPdbs = new Vector();
        Vector<TreePdb> vecCurHalfPdb = new Vector<TreePdb>();
        TreePdb startTreePdb = new TreePdb(pdbStart);
        TreePdb curHalfTreePdb = new TreePdb(curHalfPdb);
        startTreePdb.vecChildPdb.add(curHalfTreePdb);
        curHalfTreePdb.parenPdb.add(startTreePdb);
        Vector vecFinalPdb = new Vector();
        vecCurHalfPdb.add(curHalfTreePdb);
        int curResNo = noStart;
        Vector vecNextHalfPdb = new Vector();
        Vector vecCurFullPdb = new Vector();
        boolean isSolution = false;
        boolean isFirst = false;
        curResNo = noEnd;
        Vector vecAllPdbsBackward = new Vector();
        while (curResNo >= noStart) {
            int indNH;
            if (curResNo == noStart) {
                isFirst = true;
            }
            vecNextHalfPdb = new Vector();
            vecCurFullPdb = new Vector();
            boolean isMissing = false;
            double chRdc = -99999.9;
            double nhRdc = -99999.9;
            int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
            if (indCH > -1) {
                chRdc = this.vecChRDC.elementAt(indCH).getRdc();
            }
            if ((indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo), new Dipolar.rdcComparator())) > -1) {
                nhRdc = this.vecNhRDC.elementAt(indNH).getRdc();
            }
            if (curResNo == noEnd) {
                isSolution = this.LoopLastHalfResPsiGridSearch(noStart, noEnd, nhRdc, chRdc, vecCurFullPdb, vecNextHalfPdb);
            } else if (this.isAllGridSearch) {
                isSolution = this.LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst);
            } else if (indCH < 0 || indNH < 0) {
                isSolution = this.LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst);
            } else {
                isSolution = this.LoopCurResPhiPsiExactSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst);
                if (!isSolution) {
                    isSolution = this.LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo, noStart, noEnd, chRdc, nhRdc, vecCurFullPdb, vecNextHalfPdb, isFirst);
                }
            }
            vecAllPdbsBackward.add(vecCurFullPdb);
            vecCurHalfPdb = new Vector();
            vecCurHalfPdb.addAll(vecNextHalfPdb);
            vecNextHalfPdb = new Vector();
            if (!isSolution) {
                System.out.println("No solution found for backward computation for residue: " + curResNo);
                break;
            }
            System.out.println("debugging...residue num: " + curResNo);
            System.out.println("debugging...num of soutions: " + vecCurFullPdb.size());
            --curResNo;
        }
        Vector vecLoopsNew2 = new Vector();
        if (isSolution) {
            Vector vecFinalTreePdbBackward = (Vector)vecAllPdbsBackward.elementAt(vecAllPdbsBackward.size() - 1);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are the ensemble of structures computed in a Backward way. ");
            System.out.println("REMARK :  =========================  ");
            vecLoopsNew2 = this.OutputEnsemblePdbsBackward(vecFinalTreePdbBackward, noStart, noEnd, 8.0);
            System.out.println("REMARK :  =========================  ");
            System.out.println("REMARK : Here are the fixed SSEs: ");
            System.out.println("REMARK :  =========================  ");
            System.out.println("TER");
            System.out.println("END");
        } else {
            System.out.println("No solution is found...");
        }
        return vecLoopsNew2;
    }

    public Vector MergeTwoFragmentIntoOne(Vector vecPdbEnsemb1, Vector vecPdbEnsemb2, double error, int noStart, int noEnd, int noMiddle, boolean isFirstHalf) {
        Vector vecFinalEnsemble = new Vector();
        int i = 0;
        while (i < vecPdbEnsemb1.size()) {
            Vector<Pdb> vecPdbNew = new Vector<Pdb>();
            boolean isFindMatched = false;
            double minDist = 999999.9;
            Vector vecSecFragment = new Vector();
            Vector<Cartesian> vecAtomMiddle2 = new Vector<Cartesian>();
            Vector vecPdb1 = (Vector)vecPdbEnsemb1.elementAt(i);
            int index1 = Collections.binarySearch(vecPdb1, new Pdb(noMiddle), new Pdb.PdbComparator());
            if (index1 < 0) {
                System.out.println("error: middle residue not found...exist...");
                System.exit(0);
            }
            Pdb pdb1 = (Pdb)vecPdb1.elementAt(index1);
            Vector<Cartesian> atomVec1 = pdb1.getAtomVec();
            double[] coordCA1 = new double[3];
            int k = 0;
            while (k < atomVec1.size()) {
                Cartesian cc = atomVec1.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    coordCA1 = cc.getXYZ();
                }
                ++k;
            }
            int j = 0;
            while (j < vecPdbEnsemb2.size()) {
                Vector vecPdb2 = (Vector)vecPdbEnsemb2.elementAt(j);
                int index2 = Collections.binarySearch(vecPdb2, new Pdb(noMiddle), new Pdb.PdbComparator());
                if (index2 < 0) {
                    System.out.println("error: middle residue not found...exist...");
                    System.exit(0);
                }
                Pdb pdb2 = (Pdb)vecPdb2.elementAt(index2);
                Vector<Cartesian> atomVec2 = pdb2.getAtomVec();
                double[] coordCA2 = new double[3];
                int k2 = 0;
                while (k2 < atomVec2.size()) {
                    Cartesian cc = atomVec2.elementAt(k2);
                    String atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("CA")) {
                        coordCA2 = cc.getXYZ();
                    }
                    ++k2;
                }
                double distance_ca = Math.sqrt((coordCA2[0] - coordCA1[0]) * (coordCA2[0] - coordCA1[0]) + (coordCA2[1] - coordCA1[1]) * (coordCA2[1] - coordCA1[1]) + (coordCA2[2] - coordCA1[2]) * (coordCA2[2] - coordCA1[2]));
                if (distance_ca < minDist) {
                    minDist = distance_ca;
                    vecSecFragment = new Vector();
                    vecSecFragment.addAll(vecPdb2);
                    vecAtomMiddle2 = new Vector();
                    vecAtomMiddle2.addAll(atomVec2);
                    isFindMatched = true;
                }
                ++j;
            }
            if (isFindMatched) {
                Pdb pdbTemp;
                String strAtomTemp;
                Cartesian ccTemp;
                int t;
                Vector<Cartesian> vecAtomMiddleNew = new Vector<Cartesian>();
                if (isFirstHalf) {
                    t = 0;
                    while (t < atomVec1.size()) {
                        ccTemp = atomVec1.elementAt(t);
                        strAtomTemp = ccTemp.getAtom();
                        if (strAtomTemp.equalsIgnoreCase("HN") || strAtomTemp.equalsIgnoreCase("H") || strAtomTemp.equalsIgnoreCase("N") || strAtomTemp.equalsIgnoreCase("CA") || strAtomTemp.equalsIgnoreCase("HA") || strAtomTemp.equalsIgnoreCase("CB") || strAtomTemp.equalsIgnoreCase("HB")) {
                            vecAtomMiddleNew.add(ccTemp);
                        }
                        ++t;
                    }
                    t = 0;
                    while (t < vecAtomMiddle2.size()) {
                        ccTemp = (Cartesian)vecAtomMiddle2.elementAt(t);
                        strAtomTemp = ccTemp.getAtom();
                        if (strAtomTemp.equalsIgnoreCase("C") || strAtomTemp.equalsIgnoreCase("C'") || strAtomTemp.equalsIgnoreCase("O") || strAtomTemp.equalsIgnoreCase("CO")) {
                            vecAtomMiddleNew.add(ccTemp);
                        }
                        ++t;
                    }
                } else {
                    t = 0;
                    while (t < vecAtomMiddle2.size()) {
                        ccTemp = (Cartesian)vecAtomMiddle2.elementAt(t);
                        strAtomTemp = ccTemp.getAtom();
                        if (strAtomTemp.equalsIgnoreCase("HN") || strAtomTemp.equalsIgnoreCase("H") || strAtomTemp.equalsIgnoreCase("N") || strAtomTemp.equalsIgnoreCase("CA") || strAtomTemp.equalsIgnoreCase("HA") || strAtomTemp.equalsIgnoreCase("CB") || strAtomTemp.equalsIgnoreCase("HB")) {
                            vecAtomMiddleNew.add(ccTemp);
                        }
                        ++t;
                    }
                    t = 0;
                    while (t < atomVec1.size()) {
                        ccTemp = atomVec1.elementAt(t);
                        strAtomTemp = ccTemp.getAtom();
                        if (strAtomTemp.equalsIgnoreCase("C") || strAtomTemp.equalsIgnoreCase("C'") || strAtomTemp.equalsIgnoreCase("O") || strAtomTemp.equalsIgnoreCase("CO")) {
                            vecAtomMiddleNew.add(ccTemp);
                        }
                        ++t;
                    }
                }
                pdb1.setAtomVec(vecAtomMiddleNew);
                if (isFirstHalf) {
                    t = noStart;
                    while (t <= noMiddle) {
                        int indexT = Collections.binarySearch(vecPdb1, new Pdb(t), new Pdb.PdbComparator());
                        pdbTemp = (Pdb)vecPdb1.elementAt(indexT);
                        vecPdbNew.add(pdbTemp);
                        ++t;
                    }
                    t = noMiddle + 1;
                    while (t <= noEnd) {
                        int indexT = Collections.binarySearch(vecSecFragment, new Pdb(t), new Pdb.PdbComparator());
                        pdbTemp = (Pdb)vecSecFragment.elementAt(indexT);
                        vecPdbNew.add(pdbTemp);
                        ++t;
                    }
                } else {
                    t = noMiddle;
                    while (t <= noEnd) {
                        int indexT = Collections.binarySearch(vecPdb1, new Pdb(t), new Pdb.PdbComparator());
                        pdbTemp = (Pdb)vecPdb1.elementAt(indexT);
                        vecPdbNew.add(pdbTemp);
                        ++t;
                    }
                    t = noStart;
                    while (t < noMiddle) {
                        int indexT = Collections.binarySearch(vecSecFragment, new Pdb(t), new Pdb.PdbComparator());
                        pdbTemp = (Pdb)vecSecFragment.elementAt(indexT);
                        vecPdbNew.add(pdbTemp);
                        ++t;
                    }
                }
                Collections.sort(vecPdbNew, new Pdb.PdbComparator());
                vecFinalEnsemble.add(vecPdbNew);
            }
            ++i;
        }
        return vecFinalEnsemble;
    }

    public void PdbGenerateFromTree(Vector vecAllPdbTree) {
        int i = 0;
        while (i < vecAllPdbTree.size()) {
            Vector vecCurPdbs = (Vector)vecAllPdbTree.elementAt(i);
            int j = 0;
            while (j < vecCurPdbs.size()) {
                ++j;
            }
            ++i;
        }
    }

    public boolean LoopCurResPhiPsiExactSearch(Vector vecCurHalfPdb, int curNo, int startResNo, int endResNo, double chRdc, double nhNextRdc, Vector vecCurFullPdb, Vector vecNextHalfPdb, boolean isLast) {
        double resolCluster = 0.4;
        int topNum = 1000;
        double rdcGrid = 0.4;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 5;
        double distBtwCa = 8.0;
        double[] phiS = new double[1];
        double[] psiS = new double[1];
        int i = 0;
        while (i < 1) {
            phiS[i] = 0.0;
            psiS[i] = 0.0;
            ++i;
        }
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecNextPdbTemp = new Vector<TreePdb>();
        int rdcSampCycles = 50;
        int i2 = 0;
        while (i2 < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbTreeCur = (TreePdb)vecCurHalfPdb.elementAt(i2);
            Vector<Cartesian> atomVecStart = pdbTreeCur.pdb.getAtomVec();
            TreePdb curParent = (TreePdb)pdbTreeCur.parenPdb.elementAt(0);
            Vector vecPreChild = curParent.vecChildPdb;
            vecPreChild.remove(pdbTreeCur);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            int k = 0;
            while (k < atomVecStart.size()) {
                Cartesian cc = atomVecStart.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            double[] nToNHVec = mdc.internuclearVec(coordN, coordNH);
            double[] nToCAVec = mdc.internuclearVec(coordN, coordCA);
            ppGlobal ppg = new ppGlobal();
            Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
            Vector phiVec = new Vector();
            Vector psiVec = new Vector();
            int k2 = 0;
            while ((double)k2 < this.rdcThreshold / rdcGrid) {
                double ch_rdc = (chRdc - this.rdcThreshold / 2.0 + (double)k2 * rdcGrid) / 1.0;
                int t = 0;
                while ((double)t < this.rdcThreshold / rdcGrid) {
                    block26: {
                        double nhNext_rdc = (nhNextRdc - this.rdcThreshold / 2.0 + (double)t * rdcGrid) / 1.0;
                        PhiPsi ff = new PhiPsi();
                        boolean isHelix = false;
                        phiVec = ff.phiCalLoop(this.Syy, this.Szz, ch_rdc, mat);
                        if (phiVec.isEmpty()) break block26;
                        int h = 0;
                        while (h < phiVec.size()) {
                            block27: {
                                double phi;
                                phiS[0] = phi = ((Double)phiVec.elementAt(h)).doubleValue();
                                psiVec = ff.psiCalLoop(this.Syy, this.Szz, nhNext_rdc, phi, mat);
                                if (psiVec.isEmpty()) break block27;
                                int g = 0;
                                while (g < psiVec.size()) {
                                    block28: {
                                        double[] distCa;
                                        Pdb nextHalfPdb;
                                        Pdb curPdb;
                                        double rama_score;
                                        block30: {
                                            block29: {
                                                boolean isClash;
                                                double psi;
                                                psiS[0] = psi = ((Double)psiVec.elementAt(g)).doubleValue();
                                                rama_score = 0.0;
                                                rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phi, psi, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phi, psi, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phi, psi, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phi, psi, this.vecRamaPrePro) : lp.CompRamachandranScore(phi, psi, this.vecRamaGeneral))));
                                                if (rama_score <= 0.02) break block28;
                                                rama_score = -Math.log(rama_score);
                                                Vector pdbFragTemp0 = new Vector();
                                                pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, curNo, false);
                                                Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                                curPdb = pdbFragTemp.elementAt(0);
                                                nextHalfPdb = pdbFragTemp.elementAt(1);
                                                int resNoNext = nextHalfPdb.getResidueNo();
                                                Vector<Cartesian> atomVecNext = nextHalfPdb.getAtomVec();
                                                double[] coordN_next = new double[3];
                                                double[] coordNH_next = new double[3];
                                                double[] coordCA_next = new double[3];
                                                int f = 0;
                                                while (f < atomVecNext.size()) {
                                                    Cartesian cc = atomVecNext.elementAt(f);
                                                    String atom = cc.getAtom();
                                                    if (atom.equalsIgnoreCase("N")) {
                                                        coordN_next = cc.getXYZ();
                                                    } else if (atom.equalsIgnoreCase("CA")) {
                                                        coordCA_next = cc.getXYZ();
                                                    } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                                        coordNH_next = cc.getXYZ();
                                                    }
                                                    ++f;
                                                }
                                                if (resNoNext < endResNo && (isClash = this.CheckClashBtwRotCaNSSEs(coordCA_next))) break block28;
                                                if (resNoNext > endResNo) break block29;
                                                double errorKin = 0.0;
                                                errorKin = resNoNext == endResNo ? this.gapThreshold : 1.0;
                                                boolean isKinChain = this.CheckKinChainRestraint(nextHalfPdb, endResNo, errorKin);
                                                if (!isKinChain) break block28;
                                            }
                                            double[] dist = new double[1];
                                            distCa = new double[1];
                                            dist[0] = 99999.9;
                                            distCa[0] = 99999.9;
                                            if (!isLast) break block30;
                                            double error = this.gapThreshold;
                                            int endNo = curPdb.getResidueNo();
                                            boolean isClose = this.CheckLastResidue(curPdb, endNo, error, dist, distCa);
                                            if (!isClose) break block28;
                                        }
                                        TreePdb curTreePdb = new TreePdb(curPdb);
                                        curTreePdb.SetNhRdcDif(Math.abs(nhNext_rdc - nhNextRdc) / 1.0);
                                        curTreePdb.SetChRdcDif(Math.abs(chRdc - ch_rdc) / 1.0);
                                        curTreePdb.SetSumRdcDif(pre_sum_rdc + Math.abs(nhNext_rdc - nhNextRdc) / 1.0 + Math.abs(chRdc - ch_rdc) / 1.0);
                                        curTreePdb.SetEndDist(distCa[0]);
                                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                                        vecPreChild.add(curTreePdb);
                                        curTreePdb.parenPdb.add(curParent);
                                        vecCurPdbTemp.add(curTreePdb);
                                        TreePdb nextHalfTreePdb = new TreePdb(nextHalfPdb);
                                        nextHalfTreePdb.SetNhRdcDif(Math.abs(nhNext_rdc - nhNextRdc) / 1.0);
                                        nextHalfTreePdb.SetChRdcDif(Math.abs(chRdc - ch_rdc) / 1.0);
                                        nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc + Math.abs(nhNext_rdc - nhNextRdc) / 1.0 + Math.abs(chRdc - ch_rdc) / 1.0);
                                        nextHalfTreePdb.SetEndDist(distCa[0]);
                                        nextHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                                        curTreePdb.vecChildPdb.add(nextHalfTreePdb);
                                        nextHalfTreePdb.parenPdb.add(curTreePdb);
                                        vecNextPdbTemp.add(nextHalfTreePdb);
                                        if (distCa[0] < minDist) {
                                            minDist = distCa[0];
                                            FinalPdbS = new TreePdb(curTreePdb);
                                        }
                                        if (vecNextPdbTemp.size() > this.maxLeafNodes) {
                                            return false;
                                        }
                                    }
                                    ++g;
                                }
                            }
                            ++h;
                        }
                    }
                    ++t;
                }
                ++k2;
            }
            ++i2;
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClustering(resolCluster, vecCurPdbTemp, vecNextPdbTemp);
        if (vecCurPdbTemp.size() > topNum) {
            this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecNextPdbTemp, topNum);
        }
        vecNextHalfPdb.addAll(vecNextPdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return true;
    }

    public boolean LoopCurResPhiPsiExactSearchBackward(Vector vecCurHalfPdb, int curNo, int startNo, int endResNo, double chRdc, double nhRdc, Vector vecCurFullPdb, Vector vecPreHalfPdb, boolean isFirst) {
        double resolCluster = 0.4;
        int topNum = 1000;
        double rdcGrid = 0.4;
        Loops lp = new Loops();
        String curResName = lp.GetResNameFromSequence(this.vecSeq, curNo);
        String nextResName = lp.GetResNameFromSequence(this.vecSeq, curNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector<TreePdb> vecFinalPdb = new Vector<TreePdb>();
        TreePdb FinalPdbS = new TreePdb();
        double minDist = 999999.9;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        int topSSEK = 5;
        double distBtwCa = 8.0;
        Vector<TreePdb> vecCurPdbTemp = new Vector<TreePdb>();
        Vector<TreePdb> vecPrePdbTemp = new Vector<TreePdb>();
        int i = 0;
        while (i < vecCurHalfPdb.size()) {
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            TreePdb pdbTreeCur = (TreePdb)vecCurHalfPdb.elementAt(i);
            TreePdb curParent = (TreePdb)pdbTreeCur.parenPdb.elementAt(0);
            Vector<Cartesian> atomVecPar = curParent.pdb.getAtomVec();
            Vector vecParChild = curParent.vecChildPdb;
            vecParChild.remove(pdbTreeCur);
            double preRamaScore = curParent.GetRamaScore();
            double pre_sum_rdc = curParent.GetSumRdcDif();
            int k = 0;
            while (k < atomVecPar.size()) {
                Cartesian cc = atomVecPar.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k;
            }
            PhiPsi ff = new PhiPsi();
            double[] nToNHVec = mdc.internuclearVec(coordN, coordNH);
            double[] nToCAVec = mdc.internuclearVec(coordN, coordCA);
            ppGlobal ppg = new ppGlobal();
            Matrix mat = ff.RgCal(nToNHVec, nToCAVec);
            Vector phiVec = new Vector();
            Vector psiVec = new Vector();
            int k2 = 0;
            while ((double)k2 < this.rdcThreshold / rdcGrid) {
                double ch_rdc = (chRdc - this.rdcThreshold / 2.0 + (double)k2 * rdcGrid) / 1.0;
                int t = 0;
                while ((double)t < this.rdcThreshold / rdcGrid) {
                    block25: {
                        double nh_rdc = (nhRdc - this.rdcThreshold / 2.0 + (double)t * rdcGrid) / 1.0;
                        psiVec = ff.psiCalBackward(this.Syy, this.Szz, ch_rdc, mat);
                        if (psiVec.isEmpty()) break block25;
                        int h = 0;
                        while (h < psiVec.size()) {
                            block26: {
                                double psi = (Double)psiVec.elementAt(h);
                                phiVec = ff.phiCalBackward(this.Syy, this.Szz, nh_rdc, psi, mat);
                                if (phiVec.isEmpty()) break block26;
                                int g = 0;
                                while (g < phiVec.size()) {
                                    block27: {
                                        double[] distCa;
                                        Pdb preHalfPdb;
                                        Pdb curPdb;
                                        double rama_score;
                                        block29: {
                                            block28: {
                                                boolean isClash;
                                                double phi = (Double)phiVec.elementAt(g);
                                                rama_score = 0.0;
                                                rama_score = curResName.equalsIgnoreCase("ALA") ? lp.CompRamachandranScore(phi, psi, this.vecRamaAla) : (curResName.equalsIgnoreCase("GLY") ? lp.CompRamachandranScore(phi, psi, this.vecRamaGly) : (curResName.equalsIgnoreCase("PRO") ? lp.CompRamachandranScore(phi, psi, this.vecRamaPro) : (isPrePro ? lp.CompRamachandranScore(phi, psi, this.vecRamaPrePro) : lp.CompRamachandranScore(phi, psi, this.vecRamaGeneral))));
                                                if (rama_score <= 0.02) break block27;
                                                rama_score = -Math.log(rama_score);
                                                Vector pdbFragTemp0 = new Vector();
                                                pdbFragTemp0 = mdc.coordByBackwardNew(phi, psi, coordN, coordNH, coordCA, curNo);
                                                Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                                                curPdb = pdbFragTemp.elementAt(1);
                                                preHalfPdb = pdbFragTemp.elementAt(0);
                                                int resNoPre = preHalfPdb.getResidueNo();
                                                Vector<Cartesian> atomVecPre = preHalfPdb.getAtomVec();
                                                double[] coordN_pre = new double[3];
                                                double[] coordNH_pre = new double[3];
                                                double[] coordCA_pre = new double[3];
                                                int f = 0;
                                                while (f < atomVecPre.size()) {
                                                    Cartesian cc = atomVecPre.elementAt(f);
                                                    String atom = cc.getAtom();
                                                    if (atom.equalsIgnoreCase("N")) {
                                                        coordN_pre = cc.getXYZ();
                                                    } else if (atom.equalsIgnoreCase("CA")) {
                                                        coordCA_pre = cc.getXYZ();
                                                    } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                                                        coordNH_pre = cc.getXYZ();
                                                    }
                                                    ++f;
                                                }
                                                if (resNoPre > startNo && (isClash = this.CheckClashBtwRotCaNSSEs(coordCA_pre))) break block27;
                                                if (resNoPre < startNo) break block28;
                                                double errorKin = 0.6;
                                                errorKin = resNoPre == startNo ? this.gapThreshold : 1.0;
                                                boolean isKinChain = this.CheckKinChainRestraintBackward(preHalfPdb, startNo, errorKin);
                                                if (!isKinChain) break block27;
                                            }
                                            double[] dist = new double[1];
                                            distCa = new double[1];
                                            dist[0] = 99999.9;
                                            distCa[0] = 99999.9;
                                            if (!isFirst) break block29;
                                            double error = this.gapThreshold;
                                            int fixNo = curPdb.getResidueNo();
                                            boolean isClose = this.CheckFirstResidue(curPdb, fixNo, error, dist, distCa);
                                            if (!isClose) break block27;
                                        }
                                        TreePdb curTreePdb = new TreePdb(curPdb);
                                        curTreePdb.SetNhRdcDif(Math.abs(nh_rdc - nhRdc) / 1.0);
                                        curTreePdb.SetChRdcDif(Math.abs(chRdc - ch_rdc) / 1.0);
                                        curTreePdb.SetSumRdcDif(pre_sum_rdc + Math.abs(nh_rdc - nhRdc) / 1.0 + Math.abs(chRdc - ch_rdc) / 1.0);
                                        curTreePdb.SetEndDist(distCa[0]);
                                        curTreePdb.SetRamaScore(preRamaScore + rama_score);
                                        vecParChild.add(curTreePdb);
                                        curTreePdb.parenPdb.add(curParent);
                                        vecCurPdbTemp.add(curTreePdb);
                                        TreePdb preHalfTreePdb = new TreePdb(preHalfPdb);
                                        preHalfTreePdb.SetNhRdcDif(Math.abs(nh_rdc - nhRdc) / 1.0);
                                        preHalfTreePdb.SetChRdcDif(Math.abs(chRdc - ch_rdc) / 1.0);
                                        preHalfTreePdb.SetSumRdcDif(pre_sum_rdc + Math.abs(nh_rdc - nhRdc) / 1.0 + Math.abs(chRdc - ch_rdc) / 1.0);
                                        preHalfTreePdb.SetEndDist(distCa[0]);
                                        preHalfTreePdb.SetRamaScore(preRamaScore + rama_score);
                                        curTreePdb.vecChildPdb.add(preHalfTreePdb);
                                        preHalfTreePdb.parenPdb.add(curTreePdb);
                                        vecPrePdbTemp.add(preHalfTreePdb);
                                        if (distCa[0] < minDist) {
                                            minDist = distCa[0];
                                            FinalPdbS = new TreePdb(curTreePdb);
                                        }
                                        if (vecPrePdbTemp.size() > this.maxLeafNodes) {
                                            return false;
                                        }
                                    }
                                    ++g;
                                }
                            }
                            ++h;
                        }
                    }
                    ++t;
                }
                ++k2;
            }
            ++i;
        }
        Vector vecIndex = new Vector();
        if (vecCurPdbTemp.size() <= 0) {
            return false;
        }
        this.PlaneClusteringBackward(resolCluster, vecCurPdbTemp, vecPrePdbTemp);
        if (vecCurPdbTemp.size() > topNum) {
            this.PlaneClusteringAndTopSelection(resolCluster, vecCurPdbTemp, vecPrePdbTemp, topNum);
        }
        vecPreHalfPdb.addAll(vecPrePdbTemp);
        vecCurFullPdb.addAll(vecCurPdbTemp);
        vecCurHalfPdb = new Vector();
        vecFinalPdb.add(FinalPdbS);
        return true;
    }

    public void PlaneClustering(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecNextTreePdb) {
        Vector<Integer> vecIsChecked = new Vector<Integer>();
        int i = 0;
        while (i < vecNextTreePdb.size()) {
            vecIsChecked.add(new Integer(0));
            vecIsChecked.set(i, 0);
            ++i;
        }
        vecIsChecked.set(0, 0);
        block1: while (true) {
            TreePdb pdbTemp;
            Vector vecChild;
            TreePdb pdbTparen;
            boolean isAllChecked = true;
            int i2 = 0;
            while (i2 < vecIsChecked.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(i2);
                if (nTemp == 0) {
                    isAllChecked = false;
                    break;
                }
                ++i2;
            }
            if (isAllChecked) break;
            int[] isDele = new int[vecNextTreePdb.size()];
            int i3 = 0;
            while (i3 < isDele.length) {
                isDele[i3] = 0;
                ++i3;
            }
            int counter = 0;
            while (counter < vecIsChecked.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(counter);
                if (nTemp != 1) break;
                ++counter;
            }
            TreePdb pdb0 = vecNextTreePdb.elementAt(counter);
            Vector<Cartesian> vecAtom0 = pdb0.pdb.getAtomVec();
            double[] coordN0 = new double[3];
            double[] coordNH0 = new double[3];
            double[] coordCA0 = new double[3];
            int k = 0;
            while (k < vecAtom0.size()) {
                Cartesian cc = vecAtom0.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN0 = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA0 = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH0 = cc.getXYZ();
                }
                ++k;
            }
            isDele[counter] = 1;
            vecIsChecked.set(counter, 1);
            double ramaScore0 = pdb0.GetRamaScore();
            TreePdb pdbS = pdb0;
            double ramaScoreS = ramaScore0;
            int indS = counter;
            int i4 = counter;
            while (i4 < vecNextTreePdb.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(i4);
                if (nTemp != 1) {
                    TreePdb pdb1 = vecNextTreePdb.elementAt(i4);
                    Vector<Cartesian> vecAtom1 = pdb1.pdb.getAtomVec();
                    double[] coordN1 = new double[3];
                    double[] coordNH1 = new double[3];
                    double[] coordCA1 = new double[3];
                    int k2 = 0;
                    while (k2 < vecAtom1.size()) {
                        Cartesian cc = vecAtom1.elementAt(k2);
                        String atom = cc.getAtom();
                        if (atom.equalsIgnoreCase("N")) {
                            coordN1 = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("CA")) {
                            coordCA1 = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                            coordNH1 = cc.getXYZ();
                        }
                        ++k2;
                    }
                    double ramaScore1 = pdb1.GetRamaScore();
                    boolean isInCluster = false;
                    double distance_n = Math.sqrt((coordN1[0] - coordN0[0]) * (coordN1[0] - coordN0[0]) + (coordN1[1] - coordN0[1]) * (coordN1[1] - coordN0[1]) + (coordN1[2] - coordN0[2]) * (coordN1[2] - coordN0[2]));
                    double distance_ca = Math.sqrt((coordCA1[0] - coordCA0[0]) * (coordCA1[0] - coordCA0[0]) + (coordCA1[1] - coordCA0[1]) * (coordCA1[1] - coordCA0[1]) + (coordCA1[2] - coordCA0[2]) * (coordCA1[2] - coordCA0[2]));
                    double distance_hn = Math.sqrt((coordNH1[0] - coordNH0[0]) * (coordNH1[0] - coordNH0[0]) + (coordNH1[1] - coordNH0[1]) * (coordNH1[1] - coordNH0[1]) + (coordNH1[2] - coordNH0[2]) * (coordNH1[2] - coordNH0[2]));
                    if (distance_n < resol && distance_ca < resol && distance_hn < resol) {
                        isInCluster = true;
                    }
                    if (isInCluster) {
                        isDele[i4] = 1;
                        vecIsChecked.set(i4, 1);
                        if (ramaScore1 < ramaScoreS) {
                            pdbS = pdb1;
                            ramaScoreS = ramaScore1;
                            indS = i4;
                        }
                    }
                }
                ++i4;
            }
            isDele[indS] = 0;
            Vector<Integer> vecIsDeleNext = new Vector<Integer>();
            Vector<Integer> vecIsDeleCur = new Vector<Integer>();
            int i5 = 0;
            while (i5 < isDele.length) {
                if (isDele[i5] == 1) {
                    vecIsDeleNext.add(new Integer(1));
                    vecIsDeleCur.add(new Integer(1));
                } else {
                    vecIsDeleNext.add(new Integer(0));
                    vecIsDeleCur.add(new Integer(0));
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < vecNextTreePdb.size()) {
                int isDelete = (Integer)vecIsDeleNext.elementAt(i5);
                if (isDelete != 0) {
                    TreePdb pdbNextT = vecNextTreePdb.elementAt(i5);
                    pdbTparen = (TreePdb)pdbNextT.parenPdb.elementAt(0);
                    vecChild = pdbTparen.vecChildPdb;
                    int j = 0;
                    while (j < vecChild.size()) {
                        pdbTemp = (TreePdb)vecChild.elementAt(j);
                        if (pdbTemp.equals(pdbNextT)) {
                            vecChild.remove(j);
                            break;
                        }
                        ++j;
                    }
                    vecNextTreePdb.remove(i5);
                    vecIsDeleNext.remove(i5);
                    vecIsChecked.remove(i5);
                    --i5;
                }
                ++i5;
            }
            i5 = 0;
            while (true) {
                if (i5 >= vecCurTreePdb.size()) continue block1;
                int isDelete = (Integer)vecIsDeleCur.elementAt(i5);
                if (isDelete != 0) {
                    TreePdb pdbCurT = vecCurTreePdb.elementAt(i5);
                    pdbTparen = (TreePdb)pdbCurT.parenPdb.elementAt(0);
                    vecChild = pdbTparen.vecChildPdb;
                    int j = 0;
                    while (j < vecChild.size()) {
                        pdbTemp = (TreePdb)vecChild.elementAt(j);
                        if (pdbTemp.equals(pdbCurT)) {
                            vecChild.remove(j);
                            break;
                        }
                        ++j;
                    }
                    vecCurTreePdb.remove(i5);
                    vecIsDeleCur.remove(i5);
                    --i5;
                }
                ++i5;
            }
            break;
        }
    }

    public void PlaneClusteringBackward(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecPreTreePdb) {
        Vector<Integer> vecIsChecked = new Vector<Integer>();
        int i = 0;
        while (i < vecPreTreePdb.size()) {
            vecIsChecked.add(new Integer(0));
            vecIsChecked.set(i, 0);
            ++i;
        }
        vecIsChecked.set(0, 0);
        block1: while (true) {
            TreePdb pdbTemp;
            Vector vecChild;
            TreePdb pdbTparen;
            boolean isAllChecked = true;
            int i2 = 0;
            while (i2 < vecIsChecked.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(i2);
                if (nTemp == 0) {
                    isAllChecked = false;
                    break;
                }
                ++i2;
            }
            if (isAllChecked) break;
            int[] isDele = new int[vecPreTreePdb.size()];
            int i3 = 0;
            while (i3 < isDele.length) {
                isDele[i3] = 0;
                ++i3;
            }
            int counter = 0;
            while (counter < vecIsChecked.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(counter);
                if (nTemp != 1) break;
                ++counter;
            }
            TreePdb pdb0 = vecPreTreePdb.elementAt(counter);
            Vector<Cartesian> vecAtom0 = pdb0.pdb.getAtomVec();
            double[] coordCO2 = new double[3];
            double[] coordC2 = new double[3];
            double[] coordCA2 = new double[3];
            int k = 0;
            while (k < vecAtom0.size()) {
                Cartesian cc = vecAtom0.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                    coordCO2 = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA2 = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                    coordC2 = cc.getXYZ();
                }
                ++k;
            }
            isDele[counter] = 1;
            vecIsChecked.set(counter, 1);
            double ramaScore0 = pdb0.GetRamaScore();
            TreePdb pdbS = pdb0;
            double ramaScoreS = ramaScore0;
            int indS = counter;
            int i4 = counter;
            while (i4 < vecPreTreePdb.size()) {
                int nTemp = (Integer)vecIsChecked.elementAt(i4);
                if (nTemp != 1) {
                    TreePdb pdb1 = vecPreTreePdb.elementAt(i4);
                    Vector<Cartesian> vecAtom1 = pdb1.pdb.getAtomVec();
                    double[] coordCO1 = new double[3];
                    double[] coordC1 = new double[3];
                    double[] coordCA1 = new double[3];
                    int k2 = 0;
                    while (k2 < vecAtom1.size()) {
                        Cartesian cc = vecAtom1.elementAt(k2);
                        String atom = cc.getAtom();
                        if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O")) {
                            coordCO1 = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("CA")) {
                            coordCA1 = cc.getXYZ();
                        } else if (atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("C'")) {
                            coordC1 = cc.getXYZ();
                        }
                        ++k2;
                    }
                    double ramaScore1 = pdb1.GetRamaScore();
                    boolean isInCluster = false;
                    double distance_co = Math.sqrt((coordCO1[0] - coordCO2[0]) * (coordCO1[0] - coordCO2[0]) + (coordCO1[1] - coordCO2[1]) * (coordCO1[1] - coordCO2[1]) + (coordCO1[2] - coordCO2[2]) * (coordCO1[2] - coordCO2[2]));
                    double distance_ca = Math.sqrt((coordCA1[0] - coordCA2[0]) * (coordCA1[0] - coordCA2[0]) + (coordCA1[1] - coordCA2[1]) * (coordCA1[1] - coordCA2[1]) + (coordCA1[2] - coordCA2[2]) * (coordCA1[2] - coordCA2[2]));
                    double distance_c = Math.sqrt((coordC2[0] - coordC1[0]) * (coordC2[0] - coordC1[0]) + (coordC2[1] - coordC1[1]) * (coordC2[1] - coordC1[1]) + (coordC2[2] - coordC1[2]) * (coordC2[2] - coordC1[2]));
                    if (distance_co < resol && distance_ca < resol && distance_c < resol) {
                        isInCluster = true;
                    }
                    if (isInCluster) {
                        isDele[i4] = 1;
                        vecIsChecked.set(i4, 1);
                        if (ramaScore1 < ramaScoreS) {
                            pdbS = pdb1;
                            ramaScoreS = ramaScore1;
                            indS = i4;
                        }
                    }
                }
                ++i4;
            }
            isDele[indS] = 0;
            Vector<Integer> vecIsDeleNext = new Vector<Integer>();
            Vector<Integer> vecIsDeleCur = new Vector<Integer>();
            int i5 = 0;
            while (i5 < isDele.length) {
                if (isDele[i5] == 1) {
                    vecIsDeleNext.add(new Integer(1));
                    vecIsDeleCur.add(new Integer(1));
                } else {
                    vecIsDeleNext.add(new Integer(0));
                    vecIsDeleCur.add(new Integer(0));
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < vecPreTreePdb.size()) {
                int isDelete = (Integer)vecIsDeleNext.elementAt(i5);
                if (isDelete != 0) {
                    TreePdb pdbNextT = vecPreTreePdb.elementAt(i5);
                    pdbTparen = (TreePdb)pdbNextT.parenPdb.elementAt(0);
                    vecChild = pdbTparen.vecChildPdb;
                    int j = 0;
                    while (j < vecChild.size()) {
                        pdbTemp = (TreePdb)vecChild.elementAt(j);
                        if (pdbTemp.equals(pdbNextT)) {
                            vecChild.remove(j);
                            break;
                        }
                        ++j;
                    }
                    vecPreTreePdb.remove(i5);
                    vecIsDeleNext.remove(i5);
                    vecIsChecked.remove(i5);
                    --i5;
                }
                ++i5;
            }
            i5 = 0;
            while (true) {
                if (i5 >= vecCurTreePdb.size()) continue block1;
                int isDelete = (Integer)vecIsDeleCur.elementAt(i5);
                if (isDelete != 0) {
                    TreePdb pdbCurT = vecCurTreePdb.elementAt(i5);
                    pdbTparen = (TreePdb)pdbCurT.parenPdb.elementAt(0);
                    vecChild = pdbTparen.vecChildPdb;
                    int j = 0;
                    while (j < vecChild.size()) {
                        pdbTemp = (TreePdb)vecChild.elementAt(j);
                        if (pdbTemp.equals(pdbCurT)) {
                            vecChild.remove(j);
                            break;
                        }
                        ++j;
                    }
                    vecCurTreePdb.remove(i5);
                    vecIsDeleCur.remove(i5);
                    --i5;
                }
                ++i5;
            }
            break;
        }
    }

    public void PlaneClusteringAndTopSelection(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecNextTreePdb, int topNum) {
        TreePdb treePdbTemp;
        int j;
        boolean isIn;
        int idNext;
        TreePdb treePdb;
        int i;
        int i2 = 0;
        while (i2 < vecCurTreePdb.size()) {
            TreePdb treeCurPdb = vecCurTreePdb.elementAt(i2);
            TreePdb treeNextPdb = vecNextTreePdb.elementAt(i2);
            treeCurPdb.SetID(i2);
            treeNextPdb.SetID(i2);
            ++i2;
        }
        Vector<TreePdb> vecCurTreePdbTemp = new Vector<TreePdb>();
        vecCurTreePdbTemp.addAll(vecCurTreePdb);
        Vector<TreePdb> vecCurRama = new Vector<TreePdb>();
        Collections.sort(vecCurTreePdbTemp, new TreePdbRamaComparator());
        int i3 = 0;
        while (i3 < Math.min(topNum, vecCurTreePdbTemp.size())) {
            TreePdb treePdb2 = (TreePdb)vecCurTreePdbTemp.elementAt(i3);
            vecCurRama.add(treePdb2);
            ++i3;
        }
        Vector<TreePdb> vecCurRdc = new Vector<TreePdb>();
        Collections.sort(vecCurTreePdbTemp, new TreePdbRDCComparator());
        TreePdb treePdb0 = vecCurTreePdb.elementAt(0);
        if (treePdb0.GetChRdcDif() > -1000.0 || treePdb0.GetNhRdcDif() > -1000.0) {
            i = 0;
            while (i < Math.min(topNum, vecCurTreePdbTemp.size())) {
                treePdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
                vecCurRdc.add(treePdb);
                ++i;
            }
            i = 0;
            while (i < vecCurRama.size()) {
                treePdb = (TreePdb)vecCurRama.elementAt(i);
                if (!vecCurRdc.contains(treePdb)) {
                    vecCurRama.remove(i);
                    --i;
                }
                ++i;
            }
        }
        i = 0;
        while (i < vecCurTreePdb.size()) {
            treePdb = vecCurTreePdb.elementAt(i);
            idNext = treePdb.GetID();
            isIn = false;
            j = 0;
            while (j < vecCurRama.size()) {
                treePdbTemp = (TreePdb)vecCurRama.elementAt(j);
                if (treePdbTemp.GetID() == idNext) {
                    isIn = true;
                    break;
                }
                ++j;
            }
            if (!isIn) {
                vecCurTreePdb.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < vecNextTreePdb.size()) {
            treePdb = vecNextTreePdb.elementAt(i);
            idNext = treePdb.GetID();
            isIn = false;
            j = 0;
            while (j < vecCurRama.size()) {
                treePdbTemp = (TreePdb)vecCurRama.elementAt(j);
                if (treePdbTemp.GetID() == idNext) {
                    isIn = true;
                    break;
                }
                ++j;
            }
            if (!isIn) {
                vecNextTreePdb.remove(i);
                --i;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void PlaneClusteringAndTopSelectionNOEs(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecNextTreePdb, int topNum, int noStart, boolean isForward) {
        distUpCa = 8.0;
        numNOEGap = 60;
        maxNum = 50;
        i = 0;
        while (i < vecCurTreePdb.size()) {
            treeCurPdb = vecCurTreePdb.elementAt(i);
            treeNextPdb = vecNextTreePdb.elementAt(i);
            treeCurPdb.SetID(i);
            treeNextPdb.SetID(i);
            ++i;
        }
        vecCurTreePdbTemp = new Vector<TreePdb>();
        vecCurTreePdbTemp.addAll(vecCurTreePdb);
        vecCurRama = new Vector<TreePdb>();
        Collections.sort(vecCurTreePdbTemp, new TreePdbRamaComparator());
        i = 0;
        while ((double)i < Math.min((double)topNum * 1.5, (double)vecCurTreePdbTemp.size())) {
            treePdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
            vecCurRama.add(treePdb);
            ++i;
        }
        treePdb0 = vecCurTreePdb.elementAt(0);
        if (treePdb0.GetChRdcDif() > -1000.0 && treePdb0.GetNhRdcDif() > -1000.0) {
            vecCurRdc = new Vector<TreePdb>();
            Collections.sort(vecCurTreePdbTemp, new TreePdbRDCComparator());
            i = 0;
            while (i < Math.min(topNum, vecCurTreePdbTemp.size())) {
                treePdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
                vecCurRdc.add(treePdb);
                ++i;
            }
            i = 0;
            while (i < vecCurRama.size()) {
                treePdb = (TreePdb)vecCurRama.elementAt(i);
                if (!vecCurRdc.contains(treePdb)) {
                    vecCurRama.remove(i);
                    --i;
                }
                ++i;
            }
        }
        i = 0;
        while (i < vecCurTreePdbTemp.size()) {
            block34: {
                vecLoopFrag = new Vector<Pdb>();
                treePdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
                treeCurPdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
                resNo = treeCurPdb.pdb.getResidueNo();
                treePdbEnd = (TreePdb)treeCurPdb.vecChildPdb.elementAt(0);
                vecLoopFrag.add(treePdbEnd.pdb);
                if (!isForward) ** GOTO lbl68
                while (resNo >= noStart) {
                    vecLoopFrag.add(treeCurPdb.pdb);
                    if (resNo != noStart) {
                        treeCurPdb = (TreePdb)treeCurPdb.parenPdb.elementAt(0);
                        resNo = treeCurPdb.pdb.getResidueNo();
                        continue;
                    }
                    break block34;
                }
                break block34;
lbl-1000:
                // 1 sources

                {
                    vecLoopFrag.add(treeCurPdb.pdb);
                    if (resNo == noStart) break;
                    treeCurPdb = (TreePdb)treeCurPdb.parenPdb.elementAt(0);
                    resNo = treeCurPdb.pdb.getResidueNo();
lbl68:
                    // 2 sources

                    ** while (resNo <= noStart)
                }
            }
            Collections.sort(vecLoopFrag, new Pdb.PdbComparator());
            counter = 0;
            j = 0;
            while (j < this.vecAmbNOEs.size()) {
                isSatisfied = false;
                noe = this.vecAmbNOEs.elementAt(j);
                resNoA = noe.getResidueNoA();
                resNoB = noe.getResidueNoB();
                atomA = noe.getAtomA();
                atomB = noe.getAtomB();
                sub_atomA = atomA;
                sub_atomB = atomB;
                if (atomA.length() >= 2) {
                    sub_atomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    sub_atomB = atomB.substring(0, 2);
                }
                k = 0;
                while (k < vecLoopFrag.size()) {
                    pdbLoop = (Pdb)vecLoopFrag.elementAt(k);
                    resNoLoop = pdbLoop.getResidueNo();
                    if (resNoLoop == resNoA || resNoLoop == resNoB) {
                        vecAtomLoop = pdbLoop.getAtomVec();
                        caLoop = new double[3];
                        kk = 0;
                        while (kk < vecAtomLoop.size()) {
                            cc = vecAtomLoop.elementAt(kk);
                            atom = cc.getAtom();
                            if (atom.equalsIgnoreCase("CA")) {
                                caLoop = cc.getXYZ();
                            }
                            ++kk;
                        }
                        t = 0;
                        while (t < this.vecPdbSSE.size()) {
                            pdbSSE = this.vecPdbSSE.elementAt(t);
                            resNoSSE = pdbSSE.getResidueNo();
                            if (resNoSSE == resNoA || resNoSSE == resNoB) {
                                vecAtomSSE = pdbSSE.getAtomVec();
                                caSSE = new double[3];
                                tt = 0;
                                while (tt < vecAtomSSE.size()) {
                                    cc = vecAtomSSE.elementAt(tt);
                                    atom = cc.getAtom();
                                    if (atom.equalsIgnoreCase("CA")) {
                                        caSSE = cc.getXYZ();
                                    }
                                    ++tt;
                                }
                                if ((resNoSSE == resNoA && resNoLoop == resNoB || resNoSSE == resNoB && resNoLoop == resNoA) && (distance = Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) + (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) + (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]))) < distUpCa) {
                                    isSatisfied = true;
                                    break;
                                }
                            }
                            ++t;
                        }
                        if (isSatisfied) break;
                    }
                    ++k;
                }
                if (isSatisfied) {
                    ++counter;
                }
                ++j;
            }
            treePdb.noeScore = counter;
            ++i;
        }
        vecCurNoe = new Vector<TreePdb>();
        Collections.sort(vecCurTreePdbTemp, new TreePdbNOEComparator());
        treepdb = (TreePdb)vecCurTreePdbTemp.elementAt(0);
        maxNoeNum = treepdb.noeScore;
        i = 0;
        while (i < vecCurTreePdbTemp.size()) {
            treePdb = (TreePdb)vecCurTreePdbTemp.elementAt(i);
            if (!(Math.abs(treePdb.noeScore - maxNoeNum) < (double)numNOEGap)) break;
            vecCurNoe.add(treePdb);
            if (vecCurNoe.size() >= maxNum) break;
            ++i;
        }
        Collections.sort(vecCurNoe, new TreePdbNOEComparator());
        i = 0;
        while (i < vecCurRama.size()) {
            treePdb = (TreePdb)vecCurRama.elementAt(i);
            if (!vecCurNoe.contains(treePdb)) {
                vecCurRama.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < vecCurTreePdb.size()) {
            treePdb = vecCurTreePdb.elementAt(i);
            idNext = treePdb.GetID();
            isIn = false;
            j = 0;
            while (j < vecCurRama.size()) {
                treePdbTemp = (TreePdb)vecCurRama.elementAt(j);
                if (treePdbTemp.GetID() == idNext) {
                    isIn = true;
                    break;
                }
                ++j;
            }
            if (!isIn) {
                vecCurTreePdb.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < vecNextTreePdb.size()) {
            treePdb = vecNextTreePdb.elementAt(i);
            idNext = treePdb.GetID();
            isIn = false;
            j = 0;
            while (j < vecCurRama.size()) {
                treePdbTemp = (TreePdb)vecCurRama.elementAt(j);
                if (treePdbTemp.GetID() == idNext) {
                    isIn = true;
                    break;
                }
                ++j;
            }
            if (!isIn) {
                vecNextTreePdb.remove(i);
                --i;
            }
            ++i;
        }
    }

    public Vector RotamerReplacement(int noStart, int noEnd) {
        String atom;
        Cartesian cc;
        int j;
        Pdb pdb;
        Pdb pp = new Pdb();
        String userDirTemp = System.getProperty("user.dir");
        String refPdbFileDebugging = String.valueOf(userDirTemp) + "/inputFiles/1UBQHNew.pdb";
        Vector<Pdb> vecPdbRef = pp.readPdb(refPdbFileDebugging);
        String resStart = "";
        String resEnd = "";
        Vector<Object> vecAtomStart = new Vector();
        Vector<Object> vecAtomEnd = new Vector();
        double[] caStart = new double[3];
        double[] caEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (index > -1) {
            pdb = this.vecPdbSSE.elementAt(index);
            resStart = pdb.getResidue();
            vecAtomStart = pdb.getAtomVec();
            j = 0;
            while (j < vecAtomStart.size()) {
                cc = (Cartesian)vecAtomStart.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caStart = cc.getXYZ();
                }
                ++j;
            }
        }
        if ((index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator())) > -1) {
            pdb = this.vecPdbSSE.elementAt(index);
            resEnd = pdb.getResidue();
            vecAtomEnd = pdb.getAtomVec();
            j = 0;
            while (j < vecAtomEnd.size()) {
                cc = (Cartesian)vecAtomEnd.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caEnd = cc.getXYZ();
                }
                ++j;
            }
        }
        int topSSEK = 5;
        double caSearchRange = 12.0;
        Vector vecAllCandPos = new Vector();
        int i = noStart + 1;
        while (i < noEnd) {
            RotaPattern rotPatn;
            String resid = "";
            int j2 = 0;
            while (j2 < this.vecSeq.size()) {
                Assign asg = this.vecSeq.elementAt(j2);
                int no = asg.getResidueNo();
                if (no == i) {
                    resid = asg.getResidueType().trim();
                }
                ++j2;
            }
            String rotamFile = String.valueOf(this.rotSrc) + resid.toLowerCase() + ".pdb";
            Vector<Object> pdbRotam = new Vector();
            pdbRotam = pp.readRotamerPdb(rotamFile);
            Vector<Pdb> vecPdbAchors = this.SearchSSEAnchors(topSSEK, i);
            double searchRadius = 11.0;
            Pdb pdb_rot = (Pdb)pdbRotam.elementAt(0);
            Vector<Pdb> vecRotPdb = new Vector<Pdb>();
            vecRotPdb.add(pdb_rot);
            double scoreMax = -99999.9;
            double[] bestTranS = new double[3];
            double[] bestRotS = new double[3];
            Vector<RotaPattern> vecCandPosTemp = new Vector<RotaPattern>();
            int k = 0;
            while (k < vecPdbAchors.size()) {
                Vector<RotaPattern> vecCandPos = new Vector<RotaPattern>();
                Pdb ppSSE = vecPdbAchors.elementAt(k);
                Vector<Cartesian> vecAtomSSE = ppSSE.getAtomVec();
                double[] caSSE = new double[3];
                int t = 0;
                while (t < vecAtomSSE.size()) {
                    Cartesian cc2 = vecAtomSSE.elementAt(t);
                    String atom2 = cc2.getAtom();
                    if (atom2.equalsIgnoreCase("CA")) {
                        caSSE = cc2.getXYZ();
                    }
                    ++t;
                }
                double[] bestTran = new double[3];
                double[] tranResol = new double[3];
                double[] tranX0 = new double[3];
                double[] tranXn = new double[3];
                tranX0[0] = 0.0;
                tranXn[0] = 180.0;
                tranX0[1] = 0.0;
                tranXn[1] = 360.0;
                tranX0[2] = 3.8;
                tranXn[2] = 8.0;
                tranResol[0] = 10.0;
                tranResol[1] = 10.0;
                tranResol[2] = 0.5;
                int noCur = i;
                double sc = this.TranRotGridSearchNew(caSSE, tranX0, tranXn, tranResol, bestTran, noStart, noEnd, noCur, vecCandPos);
                System.out.println("here after finshing grid search..." + i + "th residue...and " + k + "th anchor (" + ppSSE.getResidueNo() + ")");
                System.out.println("The tatoal number of candidate position for this anchor: " + vecCandPos.size());
                vecCandPosTemp.addAll(vecCandPos);
                ++k;
            }
            Collections.sort(vecCandPosTemp, new RotaPattern.scoreComparator());
            int chosenNum = 150;
            Vector<RotaPattern> vecCandPosRefined = new Vector<RotaPattern>();
            int g = 0;
            while (g < Math.min(chosenNum, vecCandPosTemp.size())) {
                rotPatn = (RotaPattern)vecCandPosTemp.elementAt(g);
                vecCandPosRefined.add(rotPatn);
                ++g;
            }
            vecCandPosRefined = new Vector();
            int e = 0;
            while (e < vecCandPosTemp.size()) {
                rotPatn = (RotaPattern)vecCandPosTemp.elementAt(e);
                if (rotPatn.getScore() > 0.0) {
                    vecCandPosRefined.add(rotPatn);
                }
                ++e;
            }
            vecAllCandPos.add(vecCandPosRefined);
            ++i;
        }
        return vecAllCandPos;
    }

    public Vector RotamerReplacementOld(int noStart, int noEnd) {
        String atom;
        Cartesian cc;
        int j;
        Pdb pdb;
        Pdb pp = new Pdb();
        String resStart = "";
        String resEnd = "";
        Vector<Object> vecAtomStart = new Vector();
        Vector<Object> vecAtomEnd = new Vector();
        double[] caStart = new double[3];
        double[] caEnd = new double[3];
        int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (index > -1) {
            pdb = this.vecPdbSSE.elementAt(index);
            resStart = pdb.getResidue();
            vecAtomStart = pdb.getAtomVec();
            j = 0;
            while (j < vecAtomStart.size()) {
                cc = (Cartesian)vecAtomStart.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caStart = cc.getXYZ();
                }
                ++j;
            }
        }
        if ((index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator())) > -1) {
            pdb = this.vecPdbSSE.elementAt(index);
            resEnd = pdb.getResidue();
            vecAtomEnd = pdb.getAtomVec();
            j = 0;
            while (j < vecAtomEnd.size()) {
                cc = (Cartesian)vecAtomEnd.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caEnd = cc.getXYZ();
                }
                ++j;
            }
        }
        int topSSEK = 5;
        double caSearchRange = 12.0;
        Vector vecAllCandPos = new Vector();
        int i = noStart + 1;
        while (i < noEnd) {
            String resid = "";
            int j2 = 0;
            while (j2 < this.vecSeq.size()) {
                Assign asg = this.vecSeq.elementAt(j2);
                int no = asg.getResidueNo();
                if (no == i) {
                    resid = asg.getResidueType().trim();
                }
                ++j2;
            }
            String rotamFile = String.valueOf(this.rotSrc) + resid.toLowerCase() + ".pdb";
            Vector<Object> pdbRotam = new Vector();
            pdbRotam = pp.readRotamerPdb(rotamFile);
            Vector<Pdb> vecPdbAchors = this.SearchSSEAnchors(topSSEK, i);
            double searchRadius = 11.0;
            Vector<double[]> vecCandPos = new Vector<double[]>();
            Pdb pdb_rot = (Pdb)pdbRotam.elementAt(0);
            Vector<Pdb> vecRotPdb = new Vector<Pdb>();
            vecRotPdb.add(pdb_rot);
            double scoreMax = -99999.9;
            double[] bestTranS = new double[3];
            double[] bestRotS = new double[3];
            int k = 0;
            while (k < vecPdbAchors.size()) {
                Pdb ppSSE = vecPdbAchors.elementAt(k);
                Vector<Cartesian> vecAtomSSE = ppSSE.getAtomVec();
                double[] caSSE = new double[3];
                double[] caSSEOrg = new double[3];
                double[] caSSEEnd = new double[3];
                double[] rotOrg = new double[3];
                double[] rotEnd = new double[3];
                double[] bestTran = new double[3];
                double[] bestRot = new double[3];
                int t = 0;
                while (t < vecAtomSSE.size()) {
                    Cartesian cc2 = vecAtomSSE.elementAt(t);
                    String atom2 = cc2.getAtom();
                    if (atom2.equalsIgnoreCase("CA")) {
                        caSSE = cc2.getXYZ();
                    }
                    ++t;
                }
                double tranResol = 2.0;
                double rotResol = 45.0;
                double tranResolCoarse = tranResol;
                caSSEOrg[0] = caSSE[0] + 4.0;
                caSSEOrg[1] = caSSE[1] + 4.0;
                caSSEOrg[2] = caSSE[2] + 4.0;
                caSSEEnd[0] = caSSE[0] + searchRadius;
                caSSEEnd[1] = caSSE[1] + searchRadius;
                caSSEEnd[2] = caSSE[2] + searchRadius;
                rotOrg[0] = 0.0;
                rotOrg[1] = 0.0;
                rotOrg[2] = 0.0;
                rotEnd[0] = 180.0;
                rotEnd[1] = 180.0;
                rotEnd[2] = 180.0;
                double sc = this.TranRotGridSearch(caSSEOrg, caSSEEnd, rotOrg, rotEnd, vecRotPdb, tranResol, rotResol, false, bestTran, bestRot);
                System.out.println("here after coarse sampling..." + i + "th...rotamer");
                tranResol = 0.6;
                rotResol = 10.0;
                caSSEOrg[0] = bestTran[0] - 1.5;
                caSSEOrg[1] = bestTran[1] - 1.5;
                caSSEOrg[2] = bestTran[2] - 1.5;
                caSSEEnd[0] = bestTran[0] + 1.5;
                caSSEEnd[1] = bestTran[1] + 1.5;
                caSSEEnd[2] = bestTran[2] + 1.5;
                rotOrg[0] = Math.max(bestRot[0] - 20.0, 0.0);
                rotOrg[1] = Math.max(bestRot[1] - 20.0, 0.0);
                rotOrg[2] = Math.max(bestRot[2] - 20.0, 0.0);
                rotEnd[0] = Math.min(bestRot[0] + 20.0, 180.0);
                rotEnd[1] = Math.min(bestRot[1] + 20.0, 180.0);
                rotEnd[2] = Math.min(bestRot[2] + 20.0, 180.0);
                sc = this.TranRotGridSearch(caSSEOrg, caSSEEnd, rotOrg, rotEnd, vecRotPdb, tranResol, rotResol, false, bestTran, bestRot);
                System.out.println("here after fine sampling..." + i + "th...rotamer");
                if (sc > scoreMax) {
                    scoreMax = sc;
                    System.arraycopy(bestTran, 0, bestTranS, 0, bestTran.length);
                    System.arraycopy(bestRot, 0, bestRotS, 0, bestRot.length);
                }
                vecCandPos.add(bestTran);
                ++k;
            }
            vecAllCandPos.add(vecCandPos);
            ++i;
        }
        return vecAllCandPos;
    }

    public void EvaluateCandPositions(int noStart, int noEnd, Vector vecCandPosAll, Vector vecPdbRef) {
        int i = noStart + 1;
        while (i < noEnd) {
            int indTemp = Collections.binarySearch(vecPdbRef, new Pdb(i), new Pdb.PdbComparator());
            if (indTemp < 0) {
                System.out.println("the starting residue not found...exist.");
                System.exit(0);
            }
            Pdb pdbRefCur = (Pdb)vecPdbRef.elementAt(indTemp);
            Vector<Cartesian> atomVecRefCur = pdbRefCur.getAtomVec();
            double[] caRefCur = new double[3];
            int k = 0;
            while (k < atomVecRefCur.size()) {
                Cartesian cc = atomVecRefCur.elementAt(k);
                String atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    caRefCur = cc.getXYZ();
                }
                ++k;
            }
            int index = i - (noStart + 1);
            Vector vecCandPosCur = (Vector)vecCandPosAll.elementAt(index);
            double minDist = 999999.9;
            if (vecCandPosCur.size() < 1) {
                System.out.println("empty candidate position set...");
            } else {
                double[] caPos;
                RotaPattern rtp;
                System.out.println("Total number of candidate positions for " + i + "th residue is: " + vecCandPosCur.size());
                double[] x = new double[vecCandPosCur.size()];
                double[] y = new double[vecCandPosCur.size()];
                double[] z = new double[vecCandPosCur.size()];
                String tempXStr = "x=[ ";
                String tempYStr = "y=[ ";
                String tempZStr = "z=[ ";
                int j = 0;
                while (j < vecCandPosCur.size()) {
                    rtp = (RotaPattern)vecCandPosCur.elementAt(j);
                    caPos = new double[3];
                    caPos = rtp.getCoord();
                    tempXStr = String.valueOf(tempXStr) + caPos[0] + ",";
                    tempYStr = String.valueOf(tempYStr) + caPos[1] + ",";
                    tempZStr = String.valueOf(tempZStr) + caPos[2] + ",";
                    ++j;
                }
                System.out.println("The X coordinate is:");
                System.out.println(tempXStr);
                System.out.println("The Y coordinate is:");
                System.out.println(tempYStr);
                System.out.println("The Z coordinate is:");
                System.out.println(tempZStr);
                j = 0;
                while (j < vecCandPosCur.size()) {
                    rtp = (RotaPattern)vecCandPosCur.elementAt(j);
                    caPos = new double[3];
                    caPos = rtp.getCoord();
                    double[] caCand = new double[]{caPos[0], caPos[1], caPos[2]};
                    double distance = Math.sqrt((caRefCur[0] - caCand[0]) * (caRefCur[0] - caCand[0]) + (caRefCur[1] - caCand[1]) * (caRefCur[1] - caCand[1]) + (caRefCur[2] - caCand[2]) * (caRefCur[2] - caCand[2]));
                    if (distance < minDist) {
                        minDist = distance;
                    }
                    ++j;
                }
                System.out.println("res no: " + i + "   distance: " + minDist);
            }
            ++i;
        }
    }

    public Vector myPdbVectorCopy(Vector vecSrc) {
        Vector<Pdb> vecFinal = new Vector<Pdb>();
        int j = 0;
        while (j < vecSrc.size()) {
            Pdb pdb = (Pdb)vecSrc.elementAt(j);
            Pdb pdbCopy = new Pdb(pdb);
            vecFinal.add(pdbCopy);
            ++j;
        }
        return vecFinal;
    }

    public static void main(String[] args) {
        int index;
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Loops lp = new Loops();
        PdbRdc pdc = new PdbRdc();
        Goal goal = new Goal();
        String userDir = System.getProperty("user.dir");
        String strInPath = String.valueOf(userDir) + "/inputFiles-temp/";
        String strOut = String.valueOf(userDir) + "/outFiles/";
        String userDirTemp = System.getProperty("user.dir");
        String strRamaAla = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-ala-nosec.data";
        String strRamaGeneral = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-general-nosec.data";
        String strRamaGly = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
        String strRamaPro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-pro.data";
        String strRamaPrePro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-prepro.data";
        goal.vecRamaAla = lp.ReadRamachandranFile(strRamaAla);
        goal.vecRamaGeneral = lp.ReadRamachandranFile(strRamaGeneral);
        goal.vecRamaGly = lp.ReadRamachandranFile(strRamaGly);
        goal.vecRamaPro = lp.ReadRamachandranFile(strRamaPro);
        goal.vecRamaPrePro = lp.ReadRamachandranFile(strRamaPrePro);
        String strOutPdb = "test_loop.pdb";
        int noStart = 121;
        int noEnd = 124;
        String strPdbTest = String.valueOf(strInPath) + "1thf_h.pdb";
        double AT_syy = 7.74;
        double AT_szz = 12.66;
        goal.isForward = false;
        goal.isAllGridSearch = true;
        goal.gapThreshold = 1.0;
        goal.rdcThreshold = 2.0;
        double sigmaErr = 0.5;
        long seed = 26111L;
        double AT_sxx = -AT_syy - AT_szz;
        Vector<Pdb> vecPdbTest = pp.readPdb(strPdbTest);
        goal.vecSeq = new Vector();
        int i = 0;
        while (i < vecPdbTest.size()) {
            Pdb pdb = vecPdbTest.elementAt(i);
            int res_no = pdb.getResidueNo();
            String res = pdb.getResidue();
            goal.vecSeq.add(new Assign(res_no, res));
            ++i;
        }
        Vector<Pdb> vecPdbTemp = new Vector<Pdb>();
        int i2 = 0;
        while (i2 < vecPdbTest.size()) {
            Pdb pdb = vecPdbTest.elementAt(i2);
            int res_no = pdb.getResidueNo();
            if (res_no <= noStart || res_no >= noEnd) {
                vecPdbTemp.add(pdb);
            }
            ++i2;
        }
        Collections.sort(vecPdbTemp, new Pdb.PdbComparator());
        goal.vecPdbSSE = new Vector();
        goal.vecPdbSSE.addAll(vecPdbTemp);
        Random rr = new Random(seed);
        double[][] mat = new double[3][3];
        Matrix mm = new Matrix(3, 3);
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                mat[x][y] = x == y ? 1.0 : 0.0;
                ++y;
            }
            ++x;
        }
        mm = new Matrix(mat);
        String atom1 = "N";
        String atom2 = "HN";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] nToNHVec = new double[3];
        double rdcRatio = 1.0;
        int i3 = 0;
        while (i3 < vecPdbTest.size()) {
            Pdb pdb = vecPdbTest.elementAt(i3);
            String res = pdb.getResidue();
            if (!res.equalsIgnoreCase("PRO")) {
                int res_no = pdb.getResidueNo();
                Vector<Cartesian> atomVec = pdb.getAtomVec();
                int j = 0;
                while (j < atomVec.size()) {
                    Cartesian cc = atomVec.elementAt(j);
                    String atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("H")) {
                        atom = "HN";
                    }
                    if (atom.equals(atom1)) {
                        amide = cc.getXYZ();
                    } else if (atom.equals(atom2)) {
                        nh = cc.getXYZ();
                    }
                    ++j;
                }
                nToNHVec = pdc.internuclearVec(amide, nh);
                nToNHVec = mm.times(pdc.dirCos(nToNHVec));
                double cosX = nToNHVec[0];
                double cosY = nToNHVec[1];
                double cosZ = nToNHVec[2];
                double rdc_value = (cosX * cosX * AT_sxx + cosY * cosY * AT_syy + cosZ * cosZ * AT_szz) * rdcRatio;
                goal.vecNhRDC.add(new Dipolar(res_no, "", rdc_value += sigmaErr * rr.nextGaussian(), 0.0));
            }
            ++i3;
        }
        atom1 = "CA";
        atom2 = "HA";
        double[] ca = new double[3];
        double[] ha = new double[3];
        double[] caToHaVec = new double[3];
        rdcRatio = 1.0;
        int i4 = 0;
        while (i4 < vecPdbTest.size()) {
            Pdb pdb = vecPdbTest.elementAt(i4);
            int res_no = pdb.getResidueNo();
            String res = pdb.getResidue();
            if (!res.equalsIgnoreCase("GLY")) {
                Vector<Cartesian> atomVec = pdb.getAtomVec();
                int j = 0;
                while (j < atomVec.size()) {
                    Cartesian cc = atomVec.elementAt(j);
                    String atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("H")) {
                        atom = "HN";
                    }
                    if (atom.equals(atom1)) {
                        ca = cc.getXYZ();
                    } else if (atom.equals(atom2)) {
                        ha = cc.getXYZ();
                    }
                    ++j;
                }
                caToHaVec = pdc.internuclearVec(ca, ha);
                caToHaVec = mm.times(pdc.dirCos(caToHaVec));
                double cosX = caToHaVec[0];
                double cosY = caToHaVec[1];
                double cosZ = caToHaVec[2];
                double rdc_value = (cosX * cosX * AT_sxx + cosY * cosY * AT_syy + cosZ * cosZ * AT_szz) * rdcRatio;
                goal.vecChRDC.add(new Dipolar(res_no, "", rdc_value += sigmaErr * rr.nextGaussian(), 0.0));
            }
            ++i4;
        }
        PdbRdc pdr = new PdbRdc();
        int N = goal.vecPdbSSE.size();
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double[] saupeSave = new double[4];
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for both CH and NH RDC:  ");
        mm = pdr.bestFit(goal.vecPdbSSE, goal.vecNhRDC, goal.vecChRDC, rdc1Cal, rdc2Cal, saupeSave);
        Vector<Object> vecPdbSSENew = new Vector();
        vecPdbSSENew = pp.newPdb(goal.vecPdbSSE, mm);
        goal.vecPdbSSE = new Vector();
        goal.vecPdbSSE.addAll(vecPdbSSENew);
        double Syy = saupeSave[0];
        double Szz = saupeSave[1];
        goal.Syy = Syy;
        goal.Szz = Szz;
        double Sxx = -Syy - Szz;
        double rdc1Rmsd = saupeSave[2];
        double rdc2Rmsd = saupeSave[3];
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for my own calculation:");
        System.out.println("Sxx, Syy, Szz =    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        goal.maxLeafNodes = 10000;
        Vector vecFinal = new Vector();
        Pdb pdbFixed = new Pdb();
        if (goal.isForward) {
            index = Collections.binarySearch(goal.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
            if (index < 0) {
                System.out.println("error: fixed residue not found...exist...");
                System.exit(0);
            }
            pdbFixed = goal.vecPdbSSE.elementAt(index);
        } else {
            index = Collections.binarySearch(goal.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
            if (index < 0) {
                System.out.println("error: fixed residue not found...exist...");
                System.exit(0);
            }
            pdbFixed = goal.vecPdbSSE.elementAt(index);
        }
        Vector vecFixAtomSet = new Vector();
        vecFixAtomSet = goal.isForward ? goal.SampleFirstHalfPlanes(noStart, false) : goal.SampleFirstHalfPlanes(noEnd, false);
        System.out.println("Total number of initial positions: " + vecFixAtomSet.size());
        int i5 = 0;
        while (i5 < vecFixAtomSet.size()) {
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            System.out.println("The " + i5 + "th initial positions: ");
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            Vector vecAtomTemp = (Vector)vecFixAtomSet.elementAt(i5);
            pdbFixed.setAtomVec(vecAtomTemp);
            vecFinal = new Vector();
            vecFinal = goal.isForward ? goal.LoopAllComputation(noStart, noEnd) : goal.LoopAllComputationBackward(noStart, noEnd);
            ++i5;
        }
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int t = 0;
            while (t < vecFinal.size()) {
                Vector vecOneFragment = (Vector)vecFinal.elementAt(t);
                pp.printToFile(vecOneFragment, fileName, out);
                out.println("TER");
                ++t;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for computing loop fragments is:  " + totalTime + " minutes");
    }

    public void doGoalCalLoops(String src, String strOut, String strInput) throws JampackException {
        int index;
        Vector<Object> vecTemp;
        double cs_h2;
        double cs_h1;
        Noesy noesy2;
        String rotSrc;
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        this.rotSrc = rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        String userDirTemp = System.getProperty("user.dir");
        Loops lp = new Loops();
        String strRamaAla = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-ala-nosec.data";
        String strRamaGeneral = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-general-nosec.data";
        String strRamaGly = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
        String strRamaPro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-pro.data";
        String strRamaPrePro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-prepro.data";
        this.vecRamaAla = lp.ReadRamachandranFile(strRamaAla);
        this.vecRamaGeneral = lp.ReadRamachandranFile(strRamaGeneral);
        this.vecRamaGly = lp.ReadRamachandranFile(strRamaGly);
        this.vecRamaPro = lp.ReadRamachandranFile(strRamaPro);
        this.vecRamaPrePro = lp.ReadRamachandranFile(strRamaPrePro);
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strBB = "";
        String stroutName = "";
        String strOutOrFormat = "";
        String strSSEBB = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        int nIsoriginalUp = 0;
        int noStart = 0;
        int noEnd = 0;
        double Syy = 0.0;
        double Szz = 0.0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        double gap_Threshold = 0.0;
        double rdc_Threshold = 0.0;
        String strReson = "";
        String strResFormat = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String str4DNoesy = "";
        String strNoesyFormat = "";
        String strSSEPDBFile = "";
        String strChFile = "";
        String strNhFile = "";
        String strOutPdb = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strIsScaled = "";
        String strIsForward = "";
        String strIsAllGridSearch = "";
        String strIsSampleInitPlane = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("SSEBB")) {
                strSSEBB = paraMap.get("SSEBB");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            if (paraMap.containsKey("ISSCALED")) {
                strIsScaled = paraMap.get("ISSCALED");
            }
            if (paraMap.containsKey("ISFORWARD")) {
                strIsForward = paraMap.get("ISFORWARD");
            }
            if (paraMap.containsKey("ISALLGRIDSEARCH")) {
                strIsAllGridSearch = paraMap.get("ISALLGRIDSEARCH");
            }
            if (paraMap.containsKey("ISSAMPLEINITPLANE")) {
                strIsSampleInitPlane = paraMap.get("ISSAMPLEINITPLANE");
            }
            if (paraMap.containsKey("GAPTHRESHOLD")) {
                gap_Threshold = Double.parseDouble(paraMap.get("GAPTHRESHOLD"));
            }
            if (paraMap.containsKey("RDCTHRESHOLD")) {
                rdc_Threshold = Double.parseDouble(paraMap.get("RDCTHRESHOLD"));
            }
            if (paraMap.containsKey("SSES")) {
                strSSEPDBFile = paraMap.get("SSES");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("FIRSTNO")) {
                noStart = Integer.parseInt(paraMap.get("FIRSTNO"));
            }
            if (paraMap.containsKey("LASTNO")) {
                noEnd = Integer.parseInt(paraMap.get("LASTNO"));
            }
            ++i;
        }
        this.gapThreshold = gap_Threshold;
        this.rdcThreshold = rdc_Threshold;
        this.isForward = strIsForward.equalsIgnoreCase("1");
        this.isAllGridSearch = strIsAllGridSearch.equalsIgnoreCase("1");
        boolean isSampleInitPlane = false;
        isSampleInitPlane = strIsSampleInitPlane.equalsIgnoreCase("1");
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector cacoRdc = new Vector();
        Vector conRdc = new Vector();
        Vector nhRdc = new Vector();
        Vector cahaRdc = new Vector();
        double scale_ca_to_nh = Math.pow(1.0686274509803921, 3.0) * 0.40267459138187217;
        nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        cahaRdc = strIsScaled.equalsIgnoreCase("1") ? dd.rdcRead(strChRdcFile, 1.0) : dd.rdcRead(strChRdcFile, scale_ca_to_nh);
        this.vecNhRDC = new Vector();
        this.vecNhRDC.addAll(nhRdc);
        this.vecChRDC = new Vector();
        this.vecChRDC.addAll(cahaRdc);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warn: The Co-Ca RDC doesn't exist.");
        }
        if (existCoN) {
            dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warn: The Co-N RDC doesn't exist.");
        }
        String seqFile = String.valueOf(src) + strSeq;
        this.vecSeq = asg.ReaderSeq(seqFile);
        String ssePdbFile = String.valueOf(userDirTemp) + strSSEPDBFile;
        Vector<Pdb> vecPdbSSETemp = pp.readPdb(ssePdbFile);
        Vector<Pdb> vecSSETemp2 = pp.residueNameUpdateNoStr(this.vecSeq, vecPdbSSETemp);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, this.vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        this.vecAsg = new Vector();
        this.vecAsg.addAll(assignVec);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL") && !str4DNoesy.equalsIgnoreCase("")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector vecNoesy4D = new Vector();
        vecNoesy4D.addAll(Noe4DVec);
        String pdbSSEFile = String.valueOf(userDirTemp) + strSSEPDBFile;
        Vector<Pdb> vecSSE = pp.readPdb(pdbSSEFile);
        double[] constant = new double[1];
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        this.caliConstant = constant[0];
        Vector<Noesy> vecNoesyNoDia = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            noesy2 = (Noesy)vecNoesy.elementAt(i);
            cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.01) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy = new Vector();
        vecNoesy.addAll(vecNoesyNoDia);
        vecNoesyNoDia = new Vector();
        i = 0;
        while (i < vecNoesy4D.size()) {
            noesy2 = (Noesy)vecNoesy4D.elementAt(i);
            cs_h1 = noesy2.getH1();
            cs_h2 = noesy2.getH2();
            double cs_heavy1 = noesy2.getHeavy1();
            double cs_heavy2 = noesy2.getHeavy2();
            if (Math.abs(cs_h1 - cs_h2) > 0.04 && Math.abs(cs_heavy1 - cs_heavy2) > 0.06) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy4D = new Vector();
        vecNoesy4D.addAll(vecNoesyNoDia);
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        Vector vecNewNoesy4D = new Vector();
        vecNewNoesy.addAll(vecNoesy);
        vecNewNoesy4D.addAll(vecNoesy4D);
        Vector<Noe> vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNoesy);
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        vecNewNoes.addAll(vecAmbgAsg);
        if (strResNameScheme.equalsIgnoreCase("PDB-NEW")) {
            vecTemp = new Vector();
            Noe ee = new Noe();
            vecTemp = ee.NameConvertFromPDBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
        }
        if (strResNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            vecTemp = new Vector();
            Noe ee = new Noe();
            vecTemp = ee.NameConvertFromBMRBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
            Vector<Object> vecAsgNew = new Vector();
            H1CS h1cs = new H1CS();
            vecAsgNew = h1cs.CSNameConvertFromBMRBNewToPDBNew(assignVec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgNew);
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNewNoes);
        this.vecAmbNOEs = new Vector();
        this.vecAmbNOEs.addAll(vecAmbgAsg);
        double csErrH = 0.04;
        double csErrHeavy = 0.2;
        this.vecNOESY = new Vector();
        this.vecNOESY.addAll(vecNoesy);
        Vector<Pdb> vecSSE2Rot = pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy, vecSSETemp2, assignVec, rotSrc, vecNoesy, 4.5, 1, this.caliConstant);
        this.vecPdbSSE = new Vector();
        this.vecPdbSSE.addAll(vecSSE2Rot);
        PdbRdc pdr = new PdbRdc();
        int N = this.vecPdbSSE.size();
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double[] saupeSave = new double[4];
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for both CH and NH RDC:  ");
        Matrix mm = pdr.bestFit(this.vecPdbSSE, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupeSave);
        Vector<Object> vecPdbSSENew = new Vector();
        vecPdbSSENew = pp.newPdb(this.vecPdbSSE, mm);
        this.vecPdbSSE = new Vector();
        this.vecPdbSSE.addAll(vecPdbSSENew);
        Syy = saupeSave[0];
        Szz = saupeSave[1];
        this.Syy = Syy;
        this.Szz = Szz;
        double Sxx = -Syy - Szz;
        double rdc1Rmsd = saupeSave[2];
        double rdc2Rmsd = saupeSave[3];
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for my own calculation:");
        System.out.println("Sxx, Syy, Szz =    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (ind < 0) {
            System.out.println("the starting residue not found...exist.");
            System.exit(0);
        }
        Pdb pdbStart = this.vecPdbSSE.elementAt(ind);
        Vector<Cartesian> atomVecStart = pdbStart.getAtomVec();
        int k = 0;
        while (k < atomVecStart.size()) {
            Cartesian cc = atomVecStart.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        boolean isSkipNOE = false;
        this.maxLeafNodes = 10000;
        Vector vecFinal = new Vector();
        Pdb pdbFixed = new Pdb();
        if (this.isForward) {
            index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
            if (index < 0) {
                System.out.println("error: fixed residue not found...exist...");
                System.exit(0);
            }
            pdbFixed = this.vecPdbSSE.elementAt(index);
        } else {
            index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
            if (index < 0) {
                System.out.println("error: fixed residue not found...exist...");
                System.exit(0);
            }
            pdbFixed = this.vecPdbSSE.elementAt(index);
        }
        Vector vecFixAtomSet = new Vector();
        vecFixAtomSet = this.isForward ? this.SampleFirstHalfPlanes(noStart, isSampleInitPlane) : this.SampleFirstHalfPlanes(noEnd, false);
        System.out.println("Total number of initial positions: " + vecFixAtomSet.size());
        i = 0;
        while (i < vecFixAtomSet.size()) {
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            System.out.println("The " + i + "th initial positions: ");
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            Vector vecAtomTemp = (Vector)vecFixAtomSet.elementAt(i);
            pdbFixed.setAtomVec(vecAtomTemp);
            vecFinal = new Vector();
            vecFinal = this.isForward ? this.LoopAllComputation(noStart, noEnd) : this.LoopAllComputationBackward(noStart, noEnd);
            vecFinal.add(this.vecPdbSSE);
            ++i;
        }
        System.out.println("REMARK ++++++++++++++++++++++++++++++++++++++");
        System.out.println("REMARK Here is the SSEs");
        System.out.println("TER");
        pp.print(this.vecPdbSSE);
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int t = 0;
            while (t < vecFinal.size()) {
                Vector vecOneFragment = (Vector)vecFinal.elementAt(t);
                pp.printToFile(vecOneFragment, fileName, out);
                out.println("TER");
                ++t;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for computing loop fragments is:  " + totalTime + " minutes");
    }

    public class TreePdb {
        public int id = -1;
        public Pdb pdb = new Pdb();
        public Vector parenPdb = new Vector();
        public Vector vecChildPdb = new Vector();
        public double nhRdcDif = -99999.9;
        public double chRdcDif = -99999.9;
        public double sumRdcDif = -99999.9;
        public double ramaScore = 0.0;
        public double endDist = 9999.9;
        public double noeScore = 0.0;

        public TreePdb(TreePdb old) {
            Pdb pp = old.pdb;
            this.pdb = new Pdb(pp.getResidueNo(), pp.getResidue(), pp.getAtomVec());
            this.parenPdb = new Vector();
            this.parenPdb.addAll(old.parenPdb);
            this.vecChildPdb = new Vector();
            this.vecChildPdb.addAll(old.vecChildPdb);
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public TreePdb() {
            this.pdb = new Pdb();
            this.parenPdb = new Vector();
            this.vecChildPdb = new Vector();
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public TreePdb(int No, String res, Vector aa) {
            this.pdb = new Pdb(No, res, aa);
            this.parenPdb = new Vector();
            this.vecChildPdb = new Vector();
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public TreePdb(Pdb pp) {
            this.pdb = pp;
            this.parenPdb = new Vector();
            this.vecChildPdb = new Vector();
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public TreePdb(int No, String res, Vector aa, Vector pare, TreePdb child) {
            this.pdb = new Pdb(No, res, aa);
            this.parenPdb.addAll(pare);
            this.vecChildPdb.add(child);
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public TreePdb(Pdb pp, Vector pare, TreePdb child) {
            this.pdb = pp;
            this.parenPdb.addAll(pare);
            this.vecChildPdb.add(child);
            this.nhRdcDif = -99999.9;
            this.chRdcDif = -99999.9;
            this.ramaScore = 0.0;
            this.endDist = 9999.9;
            this.id = -1;
        }

        public void SetParenPdb(TreePdb pare) {
            this.parenPdb.add(pare);
        }

        public void SetPdb(Pdb pp) {
            this.pdb = pp;
        }

        public void SetID(int ident) {
            this.id = ident;
        }

        public void AddChildPdb(TreePdb child) {
            this.vecChildPdb.add(child);
        }

        public void SetNhRdcDif(double rdc) {
            this.nhRdcDif = rdc;
        }

        public void SetChRdcDif(double rdc) {
            this.chRdcDif = rdc;
        }

        public void SetSumRdcDif(double rdc) {
            this.sumRdcDif = rdc;
        }

        public void SetRamaScore(double sc) {
            this.ramaScore = sc;
        }

        public void SetEndDist(double dist) {
            this.endDist = dist;
        }

        public double GetNhRdcDif() {
            return this.nhRdcDif;
        }

        public double GetChRdcDif() {
            return this.chRdcDif;
        }

        public double GetSumRdcDif() {
            return this.sumRdcDif;
        }

        public double GetRamaScore() {
            return this.ramaScore;
        }

        public double GetEndDist() {
            return this.endDist;
        }

        public int GetID() {
            return this.id;
        }
    }

    public static class TreePdbAllComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            double d1 = n1.GetChRdcDif() + n1.GetNhRdcDif() + n1.GetRamaScore();
            if (d1 < (d2 = n2.GetChRdcDif() + n2.GetNhRdcDif() + n2.GetRamaScore())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class TreePdbIDComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            int d1 = n1.GetID();
            if (d1 < (d2 = n2.GetID())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class TreePdbNOEComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            double d1 = n1.noeScore;
            double d2 = n2.noeScore;
            if (d1 > d2) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class TreePdbRDCComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            double d1 = n1.GetChRdcDif() + n1.GetNhRdcDif();
            if (d1 < (d2 = n2.GetChRdcDif() + n2.GetNhRdcDif())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class TreePdbRamaComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            double d1 = n1.GetRamaScore();
            if (d1 < (d2 = n2.GetRamaScore())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class TreePdbSumRDCComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            TreePdb n1 = (TreePdb)o1;
            TreePdb n2 = (TreePdb)o2;
            double d1 = n1.GetSumRdcDif();
            if (d1 < (d2 = n2.GetSumRdcDif())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

