/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

public class Cartesian {
    private String atom;
    private double xCoord;
    private double yCoord;
    private double zCoord;

    public Cartesian() {
        this.atom = null;
        this.xCoord = 0.0;
        this.yCoord = 0.0;
        this.zCoord = 0.0;
    }

    public Cartesian(Cartesian cart) {
        this.atom = cart.getAtom();
        this.xCoord = cart.getX();
        this.yCoord = cart.getY();
        this.zCoord = cart.getZ();
    }

    public Cartesian(String aa, double X, double Y, double Z2) {
        this.atom = aa;
        this.xCoord = X;
        this.yCoord = Y;
        this.zCoord = Z2;
    }

    public Cartesian(String aa, double[] c) {
        this.atom = aa;
        this.xCoord = c[0];
        this.yCoord = c[1];
        this.zCoord = c[2];
    }

    public String getAtom() {
        return this.atom;
    }

    public double getX() {
        return this.xCoord;
    }

    public double getY() {
        return this.yCoord;
    }

    public double getZ() {
        return this.zCoord;
    }

    public void setAtom(String aName) {
        this.atom = aName;
    }

    public double measureDist(Cartesian ccA, Cartesian ccB) {
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        coordA = ccA.getXYZ();
        coordB = ccB.getXYZ();
        double distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
        return distance;
    }

    public double[] getXYZ() {
        return new double[]{this.xCoord, this.yCoord, this.zCoord};
    }

    public String toString() {
        String desc = String.valueOf(this.atom) + "  " + String.valueOf(this.xCoord) + "  " + String.valueOf(this.yCoord) + " " + String.valueOf(this.zCoord);
        return desc;
    }
}

