/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import rdcPanda.Matrix;
import rdcPanda.Pdb;

public class sp3Carbon {
    private double theta1;
    private double theta2;
    private double theta3;
    private double chi;
    private double theta2d;
    private double theta3d;
    private double d1;
    private double d2;
    private double d3;
    private boolean terminal = false;
    static final double cst = 57.29577951308232;

    public sp3Carbon() {
        this.theta1 = 0.0;
        this.theta2 = 0.0;
        this.theta3 = 0.0;
        this.chi = 0.0;
        this.theta2d = 0.0;
        this.theta3d = 0.0;
        this.d1 = 0.0;
        this.d2 = 0.0;
        this.d3 = 0.0;
        this.terminal = false;
    }

    public sp3Carbon(double theta1a, double theta2a, double theta3a, double chia, double theta2da, double theta3da, double d1a, double d2a, double d3a, boolean ter) {
        this.theta1 = theta1a;
        this.theta2 = theta2a;
        this.theta3 = theta3a;
        this.chi = chia;
        this.theta2d = theta2da;
        this.theta3d = theta3da;
        this.d1 = d1a;
        this.d2 = d2a;
        this.d3 = d3a;
        this.terminal = ter;
    }

    public sp3Carbon(double[] anglesAndLen, boolean ter) {
        this.theta1 = anglesAndLen[0];
        this.theta2 = anglesAndLen[1];
        this.theta3 = anglesAndLen[2];
        this.chi = anglesAndLen[3];
        this.theta2d = anglesAndLen[4];
        this.theta3d = anglesAndLen[5];
        this.d1 = anglesAndLen[6];
        this.d2 = anglesAndLen[7];
        this.d3 = anglesAndLen[8];
        this.terminal = ter;
    }

    public sp3Carbon(double[] atomOfChi, double[] top, double[] center, double[] vertex1, double[] vertex2, double[] vertex3, boolean ter) {
        double[] anglesAndLen = this.anglesAndLenOfSp3(atomOfChi, top, center, vertex1, vertex2, vertex3);
        this.theta1 = anglesAndLen[0];
        this.theta2 = anglesAndLen[1];
        this.theta3 = anglesAndLen[2];
        this.chi = anglesAndLen[3];
        this.theta2d = anglesAndLen[4];
        this.theta3d = anglesAndLen[5];
        this.d1 = anglesAndLen[6];
        this.d2 = anglesAndLen[7];
        this.d3 = anglesAndLen[8];
        this.terminal = ter;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.theta1 * 57.29577951308232)) + "  " + String.valueOf(this.theta2 * 57.29577951308232) + "  " + String.valueOf(this.theta3 * 57.29577951308232) + "\n";
        desc = String.valueOf(desc) + String.valueOf(this.chi * 57.29577951308232) + "  " + String.valueOf(this.theta2d * 57.29577951308232) + "  " + String.valueOf(this.theta3d * 57.29577951308232) + "\n";
        return desc;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public double[] getAll() {
        return new double[]{this.theta1, this.theta2, this.theta3, this.chi, this.theta2d, this.theta3d, this.d1, this.d2, this.d3};
    }

    public double[] addCoords(double[] n1, double[] n2) {
        return new double[]{n2[0] + n1[0], n2[1] + n1[1], n2[2] + n1[2]};
    }

    public void printArray(double[] n1) {
        int i = 0;
        while (i < n1.length) {
            System.out.print(String.valueOf(n1[i]) + "  ");
            ++i;
        }
        System.out.println();
    }

    public Matrix[] tetrahedral(double[] center, Matrix mat, sp3Carbon atomC) {
        double[] allElements = atomC.getAll();
        double theta1 = allElements[0];
        double theta2 = allElements[1];
        double theta3 = allElements[2];
        double chi = allElements[3];
        double theta2d = allElements[4];
        double theta3d = allElements[5];
        double d1 = allElements[6];
        double d2 = allElements[7];
        double d3 = allElements[8];
        Matrix rx1Inv = mat.rotationMat(theta1, "-x");
        Matrix rx2Inv = mat.rotationMat(theta2, "-x");
        Matrix rx3Inv = mat.rotationMat(theta3, "-x");
        Matrix ryChiInv = mat.rotationMat(chi, "-y");
        Matrix ry2dInv = mat.rotationMat(theta2d, "-y");
        Matrix ry3dInv = mat.rotationMat(theta3d, "-y");
        double[] coord1 = new double[]{0.0, d1, 0.0};
        double[] v1 = mat.times(ryChiInv.times(rx1Inv.times(coord1)));
        coord1 = this.addCoords(center, v1);
        double[] coord2 = new double[]{0.0, d2, 0.0};
        double[] v2 = mat.times(ryChiInv.times(ry2dInv.times(rx2Inv.times(coord2))));
        coord2 = this.addCoords(center, v2);
        double[] coord3 = new double[]{0.0, d3, 0.0};
        double[] v3 = mat.times(ryChiInv.times(ry3dInv.times(rx3Inv.times(coord3))));
        coord3 = this.addCoords(center, v3);
        if (!atomC.isTerminal()) {
            Matrix mat1 = mat.times(ryChiInv.times(rx1Inv));
            Matrix mat2 = mat.times(ryChiInv.times(ry2dInv.times(rx2Inv)));
            Matrix mat3 = mat.times(ryChiInv.times(ry3dInv.times(rx3Inv)));
            double[][] coords = new double[][]{{coord1[0], coord1[1], coord1[2]}, {coord2[0], coord2[1], coord2[2]}, {coord3[0], coord3[1], coord3[2]}};
            Matrix matCoords = new Matrix(coords);
            return new Matrix[]{matCoords, mat1, mat2, mat3};
        }
        double[][] coords = new double[][]{{coord1[0], coord1[1], coord1[2]}, {coord2[0], coord2[1], coord2[2]}, {coord3[0], coord3[1], coord3[2]}};
        Matrix matCoords = new Matrix(coords);
        return new Matrix[]{matCoords};
    }

    public double[] anglesAndLenOfSp3(double[] atomOfChi, double[] top, double[] center, double[] vertex1, double[] vertex2, double[] vertex3) {
        Pdb pp = new Pdb();
        double[] atom2Top = pp.internuclearVec(atomOfChi, top);
        double[] top2Center = pp.internuclearVec(top, center);
        double[] center2V1 = pp.internuclearVec(center, vertex1);
        double[] center2V2 = pp.internuclearVec(center, vertex2);
        double[] center2V3 = pp.internuclearVec(center, vertex3);
        double theta1 = pp.interAngle(top2Center, center2V1);
        double theta2 = pp.interAngle(top2Center, center2V2);
        double theta3 = pp.interAngle(top2Center, center2V3);
        double chi = Math.PI + pp.dihedralAngle(atom2Top, top2Center, center2V1);
        if (chi >= Math.PI) {
            chi -= Math.PI * 2;
        }
        double theta2d = pp.dihedralAngle(center2V1, top2Center, center2V2);
        double theta3d = pp.dihedralAngle(center2V1, top2Center, center2V3);
        double d1 = pp.length(center2V1);
        double d2 = pp.length(center2V2);
        double d3 = pp.length(center2V3);
        return new double[]{theta1, theta2, theta3, chi, theta2d, theta3d, d1, d2, d3};
    }
}

