/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.Peak;

public class Residue {
    private int residueNo = 0;
    private String residue = null;
    private Vector peakVec = new Vector();
    private Map noeMap = new TreeMap();
    private Vector hcchVec = new Vector();
    static final double GLY = 63.8;
    static final double ALA = 90.1;
    static final double VAL = 139.1;
    static final double ILE = 164.9;
    static final double LEU = 164.6;
    static final double MET = 167.7;
    static final double PHE = 193.5;
    static final double TYR = 197.1;
    static final double TRP = 231.7;
    static final double SER = 94.2;
    static final double THE = 120.0;
    static final double ASN = 127.5;
    static final double ASP = 117.1;
    static final double GLN = 149.4;
    static final double GLU = 140.8;
    static final double PRO = 123.1;
    static final double LYS = 170.0;
    static final double ARG = 186.4;
    static final double HIS = 190.0;
    static final double CYS = 96.2;

    public Residue() {
        this.residue = null;
        this.residueNo = 0;
        this.peakVec = null;
        this.hcchVec = null;
        this.noeMap = new TreeMap();
    }

    public Residue(int no) {
        this.residue = null;
        this.residueNo = no;
        this.peakVec = new Vector();
        this.hcchVec = new Vector();
        this.noeMap = new TreeMap();
    }

    public Residue(int no, String type) {
        this.residue = type;
        this.residueNo = no;
        this.peakVec = new Vector();
        this.hcchVec = new Vector();
        this.noeMap = new TreeMap();
    }

    public Residue(int no, String type, Vector hcVec) {
        this.residueNo = no;
        this.residue = type;
        this.peakVec = new Vector();
        this.hcchVec = hcVec;
        this.noeMap = new TreeMap();
    }

    public Residue(int no, String type, Vector pkVec, Vector hcVec) {
        this.residueNo = no;
        this.residue = type;
        this.peakVec = pkVec;
        this.hcchVec = hcVec;
        this.noeMap = new TreeMap();
    }

    public Residue(int no, String type, Vector pkVec, Map nVec) {
        this.residueNo = no;
        this.residue = type;
        this.peakVec = pkVec;
        this.noeMap = nVec;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residue;
    }

    public Vector getPeakVec() {
        return this.peakVec;
    }

    public Vector getHcchVec() {
        return this.hcchVec;
    }

    public Map getNoeMap() {
        return this.noeMap;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String R) {
        this.residue = R;
    }

    public void setPeakVec(Vector vec) {
        this.peakVec = vec;
    }

    public void setHcchVec(Vector vec) {
        this.hcchVec = vec;
    }

    public Map nucluesByAA(String type) {
        TreeMap<String, Double> mapAtoms = new TreeMap<String, Double>();
        double dummy = -999.99;
        if (type.equalsIgnoreCase("Gly")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("HA3", new Double(dummy));
            mapAtoms.put("HA2", new Double(dummy));
            mapAtoms.put("HA#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Ala")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Arg")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CD", new Double(dummy));
            mapAtoms.put("HD3", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HE", new Double(dummy));
            mapAtoms.put("HH11", new Double(dummy));
            mapAtoms.put("HH12", new Double(dummy));
            mapAtoms.put("HH1#", new Double(dummy));
            mapAtoms.put("HH21", new Double(dummy));
            mapAtoms.put("HH22", new Double(dummy));
            mapAtoms.put("HH2#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Asn")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("ND2", new Double(dummy));
            mapAtoms.put("HD21", new Double(dummy));
            mapAtoms.put("HD22", new Double(dummy));
            mapAtoms.put("HD2#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Asp")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Cys")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("HG", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Gln")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CD", new Double(dummy));
            mapAtoms.put("NE2", new Double(dummy));
            mapAtoms.put("HE21", new Double(dummy));
            mapAtoms.put("HE22", new Double(dummy));
            mapAtoms.put("HE2#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Glu")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CD", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("His")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HE1", new Double(dummy));
            mapAtoms.put("HE2", new Double(dummy));
            mapAtoms.put("HE#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Ile")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB", new Double(dummy));
            mapAtoms.put("CG1", new Double(dummy));
            mapAtoms.put("HG13", new Double(dummy));
            mapAtoms.put("HG12", new Double(dummy));
            mapAtoms.put("HG1#", new Double(dummy));
            mapAtoms.put("CG2", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Leu")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("CD2", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Lys")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CD", new Double(dummy));
            mapAtoms.put("HD3", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("CE", new Double(dummy));
            mapAtoms.put("HE3", new Double(dummy));
            mapAtoms.put("HE2", new Double(dummy));
            mapAtoms.put("HE#", new Double(dummy));
            mapAtoms.put("NZ", new Double(dummy));
            mapAtoms.put("HZ#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Met")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CE", new Double(dummy));
            mapAtoms.put("HE", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Phe")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("CD2", new Double(dummy));
            mapAtoms.put("CE1", new Double(dummy));
            mapAtoms.put("CE2", new Double(dummy));
            mapAtoms.put("CZ", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HE1", new Double(dummy));
            mapAtoms.put("HE2", new Double(dummy));
            mapAtoms.put("HE#", new Double(dummy));
            mapAtoms.put("HZ", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Ser")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("HG", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Thr")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB", new Double(dummy));
            mapAtoms.put("CG2", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            mapAtoms.put("HG1", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Trp")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("CD2", new Double(dummy));
            mapAtoms.put("CE2", new Double(dummy));
            mapAtoms.put("CE3", new Double(dummy));
            mapAtoms.put("CZ2", new Double(dummy));
            mapAtoms.put("CZ3", new Double(dummy));
            mapAtoms.put("NE1", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HE1", new Double(dummy));
            mapAtoms.put("HE3", new Double(dummy));
            mapAtoms.put("HZ2", new Double(dummy));
            mapAtoms.put("HZ3", new Double(dummy));
            mapAtoms.put("HH2", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Tyr")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("CD2", new Double(dummy));
            mapAtoms.put("CE1", new Double(dummy));
            mapAtoms.put("CE2", new Double(dummy));
            mapAtoms.put("CZ", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HE1", new Double(dummy));
            mapAtoms.put("HE2", new Double(dummy));
            mapAtoms.put("HE#", new Double(dummy));
            mapAtoms.put("HH", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Val")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB", new Double(dummy));
            mapAtoms.put("CG1", new Double(dummy));
            mapAtoms.put("HG1", new Double(dummy));
            mapAtoms.put("CG2", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Pro")) {
            mapAtoms.put("H", new Double(dummy));
            mapAtoms.put("N", new Double(dummy));
            mapAtoms.put("C", new Double(dummy));
            mapAtoms.put("CA", new Double(dummy));
            mapAtoms.put("HA", new Double(dummy));
            mapAtoms.put("CB", new Double(dummy));
            mapAtoms.put("HB3", new Double(dummy));
            mapAtoms.put("HB2", new Double(dummy));
            mapAtoms.put("HB#", new Double(dummy));
            mapAtoms.put("CG", new Double(dummy));
            mapAtoms.put("HG3", new Double(dummy));
            mapAtoms.put("HG2", new Double(dummy));
            mapAtoms.put("HG#", new Double(dummy));
            mapAtoms.put("CD", new Double(dummy));
            mapAtoms.put("HD3", new Double(dummy));
            mapAtoms.put("HD2", new Double(dummy));
            mapAtoms.put("HD#", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        return mapAtoms;
    }

    public Map fromCB(String type) {
        TreeMap<String, Double> mapAtoms = new TreeMap<String, Double>();
        double dummy = -999.99;
        if (type.equalsIgnoreCase("Ala")) {
            mapAtoms.put("HB", new Double(1.09));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Arg")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG3", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HG#", new Double(2.06));
            mapAtoms.put("HD3", new Double(3.35));
            mapAtoms.put("HD2", new Double(3.35));
            mapAtoms.put("HE", new Double(4.0));
            mapAtoms.put("HD#", new Double(3.35));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Asn")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HD21", new Double(2.06));
            mapAtoms.put("HD22", new Double(2.06));
            mapAtoms.put("HD2#", new Double(2.06));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Asp")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Cys")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Gln")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG3", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HG#", new Double(2.06));
            mapAtoms.put("HE21", new Double(3.35));
            mapAtoms.put("HE22", new Double(3.35));
            mapAtoms.put("HE2#", new Double(3.35));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Glu")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG3", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HG#", new Double(2.06));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("His")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HD1", new Double(2.67));
            mapAtoms.put("HD2", new Double(2.67));
            mapAtoms.put("HD#", new Double(2.67));
            mapAtoms.put("HE1", new Double(4.55));
            mapAtoms.put("HE2", new Double(4.55));
            mapAtoms.put("HE#", new Double(4.55));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Ile")) {
            mapAtoms.put("HB", new Double(1.09));
            mapAtoms.put("HG13", new Double(2.06));
            mapAtoms.put("HG12", new Double(2.06));
            mapAtoms.put("HG1#", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HD1", new Double(3.35));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Leu")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG", new Double(2.06));
            mapAtoms.put("HD1", new Double(3.35));
            mapAtoms.put("HD2", new Double(3.35));
            mapAtoms.put("HD#", new Double(3.35));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Lys")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG3", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HG#", new Double(2.06));
            mapAtoms.put("HD3", new Double(3.35));
            mapAtoms.put("HD2", new Double(3.35));
            mapAtoms.put("HD#", new Double(3.35));
            mapAtoms.put("HE3", new Double(4.0));
            mapAtoms.put("HE2", new Double(4.0));
            mapAtoms.put("HE#", new Double(4.0));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Met")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HG3", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            mapAtoms.put("HG#", new Double(2.06));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Phe")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HD1", new Double(2.67));
            mapAtoms.put("HD2", new Double(2.67));
            mapAtoms.put("HD#", new Double(2.67));
            mapAtoms.put("HE1", new Double(4.55));
            mapAtoms.put("HE2", new Double(4.55));
            mapAtoms.put("HE#", new Double(4.55));
            mapAtoms.put("HZ", new Double(5.0));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Ser")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Thr")) {
            mapAtoms.put("HB", new Double(1.09));
            mapAtoms.put("HG2", new Double(1.09));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Trp")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            mapAtoms.put("CD1", new Double(dummy));
            mapAtoms.put("CD2", new Double(dummy));
            mapAtoms.put("CE2", new Double(dummy));
            mapAtoms.put("CE3", new Double(dummy));
            mapAtoms.put("CZ2", new Double(dummy));
            mapAtoms.put("CZ3", new Double(dummy));
            mapAtoms.put("NE1", new Double(dummy));
            mapAtoms.put("HD1", new Double(dummy));
            mapAtoms.put("HE1", new Double(dummy));
            mapAtoms.put("HE3", new Double(dummy));
            mapAtoms.put("HZ2", new Double(dummy));
            mapAtoms.put("HZ3", new Double(dummy));
            mapAtoms.put("HH2", new Double(dummy));
            mapAtoms.put("HQ", new Double(dummy));
            mapAtoms.put("CQ", new Double(dummy));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Tyr")) {
            mapAtoms.put("HB3", new Double(1.09));
            mapAtoms.put("HB2", new Double(1.09));
            mapAtoms.put("HB#", new Double(1.09));
            mapAtoms.put("HD1", new Double(2.67));
            mapAtoms.put("HD2", new Double(2.67));
            mapAtoms.put("HD#", new Double(2.67));
            mapAtoms.put("HE1", new Double(4.55));
            mapAtoms.put("HE2", new Double(4.55));
            mapAtoms.put("HE#", new Double(4.55));
            mapAtoms.put("HZ", new Double(5.0));
            return mapAtoms;
        }
        if (type.equalsIgnoreCase("Val")) {
            mapAtoms.put("HB", new Double(1.09));
            mapAtoms.put("HG1", new Double(2.06));
            mapAtoms.put("HG2", new Double(2.06));
            return mapAtoms;
        }
        return mapAtoms;
    }

    public String toString() {
        double csValue = 0.0;
        String desc = String.valueOf(String.valueOf(this.residueNo)) + " " + this.residue + "\n";
        String str = "";
        int i = 0;
        while (i < this.peakVec.size()) {
            Peak e = (Peak)this.peakVec.elementAt(i);
            str = String.valueOf(str) + e.getNucleus() + " = " + e.getCS() + "\n";
            ++i;
        }
        desc = String.valueOf(desc) + str;
        return desc;
    }

    public static class caComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Residue n1 = (Residue)o1;
            Residue n2 = (Residue)o2;
            Peak pk = new Peak();
            String nucleus = "";
            Vector pkVec1 = n1.getPeakVec();
            Vector pkVec2 = n2.getPeakVec();
            int j = 0;
            double d1 = 0.0;
            double d2 = 0.0;
            j = 0;
            while (j < pkVec1.size()) {
                pk = (Peak)pkVec1.elementAt(j);
                nucleus = pk.getNucleus();
                if (nucleus.equals("CA")) {
                    d1 = pk.getCS();
                }
                ++j;
            }
            j = 0;
            while (j < pkVec2.size()) {
                pk = (Peak)pkVec2.elementAt(j);
                nucleus = pk.getNucleus();
                if (nucleus.equals("CA")) {
                    d2 = pk.getCS();
                }
                ++j;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class cbComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Residue n1 = (Residue)o1;
            Residue n2 = (Residue)o2;
            Peak pk = new Peak();
            String nucleus = "";
            Vector pkVec1 = n1.getPeakVec();
            Vector pkVec2 = n2.getPeakVec();
            int j = 0;
            double d1 = 0.0;
            double d2 = 0.0;
            j = 0;
            while (j < pkVec1.size()) {
                pk = (Peak)pkVec1.elementAt(j);
                nucleus = pk.getNucleus();
                if (nucleus.equals("CB")) {
                    d1 = pk.getCS();
                }
                ++j;
            }
            j = 0;
            while (j < pkVec2.size()) {
                pk = (Peak)pkVec2.elementAt(j);
                nucleus = pk.getNucleus();
                if (nucleus.equals("CB")) {
                    d2 = pk.getCS();
                }
                ++j;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

