/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.Inv;
import Jampack.JampackException;
import Jampack.Zmat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.H1CS;
import rdcPanda.Hbond;
import rdcPanda.Hsqc;
import rdcPanda.IDof2aryStructure;
import rdcPanda.Matrix;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.PdbRmsd;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;

public class Model {
    public Vector parameterReader(String fileName) {
        Vector parameterVec = new Vector();
        String ss = "";
        String str = "";
        String ss2 = "";
        int index = -1;
        int ind2 = -1;
        String key = "";
        String value = "";
        TreeMap<String, String> mapSaupe = new TreeMap<String, String>();
        TreeMap<String, String> mapHelices = new TreeMap<String, String>();
        TreeMap<String, String> map1stStrand = new TreeMap<String, String>();
        TreeMap<String, String> map2ndStrand = new TreeMap<String, String>();
        TreeMap<String, String> mapOtherStrand = new TreeMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            ss = in.readLine();
            if (ss != null) {
                ss = ss.toUpperCase();
            }
            while (ss != null) {
                if (ss.indexOf("SAUPE") > -1 && ss.indexOf("ELEMENT") > -1) {
                    ss = in.readLine().toUpperCase();
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine().toUpperCase();
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines need to be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        mapSaupe.put(key, value);
                        ss = in.readLine();
                        if (ss == null) continue;
                        ss = ss.toUpperCase();
                        index = ss.indexOf("=");
                    }
                } else if (ss.indexOf("HELICES") > -1) {
                    ss = in.readLine().toUpperCase();
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine().toUpperCase();
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines must be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        mapHelices.put(key, value);
                        ss = in.readLine();
                        if (ss == null) continue;
                        ss = ss.toUpperCase();
                        index = ss.indexOf("=");
                    }
                } else if (ss.indexOf("FIRST") > -1 && ss.indexOf("STRAND") > -1) {
                    ss = in.readLine().toUpperCase();
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine().toUpperCase();
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines need to be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        map1stStrand.put(key, value);
                        ss = in.readLine();
                        if (ss == null) continue;
                        ss = ss.toUpperCase();
                        index = ss.indexOf("=");
                    }
                } else if (ss.indexOf("SECOND") > -1 && ss.indexOf("STRAND") > -1) {
                    ss = in.readLine().toUpperCase();
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine().toUpperCase();
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines need to be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        map2ndStrand.put(key, value);
                        ss = in.readLine();
                        if (ss == null) continue;
                        ss = ss.toUpperCase();
                        index = ss.indexOf("=");
                    }
                } else if (ss.indexOf("OTHER") > -1 && ss.indexOf("STRAND") > -1) {
                    ss = in.readLine().toUpperCase();
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine().toUpperCase();
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines need to be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        mapOtherStrand.put(key, value);
                        ss = in.readLine();
                        if (ss == null) continue;
                        ss = ss.toUpperCase();
                        index = ss.indexOf("=");
                    }
                }
                if ((ss = in.readLine()) == null) continue;
                ss = ss.toUpperCase();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        parameterVec.add(mapSaupe);
        parameterVec.add(mapHelices);
        parameterVec.add(map1stStrand);
        parameterVec.add(map2ndStrand);
        parameterVec.add(mapOtherStrand);
        return parameterVec;
    }

    public Vector BackonbeRotation(Vector pdbAll, Vector pdbBB) throws JampackException {
        Pdb pdbA = new Pdb();
        Pdb pdbB = new Pdb();
        Vector<Object> atomVecA = new Vector();
        Vector<Object> atomVecB = new Vector();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        String resNameA = "";
        String resNameB = "";
        String nucleusA = "";
        String nucleusB = "";
        String atomA = "";
        String atomB = "";
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        double[] ha1 = new double[3];
        double[] ca1 = new double[3];
        double[] amide1 = new double[3];
        double[] ha2 = new double[3];
        double[] ca2 = new double[3];
        double[] amide2 = new double[3];
        pdbA = (Pdb)pdbAll.elementAt(0);
        atomVecA = pdbA.getAtomVec();
        int resNoA = pdbA.getResidueNo();
        resNameA = pdbA.getResidue();
        int j = 0;
        while (j < atomVecA.size()) {
            ccA = (Cartesian)atomVecA.elementAt(j);
            atomA = ccA.getAtom();
            if (atomA.equalsIgnoreCase("CA")) {
                coordA = ccA.getXYZ();
                ca1 = ccA.getXYZ();
            }
            if (atomA.equalsIgnoreCase("N")) {
                amide1 = ccA.getXYZ();
            }
            if (atomA.equalsIgnoreCase("HA") || atomA.equalsIgnoreCase("HA2")) {
                ha1 = ccA.getXYZ();
            }
            ++j;
        }
        pdbB = (Pdb)pdbBB.elementAt(0);
        atomVecB = pdbB.getAtomVec();
        int resNoB = pdbB.getResidueNo();
        resNameB = pdbB.getResidue();
        j = 0;
        while (j < atomVecB.size()) {
            ccB = (Cartesian)atomVecB.elementAt(j);
            atomB = ccB.getAtom();
            if (atomB.equalsIgnoreCase("CA")) {
                coordB = ccB.getXYZ();
                ca2 = ccB.getXYZ();
            }
            if (atomB.equalsIgnoreCase("N")) {
                amide2 = ccB.getXYZ();
            }
            if (atomB.equalsIgnoreCase("HA") || atomB.equalsIgnoreCase("HA2")) {
                ha2 = ccB.getXYZ();
            }
            ++j;
        }
        Pdb pp = new Pdb();
        PhiPsi ff = new PhiPsi();
        double[] CaToHaVecRot1 = pp.internuclearVec(ca1, ha1);
        double[] CaToNVecRot1 = pp.internuclearVec(ca1, amide1);
        Matrix rg1 = Matrix.identity(3, 3);
        rg1 = ff.RgCal(CaToHaVecRot1, CaToNVecRot1);
        double[] CaToHaVecRot2 = pp.internuclearVec(ca2, ha2);
        double[] CaToNVecRot2 = pp.internuclearVec(ca2, amide2);
        Matrix rg2 = Matrix.identity(3, 3);
        rg2 = ff.RgCal(CaToHaVecRot2, CaToNVecRot2);
        double[][] A2 = rg2.getArray();
        Zmat zmat = new Zmat(A2);
        Zmat A2i = Inv.o(zmat);
        Matrix rg2N = new Matrix(A2i.getRe());
        Matrix rotA = rg2N.times(rg1);
        Vector<Pdb> vecPdbAllNew = pp.newPdb(pdbAll, rotA);
        pdbA = vecPdbAllNew.elementAt(0);
        atomVecA = pdbA.getAtomVec();
        j = 0;
        while (j < atomVecA.size()) {
            ccA = (Cartesian)atomVecA.elementAt(j);
            atomA = ccA.getAtom();
            if (atomA.equalsIgnoreCase("CA")) {
                coordA = ccA.getXYZ();
            }
            ++j;
        }
        pdbB = (Pdb)pdbBB.elementAt(0);
        atomVecB = pdbB.getAtomVec();
        j = 0;
        while (j < atomVecB.size()) {
            ccB = (Cartesian)atomVecB.elementAt(j);
            atomB = ccB.getAtom();
            if (atomB.equalsIgnoreCase("CA")) {
                coordB = ccB.getXYZ();
            }
            ++j;
        }
        double[] trans_vec = new double[3];
        trans_vec = pp.internuclearVec(coordA, coordB);
        Vector<Pdb> pdbAllNew2 = pp.newPdbByTranslation(vecPdbAllNew, trans_vec);
        return pdbAllNew2;
    }

    public Vector BackonbeRotationAtResidue(Vector pdbAll, Vector pdbBB, int resNo) throws JampackException {
        Pdb pdbA = new Pdb();
        Pdb pdbB = new Pdb();
        Vector<Object> atomVecA = new Vector();
        Vector<Object> atomVecB = new Vector();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        String resNameA = "";
        String resNameB = "";
        String nucleusA = "";
        String nucleusB = "";
        String atomA = "";
        String atomB = "";
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        double[] ha1 = new double[3];
        double[] ca1 = new double[3];
        double[] amide1 = new double[3];
        double[] ha2 = new double[3];
        double[] ca2 = new double[3];
        double[] amide2 = new double[3];
        int index0 = Collections.binarySearch(pdbAll, new Pdb(resNo), new Pdb.PdbComparator());
        if (index0 < 0) {
            System.out.println("error: the aligned residue not found...exist...");
            System.exit(0);
        }
        pdbA = (Pdb)pdbAll.elementAt(index0);
        atomVecA = pdbA.getAtomVec();
        int resNoA = pdbA.getResidueNo();
        resNameA = pdbA.getResidue();
        int j = 0;
        while (j < atomVecA.size()) {
            ccA = (Cartesian)atomVecA.elementAt(j);
            atomA = ccA.getAtom();
            if (atomA.equalsIgnoreCase("CA")) {
                coordA = ccA.getXYZ();
                ca1 = ccA.getXYZ();
            }
            if (atomA.equalsIgnoreCase("N")) {
                amide1 = ccA.getXYZ();
            }
            if (atomA.equalsIgnoreCase("HA") || atomA.equalsIgnoreCase("HA2")) {
                ha1 = ccA.getXYZ();
            }
            ++j;
        }
        int index = Collections.binarySearch(pdbBB, new Pdb(resNo), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("error: the aligned residue not found...exist...");
            System.exit(0);
        }
        pdbB = (Pdb)pdbBB.elementAt(index);
        atomVecB = pdbB.getAtomVec();
        int resNoB = pdbB.getResidueNo();
        resNameB = pdbB.getResidue();
        j = 0;
        while (j < atomVecB.size()) {
            ccB = (Cartesian)atomVecB.elementAt(j);
            atomB = ccB.getAtom();
            if (atomB.equalsIgnoreCase("CA")) {
                coordB = ccB.getXYZ();
                ca2 = ccB.getXYZ();
            }
            if (atomB.equalsIgnoreCase("N")) {
                amide2 = ccB.getXYZ();
            }
            if (atomB.equalsIgnoreCase("HA") || atomB.equalsIgnoreCase("HA2")) {
                ha2 = ccB.getXYZ();
            }
            ++j;
        }
        Pdb pp = new Pdb();
        PhiPsi ff = new PhiPsi();
        double[] CaToHaVecRot1 = pp.internuclearVec(ca1, ha1);
        double[] CaToNVecRot1 = pp.internuclearVec(ca1, amide1);
        Matrix rg1 = Matrix.identity(3, 3);
        rg1 = ff.RgCal(CaToHaVecRot1, CaToNVecRot1);
        double[] CaToHaVecRot2 = pp.internuclearVec(ca2, ha2);
        double[] CaToNVecRot2 = pp.internuclearVec(ca2, amide2);
        Matrix rg2 = Matrix.identity(3, 3);
        rg2 = ff.RgCal(CaToHaVecRot2, CaToNVecRot2);
        double[][] A2 = rg2.getArray();
        Zmat zmat = new Zmat(A2);
        Zmat A2i = Inv.o(zmat);
        Matrix rg2N = new Matrix(A2i.getRe());
        Matrix rotA = rg2N.times(rg1);
        Vector<Pdb> vecPdbAllNew = pp.newPdb(pdbAll, rotA);
        index0 = Collections.binarySearch(vecPdbAllNew, new Pdb(resNo), new Pdb.PdbComparator());
        pdbA = vecPdbAllNew.elementAt(index0);
        atomVecA = pdbA.getAtomVec();
        j = 0;
        while (j < atomVecA.size()) {
            ccA = (Cartesian)atomVecA.elementAt(j);
            atomA = ccA.getAtom();
            if (atomA.equalsIgnoreCase("CA")) {
                coordA = ccA.getXYZ();
            }
            ++j;
        }
        index = Collections.binarySearch(pdbBB, new Pdb(resNo), new Pdb.PdbComparator());
        pdbB = (Pdb)pdbBB.elementAt(index);
        atomVecB = pdbB.getAtomVec();
        j = 0;
        while (j < atomVecB.size()) {
            ccB = (Cartesian)atomVecB.elementAt(j);
            atomB = ccB.getAtom();
            if (atomB.equalsIgnoreCase("CA")) {
                coordB = ccB.getXYZ();
            }
            ++j;
        }
        double[] trans_vec = new double[3];
        trans_vec = pp.internuclearVec(coordA, coordB);
        Vector<Pdb> pdbAllNew2 = pp.newPdbByTranslation(vecPdbAllNew, trans_vec);
        return pdbAllNew2;
    }

    public void doRdcExactSheet(String src, String strOut, String strInput) throws JampackException {
        int maxStructurePerEnsemble = 2000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        Model mod = new Model();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double Syy = 0.0;
        double Szz = 0.0;
        double wtCoCA = 0.0;
        double wtCoN = 0.0;
        String strSseBounds = "";
        String strOutPdb = "";
        String strChFile = "";
        String strNhFile = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strTalos = "";
        String strHBonds = "";
        String strSeq = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("TALOS")) {
                strTalos = paraMap.get("TALOS");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("WTCOCA")) {
                wtCoCA = Double.parseDouble(paraMap.get("WTCOCA"));
            }
            if (paraMap.containsKey("WTCON")) {
                wtCoN = Double.parseDouble(paraMap.get("WTCON"));
            }
            if (paraMap.containsKey("SSEBOUNDARIES")) {
                strSseBounds = paraMap.get("SSEBOUNDARIES");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("HBONDS")) {
                strHBonds = paraMap.get("HBONDS");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String strTalosFile = String.valueOf(src) + strTalos;
        PhiPsi phipsi0 = new PhiPsi();
        Vector<Object> vecTalos = new Vector();
        boolean existTalos = new File(strTalosFile).exists();
        if (existTalos) {
            vecTalos = phipsi0.talosAngleReader(strTalosFile);
        } else {
            System.out.println("Warning: The TALOS input is not available...");
        }
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 1.0);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        Vector cacoRdc = new Vector();
        Vector conRdc = new Vector();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warning: The Co-Ca RDC doesn't exist...");
        }
        if (existCoN) {
            conRdc = dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warning: The Co-N RDC doesn't exist...");
        }
        Vector vecPrePdb = new Vector();
        Hbond hb = new Hbond();
        String HbondFile = String.valueOf(src) + strHBonds;
        Vector HbondVec = hb.HbondReader(HbondFile);
        IDof2aryStructure id2ary = new IDof2aryStructure();
        String id2aryFile = String.valueOf(src) + strSseBounds;
        Vector idVec = id2ary.IDof2aryStructureReader(id2aryFile);
        Vector[] orderVec = id2ary.getOrder(id2aryFile);
        Vector<Vector<Dipolar>> eRdcNhVec = dd.rdcReader(strNhRdcFile, idVec, "E");
        Vector<Vector<Dipolar>> eRdcChVec = dd.rdcReader(strChRdcFile, idVec, "E");
        String userDir = System.getProperty("user.dir");
        String srcSheetPara = String.valueOf(userDir) + "/system/rdc-exact-sheet-parameter.txt";
        Vector paraVecSheet = mod.parameterReader(srcSheetPara);
        boolean printEulerSearch = true;
        Vector sheetVec = mod.sheetModel(eRdcNhVec, eRdcChVec, Syy, Szz, HbondVec, paraVecSheet, orderVec, printEulerSearch);
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(sheetVec, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public Vector sheetModel(Vector eRdc1Vec, Vector eRdc2Vec, double Syy, double Szz, Vector HbondVec, Vector paraVec, Vector[] orderVec, boolean printEulerSearch) {
        int i = 0;
        int j = 0;
        Pdb pp = new Pdb();
        Vector strand1Rdc1 = new Vector();
        Vector strand1Rdc2 = new Vector();
        String id2ary0 = (String)orderVec[i].elementAt(0);
        int index0 = id2ary0.indexOf("E");
        if (index0 > -1) {
            String strTemp = id2ary0.substring(index0 + 1, index0 + 2);
            int nn0 = Integer.parseInt(strTemp) - 1;
            strand1Rdc1 = (Vector)eRdc1Vec.elementAt(nn0);
            strand1Rdc2 = (Vector)eRdc2Vec.elementAt(nn0);
        }
        Vector sheetPdb = new Vector();
        double[] ramaFilter = new double[]{-2.9670597283903604, -1.2217304763960306, 1.3962634015954636, Math.PI};
        double phiAve = -2.0943951023931953;
        double psiAve = 2.4085543677521746;
        Map map1stStrand = (Map)paraVec.elementAt(2);
        double resolution = new Double((String)map1stStrand.get("RESOLUTION"));
        int refineCycle = Integer.parseInt((String)map1stStrand.get("REFINECYCLE"));
        int dfsCycle = Integer.parseInt((String)map1stStrand.get("DFSCYCLE"));
        boolean debugDFS = new Boolean((String)map1stStrand.get("DEBUGDFS"));
        boolean printResults = new Boolean((String)map1stStrand.get("PRINTRESULTS"));
        double w4Angles = new Double((String)map1stStrand.get("WEIGHT4ANGLES"));
        PdbRmsd psd = new PdbRmsd();
        ModelRdc mdc = new ModelRdc();
        Hbond hb = new Hbond();
        Vector pdbStrand1 = mdc.refineStrand(strand1Rdc1, strand1Rdc2, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults);
        sheetPdb.addAll(pdbStrand1);
        double w4HB = 4.0;
        Vector hBondVecOfEab = new Vector();
        int nn = 0;
        int index = -1;
        Vector strandRdc1 = new Vector();
        Vector strandRdc2 = new Vector();
        Vector pdbStrand1N = new Vector();
        Vector pdbStrand2 = new Vector();
        String id2ary = "";
        double resolution2 = 0.0;
        int refineCycle2 = 1;
        int dfsCycle2 = 1;
        boolean debugDFS2 = false;
        boolean printResults2 = false;
        double w4Angles2 = 1.0;
        double w4HB2 = 1.0;
        if (paraVec.size() > 3) {
            Map map2ndStrand = (Map)paraVec.elementAt(3);
            resolution2 = new Double((String)map2ndStrand.get("RESOLUTION"));
            refineCycle2 = Integer.parseInt((String)map2ndStrand.get("REFINECYCLE"));
            dfsCycle2 = Integer.parseInt((String)map2ndStrand.get("DFSCYCLE"));
            debugDFS2 = new Boolean((String)map2ndStrand.get("DEBUGDFS"));
            printResults2 = new Boolean((String)map2ndStrand.get("PRINTRESULTS"));
            w4Angles2 = new Double((String)map2ndStrand.get("WEIGHT4ANGLES"));
            w4HB2 = new Double((String)map2ndStrand.get("WEIGHT4HBONDS"));
        }
        if (paraVec.size() > 3) {
            Map mapOtherStrand = (Map)paraVec.elementAt(4);
            resolution = new Double((String)mapOtherStrand.get("RESOLUTION"));
            refineCycle = Integer.parseInt((String)mapOtherStrand.get("REFINECYCLE"));
            dfsCycle = Integer.parseInt((String)mapOtherStrand.get("DFSCYCLE"));
            debugDFS = new Boolean((String)mapOtherStrand.get("DEBUGDFS"));
            printResults = new Boolean((String)mapOtherStrand.get("PRINTRESULTS"));
            w4Angles = new Double((String)mapOtherStrand.get("WEIGHT4ANGLES"));
            w4HB = new Double((String)mapOtherStrand.get("WEIGHT4HBONDS"));
            i = 0;
            while (i < orderVec.length) {
                pdbStrand1N = pdbStrand1;
                j = 0;
                while (j < orderVec[i].size()) {
                    id2ary = (String)orderVec[i].elementAt(j);
                    index = id2ary.lastIndexOf("E");
                    if (index > -1) {
                        nn = Integer.parseInt(id2ary.substring(index + 1)) - 1;
                        hBondVecOfEab = hb.hbOfTwoStrands(HbondVec, id2ary);
                        strandRdc1 = (Vector)eRdc1Vec.elementAt(nn);
                        strandRdc2 = (Vector)eRdc2Vec.elementAt(nn);
                        System.out.println(strandRdc1.size());
                        System.out.println(strandRdc2.size());
                        if (i == 0) {
                            pdbStrand2 = mdc.refineStrand(strandRdc1, strandRdc2, Syy, Szz, phiAve, psiAve, refineCycle2, dfsCycle2, resolution2, w4Angles2, w4HB2, pdbStrand1N, hBondVecOfEab, printEulerSearch, debugDFS2, printResults2);
                            sheetPdb.addAll(pdbStrand2);
                            pdbStrand1N = pdbStrand2;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(sheetPdb, new Pdb.PdbComparator());
        return sheetPdb;
    }

    public Vector sheetModel2(Vector pdbVec, Vector eRdc1Vec, Vector eRdc2Vec, double Syy, double Szz, Vector HbondVec, Vector paraVec, Vector[] orderVec, boolean printEulerSearch) {
        int i = 0;
        int j = 0;
        Pdb pp = new Pdb();
        Vector strand1Rdc1 = (Vector)eRdc1Vec.elementAt(4);
        Vector strand1Rdc2 = (Vector)eRdc2Vec.elementAt(4);
        Dipolar dd1 = (Dipolar)strand1Rdc1.elementAt(0);
        Dipolar dd2 = (Dipolar)strand1Rdc2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo()) - 1;
        dd1 = (Dipolar)strand1Rdc1.elementAt(strand1Rdc1.size() - 1);
        dd2 = (Dipolar)strand1Rdc2.elementAt(strand1Rdc2.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        Vector sheetPdb = new Vector();
        double[] ramaFilter = new double[]{-2.9670597283903604, -1.2217304763960306, 1.3962634015954636, Math.PI};
        double phiAve = -2.0943951023931953;
        double psiAve = 2.4085543677521746;
        Map map1stStrand = (Map)paraVec.elementAt(2);
        double resolution = new Double((String)map1stStrand.get("RESOLUTION"));
        int refineCycle = Integer.parseInt((String)map1stStrand.get("REFINECYCLE"));
        int dfsCycle = Integer.parseInt((String)map1stStrand.get("DFSCYCLE"));
        boolean debugDFS = new Boolean((String)map1stStrand.get("DEBUGDFS"));
        boolean printResults = new Boolean((String)map1stStrand.get("PRINTRESULTS"));
        double w4Angles = new Double((String)map1stStrand.get("WEIGHT4ANGLES"));
        PdbRmsd psd = new PdbRmsd();
        ModelRdc mdc = new ModelRdc();
        Hbond hb = new Hbond();
        Vector<Pdb> pdbStrand1 = new Vector<Pdb>();
        int no = 0;
        i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no = pp.getResidueNo();
            if (no > firstResidueNo && no < lastResidueNo + 1) {
                pdbStrand1.add(pp);
            }
            ++i;
        }
        sheetPdb.addAll(pdbStrand1);
        double w4HB = 4.0;
        Vector hBondVecOfEab = new Vector();
        int nn = 0;
        int index = -1;
        Vector strandRdc1 = new Vector();
        Vector strandRdc2 = new Vector();
        Vector pdbStrand1N = new Vector();
        Vector pdbStrand2 = new Vector();
        String id2ary = "";
        double resolution2 = 0.0;
        int refineCycle2 = 1;
        int dfsCycle2 = 1;
        boolean debugDFS2 = false;
        boolean printResults2 = false;
        double w4Angles2 = 1.0;
        double w4HB2 = 1.0;
        if (paraVec.size() > 3) {
            Map map2ndStrand = (Map)paraVec.elementAt(3);
            resolution2 = new Double((String)map2ndStrand.get("RESOLUTION"));
            refineCycle2 = Integer.parseInt((String)map2ndStrand.get("REFINECYCLE"));
            dfsCycle2 = Integer.parseInt((String)map2ndStrand.get("DFSCYCLE"));
            debugDFS2 = new Boolean((String)map2ndStrand.get("DEBUGDFS"));
            printResults2 = new Boolean((String)map2ndStrand.get("PRINTRESULTS"));
            w4Angles2 = new Double((String)map2ndStrand.get("WEIGHT4ANGLES"));
            w4HB2 = new Double((String)map2ndStrand.get("WEIGHT4HBONDS"));
        }
        if (paraVec.size() > 3) {
            Map mapOtherStrand = (Map)paraVec.elementAt(4);
            resolution = new Double((String)mapOtherStrand.get("RESOLUTION"));
            refineCycle = Integer.parseInt((String)mapOtherStrand.get("REFINECYCLE"));
            dfsCycle = Integer.parseInt((String)mapOtherStrand.get("DFSCYCLE"));
            debugDFS = new Boolean((String)mapOtherStrand.get("DEBUGDFS"));
            printResults = new Boolean((String)mapOtherStrand.get("PRINTRESULTS"));
            w4Angles = new Double((String)mapOtherStrand.get("WEIGHT4ANGLES"));
            w4HB = new Double((String)mapOtherStrand.get("WEIGHT4HBONDS"));
            i = 0;
            while (i < orderVec.length) {
                pdbStrand1N = pdbStrand1;
                j = 0;
                while (j < orderVec[i].size()) {
                    id2ary = (String)orderVec[i].elementAt(j);
                    index = id2ary.lastIndexOf("E");
                    if (index > -1) {
                        nn = Integer.parseInt(id2ary.substring(index + 1)) - 1;
                        hBondVecOfEab = hb.hbOfTwoStrands(HbondVec, id2ary);
                        strandRdc1 = (Vector)eRdc1Vec.elementAt(nn);
                        strandRdc2 = (Vector)eRdc2Vec.elementAt(nn);
                        System.out.println(strandRdc1.size());
                        System.out.println(strandRdc2.size());
                        if (i == 1) {
                            pdbStrand2 = mdc.refineStrand(strandRdc1, strandRdc2, Syy, Szz, phiAve, psiAve, refineCycle, dfsCycle, resolution, w4Angles, w4HB, pdbStrand1N, hBondVecOfEab, printEulerSearch, debugDFS, printResults);
                            sheetPdb.addAll(pdbStrand2);
                            pdbStrand1N = pdbStrand2;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(sheetPdb, new Pdb.PdbComparator());
        strandRdc1 = (Vector)eRdc1Vec.elementAt(2);
        strandRdc2 = (Vector)eRdc2Vec.elementAt(2);
        pdbStrand2 = mdc.refineStrand2(strandRdc1, strandRdc2, Syy, Szz, phiAve, psiAve, refineCycle, dfsCycle, resolution, w4Angles, w4HB, sheetPdb, HbondVec, printEulerSearch, debugDFS, printResults);
        return pdbStrand2;
    }

    public static void main(String[] argv) throws JampackException {
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        ModelRdc mdc = new ModelRdc();
        Model mod = new Model();
        IDof2aryStructure id2ary = new IDof2aryStructure();
        Pdb pp = new Pdb();
        String rdcNhFile = String.valueOf(src) + "nhRdc-temp.txt";
        String rdcChFile = String.valueOf(src) + "chRdc-temp.txt";
        String rdcCaCoFile = String.valueOf(src) + "cacoRdc-temp.txt";
        String rdcConFile = String.valueOf(src) + "conRdc-temp.txt";
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(rdcNhFile, 1.0);
        Vector cahaRdc = dd.rdcRead(rdcChFile, 2.008);
        Vector cacoRdc = dd.rdcRead(rdcCaCoFile, 0.19845);
        Vector conRdc = dd.rdcRead(rdcConFile, 0.12086);
        Vector vecBB = new Vector();
        String strH1File = String.valueOf(src) + "top_ff2_3.pdb";
        String strH3File = String.valueOf(src) + "top_ff2_3.pdb";
        String strH4File = String.valueOf(src) + "top_ff2_3.pdb";
        String strH5File = String.valueOf(src) + "top_ff2_3.pdb";
        String strH6File = String.valueOf(src) + "top_ff2_3.pdb";
        Vector<Pdb> ppVecH1 = pp.readPdb(strH1File);
        Vector<Pdb> ppVecH3 = pp.readPdb(strH3File);
        double[] saupe = new double[5];
        PdbRdc pdr = new PdbRdc();
        double[] ramaFilter = new double[]{-1.7453292519943295, -0.5235987755982988, -1.5707963267948966, -0.2617993877991494};
        double phiAve = -1.1397000015522971;
        double psiAve = -0.6876597252857658;
        double Syy = 0.8193489560852427;
        double Szz = 35.37745291254462;
        phiAve = -1.1397000015522971;
        psiAve = -0.6876597252857658;
        Pdb temp2 = new Pdb();
        String talosStr = String.valueOf(src) + "talos.txt";
        PhiPsi phipsi = new PhiPsi();
        Vector vecTalos = new Vector();
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 27;
        while (i <= 33) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
        String strTempStr = String.valueOf(src) + "top_ff2_1.pdb";
        Vector<Pdb> ppVecTempStr = pp.readPdb(strTempStr);
        i = 3;
        Vector<Pdb> helixVecN = pp.newPdb(ppVecTempStr, Const.mat4ThreeDirs[i - 1]);
        double[] rdc1Cal = new double[nhRdc.size() + 100];
        double[] rdc2Cal = new double[cahaRdc.size() + 100];
        Matrix mm = new Matrix(3, 3);
        Vector<Object> pdbVecTempStr2 = new Vector();
        mm = pdr.bestFit(ppVecTempStr, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupe);
        pdbVecTempStr2 = pp.newPdb(ppVecTempStr, mm);
        double[] sRmsd = new double[1];
        int[] sizeRdc = new int[1];
        double[] rdcCoNCal = new double[nhRdc.size() + 100];
        double[] rdcCaCoCal = new double[cahaRdc.size() + 100];
        Syy = saupe[0];
        Szz = saupe[1];
        double r_nh = pdr.BackCal(ppVecTempStr, nhRdc, "N", "H", mm, -Syy - Szz, Syy, Szz, 1.0, rdcCaCoCal, sRmsd, sizeRdc);
        double r_caha = pdr.BackCal(ppVecTempStr, cahaRdc, "CA", "HA", mm, -Syy - Szz, Syy, Szz, 1.0, rdcCaCoCal, sRmsd, sizeRdc);
        double r_caco = pdr.BackCalCACO(ppVecTempStr, cacoRdc, "C", "CA", mm, -Syy - Szz, Syy, Szz, Const.cacoRatio, rdcCaCoCal, sRmsd, sizeRdc, true);
        double r_con = pdr.BackCalCON(ppVecTempStr, conRdc, "C", "N", mm, -Syy - Szz, Syy, Szz, Const.conRatio, rdcCoNCal, sRmsd, sizeRdc, true);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public static void main1(String[] argv) throws JampackException {
        int j;
        long startTime = System.currentTimeMillis();
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String paramFile = String.valueOf(src) + "parameters.input";
        Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noeBound = 0.0;
        String strSeq = "";
        String strBB = "";
        String strReson = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strManualAsg = "";
        String strSSES = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOEBOUND")) {
                noeBound = Double.parseDouble(paraMap.get("NOEBOUND"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            strSeq = strSeq.toLowerCase();
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            strBB = strBB.toLowerCase();
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            strNoesy2D = strNoesy2D.toLowerCase();
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            strHnNoesy3D = strHnNoesy3D.toLowerCase();
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            strHaNoesy3D = strHaNoesy3D.toLowerCase();
            if (paraMap.containsKey("MANUAL-ASSIGNMENT")) {
                strManualAsg = paraMap.get("MANUAL-ASSIGNMENT");
            }
            strManualAsg = strManualAsg.toLowerCase();
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVec3 = pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector pdbVecBBN = pp.nameConvert(pdbVec3);
        Collections.sort(pdbVecBBN, new Pdb.PdbComparator());
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReader(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReader(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String pdbFileXray = String.valueOf(src) + "2A7O.pdb";
        Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
        Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
        Vector<Pdb> vecBB = pp.OutputBackbone(vecTempPdbBB2);
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0);
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector> vecPdbSSE = new Vector<Vector>();
        i = 0;
        while (i < vecOrderSSES.size()) {
            String strPdbFile = (String)vecOrderSSES.elementAt(i);
            strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
            Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
            Vector pdbVecSSE = pp.nameConvert(pdbVecSSE_temp2);
            Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
            vecPdbSSE.add(pdbVecSSE);
            ++i;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Vector<Pdb> vecPdbSseRot = pp.RotamSelectAndStructure(2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, vecPdbSseBb, assignVec, rotSrc, vecNewNoesy, noeBound, 1, 0.0);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i;
        }
        System.out.println("====================================");
        Vector<Pdb> vecPdbA = new Vector<Pdb>();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        i = 0;
        while (i < 4) {
            vecEnsembPack[i] = new Vector();
            ++i;
        }
        i = 1;
        while (i < vecPdbRotSSE.size()) {
            vecPdbB = new Vector();
            double[] dbTemp = new double[1];
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(i));
            vecEnsembPack[0] = pdr.positionByNOEPatterns(vecPdbA, vecPdbB, assignVec, vecNewNoesy, 2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, noeBound, 1, dbTemp);
            max_score[0] = dbTemp[0];
            Vector vecTemp = (Vector)vecEnsembPack[0].elementAt(0);
            System.out.println("i:" + i);
            System.out.println("here we have the first packing:");
            Vector vecBBTemp = pp.OutputBackboneNoCB(vecTemp);
            pp.print(vecBBTemp);
            j = 1;
            while (j < 4) {
                Vector<Pdb> vecPdbANew = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[j - 1]);
                vecEnsembPack[j] = pdr.positionByNOEPatterns(vecPdbA, vecPdbB, assignVec, vecNewNoesy, 2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, noeBound, 1, dbTemp);
                max_score[j] = dbTemp[0];
                ++j;
            }
            int maxPackIndex = 0;
            double max_pack_score = max_score[0];
            int t = 0;
            while (t < max_score.length) {
                if (max_score[t] > max_pack_score) {
                    max_pack_score = max_score[t];
                    maxPackIndex = t;
                }
                ++t;
            }
            Vector vecEnsembPackNew = new Vector();
            vecEnsembPackNew = vecEnsembPack[maxPackIndex];
            vecTemp = (Vector)vecEnsembPackNew.elementAt(0);
            System.out.println("here we have the final packing:");
            pp.print(vecTemp);
            vecPdbA = new Vector();
            vecPdbA.addAll(vecTemp);
            ++i;
        }
        System.out.println("here we have the structure after first iteration:");
        pp.print(vecPdbA);
        System.out.println("====================================");
        System.out.println("here we refine the rotamer selection:");
        Vector<Pdb> vecPdbAll2 = new Vector<Pdb>();
        vecPdbAll2.addAll(vecPdbA);
        Vector<Pdb> vecBB2 = pp.OutputBackbone(vecPdbAll2);
        vecPdbRotSSE = new Vector();
        Vector<Pdb> vecPdbSSERot2 = pp.RotamSelectAndStructure(2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, vecBB2, assignVec, rotSrc, vecNewNoesy, noeBound, 1, 0.0);
        Vector vecPdbSseRotNew2 = md.BackonbeRotation(vecPdbSSERot2, vecBB2);
        Collections.sort(vecPdbSseRotNew2, new Pdb.PdbComparator());
        pp.print(vecPdbSseRotNew2);
        Vector vecPdbSSERotRefine = new Vector();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Pdb pdb1 = (Pdb)vecPdbSseBb.elementAt(0);
            Pdb pdb2 = (Pdb)vecPdbSseBb.elementAt(vecPdbSseBb.size() - 1);
            int resNo1 = pdb1.getResidueNo();
            int resNo2 = pdb2.getResidueNo();
            Vector<Pdb> vecPdbSSE_temp2 = new Vector<Pdb>();
            j = 0;
            while (j < vecPdbSseRotNew2.size()) {
                Pdb pdb3 = (Pdb)vecPdbSseRotNew2.elementAt(j);
                if (pdb3.getResidueNo() >= resNo1 && pdb3.getResidueNo() <= resNo2) {
                    vecPdbSSE_temp2.add(pdb3);
                }
                ++j;
            }
            vecPdbSSERotRefine.add(vecPdbSSE_temp2);
            ++i;
        }
        System.out.println("====================================");
        System.out.println("here we refine the packing by using grid search:");
        vecPdbA = new Vector();
        vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbSSERotRefine.elementAt(0));
        pdr = new PdbRmsd();
        max_score = new double[4];
        vecEnsembPack = new Vector[4];
        i = 1;
        while (i < vecPdbSSERotRefine.size()) {
            double[] dbTemp = new double[1];
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbSSERotRefine.elementAt(i));
            vecEnsembPack[0] = pdr.positionByNOEPatterns(vecPdbA, vecPdbB, assignVec, vecNewNoesy, 2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, noeBound, 1, dbTemp);
            max_score[0] = dbTemp[0];
            Vector vecTemp = (Vector)vecEnsembPack[0].elementAt(0);
            System.out.println("i:" + i);
            System.out.println("here we have the first packing:");
            pp.print(vecTemp);
            j = 1;
            while (j < 4) {
                Vector<Pdb> vecPdbANew = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[j - 1]);
                vecEnsembPack[j] = pdr.positionByNOEPatterns(vecPdbA, vecPdbB, assignVec, vecNewNoesy, 2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, noeBound, 1, dbTemp);
                max_score[j] = dbTemp[0];
                ++j;
            }
            int maxPackIndex = 0;
            double max_pack_score = max_score[0];
            int t = 0;
            while (t < max_score.length) {
                if (max_score[t] > max_pack_score) {
                    max_pack_score = max_score[t];
                    maxPackIndex = t;
                }
                ++t;
            }
            Vector vecEnsembPackNew = new Vector();
            vecEnsembPackNew = vecEnsembPack[maxPackIndex];
            vecTemp = (Vector)vecEnsembPackNew.elementAt(0);
            System.out.println("here we have the final packing:");
            pp.print(vecTemp);
            vecPdbA = new Vector();
            vecPdbA.addAll(vecTemp);
            ++i;
        }
        System.out.println("here we have the structure after second iteration:");
        pp.print(vecPdbA);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }
}

