/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.HnNoe;

public class HcchTocsy {
    private int residueNo;
    private String residue;
    private double csHA;
    private double csC13;
    private double csH1;
    private double intensity;
    private double uncertainty = 0.0;
    private Map assignMap = new TreeMap();

    public HcchTocsy() {
        this.residueNo = 0;
        this.residue = null;
        this.csHA = 0.0;
        this.csC13 = 0.0;
        this.csH1 = 0.0;
        this.intensity = 0.0;
        this.assignMap = new TreeMap();
    }

    public HcchTocsy(int no) {
        this.residueNo = no;
        this.residue = null;
        this.csHA = 0.0;
        this.csC13 = 0.0;
        this.csH1 = 0.0;
        this.intensity = 0.0;
        this.assignMap = new TreeMap();
    }

    public HcchTocsy(int no, String resid, double HN, double N15, double H1, double inten) {
        this.residueNo = no;
        this.residue = resid;
        this.csHA = HN;
        this.csC13 = N15;
        this.csH1 = H1;
        this.intensity = inten;
        this.assignMap = new TreeMap();
    }

    public HcchTocsy(int no, String resid, double HN, double N15, double H1, double inten, double uncern) {
        this.residueNo = no;
        this.residue = resid;
        this.csHA = HN;
        this.csC13 = N15;
        this.csH1 = H1;
        this.intensity = inten;
        this.assignMap = new TreeMap();
        this.uncertainty = uncern;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residue;
    }

    public double getHA() {
        return this.csHA;
    }

    public double getC13() {
        return this.csC13;
    }

    public double getH1() {
        return this.csH1;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public Map getAssignMap() {
        return this.assignMap;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String R) {
        this.residue = R;
    }

    public void setAssignMap(Map aMap) {
        this.assignMap = aMap;
    }

    public String toString() {
        String desc = "";
        String str = String.valueOf(String.valueOf(this.residueNo)) + " " + this.residue + "\n";
        double csValue = 0.0;
        if (!this.assignMap.isEmpty()) {
            for (Map.Entry e : this.assignMap.entrySet()) {
                csValue = (Double)e.getValue();
                if (!(Math.abs(csValue + 999.99) > 0.01)) continue;
                str = String.valueOf(str) + (String)e.getKey() + " = " + (Double)e.getValue() + "\n";
            }
            desc = String.valueOf(desc) + str + "\n";
            desc = String.valueOf(desc) + String.valueOf(this.csHA) + "  " + String.valueOf(this.csC13) + "   " + String.valueOf(this.csH1) + "  " + String.valueOf(this.intensity);
        } else {
            desc = String.valueOf(this.residueNo) + "  " + String.valueOf(this.csHA) + "  " + String.valueOf(this.csC13) + "   " + String.valueOf(this.csH1) + "  " + String.valueOf(this.intensity);
        }
        return desc;
    }

    public Vector hcchReader(String filename) {
        Vector<HcchTocsy> inputs = new Vector<HcchTocsy>();
        double csHA = 0.0;
        double csC13 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        int index1 = 0;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int no = 0;
        String aaType = "";
        String ss = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            ss = in.readLine();
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csHA = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csC13 = new Double(st.nextToken()) - 1.3;
                }
                if (st.hasMoreTokens()) {
                    str = st.nextToken();
                    index1 = str.indexOf("e");
                    order = str.substring(index1 + 1);
                    value = new Double(str.substring(0, index1));
                    if (order.equals("+10")) {
                        intensity = value * 10000.0;
                    }
                    if (order.equals("+09")) {
                        intensity = value * 1000.0;
                    } else if (order.equals("+08")) {
                        intensity = value * 100.0;
                    } else if (order.equals("+07")) {
                        intensity = value * 10.0;
                    } else if (order.equals("+06")) {
                        intensity = value;
                    } else if (order.equals("+05")) {
                        intensity = value * 0.1;
                    } else {
                        System.out.println("Intensity Error");
                    }
                }
                inputs.add(new HcchTocsy(no, aaType, csHA, csC13, csH1, intensity));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector NoesyReader(String filename) {
        inputs = new Vector<HnNoe>();
        csHa = 0.0;
        csC13 = 0.0;
        csH1 = 0.0;
        intensity = 0.0;
        uncertainty = 0.0;
        csVec = new Vector<E>();
        st = new StringTokenizer("");
        str = "";
        strTemp = "";
        csID = 0.0;
        index1 = false;
        index2 = false;
        order = "";
        value = 0.0;
        no = false;
        aaType = "";
        ss = "";
        counter = 0;
        index = -1;
        try {
            in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block13: {
                    if ((index = ss.trim().indexOf("#")) != 0) break block13;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    csID = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csC13 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csHa = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    uncertainty = new Double(st.nextToken());
                }
                ++counter;
                inputs.add(new HnNoe(0, "", csHa, csC13, csH1, intensity, uncertainty));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        System.out.println("The total number of HN-NOE frequency triples is: " + counter);
        return inputs;
    }

    public Vector hcchReader2(String filename) {
        Vector<HcchTocsy> inputs = new Vector<HcchTocsy>();
        double csHA = 0.0;
        double csC13 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int no = 0;
        String aaType = "";
        String ss = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csHA = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csC13 = new Double(st.nextToken()) - 0.5;
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                inputs.add(new HcchTocsy(no, aaType, csHA, csC13, csH1, intensity));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector hcchReader3(String filename) {
        Vector allVec = new Vector();
        Vector<HcchTocsy> inputs = new Vector<HcchTocsy>();
        double csHA = 0.0;
        double csC13 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int no = 0;
        int cnt = 0;
        String aaType = "";
        String ss = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            st = new StringTokenizer(ss);
            no = Integer.parseInt(st.nextToken());
            while ((ss = in.readLine()) != null) {
                st = new StringTokenizer(ss);
                cnt = st.countTokens();
                if (cnt == 2) {
                    no = Integer.parseInt(st.nextToken());
                    continue;
                }
                csHA = new Double(st.nextToken());
                csC13 = new Double(st.nextToken());
                csH1 = new Double(st.nextToken());
                intensity = new Double(st.nextToken());
                inputs.add(new HcchTocsy(no, aaType, csHA, csC13, csH1, intensity));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector hcchReader4(String filename) {
        Vector allVec = new Vector();
        Vector<HcchTocsy> inputs = new Vector<HcchTocsy>();
        double csHA = 0.0;
        double csC13 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int no = 0;
        int cnt = 0;
        String aaType = "";
        String ss = "";
        int counter = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            st = new StringTokenizer(ss);
            st.nextToken();
            no = Integer.parseInt(st.nextToken());
            csHA = new Double(st.nextToken());
            st.nextToken();
            csC13 = new Double(st.nextToken());
            while ((ss = in.readLine()) != null) {
                st = new StringTokenizer(ss);
                cnt = st.countTokens();
                if (cnt == 2) {
                    csH1 = new Double(st.nextToken());
                    intensity = new Double(st.nextToken());
                    ++counter;
                    inputs.add(new HcchTocsy(no, aaType, csHA, csC13, csH1, intensity));
                    continue;
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    no = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csHA = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (!st.hasMoreTokens()) continue;
                csC13 = new Double(st.nextToken());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        System.out.println("The total number of HA-NOE frequency triples is: " + counter);
        return inputs;
    }

    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec) {
        Vector outVec = new Vector();
        double csValue = 0.0;
        int i = 0;
        while (i < pkVec.size()) {
            if (nucType.equals("H1")) {
                csValue = ((HcchTocsy)pkVec.elementAt(i)).getHA();
            } else if (nucType.equals("N15")) {
                csValue = ((HcchTocsy)pkVec.elementAt(i)).getC13();
            }
            if (csValue >= a && csValue <= b) {
                outVec.add(pkVec.elementAt(i));
            }
            ++i;
        }
        return outVec;
    }

    public Vector deleteRepeat(Vector hcchVec, double epsH, double epsH1, double epsC13) {
        Vector outVec = new Vector();
        double csHa1 = 0.0;
        double csHa2 = 0.0;
        double csH1 = 0.0;
        double csH2 = 0.0;
        double csC1 = 0.0;
        double csC2 = 0.0;
        double intensity1 = 0.0;
        double intensity2 = 0.0;
        HcchTocsy hcch = new HcchTocsy();
        HcchTocsy hcch2 = new HcchTocsy();
        boolean no = false;
        outVec.add(hcchVec.elementAt(0));
        boolean bigger = false;
        boolean smaller = false;
        int i = 1;
        while (i < hcchVec.size()) {
            hcch = (HcchTocsy)hcchVec.elementAt(i);
            csHa1 = hcch.getHA();
            csH1 = hcch.getH1();
            csC1 = hcch.getC13();
            intensity1 = hcch.getIntensity();
            bigger = false;
            smaller = false;
            int j = 0;
            while (j < outVec.size()) {
                hcch2 = (HcchTocsy)outVec.elementAt(j);
                csHa2 = hcch2.getHA();
                csH2 = hcch2.getH1();
                csC2 = hcch2.getC13();
                intensity2 = hcch2.getIntensity();
                if (Math.abs(csHa1 - csHa2) < epsH && Math.abs(csH1 - csH2) < epsH1 && Math.abs(csC1 - csC2) < epsC13 && intensity1 > intensity2) {
                    bigger = true;
                    outVec.setElementAt(hcch, j);
                    break;
                }
                if (Math.abs(csHa1 - csHa2) < epsH && Math.abs(csH1 - csH2) < epsH1 && Math.abs(csC1 - csC2) < epsC13 && intensity1 <= intensity2) {
                    smaller = true;
                    break;
                }
                ++j;
            }
            if (!bigger && !smaller) {
                outVec.add(hcch);
            }
            ++i;
        }
        return outVec;
    }

    public Vector mergeHcch(Vector pkVec, double epsH, double epsC) {
        double csHA = 0.0;
        double csC13 = 0.0;
        double csHATmp = 0.0;
        double csC13Tmp = 0.0;
        Vector<HcchTocsy> outVec = new Vector<HcchTocsy>();
        Vector<Vector<HcchTocsy>> allVec = new Vector<Vector<HcchTocsy>>();
        double csValue = 0.0;
        HcchTocsy hncc = new HcchTocsy();
        int i = 0;
        int j = 0;
        Collections.sort(pkVec, new c13Comparator());
        boolean count = false;
        int cnt1 = 0;
        int cnt2 = 0;
        int N = pkVec.size();
        while (!pkVec.isEmpty()) {
            hncc = (HcchTocsy)pkVec.elementAt(0);
            csHA = hncc.getH1();
            csC13 = hncc.getC13();
            outVec.add(hncc);
            cnt1 = 0;
            i = 1;
            while (i < pkVec.size()) {
                hncc = (HcchTocsy)pkVec.elementAt(i);
                csHATmp = hncc.getH1();
                csC13Tmp = hncc.getC13();
                if (Math.abs(csHATmp - csHA) < epsH && Math.abs(csC13Tmp - csC13) < epsC) {
                    outVec.add(hncc);
                    ++cnt1;
                }
                ++i;
            }
            allVec.add(outVec);
            outVec = new Vector();
            cnt2 = 0;
            j = 0;
            while (j < pkVec.size()) {
                hncc = (HcchTocsy)pkVec.elementAt(j);
                csHATmp = hncc.getH1();
                csC13Tmp = hncc.getC13();
                if (Math.abs(csHATmp - csHA) < epsH && Math.abs(csC13Tmp - csC13) < epsC) {
                    pkVec.removeElementAt(j);
                    ++cnt2;
                    continue;
                }
                ++j;
            }
            pkVec.trimToSize();
            N = pkVec.size();
        }
        return allVec;
    }

    public static class c13Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HcchTocsy n1 = (HcchTocsy)o1;
            HcchTocsy n2 = (HcchTocsy)o2;
            double d1 = n1.getC13();
            if (d1 < (d2 = n2.getC13())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class h1Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HcchTocsy n1 = (HcchTocsy)o1;
            HcchTocsy n2 = (HcchTocsy)o2;
            double d1 = n1.getH1();
            if (d1 > (d2 = n2.getH1())) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class haComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HcchTocsy n1 = (HcchTocsy)o1;
            HcchTocsy n2 = (HcchTocsy)o2;
            double d1 = n1.getHA();
            if (d1 > (d2 = n2.getHA())) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HcchTocsy n1 = (HcchTocsy)o1;
            HcchTocsy n2 = (HcchTocsy)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

