/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.BackNoe;
import rdcPanda.Gaussian;
import rdcPanda.H1CS;
import rdcPanda.HcchTocsy;
import rdcPanda.HnNoe;
import rdcPanda.Hsqc;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;
import rdcPanda.Residue;

public class Assign {
    int residueNo;
    String residueType;
    Map assignMap = new TreeMap();
    Vector hnNoeVec = new Vector();
    Vector haNoeVec = new Vector();
    Vector h1NoeVec = new Vector();
    double maxValue = 0.0;
    int[] missingIndex;

    public void setMaxValue(double maxval) {
        this.maxValue = maxval;
    }

    public void setMissingIndex(int[] index) {
        this.missingIndex = index;
    }

    public int[] getMissingIndex() {
        return this.missingIndex;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Assign() {
    }

    public Assign(int no) {
        this.residueNo = no;
        this.residueType = null;
    }

    public Assign(int no, String type) {
        this.residueNo = no;
        this.residueType = type;
    }

    public Assign(int no, String type, Map aMap) {
        this.residueNo = no;
        this.residueType = type;
        this.assignMap = aMap;
    }

    public Assign(int no, String type, Map aMap, Vector hnVec, Vector haVec) {
        this.residueNo = no;
        this.residueType = type;
        this.assignMap = aMap;
        this.hnNoeVec = hnVec;
        this.haNoeVec = haVec;
    }

    public Assign(int no, String type, Map aMap, Vector hnVec, Vector haVec, Vector h1Vec) {
        this.residueNo = no;
        this.residueType = type;
        this.assignMap = aMap;
        this.hnNoeVec = hnVec;
        this.haNoeVec = haVec;
        this.h1NoeVec = h1Vec;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residueType;
    }

    public Map getMap() {
        return this.assignMap;
    }

    public Vector getHnNoeVec() {
        return this.hnNoeVec;
    }

    public Vector getHaNoeVec() {
        return this.haNoeVec;
    }

    public Vector getH1NoeVec() {
        return this.h1NoeVec;
    }

    public String toString() {
        double csValue = 0.0;
        String desc = String.valueOf(String.valueOf(this.residueNo)) + " " + this.residueType + "\n";
        String str = "";
        for (Map.Entry e : this.assignMap.entrySet()) {
            csValue = (Double)e.getValue();
            if (!(Math.abs(csValue + 999.99) > 0.01)) continue;
            str = String.valueOf(str) + (String)e.getKey() + " = " + (Double)e.getValue() + "\n";
        }
        desc = String.valueOf(desc) + str;
        return desc;
    }

    public Vector getOrder(String strSSES) {
        Vector<String> vecOrder = new Vector<String>();
        String fileName = "d";
        String ss = "";
        String str = "";
        Vector inputs = new Vector();
        int index = -1;
        if (strSSES.indexOf("-") < 0) {
            System.out.println("We need at lease two secondary structure elements.");
        }
        int preIndex = 0;
        int i = 1;
        while (i < strSSES.length() + 1) {
            str = strSSES.substring(i - 1, i);
            if (str.equalsIgnoreCase("-")) {
                ss = strSSES.substring(preIndex, i - 1);
                preIndex = i;
                vecOrder.add(ss);
            }
            ++i;
        }
        ss = strSSES.substring(preIndex, strSSES.length());
        vecOrder.add(ss);
        return vecOrder;
    }

    public Vector assignReader(String pdbFile, double h1Ref) {
        Vector<Assign> assignVec;
        block18: {
            String ss = "";
            String str = "";
            int no = 0;
            int noTmp = 0;
            String aaType = "";
            String atomName = "";
            StringTokenizer st = new StringTokenizer("");
            assignVec = new Vector<Assign>();
            Map<String, Double> mapAssign = new TreeMap();
            Residue res = new Residue();
            double csValue = 0.0;
            try {
                BufferedReader in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                while (true) {
                    String string;
                    if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        no = Integer.parseInt(st.nextToken());
                    }
                    if (st.hasMoreTokens()) {
                        aaType = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        atomName = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        string = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        csValue = new Double(st.nextToken()) + h1Ref;
                    }
                    mapAssign = res.nucluesByAA(aaType);
                    mapAssign.put(atomName, new Double(csValue));
                    ss = in.readLine();
                    if (ss == null) {
                        assignVec.add(new Assign(no, aaType, mapAssign));
                        break;
                    }
                    st = new StringTokenizer(ss);
                    st.nextToken();
                    if (st.hasMoreTokens()) {
                        noTmp = Integer.parseInt(st.nextToken());
                    }
                    while (noTmp == no) {
                        if (st.hasMoreTokens()) {
                            aaType = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            atomName = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            string = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            csValue = new Double(st.nextToken()) + h1Ref;
                        }
                        mapAssign.put(atomName, new Double(csValue));
                        ss = in.readLine();
                        if (ss == null) {
                            assignVec.add(new Assign(no, aaType, mapAssign));
                            break block18;
                        }
                        st = new StringTokenizer(ss);
                        st.nextToken();
                        if (!st.hasMoreTokens()) continue;
                        noTmp = Integer.parseInt(st.nextToken());
                    }
                    assignVec.add(new Assign(no, aaType, mapAssign));
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + pdbFile);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        Collections.sort(assignVec, new assignComparator());
        return assignVec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector assignReader2(String hncacbFile, Vector assignVec, Vector chsqcVec) {
        String ss = "";
        String str = "";
        int no = 0;
        int noTmp = 0;
        String aaType = "";
        String aaTypeS = "";
        String atomName = "";
        StringTokenizer st = new StringTokenizer("");
        TreeMap mapAssign = new TreeMap();
        Residue res = new Residue();
        double hnValue = 0.0;
        double nValue = 0.0;
        double caValue = 0.0;
        double cbValue = 0.0;
        double intensity = 1.0;
        double cs = 1.0;
        Assign assign = new Assign();
        Hsqc hsqc = new Hsqc();
        Map<String, Double> aMap = new TreeMap<String, Double>();
        Vector<Assign> assignVecN = new Vector<Assign>();
        double haCs = 0.0;
        double caCs = 0.0;
        boolean haveIt = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(hncacbFile));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    no = Integer.parseInt(st.nextToken());
                }
                if ((ss = in.readLine()) == null) return assignVecN;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    nValue = 100.0 * new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    hnValue = new Double(st.nextToken());
                }
                if ((ss = in.readLine()) == null) return assignVecN;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    cs = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (intensity > 0.0) {
                    caValue = cs;
                } else {
                    cbValue = cs;
                }
                ss = in.readLine();
                if (ss == null) return assignVecN;
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    cs = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (intensity > 0.0) {
                    caValue = cs;
                } else {
                    cbValue = cs;
                }
                int i = 0;
                while (i < assignVec.size()) {
                    assign = (Assign)assignVec.elementAt(i);
                    noTmp = assign.getResidueNo();
                    aaType = assign.getResidueType();
                    if (no == noTmp) {
                        aMap = assign.getMap();
                        aMap.put("HN", new Double(hnValue));
                        aMap.put("N", new Double(nValue));
                        aMap.put("CA", new Double(caValue));
                        if (!aaType.equalsIgnoreCase("GLY")) {
                            aMap.put("CB", new Double(cbValue));
                        }
                        aaTypeS = aaType;
                    }
                    ++i;
                }
                haveIt = false;
                int k = 0;
                while (k < chsqcVec.size()) {
                    hsqc = (Hsqc)chsqcVec.elementAt(k);
                    haCs = hsqc.getHN();
                    caCs = hsqc.getN15();
                    noTmp = hsqc.getResidueNo();
                    if (no == noTmp) {
                        aMap.put("ha", new Double(haCs));
                        aMap.put("ca", new Double(caCs));
                        haveIt = true;
                    }
                    ++k;
                }
                if (!haveIt) {
                    aMap.put("ha", new Double(-999.9));
                    aMap.put("ca", new Double(-999.9));
                }
                assignVecN.add(new Assign(no, aaTypeS, aMap));
                aMap = new TreeMap();
            } while ((ss = in.readLine()) != null);
            return assignVecN;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + hncacbFile);
            return assignVecN;
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return assignVecN;
    }

    public Vector<Assign> ReaderSeq(String filename) {
        Vector<Assign> inputs = new Vector<Assign>();
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String ss = "";
        String resName = "";
        int resNo = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    resName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                inputs.add(new Assign(resNo, resName));
            } while ((ss = in.readLine()) != null && !ss.equalsIgnoreCase(""));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<Map<String, String>> ParamReader(String fileName) {
        Vector<Map<String, String>> parameterVec = new Vector<Map<String, String>>();
        String ss = "";
        String str = "";
        String ss2 = "";
        int index = -1;
        int ind2 = -1;
        String key = "";
        String value = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            ss = in.readLine();
            if (ss != null) {
                while (ss != null) {
                    index = ss.indexOf("=");
                    while (index == -1) {
                        ss = in.readLine();
                        if (ss == null) break;
                        index = ss.indexOf("=");
                    }
                    while (ss != null && index > -1) {
                        key = ss.substring(0, index).trim();
                        key = key.toUpperCase();
                        ind2 = ss.indexOf(";", index);
                        if (ind2 < 0) {
                            System.out.println("Error in parameter file: lines need to be ended by \";\", see Example");
                            System.exit(1);
                        }
                        value = ss.substring(index + 1, ind2).trim();
                        TreeMap<String, String> mapParam = new TreeMap<String, String>();
                        mapParam.put(key, value);
                        parameterVec.add(mapParam);
                        ss = in.readLine();
                        if (ss == null) continue;
                        index = ss.indexOf("=");
                    }
                    ss = in.readLine();
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return parameterVec;
    }

    public Vector asgReader3(String filename) {
        Vector<Assign> inputs = new Vector<Assign>();
        double cs = 0.0;
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        int no = 0;
        int cnt = 0;
        String aaType = "";
        String ss = "";
        TreeMap<String, Double> aMap = new TreeMap<String, Double>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            st = new StringTokenizer(ss);
            no = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                aaType = st.nextToken();
            }
            while ((ss = in.readLine()) != null) {
                st = new StringTokenizer(ss);
                cnt = st.countTokens();
                if (cnt == 2) {
                    inputs.add(new Assign(no, aaType, aMap));
                    aMap = new TreeMap();
                    no = Integer.parseInt(st.nextToken());
                    aaType = st.nextToken();
                    continue;
                }
                if (cnt != 3) continue;
                str = st.nextToken();
                cs = new Double(st.nextToken());
                aMap.put(str, new Double(cs));
            }
            inputs.add(new Assign(no, aaType, aMap));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public void assignHsqc(Vector assignVec, Vector hsqcVec) {
        double hErr = 0.02;
        double nErr = 0.05;
        boolean no = false;
        int noTmp = 0;
        String aaType = "";
        double hnValue = 0.0;
        double nValue = 0.0;
        double csHN = 0.0;
        double csN = 0.0;
        Assign assign = new Assign();
        Map aMap = new TreeMap();
        Vector assignVecN = new Vector();
        Hsqc qc = new Hsqc();
        int i = 0;
        while (i < assignVec.size()) {
            assign = (Assign)assignVec.elementAt(i);
            noTmp = assign.getResidueNo();
            aaType = assign.getResidueType();
            aMap = assign.getMap();
            hnValue = (Double)aMap.get("HN");
            nValue = (Double)aMap.get("N");
            int j = 0;
            while (j < hsqcVec.size()) {
                qc = (Hsqc)hsqcVec.elementAt(j);
                csHN = qc.getHN();
                csN = qc.getN15();
                if (Math.abs(csHN - hnValue) < hErr && Math.abs(csN - nValue) < nErr) {
                    qc.setResidueNo(noTmp);
                    qc.setResidueType(aaType);
                }
                ++j;
            }
            ++i;
        }
    }

    public void matchC13Hsqc(Vector foldHsqcVec, Vector hsqcVec) {
        double hErr = 0.02;
        double nErr = 0.05;
        boolean no = false;
        int noTmp = 0;
        String aaType = "";
        double hnValue = 0.0;
        double nValue = 0.0;
        double csHN = 0.0;
        double csN = 0.0;
        Hsqc qc = new Hsqc();
        Hsqc qc2 = new Hsqc();
        int i = 0;
        while (i < foldHsqcVec.size()) {
            qc = (Hsqc)foldHsqcVec.elementAt(i);
            hnValue = qc.getHN();
            nValue = qc.getN15();
            int j = 0;
            while (j < hsqcVec.size()) {
                qc2 = (Hsqc)hsqcVec.elementAt(j);
                csHN = qc2.getHN();
                csN = qc2.getN15();
                noTmp = qc2.getResidueNo();
                aaType = qc2.getResidueType();
                if (Math.abs(csHN - hnValue) < hErr && Math.abs(csN - nValue) < nErr) {
                    qc.setResidueNo(noTmp);
                    qc.setResidueType(aaType);
                }
                ++j;
            }
            ++i;
        }
    }

    public Vector mergeNoe(Vector hnNoeVec, Vector hsqcVec, double hnErr, double nErr) {
        boolean no = false;
        boolean noTmp = false;
        String aaType = "";
        double hnValue = 0.0;
        double nValue = 0.0;
        double csHN = 0.0;
        double csN = 0.0;
        Assign assign = new Assign();
        HnNoe hnNoe = new HnNoe();
        TreeMap aMap = new TreeMap();
        Vector noeVecN = new Vector();
        Vector<HnNoe> oneVec = new Vector<HnNoe>();
        int i = 0;
        while (i < hsqcVec.size()) {
            csHN = ((Hsqc)hsqcVec.elementAt(i)).getHN();
            csN = ((Hsqc)hsqcVec.elementAt(i)).getN15();
            int j = 0;
            while (j < hnNoeVec.size()) {
                hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                hnValue = hnNoe.getHN();
                nValue = hnNoe.getN15();
                if (Math.abs(csHN - hnValue) < hnErr && Math.abs(csN - nValue) < nErr) {
                    oneVec.add(hnNoe);
                }
                ++j;
            }
            noeVecN.add(oneVec);
            oneVec = new Vector();
            ++i;
        }
        return noeVecN;
    }

    public Vector mergeC13Noe(Vector hcchVec, Vector hsqcVec, double haErr, double cErr) {
        int no = 0;
        boolean noTmp = false;
        String aaType = "";
        double haValue = 0.0;
        double cValue = 0.0;
        double csHa = 0.0;
        double csC = 0.0;
        double h1Value = 0.0;
        HcchTocsy hcch = new HcchTocsy();
        Vector<Residue> allVec = new Vector<Residue>();
        Vector<HcchTocsy> oneVec = new Vector<HcchTocsy>();
        Vector<Peak> pkVec = new Vector<Peak>();
        Residue resid = new Residue();
        Hsqc qc = new Hsqc();
        int i = 0;
        while (i < hsqcVec.size()) {
            qc = (Hsqc)hsqcVec.elementAt(i);
            csHa = qc.getHN();
            csC = qc.getN15();
            no = qc.getResidueNo();
            aaType = qc.getResidueType();
            pkVec.add(new Peak("ha", csHa));
            pkVec.add(new Peak("ca", csC));
            int j = 0;
            while (j < hcchVec.size()) {
                hcch = (HcchTocsy)hcchVec.elementAt(j);
                haValue = hcch.getHA();
                cValue = hcch.getC13();
                h1Value = hcch.getH1();
                if (Math.abs(csHa - haValue) < haErr && Math.abs(csC - cValue) < cErr) {
                    oneVec.add(hcch);
                }
                ++j;
            }
            allVec.add(new Residue(no, aaType, pkVec, oneVec));
            pkVec = new Vector();
            oneVec = new Vector();
            ++i;
        }
        return allVec;
    }

    public Vector mergeNoeAndAssign(Vector hnNoeVec, Vector hsqcVec, Vector assignVec, double hnErr, double nErr) {
        boolean no = false;
        int noTmp = 0;
        String aaType = "";
        double hnValue = 0.0;
        double nValue = 0.0;
        double csHN = 0.0;
        double csN = 0.0;
        Assign assign = new Assign();
        HnNoe hnNoe = new HnNoe();
        Map aMap = new TreeMap();
        Vector noeVecN = new Vector();
        Vector<HnNoe> oneVec = new Vector<HnNoe>();
        Hsqc qc = new Hsqc();
        int i = 0;
        while (i < hsqcVec.size()) {
            qc = (Hsqc)hsqcVec.elementAt(i);
            csHN = qc.getHN();
            csN = qc.getN15();
            noTmp = qc.getResidueNo();
            if (noTmp != 0) {
                aaType = qc.getResidueType();
                int j = 0;
                while (j < hnNoeVec.size()) {
                    hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                    hnValue = hnNoe.getHN();
                    nValue = hnNoe.getN15();
                    if (Math.abs(csHN - hnValue) < hnErr && Math.abs(csN - nValue) < nErr) {
                        oneVec.add(hnNoe);
                    }
                    ++j;
                }
                int k = 0;
                while (k < assignVec.size()) {
                    assign = (Assign)assignVec.elementAt(k);
                    aMap = assign.getMap();
                    hnValue = (Double)aMap.get("HN");
                    nValue = (Double)aMap.get("N");
                    if (Math.abs(csHN - hnValue) < hnErr && Math.abs(csN - nValue) < nErr && !oneVec.isEmpty()) {
                        hnNoe = (HnNoe)oneVec.elementAt(0);
                        hnNoe.setResidueNo(noTmp);
                        hnNoe.setResidueType(aaType);
                        hnNoe.setAssignMap(aMap);
                    }
                    ++k;
                }
                noeVecN.add(oneVec);
                oneVec = new Vector();
            }
            ++i;
        }
        return noeVecN;
    }

    public Vector mergeAssignAndNoe(Vector asgVec, Vector hnNoeVec, Vector cNoeVec, double hnErr, double nErr, double haErr, double cErr) {
        int no = 0;
        int noTmp = 0;
        String aaType = "";
        double hnValue = 0.0;
        double nValue = 0.0;
        double csHN = 0.0;
        double csN = 0.0;
        double he1 = 0.0;
        double he2 = 0.0;
        double ne = 0.0;
        double haValue = 0.0;
        double caValue = 0.0;
        double csHA = 0.0;
        double csHA2 = 0.0;
        double csHA3 = 0.0;
        double csCa = 0.0;
        Assign assign = new Assign();
        HnNoe hnNoe = new HnNoe();
        HcchTocsy hcch = new HcchTocsy();
        Map aMap = new TreeMap();
        Vector<HnNoe> hnNoeVec2 = new Vector<HnNoe>();
        Vector<HcchTocsy> haNoeVec = new Vector<HcchTocsy>();
        Vector<HnNoe> h1NoeVec = new Vector<HnNoe>();
        Vector<Assign> asgVec2 = new Vector<Assign>();
        Residue res = new Residue();
        Vector pkVec = new Vector();
        Vector hcchVec2 = new Vector();
        int i = 0;
        while (i < asgVec.size()) {
            assign = (Assign)asgVec.elementAt(i);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            aMap = assign.getMap();
            csHN = (Double)aMap.get("HN");
            csN = aMap.get("N") != null ? (Double)aMap.get("N") : -999.99;
            if (aMap.get("ca") == null) {
                System.out.println(String.valueOf(no) + " " + aaType);
            } else {
                csCa = (Double)aMap.get("ca");
            }
            int j = 0;
            while (j < hnNoeVec.size()) {
                hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                hnValue = hnNoe.getHN();
                nValue = hnNoe.getN15();
                if (Math.abs(csHN - hnValue) < hnErr && Math.abs(csN - nValue) < nErr) {
                    hnNoeVec2.add(hnNoe);
                }
                ++j;
            }
            if (aMap.get("NE") != null) {
                ne = (Double)aMap.get("NE");
                he1 = (Double)aMap.get("HE21");
                he2 = (Double)aMap.get("HE22");
                j = 0;
                while (j < hnNoeVec.size()) {
                    hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                    hnValue = hnNoe.getHN();
                    nValue = hnNoe.getN15();
                    if ((Math.abs(he1 - hnValue) < 0.5 * hnErr || Math.abs(he2 - hnValue) < 0.5 * hnErr) && Math.abs(ne - nValue) < 0.5 * nErr) {
                        h1NoeVec.add(hnNoe);
                    }
                    ++j;
                }
            } else if (aMap.get("ND") != null) {
                ne = (Double)aMap.get("ND");
                he1 = (Double)aMap.get("HD21");
                he2 = (Double)aMap.get("HD22");
                j = 0;
                while (j < hnNoeVec.size()) {
                    hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                    hnValue = hnNoe.getHN();
                    nValue = hnNoe.getN15();
                    if ((Math.abs(he1 - hnValue) < 0.5 * hnErr || Math.abs(he2 - hnValue) < 0.5 * hnErr) && Math.abs(ne - nValue) < 0.5 * nErr) {
                        h1NoeVec.add(hnNoe);
                    }
                    ++j;
                }
            }
            j = 0;
            while (j < cNoeVec.size()) {
                hcch = (HcchTocsy)cNoeVec.elementAt(j);
                noTmp = hcch.getResidueNo();
                if (no == noTmp) {
                    haNoeVec.add(hcch);
                }
                ++j;
            }
            asgVec2.add(new Assign(no, aaType, aMap, hnNoeVec2, haNoeVec, h1NoeVec));
            hnNoeVec2 = new Vector();
            haNoeVec = new Vector();
            h1NoeVec = new Vector();
            ++i;
        }
        return asgVec2;
    }

    public Vector deleteRepeat(Vector allVec, double epsH, double epsN, double epsH1) {
        Vector oneVec = new Vector();
        Vector<HnNoe> oneVecNew = new Vector<HnNoe>();
        Vector<Vector<HnNoe>> allVecNew = new Vector<Vector<HnNoe>>();
        double csHN1 = 0.0;
        double csHN2 = 0.0;
        double csH1 = 0.0;
        double csH2 = 0.0;
        double csN1 = 0.0;
        double csN2 = 0.0;
        double intensity1 = 0.0;
        double intensity2 = 0.0;
        HnNoe hncc = new HnNoe();
        HnNoe hncc1 = new HnNoe();
        HnNoe hncc2 = new HnNoe();
        HnNoe hnNoe1 = new HnNoe();
        HnNoe hnNoe2 = new HnNoe();
        boolean bigger = false;
        int no = 0;
        String residue = "";
        Map aMap = new TreeMap();
        Assign assign = new Assign();
        int i = 0;
        while (i < allVec.size()) {
            oneVec = (Vector)allVec.elementAt(i);
            if (!oneVec.isEmpty()) {
                hnNoe1 = (HnNoe)oneVec.elementAt(0);
                no = hnNoe1.getResidueNo();
                residue = hnNoe1.getResidueType();
                aMap = hnNoe1.getAssignMap();
            }
            int j = 0;
            while (j < oneVec.size()) {
                hncc1 = (HnNoe)oneVec.elementAt(j);
                csHN1 = hncc1.getHN();
                csH1 = hncc1.getH1();
                csN1 = hncc1.getN15();
                intensity1 = hncc1.getIntensity();
                bigger = false;
                int k = 0;
                while (k < oneVec.size()) {
                    hncc2 = (HnNoe)oneVec.elementAt(k);
                    csHN2 = hncc2.getHN();
                    csH2 = hncc2.getH1();
                    csN2 = hncc2.getN15();
                    intensity2 = hncc2.getIntensity();
                    if (Math.abs(csHN2 - csHN1) < epsH && Math.abs(csN2 - csN1) < epsN && Math.abs(csH2 - csH1) < epsH && Math.abs(intensity2) >= Math.abs(intensity1)) {
                        bigger = true;
                        hncc = hncc2;
                        csH1 = hncc.getH1();
                        csHN1 = hncc.getHN();
                        csN1 = hncc.getN15();
                        intensity1 = hncc.getIntensity();
                    }
                    ++k;
                }
                if (!bigger) {
                    if (oneVecNew.indexOf(hncc1) < 0) {
                        oneVecNew.add(hncc1);
                    }
                } else if (oneVecNew.indexOf(hncc) < 0) {
                    oneVecNew.add(hncc);
                }
                ++j;
            }
            if (!oneVecNew.isEmpty()) {
                hnNoe2 = (HnNoe)oneVecNew.elementAt(0);
                hnNoe2.setResidueNo(no);
                hnNoe2.setResidueType(residue);
                hnNoe2.setAssignMap(aMap);
            }
            allVecNew.add(oneVecNew);
            oneVecNew = new Vector();
            ++i;
        }
        return allVecNew;
    }

    public Vector sortAssign(Vector allVec) {
        Vector oneVec = new Vector();
        double csHN2 = 0.0;
        double csH2 = 0.0;
        double csN2 = 0.0;
        HnNoe hncc2 = new HnNoe();
        double cs = 0.0;
        double inten = 0.0;
        HnNoe hnNoe1 = new HnNoe();
        int no = 0;
        String residue = "";
        String nucleus = "";
        Map aMap = new TreeMap();
        Vector<Peak> pkVec = new Vector<Peak>();
        Vector<HnNoe> oneNoeVec = new Vector<HnNoe>();
        Vector<Residue> allPkVec = new Vector<Residue>();
        TreeMap<String, Vector<HnNoe>> noeMap = new TreeMap<String, Vector<HnNoe>>();
        Residue resid = new Residue();
        int i = 0;
        while (i < allVec.size()) {
            oneVec = (Vector)allVec.elementAt(i);
            int k = 0;
            while (k < oneVec.size()) {
                hncc2 = (HnNoe)oneVec.elementAt(k);
                aMap = hncc2.getAssignMap();
                if (!aMap.isEmpty()) {
                    no = hncc2.getResidueNo();
                    residue = hncc2.getResidueType();
                    for (Map.Entry e : aMap.entrySet()) {
                        nucleus = (String)e.getKey();
                        cs = (Double)e.getValue();
                        if (!(Math.abs(cs + 999.99) > 0.01)) continue;
                        pkVec.add(new Peak(nucleus, cs));
                    }
                }
                csHN2 = hncc2.getHN();
                csH2 = hncc2.getH1();
                csN2 = hncc2.getN15();
                inten = hncc2.getIntensity();
                oneNoeVec.add(new HnNoe(no, residue, csHN2, csN2, csH2, inten));
                ++k;
            }
            noeMap.put("H", oneNoeVec);
            allPkVec.add(new Residue(no, residue, pkVec, noeMap));
            oneNoeVec = new Vector();
            noeMap = new TreeMap();
            pkVec = new Vector();
            ++i;
        }
        return allPkVec;
    }

    public Vector mergeAll(Vector allVec, Vector hcchVec, double haErr, double c13Err) {
        Vector<HcchTocsy> oneVec = new Vector<HcchTocsy>();
        double csHa = 0.0;
        double csHA = 0.0;
        double csHA2 = 0.0;
        double csHA3 = 0.0;
        double csHB = 0.0;
        double csHB2 = 0.0;
        double csHB3 = 0.0;
        double csC13 = 0.0;
        double csCA = 0.0;
        double csCB = 0.0;
        HnNoe hncc2 = new HnNoe();
        double cs = 0.0;
        double inten = 0.0;
        HnNoe hnNoe1 = new HnNoe();
        int no = 0;
        String residue = "";
        String nucleus = "";
        TreeMap<String, Double> aMap = new TreeMap<String, Double>();
        Vector pkVec = new Vector();
        Vector oneNoeVec = new Vector();
        TreeMap noeMap = new TreeMap();
        Residue resid = new Residue();
        Peak pk = new Peak();
        HcchTocsy hcch = new HcchTocsy();
        Vector<Residue> allVecN = new Vector<Residue>();
        int i = 0;
        while (i < allVec.size()) {
            int j;
            resid = (Residue)allVec.elementAt(i);
            no = resid.getResidueNo();
            residue = resid.getResidueType().toUpperCase();
            pkVec = resid.getPeakVec();
            if (!residue.equals("GLY")) {
                csHA = -999.99;
                csCA = -999.99;
                csHB2 = -999.99;
                csHB3 = -999.99;
                csCB = -999.99;
                j = 0;
                while (j < pkVec.size()) {
                    pk = (Peak)pkVec.elementAt(j);
                    aMap.put(pk.getNucleus(), new Double(pk.getCS()));
                    nucleus = pk.getNucleus();
                    if (nucleus.equals("HA")) {
                        csHA = pk.getCS();
                    } else if (nucleus.equals("CA")) {
                        csCA = pk.getCS();
                    } else if (nucleus.equals("CB")) {
                        csCB = pk.getCS();
                    } else if (nucleus.equals("HB")) {
                        csHB = pk.getCS();
                    } else if (nucleus.equals("HB2")) {
                        csHB2 = pk.getCS();
                    } else if (nucleus.equals("HB3")) {
                        csHB3 = pk.getCS();
                    }
                    ++j;
                }
                j = 0;
                while (j < hcchVec.size()) {
                    hcch = (HcchTocsy)hcchVec.elementAt(j);
                    csHa = hcch.getHA();
                    csC13 = hcch.getC13();
                    if (Math.abs(csHa - csHA) < haErr && Math.abs(csC13 - csCA) < c13Err) {
                        oneVec.add(hcch);
                    } else if (Math.abs(csHa - csHB) < haErr && Math.abs(csC13 - csCB) < c13Err) {
                        oneVec.add(hcch);
                    } else if ((Math.abs(csHa - csHB2) < haErr || Math.abs(csHa - csHB3) < haErr) && Math.abs(csC13 - csCB) < c13Err) {
                        oneVec.add(hcch);
                    }
                    ++j;
                }
            } else if (residue.equals("GLY")) {
                csHA2 = -999.99;
                csHA3 = -999.99;
                csCA = -999.99;
                j = 0;
                while (j < pkVec.size()) {
                    pk = (Peak)pkVec.elementAt(j);
                    aMap.put(pk.getNucleus(), new Double(pk.getCS()));
                    nucleus = pk.getNucleus();
                    if (nucleus.equals("HA2")) {
                        csHA2 = pk.getCS();
                    } else if (nucleus.equals("HA3")) {
                        csHA3 = pk.getCS();
                    } else if (nucleus.equals("CA")) {
                        csCA = pk.getCS();
                    }
                    ++j;
                }
                j = 0;
                while (j < hcchVec.size()) {
                    hcch = (HcchTocsy)hcchVec.elementAt(j);
                    csHa = hcch.getHA();
                    csC13 = hcch.getC13();
                    if ((Math.abs(csHa - csHA2) < haErr || Math.abs(csHa - csHA3) < haErr) && Math.abs(csC13 - csCA) < c13Err) {
                        oneVec.add(hcch);
                    }
                    ++j;
                }
            }
            resid.setHcchVec(oneVec);
            oneVec = new Vector();
            allVecN.add(resid);
            ++i;
        }
        return allVecN;
    }

    public Vector BackNoeDeleteRepeat(Vector vecBackNoe) {
        Vector<BackNoe> vecBackNoeNew = new Vector<BackNoe>();
        boolean isRepeat = false;
        int i = 0;
        while (i < vecBackNoe.size()) {
            isRepeat = false;
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            double csH1 = backNoe.getCSH1();
            double csHeavy = backNoe.getCSHeavy();
            double csH2 = backNoe.getCSH2();
            int j = i + 1;
            while (j < vecBackNoe.size()) {
                BackNoe backNoe_temp = (BackNoe)vecBackNoe.elementAt(j);
                double csH1_temp = backNoe_temp.getCSH1();
                double csHeavy_temp = backNoe_temp.getCSHeavy();
                double csH2_temp = backNoe_temp.getCSH2();
                if (csH1 == csH1_temp && csHeavy == csHeavy_temp && csH2 == csH2_temp) {
                    isRepeat = true;
                }
                ++j;
            }
            if (!isRepeat) {
                vecBackNoeNew.add(backNoe);
            }
            ++i;
        }
        return vecBackNoeNew;
    }

    public void CompMaxMatchScore_old(Vector vecBackNoe, double preMisPenalty, double preMatchScore, int depth, int finalDepth, int[] missingIndex) {
        int[] msIndex = (int[])missingIndex.clone();
        double sigma = 2.0;
        if (depth == finalDepth) {
            double sc;
            double dbMax = this.getMaxValue();
            if (dbMax < (sc = Math.exp(-preMisPenalty) + preMatchScore)) {
                this.setMaxValue(sc);
                this.setMissingIndex(missingIndex);
            }
            return;
        }
        msIndex[depth] = 1;
        double curPenalty = ((BackNoe)vecBackNoe.elementAt(depth)).getMissingPenalty();
        this.CompMaxMatchScore_old(vecBackNoe, curPenalty, preMatchScore, depth + 1, finalDepth, msIndex);
        Gaussian gs = new Gaussian();
        msIndex[depth] = 0;
        double rmsd = ((BackNoe)vecBackNoe.elementAt(depth)).getRmsd();
        double curMatchScore = preMatchScore * (Gaussian.Phi(rmsd, 0.0, sigma) - Gaussian.Phi(-rmsd, 0.0, sigma));
        this.CompMaxMatchScore_old(vecBackNoe, preMisPenalty, curMatchScore, depth + 1, finalDepth, msIndex);
    }

    public double NoePatternMatchScore_old2(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks) {
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = csErrH / 4.0;
        double sigmaHN = csErrH / 4.0;
        double sigmaN = csErrN / 4.0;
        double sigmaHA = csErrH / 4.0;
        double sigmaCA = csErrCA / 4.0;
        double sigmaHeavy = 0.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
            }
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                if (Math.abs(csExpH1 - csBackH1) < csErrH && Math.abs(csExpH2 - csBackH2) < csErrH && Math.abs(csExpHeavy - csBackHeavy) < csErrHeavy) {
                    ++counter;
                    double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                    tempp += Math.exp(-0.5 * (cs_dist /= 3.0));
                }
                ++j;
            }
            if (tempp >= 1.0) {
                tempp = 1.0;
            }
            prob_score += tempp;
            ++i;
        }
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScoreWCali(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks, boolean isSkipIntensity, double constant) {
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = 0.04;
        double sigmaHN = 0.04;
        double sigmaN = 0.1;
        double sigmaHA = 0.04;
        double sigmaCA = 0.1;
        double sigmaHeavy = 0.1;
        double sigmaInten = 3.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        double bkCompDist = 0.0;
        double distSigma = 1.0;
        int bkBinIndex = 0;
        int expBinIndex = 0;
        double distExp = 0.0;
        Noesy nesy = new Noesy();
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            int no1 = backNoe.getFirstResNo();
            int no2 = backNoe.getSecondResNo();
            String res1 = backNoe.getFirstResName();
            String res2 = backNoe.getSecondResName();
            String atom1 = backNoe.getH1Name();
            String atom2 = backNoe.getH2Name();
            double distanceT = backNoe.getDistance();
            bkCompDist = backNoe.getDistance();
            if (bkCompDist <= 2.7) {
                bkBinIndex = 1;
            } else if (bkCompDist <= 3.3) {
                bkBinIndex = 2;
            } else if (bkCompDist < 5.0) {
                bkBinIndex = 3;
            } else if (bkCompDist < 6.0) {
                bkBinIndex = 4;
            }
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            double dist_min = 999.9;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
            }
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                expBinIndex = noesy.getBinIndex();
                double intensity = noesy.getIntensity();
                if (Math.abs(csExpH1 - csBackH1) < 0.04 && Math.abs(csExpH2 - csBackH2) < 0.03 && Math.abs(csExpHeavy - csBackHeavy) < 0.1 && !(bkCompDist > (distExp = nesy.SetCalibrationOneCyana(backNoe, noesy, constant)) + 0.0) && !(Math.abs(bkCompDist - distExp) > 2.5)) {
                    ++counter;
                    double inten_dist = (distExp - bkCompDist) * (distExp - bkCompDist) / (distSigma * distSigma);
                    double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                    cs_dist /= 3.0;
                    if (isSkipIntensity) {
                        inten_dist = 0.0;
                    }
                    if ((cs_dist = 0.5 * (cs_dist + inten_dist)) < dist_min) {
                        dist_min = cs_dist;
                    }
                }
                ++j;
            }
            prob_score += (tempp += Math.exp(-0.5 * dist_min));
            ++i;
        }
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScoreWCaliTestJBNMR1(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks, boolean isSkipIntensity, double constant) {
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = 0.04;
        double sigmaHN = 0.04;
        double sigmaN = 0.1;
        double sigmaHA = 0.04;
        double sigmaCA = 0.1;
        double sigmaHeavy = 0.1;
        double sigmaInten = 3.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        double bkCompDist = 0.0;
        double distSigma = 1.0;
        int bkBinIndex = 0;
        int expBinIndex = 0;
        double distExp = 0.0;
        Noesy nesy = new Noesy();
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            int no1 = backNoe.getFirstResNo();
            int no2 = backNoe.getSecondResNo();
            String res1 = backNoe.getFirstResName();
            String res2 = backNoe.getSecondResName();
            String atom1 = backNoe.getH1Name();
            String atom2 = backNoe.getH2Name();
            double distanceT = backNoe.getDistance();
            bkCompDist = backNoe.getDistance();
            if (bkCompDist <= 2.7) {
                bkBinIndex = 1;
            } else if (bkCompDist <= 3.3) {
                bkBinIndex = 2;
            } else if (bkCompDist < 5.0) {
                bkBinIndex = 3;
            } else if (bkCompDist < 6.0) {
                bkBinIndex = 4;
            }
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            double dist_min = 0.0;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
            }
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                expBinIndex = noesy.getBinIndex();
                double intensity = noesy.getIntensity();
                if (Math.abs(csExpH1 - csBackH1) < 0.04 && Math.abs(csExpH2 - csBackH2) < 0.04 && Math.abs(csExpHeavy - csBackHeavy) < 0.4 && !(bkCompDist > (distExp = nesy.SetCalibrationOneCyana(backNoe, noesy, constant)) + 0.0) && !(Math.abs(bkCompDist - distExp) > 2.5)) {
                    ++counter;
                    double inten_dist = (distExp - bkCompDist) * (distExp - bkCompDist) / (distSigma * distSigma);
                    double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                    cs_dist /= 3.0;
                    if (isSkipIntensity) {
                        inten_dist = 0.0;
                    }
                    cs_dist = 0.5 * (cs_dist + inten_dist);
                    dist_min += cs_dist;
                }
                ++j;
            }
            tempp = dist_min > 1.0E-7 ? (tempp += Math.exp(-0.5 * dist_min)) : 0.0;
            prob_score += tempp;
            ++i;
        }
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScoreWCaliTestJBNMR2(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks, boolean isSkipIntensity, double constant) {
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = 0.04;
        double sigmaHN = 0.04;
        double sigmaN = 0.1;
        double sigmaHA = 0.04;
        double sigmaCA = 0.1;
        double sigmaHeavy = 0.1;
        double sigmaInten = 3.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        double bkCompDist = 0.0;
        double distSigma = 1.0;
        boolean bkBinIndex = false;
        int expBinIndex = 0;
        double distExp = 0.0;
        Noesy nesy = new Noesy();
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            int no1 = backNoe.getFirstResNo();
            int no2 = backNoe.getSecondResNo();
            String res1 = backNoe.getFirstResName();
            String res2 = backNoe.getSecondResName();
            String atom1 = backNoe.getH1Name();
            String atom2 = backNoe.getH2Name();
            double distanceT = backNoe.getDistance();
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            double weighting = 1.0;
            double dist_min = 9999.9;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
                weighting = 0.1;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
                weighting = 0.2;
            }
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                expBinIndex = noesy.getBinIndex();
                double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) + weighting * weighting * (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2);
                if ((cs_dist /= 3.0) < dist_min) {
                    dist_min = cs_dist;
                }
                ++j;
            }
            prob_score += dist_min;
            ++i;
        }
        score = Math.sqrt(prob_score / (double)vecBackNoe.size());
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScoreWCaliHdphic(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks, boolean isSkipIntensity, double constant) {
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = 0.01;
        double sigmaHN = 0.01;
        double sigmaN = 0.1;
        double sigmaHA = 0.01;
        double sigmaCA = 0.1;
        double sigmaHeavy = 0.1;
        double sigmaInten = 3.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        double bkCompDist = 0.0;
        double distSigma = 0.3;
        int bkBinIndex = 0;
        int expBinIndex = 0;
        double distExp = 0.0;
        Noesy nesy = new Noesy();
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            int no1 = backNoe.getFirstResNo();
            int no2 = backNoe.getSecondResNo();
            String res1 = backNoe.getFirstResName();
            String res2 = backNoe.getSecondResName();
            String atom1 = backNoe.getH1Name();
            String atom2 = backNoe.getH2Name();
            double distanceT = backNoe.getDistance();
            bkCompDist = backNoe.getDistance();
            if (bkCompDist <= 2.7) {
                bkBinIndex = 1;
            } else if (bkCompDist <= 3.3) {
                bkBinIndex = 2;
            } else if (bkCompDist < 5.0) {
                bkBinIndex = 3;
            } else if (bkCompDist < 6.0) {
                bkBinIndex = 4;
            }
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            double dist_min = 999.9;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
            }
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                expBinIndex = noesy.getBinIndex();
                double intensity = noesy.getIntensity();
                if (Math.abs(csExpH1 - csBackH1) < 0.04 && Math.abs(csExpH2 - csBackH2) < 0.04 && Math.abs(csExpHeavy - csBackHeavy) < 0.2) {
                    distExp = nesy.SetCalibrationOneCyana(backNoe, noesy, constant);
                    ++counter;
                    double inten_dist = (distExp - bkCompDist) * (distExp - bkCompDist) / (distSigma * distSigma);
                    double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                    cs_dist /= 3.0;
                    if (isSkipIntensity) {
                        inten_dist = 0.0;
                    }
                    if ((cs_dist = 0.5 * (cs_dist + inten_dist)) < dist_min) {
                        dist_min = cs_dist;
                    }
                }
                ++j;
            }
            prob_score += (tempp += Math.exp(-0.5 * dist_min));
            ++i;
        }
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScore(double csErrH, double csErrN, double csErrCA, Vector vecBackNoe, Vector vecNoesy, int[] numPeaks, boolean isSkipIntensity) {
        double wtIntra = 6.0;
        double csErrHeavy = 0.0;
        double score = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        int counter = 0;
        double sigmaH = 0.01;
        double sigmaHN = 0.01;
        double sigmaN = 0.05;
        double sigmaHA = 0.01;
        double sigmaCA = 0.05;
        double sigmaHeavy = 0.05;
        double sigmaInten = 1.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        double bkCompDist = 0.0;
        double distSigma = 1.2;
        int bkBinIndex = 0;
        int expBinIndex = 0;
        double distExp = 0.0;
        int i = 0;
        while (i < vecBackNoe.size()) {
            BackNoe backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            double wt = 1.0;
            int no1 = backNoe.getFirstResNo();
            int no2 = backNoe.getSecondResNo();
            String res1 = backNoe.getFirstResName();
            String res2 = backNoe.getSecondResName();
            String atom1 = backNoe.getH1Name();
            String atom2 = backNoe.getH2Name();
            double distanceT = backNoe.getDistance();
            double minExpDist = 6.0;
            bkCompDist = backNoe.getDistance();
            if (bkCompDist <= 2.7) {
                bkBinIndex = 1;
            } else if (bkCompDist <= 3.3) {
                bkBinIndex = 2;
            } else if (bkCompDist < 5.0) {
                bkBinIndex = 3;
            } else if (bkCompDist < 6.0) {
                bkBinIndex = 4;
            }
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            double dist_min = 999.9;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sigmaHeavy = sigmaN;
                csErrHeavy = csErrN;
                sigmaH = sigmaHN;
            } else {
                sigmaHeavy = sigmaCA;
                csErrHeavy = csErrCA;
                sigmaH = sigmaHA;
            }
            boolean isFound = false;
            int j = 0;
            while (j < vecNoesy.size()) {
                Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                csExpH1 = noesy.getH1();
                csExpHeavy = noesy.getHeavy();
                csExpH2 = noesy.getH2();
                expBinIndex = noesy.getBinIndex();
                distExp = noesy.getUpperDist();
                double intensity = noesy.getIntensity();
                if (Math.abs(csExpH1 - csBackH1) < 0.03 && Math.abs(csExpH2 - csBackH2) < 0.03 && Math.abs(csExpHeavy - csBackHeavy) < 0.1) {
                    double inten_dist = (double)((expBinIndex - bkBinIndex) * (expBinIndex - bkBinIndex)) / (sigmaInten * sigmaInten);
                    isFound = true;
                    double cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                    cs_dist /= 3.0;
                    if (isSkipIntensity) {
                        inten_dist = 0.0;
                    }
                    if ((cs_dist = 0.5 * (cs_dist + inten_dist)) < dist_min) {
                        dist_min = cs_dist;
                        minExpDist = distExp;
                    }
                }
                ++j;
            }
            if (isFound) {
                ++counter;
            }
            wt = Math.abs(no1 - no2) == 0 ? wtIntra : 1.0;
            prob_score += (tempp += wt * Math.exp(-0.5 * dist_min));
            ++i;
        }
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public double NoePatternMatchScore(Vector vecBackNoe, Vector vecHnNoe, Vector vecCaNoe, int[] numPeaks) {
        BackNoe backNoe;
        double csErrH = 0.04;
        double csErrN = 0.2;
        double csErrCA = 0.12;
        double score = 0.0;
        double temp = 0.0;
        double csBackH1 = 0.0;
        double csBackHeavy = 0.0;
        double csBackH2 = 0.0;
        double csExpH1 = 0.0;
        double csExpHeavy = 0.0;
        double csExpH2 = 0.0;
        double wtCSfromNtoH = 0.04;
        double wtCSfromCtoH = 0.09;
        double rmsd = 0.0;
        double sumH1 = 0.0;
        double sumHeavy = 0.0;
        double sumH2 = 0.0;
        boolean index = false;
        int count = 0;
        double mu = 0.0;
        double sigmaH = csErrH / 4.0;
        double sigmaHN = csErrH / 4.0;
        double sigmaN = csErrN / 4.0;
        double sigmaHA = csErrH / 4.0;
        double sigmaCA = csErrCA / 4.0;
        double sigmaHeavy = 0.0;
        double winHeavy = 0.0;
        double sigmaDist = 0.9;
        double wtC2 = 1.0;
        double prob_score = 0.0;
        double tempp = 0.0;
        int i = 0;
        while (i < vecBackNoe.size()) {
            double cs_dist;
            int j;
            backNoe = (BackNoe)vecBackNoe.elementAt(i);
            csBackH1 = backNoe.getCSH1();
            csBackHeavy = backNoe.getCSHeavy();
            csBackH2 = backNoe.getCSH2();
            rmsd = 9999.9;
            index = false;
            count = 0;
            String heavyName = backNoe.getHeavyName();
            tempp = 0.0;
            if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                sumH1 = 0.0;
                sumHeavy = 0.0;
                sumH2 = 0.0;
                count = 0;
                sigmaHeavy = sigmaN;
                sigmaH = sigmaHN;
                j = 0;
                while (j < vecHnNoe.size()) {
                    HnNoe hnNoe = (HnNoe)vecHnNoe.elementAt(j);
                    csExpH1 = hnNoe.getHN();
                    csExpHeavy = hnNoe.getN15();
                    csExpH2 = hnNoe.getH1();
                    if (Math.abs(csExpH1 - csBackH1) < csErrH && Math.abs(csExpH2 - csBackH2) < csErrH && Math.abs(csExpHeavy - csBackHeavy) < csErrN) {
                        backNoe.addHnNoe(hnNoe);
                        sumH1 += Math.abs(csExpH1 - csBackH1);
                        sumHeavy += Math.abs(csExpHeavy - csBackHeavy);
                        sumH2 += Math.abs(csExpH2 - csBackH2);
                        cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                        tempp += Math.exp(-0.5 * (cs_dist /= 3.0));
                    }
                    ++j;
                }
                count = backNoe.getHnNoeVector().size();
                if (count > 0) {
                    backNoe.setRmsdAll(sumH1 / (double)count, sumHeavy / (double)count, sumH2 / (double)count);
                } else {
                    backNoe.setIsMissing(true);
                }
            } else {
                sumH1 = 0.0;
                sumHeavy = 0.0;
                sumH2 = 0.0;
                count = 0;
                sigmaHeavy = sigmaCA;
                sigmaH = sigmaHA;
                j = 0;
                while (j < vecCaNoe.size()) {
                    HcchTocsy caNoe = (HcchTocsy)vecCaNoe.elementAt(j);
                    csExpH1 = caNoe.getHA();
                    csExpHeavy = caNoe.getC13();
                    csExpH2 = caNoe.getH1();
                    if (Math.abs(csExpH1 - csBackH1) < csErrH && Math.abs(csExpH2 - csBackH2) < csErrH && Math.abs(csExpHeavy - csBackHeavy) < csErrCA) {
                        backNoe.addCaNoe(caNoe);
                        sumH1 += Math.abs(csExpH1 - csBackH1);
                        sumHeavy += Math.abs(csExpHeavy - csBackHeavy);
                        sumH2 += Math.abs(csExpH2 - csBackH2);
                        cs_dist = (csExpH1 - csBackH1) * (csExpH1 - csBackH1) / (sigmaH * sigmaH) + (csExpHeavy - csBackHeavy) * (csExpHeavy - csBackHeavy) / (sigmaHeavy * sigmaHeavy) + (csExpH2 - csBackH2) * (csExpH2 - csBackH2) / (sigmaH * sigmaH);
                        tempp += Math.exp(-0.5 * (cs_dist /= 3.0));
                    }
                    ++j;
                }
                count = backNoe.getCaNoeVector().size();
                if (count > 0) {
                    backNoe.setRmsdAll(sumH1 / (double)count, sumHeavy / (double)count, sumH2 / (double)count);
                } else {
                    backNoe.setIsMissing(true);
                }
            }
            if (tempp >= 1.0) {
                tempp = 1.0;
            }
            prob_score += tempp;
            ++i;
        }
        double msPenalty4LargeDist = 0.5;
        double msPenalty4SmallDist = 3.0;
        double distThreshold = 4.5;
        double distUpBound = 6.0;
        double penaltySC = 0.0;
        double matchSC = 0.0;
        Gaussian gs = new Gaussian();
        double msPr = 0.0;
        double prScore = 0.0;
        double dbPenalty = 0.0;
        double score_temp = 0.0;
        int counter = 0;
        i = 0;
        while (i < vecBackNoe.size()) {
            backNoe = (BackNoe)vecBackNoe.elementAt(i);
            if (backNoe.getDistance() != 0.0 && backNoe.getCSH1() != -999.9 && backNoe.getCSH2() != -999.9 && backNoe.getCSHeavy() != -999.9) {
                msPr = Gaussian.phiExtend(Math.abs(distUpBound - backNoe.getDistance()), mu, sigmaDist);
                backNoe.setMissingProb(msPr);
                if (backNoe.getIsMissing()) {
                    backNoe.setMissingPenalty(distThreshold, msPenalty4SmallDist, msPenalty4LargeDist);
                    penaltySC += backNoe.getMissingPenalty();
                    prScore += dbPenalty;
                    if (backNoe.getHeavyName().substring(0, 1).equalsIgnoreCase("N")) {
                        sigmaHeavy = sigmaN;
                        winHeavy = csErrN;
                    } else {
                        sigmaHeavy = sigmaCA;
                        winHeavy = csErrCA;
                    }
                    double temp8 = 1.0 - Gaussian.Phi(csErrH, mu, sigmaH);
                    double temp9 = 1.0 - Gaussian.Phi(winHeavy, mu, sigmaHeavy);
                    double temp4 = Math.log(1.0 - Gaussian.Phi(csErrH, mu, sigmaH));
                    double temp5 = Math.log(1.0 - Gaussian.Phi(winHeavy, mu, sigmaHeavy));
                    score_temp = score_temp + Math.log(1.0 - Gaussian.Phi(csErrH, mu, sigmaH)) + Math.log(1.0 - Gaussian.Phi(winHeavy, mu, sigmaHeavy)) + Math.log(1.0 - Gaussian.Phi(csErrH, mu, sigmaH));
                } else {
                    if (backNoe.getHeavyName().substring(0, 1).equalsIgnoreCase("N")) {
                        sigmaHeavy = sigmaN;
                        sigmaH = sigmaHN;
                    } else {
                        sigmaHeavy = sigmaCA;
                        sigmaH = sigmaHA;
                    }
                    double temp1 = (backNoe.getRmsdH1() - mu) * (backNoe.getRmsdH1() - mu) / (sigmaH * sigmaH);
                    double temp2 = (backNoe.getRmsdHeavy() - mu) * (backNoe.getRmsdHeavy() - mu) / (sigmaHeavy * sigmaHeavy);
                    double temp3 = (backNoe.getRmsdH2() - mu) * (backNoe.getRmsdH2() - mu) / (sigmaH * sigmaH);
                    double temp_dist = (backNoe.getRmsdH1() - mu) * (backNoe.getRmsdH1() - mu) / (sigmaH * sigmaH) + (backNoe.getRmsdHeavy() - mu) * (backNoe.getRmsdHeavy() - mu) / (sigmaHeavy * sigmaHeavy) + (backNoe.getRmsdH2() - mu) * (backNoe.getRmsdH2() - mu) / (sigmaH * sigmaH);
                    matchSC += Math.exp(-0.5 * (temp_dist /= 3.0));
                    ++counter;
                }
            }
            ++i;
        }
        double score2 = matchSC / (double)vecBackNoe.size();
        score = prob_score / (double)vecBackNoe.size();
        numPeaks[0] = counter;
        return score;
    }

    public Vector SwapStereoAsg(Vector vecAsg, int resNo) {
        Vector<H1CS> vecNewAsg = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = (H1CS)vecAsg.elementAt(i);
            String atomOld = h1cs.getAtomName();
            String atom = new String(atomOld);
            double csH = h1cs.getH1CS();
            String subAtom = "";
            subAtom = atom.length() > 2 ? atom.substring(0, 2) : atom;
            String res = h1cs.getResidueType();
            int no = h1cs.getResidueNo();
            boolean isChanged = false;
            if (no == resNo && subAtom.equalsIgnoreCase("HB") && (res.equalsIgnoreCase("CYS") || res.equalsIgnoreCase("ASP") || res.equalsIgnoreCase("GLU") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("LYS") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("ASN") || res.equalsIgnoreCase("PRO") || res.equalsIgnoreCase("GLN") || res.equalsIgnoreCase("ARG") || res.equalsIgnoreCase("SER") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("TYR"))) {
                if (atom.equalsIgnoreCase("HB1")) {
                    atom = "HB2";
                } else if (atom.equalsIgnoreCase("HB2")) {
                    atom = "HB1";
                }
            }
            if (no == resNo && subAtom.equalsIgnoreCase("HA") && res.equalsIgnoreCase("GLY")) {
                if (atom.equalsIgnoreCase("HA1")) {
                    atom = "HA2";
                } else if (atom.equalsIgnoreCase("HA2")) {
                    atom = "HA1";
                }
            }
            if (no == resNo && (subAtom.equalsIgnoreCase("HG") || subAtom.equalsIgnoreCase("CG")) && res.equalsIgnoreCase("VAL")) {
                if (atom.equalsIgnoreCase("HG1")) {
                    atom = "HG2";
                } else if (atom.equalsIgnoreCase("HG2")) {
                    atom = "HG1";
                } else if (atom.equalsIgnoreCase("CG1")) {
                    atom = "CG2";
                } else if (atom.equalsIgnoreCase("CG2")) {
                    atom = "CG1";
                }
            }
            if (no == resNo && (subAtom.equalsIgnoreCase("HD") || subAtom.equalsIgnoreCase("CD")) && res.equalsIgnoreCase("LEU")) {
                if (atom.equalsIgnoreCase("HD1")) {
                    atom = "HD2";
                } else if (atom.equalsIgnoreCase("HD2")) {
                    atom = "HD1";
                } else if (atom.equalsIgnoreCase("CD1")) {
                    atom = "CD2";
                } else if (atom.equalsIgnoreCase("CD2")) {
                    atom = "CD1";
                }
            }
            vecNewAsg.add(new H1CS(no, res, atom, csH));
            ++i;
        }
        return vecNewAsg;
    }

    public Vector StereospecificNoeAsg(Vector vecNoe) {
        Noe noe = new Noe();
        Peak pk = new Peak();
        boolean isFound = false;
        Vector<Noe> vecRefinedNoe = new Vector<Noe>();
        int i = 0;
        while (i < vecNoe.size()) {
            noe = (Noe)vecNoe.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            String secondAtomName = noe.getAtomB();
            double dist = noe.getUpper();
            boolean isStereo = false;
            if (firstAtomName.length() > 2) {
                if (firstAtomName.substring(0, 2).equalsIgnoreCase("HB")) {
                    firstAtomName = "HB";
                }
                if (firstResName.equalsIgnoreCase("LEU") && firstAtomName.substring(0, 2).equalsIgnoreCase("HD")) {
                    firstAtomName = "HD";
                }
                if (firstResName.equalsIgnoreCase("VAL") && firstAtomName.substring(0, 2).equalsIgnoreCase("HG")) {
                    firstAtomName = "HG";
                }
                isStereo = true;
            }
            if (secondAtomName.length() > 2) {
                if (secondAtomName.substring(0, 2).equalsIgnoreCase("HB")) {
                    secondAtomName = "HB";
                }
                if (secondAtomName.equalsIgnoreCase("LEU") && secondAtomName.substring(0, 2).equalsIgnoreCase("HD")) {
                    secondAtomName = "HD";
                }
                if (secondAtomName.equalsIgnoreCase("VAL") && secondAtomName.substring(0, 2).equalsIgnoreCase("HG")) {
                    secondAtomName = "HG";
                }
                isStereo = true;
            }
            noe.setAtom1Name(firstAtomName);
            noe.setAtom2Name(secondAtomName);
            if (isStereo) {
                dist += 2.0;
            }
            noe.setDistUpper(dist);
            vecRefinedNoe.add(noe);
            ++i;
        }
        return vecRefinedNoe;
    }

    public Vector<Noe> PrunAmbgNoeAsg(Vector<Pdb> pdbVec, Vector<Noe> vecNoe, double noeLimit, double methylCorrection, int nIsoriginalUp) {
        Noe noe = new Noe();
        Peak pk = new Peak();
        double dist_from_inten = 0.0;
        boolean isFound = false;
        double[] noeDist = new double[2];
        Vector<Noe> vecRefinedNoe = new Vector<Noe>();
        boolean numPrunedPeaks = false;
        int i = 0;
        while (i < vecNoe.size()) {
            noe = vecNoe.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            String secondAtomName = noe.getAtomB();
            dist_from_inten = noe.getUpper();
            double noeUpperPrune = 0.0;
            noeUpperPrune = noeLimit > 0.0 ? noeLimit : dist_from_inten;
            isFound = pk.checkNoeNew(pdbVec, firstResNo, firstAtomName, secondResNo, secondAtomName, noeUpperPrune += 0.0, 0.0, noeDist);
            if (isFound) {
                if (nIsoriginalUp == 0) {
                    noe.setDistUpper(noeDist[0] + 0.5);
                } else if (nIsoriginalUp == 2) {
                    noe.setDistUpper(6.0);
                }
                vecRefinedNoe.add(noe);
            }
            ++i;
        }
        return vecRefinedNoe;
    }

    public Vector<Noe> InitAmbiAssignmentUnique(double nErr, double cErr, double hnErr, double haErr, double h2Err, Vector vecAsg, Vector vecAllH1, Vector vecNoesy) {
        boolean debugCounter = false;
        double h1Err = 0.0;
        double heavyErr = 0.0;
        h1Err = Math.max(hnErr, haErr);
        Vector<Noe> vecAmbgNoe = new Vector<Noe>();
        Noesy noesy = new Noesy();
        H1CS h1CS = new H1CS();
        Peak pk = new Peak();
        Vector<Object> vecH1Temp = new Vector();
        Vector<Object> vecH2Temp = new Vector();
        Peak peakA = new Peak();
        Peak peakB = new Peak();
        double distUpper = 0.0;
        int i = 0;
        while (i < vecNoesy.size()) {
            boolean isWait = false;
            boolean isRemoved = false;
            noesy = (Noesy)vecNoesy.elementAt(i);
            double csHeavy = noesy.getHeavy();
            double csH1 = noesy.getH1();
            double csH2 = noesy.getH2();
            distUpper = noesy.getUpperDist();
            vecH1Temp = pk.rangeSearch(vecAllH1, csH1, h1Err);
            vecH2Temp = pk.rangeSearch(vecAllH1, csH2, h2Err);
            int j = 0;
            while (j < vecH1Temp.size()) {
                peakA = (Peak)vecH1Temp.elementAt(j);
                String resIdA = peakA.getNucleus();
                int indexA = resIdA.indexOf("-");
                int resNoA = Integer.parseInt(resIdA.substring(3, indexA));
                String resA = resIdA.substring(0, 3);
                String nucleusA = resIdA.substring(indexA + 1);
                if (nucleusA.equalsIgnoreCase("HN")) {
                    nucleusA = "H";
                }
                double csResA = peakA.getCS();
                String heavyName = pk.GetHeavyAtomFromProton(resA, nucleusA);
                if (heavyName.substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                    if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                        h1Err = hnErr;
                        heavyErr = nErr;
                    } else {
                        h1Err = haErr;
                        heavyErr = cErr;
                    }
                    if (!(Math.abs(csResA - csH1) > h1Err)) {
                        double csHeavyTemp = 0.0;
                        int k = 0;
                        while (k < vecAsg.size()) {
                            H1CS h1cs = (H1CS)vecAsg.elementAt(k);
                            int asgResNo = h1cs.getResidueNo();
                            String asgRes = h1cs.getResidueType();
                            String asgAtom = h1cs.getAtomName();
                            double asgCS = h1cs.getH1CS();
                            if (asgResNo == resNoA && asgAtom.equalsIgnoreCase(heavyName)) {
                                csHeavyTemp = asgCS;
                                break;
                            }
                            ++k;
                        }
                        if (!(Math.abs(csHeavyTemp - csHeavy) > heavyErr)) {
                            k = 0;
                            while (k < vecH2Temp.size()) {
                                peakB = (Peak)vecH2Temp.elementAt(k);
                                String resIdB = peakB.getNucleus();
                                int indexB = resIdB.indexOf("-");
                                int resNoB = Integer.parseInt(resIdB.substring(3, indexB));
                                String resB = resIdB.substring(0, 3);
                                String nucleusB = resIdB.substring(indexB + 1);
                                if (nucleusB.equalsIgnoreCase("HN")) {
                                    nucleusB = "H";
                                }
                                if (!isWait) {
                                    vecAmbgNoe.add(new Noe(i, resNoA, resNoB, resA, resB, nucleusA, nucleusB, 1.8, distUpper));
                                    isWait = true;
                                    isRemoved = false;
                                } else if (!isRemoved) {
                                    vecAmbgNoe.remove(vecAmbgNoe.size() - 1);
                                    isRemoved = true;
                                }
                                ++k;
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return vecAmbgNoe;
    }

    public Vector<Noe> InitAmbiAssignment(double nErr, double cErr, double hnErr, double haErr, double h2Err, Vector<H1CS> vecAsg, Vector<Peak> vecAllH1, Vector<Noesy> vecNoesy) {
        double h1Err = 0.0;
        double heavyErr = 0.0;
        h1Err = Math.max(hnErr, haErr);
        Vector<Noe> vecAmbgNoe = new Vector<Noe>();
        Noesy noesy = new Noesy();
        H1CS h1CS = new H1CS();
        Peak pk = new Peak();
        Vector<Object> vecH1Temp = new Vector();
        Vector<Object> vecH2Temp = new Vector();
        Peak peakA = new Peak();
        Peak peakB = new Peak();
        double distUpper = 0.0;
        int i = 0;
        while (i < vecNoesy.size()) {
            noesy = vecNoesy.elementAt(i);
            double csHeavy = noesy.getHeavy();
            double csH1 = noesy.getH1();
            double csH2 = noesy.getH2();
            distUpper = noesy.getUpperDist();
            if (!(Math.abs(csH1 - csH2) < 0.05)) {
                vecH1Temp = pk.rangeSearch(vecAllH1, csH1, h1Err);
                vecH2Temp = pk.rangeSearch(vecAllH1, csH2, h2Err);
                int j = 0;
                while (j < vecH1Temp.size()) {
                    peakA = (Peak)vecH1Temp.elementAt(j);
                    String resIdA = peakA.getNucleus();
                    int indexA = resIdA.indexOf("-");
                    int resNoA = Integer.parseInt(resIdA.substring(3, indexA));
                    String resA = resIdA.substring(0, 3);
                    String nucleusA = resIdA.substring(indexA + 1);
                    if (nucleusA.equalsIgnoreCase("HN")) {
                        nucleusA = "H";
                    }
                    double csResA = peakA.getCS();
                    String heavyName = pk.GetHeavyAtomFromProton(resA, nucleusA);
                    if (heavyName.substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                        if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                            h1Err = hnErr;
                            heavyErr = nErr;
                        } else {
                            h1Err = haErr;
                            heavyErr = cErr;
                        }
                        if (!(Math.abs(csResA - csH1) > h1Err)) {
                            double csHeavyTemp = 0.0;
                            int k = 0;
                            while (k < vecAsg.size()) {
                                H1CS h1cs = vecAsg.elementAt(k);
                                int asgResNo = h1cs.getResidueNo();
                                String asgRes = h1cs.getResidueType();
                                String asgAtom = h1cs.getAtomName();
                                double asgCS = h1cs.getH1CS();
                                if (asgResNo == resNoA && asgAtom.equalsIgnoreCase(heavyName)) {
                                    csHeavyTemp = asgCS;
                                    break;
                                }
                                ++k;
                            }
                            if (!(Math.abs(csHeavyTemp - csHeavy) > heavyErr)) {
                                k = 0;
                                while (k < vecH2Temp.size()) {
                                    peakB = (Peak)vecH2Temp.elementAt(k);
                                    String resIdB = peakB.getNucleus();
                                    int indexB = resIdB.indexOf("-");
                                    int resNoB = Integer.parseInt(resIdB.substring(3, indexB));
                                    String resB = resIdB.substring(0, 3);
                                    String nucleusB = resIdB.substring(indexB + 1);
                                    if (nucleusB.equalsIgnoreCase("HN")) {
                                        nucleusB = "H";
                                    }
                                    vecAmbgNoe.add(new Noe(i, resNoA, resNoB, resA, resB, nucleusA, nucleusB, 1.8, distUpper));
                                    ++k;
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return vecAmbgNoe;
    }

    public Vector InitAmbiAssignment4D(double nErr, double cErr, double hnErr, double haErr, double h2Err, Vector vecAsg, Vector vecAllH1, Vector vecNoesy) {
        double h1Err = 0.0;
        double heavyErr = 0.0;
        h1Err = Math.max(hnErr, haErr);
        Vector<Noe> vecAmbgNoe = new Vector<Noe>();
        Noesy noesy = new Noesy();
        H1CS h1CS = new H1CS();
        Peak pk = new Peak();
        Vector<Object> vecH1Temp = new Vector();
        Vector<Object> vecH2Temp = new Vector();
        Peak peakA = new Peak();
        Peak peakB = new Peak();
        double distUpper = 0.0;
        int i = 0;
        while (i < vecNoesy.size()) {
            noesy = (Noesy)vecNoesy.elementAt(i);
            double csHeavy1 = noesy.getHeavy1();
            double csHeavy2 = noesy.getHeavy2();
            double csH1 = noesy.getH1();
            double csH2 = noesy.getH2();
            distUpper = noesy.getUpperDist();
            vecH1Temp = pk.rangeSearch(vecAllH1, csH1, h1Err);
            vecH2Temp = pk.rangeSearch(vecAllH1, csH2, h2Err);
            int j = 0;
            while (j < vecH1Temp.size()) {
                peakA = (Peak)vecH1Temp.elementAt(j);
                String resIdA = peakA.getNucleus();
                int indexA = resIdA.indexOf("-");
                int resNoA = Integer.parseInt(resIdA.substring(3, indexA));
                String resA = resIdA.substring(0, 3);
                String nucleusA = resIdA.substring(indexA + 1);
                if (nucleusA.equalsIgnoreCase("HN")) {
                    nucleusA = "H";
                }
                double csResA = peakA.getCS();
                String heavyName = pk.GetHeavyAtomFromProton(resA, nucleusA);
                if (heavyName.substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                    if (heavyName.substring(0, 1).equalsIgnoreCase("N")) {
                        h1Err = hnErr;
                        heavyErr = nErr;
                    } else {
                        h1Err = haErr;
                        heavyErr = cErr;
                    }
                    if (!(Math.abs(csResA - csH1) > h1Err)) {
                        double csHeavyTemp = 0.0;
                        int k = 0;
                        while (k < vecAsg.size()) {
                            H1CS h1cs = (H1CS)vecAsg.elementAt(k);
                            int asgResNo = h1cs.getResidueNo();
                            String asgRes = h1cs.getResidueType();
                            String asgAtom = h1cs.getAtomName();
                            double asgCS = h1cs.getH1CS();
                            if (asgResNo == resNoA && asgAtom.equalsIgnoreCase(heavyName)) {
                                csHeavyTemp = asgCS;
                                break;
                            }
                            ++k;
                        }
                        if (!(Math.abs(csHeavyTemp - csHeavy1) > heavyErr)) {
                            k = 0;
                            while (k < vecH2Temp.size()) {
                                peakB = (Peak)vecH2Temp.elementAt(k);
                                String resIdB = peakB.getNucleus();
                                int indexB = resIdB.indexOf("-");
                                int resNoB = Integer.parseInt(resIdB.substring(3, indexB));
                                String resB = resIdB.substring(0, 3);
                                String nucleusB = resIdB.substring(indexB + 1);
                                if (nucleusB.equalsIgnoreCase("HN")) {
                                    nucleusB = "H";
                                }
                                double csResB = peakB.getCS();
                                heavyName = pk.GetHeavyAtomFromProton(resB, nucleusB);
                                if (heavyName.substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                                    heavyErr = heavyName.substring(0, 1).equalsIgnoreCase("N") ? nErr : cErr;
                                    if (!(Math.abs(csResB - csH2) > h2Err)) {
                                        csHeavyTemp = 0.0;
                                        int t = 0;
                                        while (t < vecAsg.size()) {
                                            H1CS h1cs = (H1CS)vecAsg.elementAt(t);
                                            int asgResNo = h1cs.getResidueNo();
                                            String asgRes = h1cs.getResidueType();
                                            String asgAtom = h1cs.getAtomName();
                                            double asgCS = h1cs.getH1CS();
                                            if (asgResNo == resNoA && asgAtom.equalsIgnoreCase(heavyName)) {
                                                csHeavyTemp = asgCS;
                                                break;
                                            }
                                            ++t;
                                        }
                                        if (!(Math.abs(csHeavyTemp - csHeavy2) > heavyErr)) {
                                            vecAmbgNoe.add(new Noe(i, resNoA, resNoB, resA, resB, nucleusA, nucleusB, 1.8, distUpper));
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return vecAmbgNoe;
    }

    public Vector mergeAll3(Vector allVec, Vector hcchVec) {
        Vector<HcchTocsy> oneVec = new Vector<HcchTocsy>();
        HnNoe hncc2 = new HnNoe();
        HnNoe hnNoe1 = new HnNoe();
        int no = 0;
        int no2 = 0;
        TreeMap<String, Double> aMap = new TreeMap<String, Double>();
        Vector pkVec = new Vector();
        Vector oneNoeVec = new Vector();
        Residue resid = new Residue();
        Peak pk = new Peak();
        HcchTocsy hcch = new HcchTocsy();
        Vector<Residue> allVecN = new Vector<Residue>();
        int i = 0;
        while (i < allVec.size()) {
            resid = (Residue)allVec.elementAt(i);
            no = resid.getResidueNo();
            pkVec = resid.getPeakVec();
            int j = 0;
            while (j < pkVec.size()) {
                pk = (Peak)pkVec.elementAt(j);
                aMap.put(pk.getNucleus(), new Double(pk.getCS()));
                ++j;
            }
            j = 0;
            while (j < hcchVec.size()) {
                hcch = (HcchTocsy)hcchVec.elementAt(j);
                no2 = hcch.getResidueNo();
                if (no2 == no) {
                    oneVec.add(hcch);
                }
                ++j;
            }
            resid.setHcchVec(oneVec);
            oneVec = new Vector();
            allVecN.add(resid);
            ++i;
        }
        return allVecN;
    }

    public Vector mergeAll4(Vector allHcchVec) {
        double h1Err = 0.01;
        Residue res = new Residue();
        Peak pk = new Peak();
        HcchTocsy hcch = new HcchTocsy();
        Vector pkVec = new Vector();
        Vector hcchVec2 = new Vector();
        double h1 = 0.0;
        double h2 = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector pkVecN = new Vector();
        Vector<Residue> allVec = new Vector<Residue>();
        i = 0;
        while (i < allHcchVec.size()) {
            res = (Residue)allHcchVec.elementAt(i);
            int residueNo = res.getResidueNo();
            String residue = res.getResidueType();
            System.out.println(String.valueOf(residueNo) + " " + residue);
            pkVec = res.getPeakVec();
            Collections.sort(pkVec, new Peak.csComparator());
            hcchVec2 = res.getHcchVec();
            Collections.sort(hcchVec2, new HcchTocsy.haComparator());
            System.out.println();
            j = 0;
            while (j < pkVec.size()) {
                pk = (Peak)pkVec.elementAt(j);
                String nucleus1 = pk.getNucleus();
                h1 = pk.getCS();
                System.out.println(pk);
                ++j;
            }
            k = 0;
            while (k < hcchVec2.size()) {
                hcch = (HcchTocsy)hcchVec2.elementAt(k);
                System.out.println(hcch);
                ++k;
            }
            allVec.add(new Residue(residueNo, residue, pkVecN, hcchVec2));
            pkVecN = new Vector();
            ++i;
        }
        return allVec;
    }

    public void NOEAsgFromCS(String src, String strOut, String strInput) {
        String atomB;
        String atomA;
        int noB;
        Noe noe;
        Vector<Noe> vecNoeTemp;
        Noe ee;
        Vector<Object> vecTemp;
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strResNameScheme = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strIsUnique = "";
        String strIsInterSSE = "";
        String stroutName = "";
        String strNoesyFormat = "";
        String strIsLongNoeCheck = "";
        String strIsCheckSym = "";
        String strIsDeltWeak = "";
        String strIsDeltBBNoe = "";
        String strOutOrFormat = "";
        String strSSEBB = "";
        double SSE1_first = 0.0;
        double SSE1_second = 0.0;
        double SSE2_first = 0.0;
        double SSE2_second = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("SSEBB")) {
                strSSEBB = paraMap.get("SSEBB");
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("ISLONGNOECHECK")) {
                strIsLongNoeCheck = paraMap.get("ISLONGNOECHECK");
            }
            if (paraMap.containsKey("ISSYMCHECK")) {
                strIsCheckSym = paraMap.get("ISSYMCHECK");
            }
            if (paraMap.containsKey("ISDELETEWEAK")) {
                strIsDeltWeak = paraMap.get("ISDELETEWEAK");
            }
            if (paraMap.containsKey("ISDELETEBBNOE")) {
                strIsDeltBBNoe = paraMap.get("ISDELETEBBNOE");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("ISUNIQUE")) {
                strIsUnique = paraMap.get("ISUNIQUE");
            }
            if (paraMap.containsKey("ISINTERSSES")) {
                strIsInterSSE = paraMap.get("ISINTERSSES");
            }
            if (paraMap.containsKey("SSE1START")) {
                SSE1_first = Double.parseDouble(paraMap.get("SSE1START"));
            }
            if (paraMap.containsKey("SSE1END")) {
                SSE1_second = Double.parseDouble(paraMap.get("SSE1END"));
            }
            if (paraMap.containsKey("SSE2START")) {
                SSE2_first = Double.parseDouble(paraMap.get("SSE2START"));
            }
            if (paraMap.containsKey("SSE2END")) {
                SSE2_second = Double.parseDouble(paraMap.get("SSE2END"));
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        Vector vecNoesy = new Vector();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        String pdbSSEFile = String.valueOf(src) + strSSEBB;
        Vector<Pdb> vecSSE = pp.readPdb(pdbSSEFile);
        double[] constant = new double[1];
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        Vector<Noesy> vecNoesyNoDia = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            double cs_h2;
            Noesy noesy2 = (Noesy)vecNoesy.elementAt(i);
            double cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.01) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy = new Vector();
        vecNoesy.addAll(vecNoesyNoDia);
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        vecNewNoesy.addAll(vecNoesy);
        Vector<Noe> vecAmbgAsg = new Vector<Noe>();
        Vector<Noe> vecUniqueAsg = asg.InitAmbiAssignmentUnique(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNewNoesy);
        if (strIsUnique.equalsIgnoreCase("1")) {
            vecAmbgAsg.addAll(vecUniqueAsg);
        } else {
            vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNewNoesy);
        }
        Collections.sort(vecAmbgAsg, new Noe.NoeComparator());
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        vecNewNoes.addAll(vecAmbgAsg);
        if (strResNameScheme.equalsIgnoreCase("PDB-NEW")) {
            vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromPDBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
        }
        if (strResNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromBMRBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
            Vector<Object> vecAsgNew = new Vector();
            H1CS h1cs = new H1CS();
            vecAsgNew = h1cs.CSNameConvertFromBMRBNewToPDBNew(assignVec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgNew);
        }
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecNewNoes, vecNewNoesy, constant[0]);
        vecNewNoes = new Vector();
        vecNewNoes.addAll(vecAmbgAsgTemp);
        if (strIsDeltBBNoe.equalsIgnoreCase("1")) {
            vecNoeTemp = new Vector<Noe>();
            i = 0;
            while (i < vecNewNoes.size()) {
                noe = vecNewNoes.elementAt(i);
                int noA = noe.getResidueNoA();
                if (Math.abs(noA - (noB = noe.getResidueNoB())) <= 4) {
                    vecNoeTemp.add(noe);
                } else {
                    atomA = noe.getAtomA();
                    atomB = noe.getAtomB();
                    double distUp = noe.getUpper();
                    String atomA_new = "";
                    String atomB_new = "";
                    atomA_new = atomA.length() >= 2 ? atomA.substring(0, 2) : atomA;
                    atomB_new = atomB.length() >= 2 ? atomB.substring(0, 2) : atomB;
                    if (!atomA_new.equalsIgnoreCase("H") && !atomA_new.equalsIgnoreCase("HN") && !atomA_new.equalsIgnoreCase("HA") && !atomA_new.equalsIgnoreCase("HB") || !atomB_new.equalsIgnoreCase("H") && !atomB_new.equalsIgnoreCase("HN") && !atomB_new.equalsIgnoreCase("HA") && !atomB_new.equalsIgnoreCase("HB") || !(distUp < 3.4)) {
                        vecNoeTemp.add(noe);
                    }
                }
                ++i;
            }
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecNoeTemp);
        }
        if (strIsCheckSym.equalsIgnoreCase("1")) {
            Vector vecTemp2 = pk.CheckNoeSym(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp2);
        }
        if (strIsDeltWeak.equalsIgnoreCase("1")) {
            vecNoeTemp = new Vector();
            i = 0;
            while (i < vecNewNoes.size()) {
                noe = vecNewNoes.elementAt(i);
                double distUp = noe.getUpper();
                if (distUp < 5.9) {
                    vecNoeTemp.add(noe);
                }
                ++i;
            }
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecNoeTemp);
        }
        Vector<Noe> vecNoeRefine2 = new Vector<Noe>();
        i = 0;
        while (i < vecNewNoes.size()) {
            noe = vecNewNoes.elementAt(i);
            int noA = noe.getResidueNoA();
            noB = noe.getResidueNoB();
            atomA = noe.getAtomA();
            atomB = noe.getAtomB();
            if (noA != noB || !atomA.equalsIgnoreCase(atomB)) {
                boolean isIn = true;
                if (strOutOrFormat.equalsIgnoreCase("0")) {
                    int j = 0;
                    while (j < vecNoeRefine2.size()) {
                        Noe noeT = (Noe)vecNoeRefine2.elementAt(j);
                        int noAT = noeT.getResidueNoA();
                        int noBT = noeT.getResidueNoB();
                        String atomAT = noeT.getAtomA();
                        String atomBT = noeT.getAtomB();
                        if (noA == noAT && atomA.equalsIgnoreCase(atomAT) && noB == noBT && atomB.equalsIgnoreCase(atomBT)) {
                            isIn = false;
                        }
                        if (noA == noBT && atomA.equalsIgnoreCase(atomBT) && noB == noAT && atomB.equalsIgnoreCase(atomAT)) {
                            isIn = false;
                        }
                        ++j;
                    }
                }
                if (isIn) {
                    vecNoeRefine2.add(noe);
                }
            }
            ++i;
        }
        vecNewNoes = new Vector();
        vecNewNoes.addAll(vecNoeRefine2);
        if (strIsLongNoeCheck.equalsIgnoreCase("1")) {
            Vector vecRefineLongNOE = pk.CheckLongRangNOE(vecNewNoes, 10);
            Vector vecRefineLongNOE2 = new Vector();
            vecRefineLongNOE2.addAll(vecRefineLongNOE);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecRefineLongNOE2);
            Collections.sort(vecNewNoes, new Noe.NoeComparator());
        }
        Vector<Noe> vecTemp3 = new Vector<Noe>();
        if (strIsInterSSE.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecNewNoes.size()) {
                boolean isIn = false;
                Noe noe2 = new Noe();
                noe2 = vecNewNoes.elementAt(i);
                int firstResNo = noe2.getResidueNoA();
                int secondResNo = noe2.getResidueNoB();
                if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first && (double)secondResNo <= SSE2_second && (double)secondResNo >= SSE2_first) {
                    isIn = true;
                }
                if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first && (double)firstResNo <= SSE2_second && (double)firstResNo >= SSE2_first) {
                    isIn = true;
                }
                if (isIn) {
                    vecTemp3.add(noe2);
                }
                ++i;
            }
        } else {
            vecTemp3.addAll(vecNewNoes);
        }
        vecNewNoes = new Vector();
        vecNewNoes.addAll(vecTemp3);
        String userDirTemp = System.getProperty("user.dir");
        if (strOutOrFormat.equalsIgnoreCase("0")) {
            String fileName = String.valueOf(userDirTemp) + stroutName;
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of NOEs is " + vecNewNoes.size());
                out.println("");
                out.println("");
                i = 0;
                while (i < vecNewNoes.size()) {
                    Noe noe3 = vecNewNoes.elementAt(i);
                    int resNo1 = noe3.getResidueNoA();
                    int resNo2 = noe3.getResidueNoB();
                    String res1 = noe3.getResidueA();
                    String res2 = noe3.getResidueB();
                    String atom1 = noe3.getAtomA();
                    String atom2 = noe3.getAtomB();
                    double distUpper = noe3.getUpper();
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    if (isDebug) {
                        System.out.println(xplorNoeStr);
                    }
                    out.println(xplorNoeStr);
                    ++i;
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        } else if (strOutOrFormat.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecNewNoes);
            String fileName = String.valueOf(userDirTemp) + stroutName;
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Total time for NOE assignment:  " + totalTime + " minutes");
    }

    public void doHANANOEAsg(String src, String strOut, String strInput) throws JampackException {
        int j;
        Noe noe;
        Noe ee;
        Vector<Object> vecTemp;
        double cs_h2;
        double cs_h1;
        Noesy noesy2;
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strBB = "";
        String stroutName = "";
        String strNoesyFormat = "";
        String strOutOrFormat = "";
        String strSSEBB = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        String str4DNoesy = "";
        int nIsoriginalUp = 0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("SSEBB")) {
                strSSEBB = paraMap.get("SSEBB");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector vecNoesy = new Vector();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector vecNoesy4D = new Vector();
        vecNoesy4D.addAll(Noe4DVec);
        String pdbSSEFile = String.valueOf(src) + strSSEBB;
        Vector<Pdb> vecSSE = pp.readPdb(pdbSSEFile);
        double[] constant = new double[1];
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        Vector<Noesy> vecNoesyNoDia = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            noesy2 = (Noesy)vecNoesy.elementAt(i);
            cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.01) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy = new Vector();
        vecNoesy.addAll(vecNoesyNoDia);
        vecNoesyNoDia = new Vector();
        i = 0;
        while (i < vecNoesy4D.size()) {
            noesy2 = (Noesy)vecNoesy4D.elementAt(i);
            cs_h1 = noesy2.getH1();
            cs_h2 = noesy2.getH2();
            double cs_heavy1 = noesy2.getHeavy1();
            double cs_heavy2 = noesy2.getHeavy2();
            if (Math.abs(cs_h1 - cs_h2) > 0.04 && Math.abs(cs_heavy1 - cs_heavy2) > 0.06) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy4D = new Vector();
        vecNoesy4D.addAll(vecNoesyNoDia);
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        Vector vecNewNoesy4D = new Vector();
        vecNewNoesy.addAll(vecNoesy);
        vecNewNoesy4D.addAll(vecNoesy4D);
        String userDirTemp = System.getProperty("user.dir");
        String pdbFile = String.valueOf(userDirTemp) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = new Vector();
        pdbVecNew = strIsWholeStr.equalsIgnoreCase("1") ? pp.residueNameUpdateNoStr(vecSeq, pdbVecBB) : pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector<Object> pdbVecNewSec = new Vector();
        if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
            pdbVecNewSec = pp.nameConvertOrder(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
            Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecNew);
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecSSE22);
        } else {
            pdbVecNewSec.addAll(pdbVecNew);
        }
        Vector<Object> vecStructureAll = new Vector<Object>();
        vecStructureAll.addAll(pdbVecNewSec);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(pdbVecNewSec);
        pdbVecNewSec = new Vector();
        pdbVecNewSec.addAll(vecBBTemp);
        Vector<Object> vecAmbgAsg = new Vector();
        vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNewNoesy);
        Vector vecAmbgAsg4D = new Vector();
        vecAmbgAsg4D = asg.InitAmbiAssignment4D(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNewNoesy4D);
        vecAmbgAsg.addAll(vecAmbgAsg4D);
        Collections.sort(vecAmbgAsg, new Noe.NoeComparator());
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        vecNewNoes.addAll(vecAmbgAsg);
        if (strResNameScheme.equalsIgnoreCase("PDB-NEW")) {
            vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromPDBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
        }
        if (strResNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromBMRBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
            Vector<Object> vecAsgNew = new Vector();
            H1CS h1cs = new H1CS();
            vecAsgNew = h1cs.CSNameConvertFromBMRBNewToPDBNew(assignVec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgNew);
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNewNoes);
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecAmbgAsg, vecNewNoesy, constant[0]);
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecAmbgAsgTemp);
        Vector<Noe> vecNoeRefine2 = new Vector<Noe>();
        i = 0;
        while (i < vecAmbgAsg.size()) {
            noe = (Noe)vecAmbgAsg.elementAt(i);
            int noA = noe.getResidueNoA();
            int noB = noe.getResidueNoB();
            String atomA = noe.getAtomA();
            String atomB = noe.getAtomB();
            if (noA != noB || !atomA.equalsIgnoreCase(atomB)) {
                boolean isIn = true;
                if (strOutOrFormat.equalsIgnoreCase("0")) {
                    j = 0;
                    while (j < vecNoeRefine2.size()) {
                        Noe noeT = (Noe)vecNoeRefine2.elementAt(j);
                        int noAT = noeT.getResidueNoA();
                        int noBT = noeT.getResidueNoB();
                        String atomAT = noeT.getAtomA();
                        String atomBT = noeT.getAtomB();
                        if (noA == noAT && atomA.equalsIgnoreCase(atomAT) && noB == noBT && atomB.equalsIgnoreCase(atomBT)) {
                            isIn = false;
                        }
                        if (noA == noBT && atomA.equalsIgnoreCase(atomBT) && noB == noAT && atomB.equalsIgnoreCase(atomAT)) {
                            isIn = false;
                        }
                        ++j;
                    }
                }
                if (isIn) {
                    vecNoeRefine2.add(noe);
                }
            }
            ++i;
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNoeRefine2);
        if (!strOutOrFormat.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecAmbgAsg.size()) {
                noe = (Noe)vecAmbgAsg.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String firstAtomName = noe.getAtomA();
                String secondAtomName = noe.getAtomB();
                if (secondResNo < firstResNo) {
                    noe.setResNoA(secondResNo);
                    noe.setResNoB(firstResNo);
                    noe.setAtom1Name(secondAtomName);
                    noe.setAtom2Name(firstAtomName);
                    noe.setResNameA(secondResName);
                    noe.setResNameB(firstResName);
                }
                ++i;
            }
            Collections.sort(vecAmbgAsg, new Noe.noeComparatorC());
        }
        String userDir = System.getProperty("user.dir");
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        Vector vecNoeAfterMetCor = new Vector();
        Noe ee2 = new Noe();
        vecNoeAfterMetCor = ee2.NoeMethylCorrection(vecAmbgAsg, 2.5);
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNoeAfterMetCor);
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(hnErr, nErr, c13Err, pdbVecNewSec, assignVec, rotSrc, vecNewNoesy, 4.5, 1, constant[0]);
        if (strIsWholeStr.equalsIgnoreCase("1")) {
            vecRotStructure = new Vector();
            vecRotStructure.addAll(vecStructureAll);
        }
        Vector<Object> vecRefinedNoes = new Vector();
        vecRefinedNoes = asg.PrunAmbgNoeAsg(vecRotStructure, vecAmbgAsg, noeLimit, 0.0, nIsoriginalUp);
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        if (strIsCheckLongAA.equalsIgnoreCase("1")) {
            Vector<Noe> vecTemp2 = new Vector<Noe>();
            i = 0;
            while (i < vecRefinedNoes.size()) {
                Noe noe2 = (Noe)vecRefinedNoes.elementAt(i);
                int firstResNo = noe2.getResidueNoA();
                int secondResNo = noe2.getResidueNoB();
                String firstResName = noe2.getResidueA();
                String secondResName = noe2.getResidueB();
                String atomA = noe2.getAtomA();
                String atomB = noe2.getAtomB();
                String subAtomA = atomA;
                String subAtomB = atomB;
                if (atomA.length() >= 2) {
                    subAtomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    subAtomB = atomB.substring(0, 2);
                }
                if (Math.abs(firstResNo - secondResNo) <= 4) {
                    vecTemp2.add(noe2);
                } else {
                    boolean isKeep = true;
                    if (pk.isCharged(firstResName) && pk.isHydrophobic(secondResName)) {
                        isKeep = false;
                    }
                    if (pk.isCharged(secondResName) && pk.isHydrophobic(firstResName)) {
                        isKeep = false;
                    }
                    if ((subAtomB.equalsIgnoreCase("HN") || subAtomB.equalsIgnoreCase("H") || subAtomB.equalsIgnoreCase("HA") || subAtomB.equalsIgnoreCase("HB")) && (subAtomA.equalsIgnoreCase("HN") || subAtomA.equalsIgnoreCase("H") || subAtomA.equalsIgnoreCase("HA") || subAtomA.equalsIgnoreCase("HB"))) {
                        isKeep = true;
                    }
                    if (isKeep) {
                        vecTemp2.add(noe2);
                    }
                }
                ++i;
            }
            vecRefinedNoes = new Vector();
            vecRefinedNoes.addAll(vecTemp2);
        }
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        Noe ne = new Noe();
        Vector<Noe> vecNoeNewT = ne.NameConvertFromPDBNewToPDBNew(vecRefinedNoes);
        vecRefinedNoes = new Vector();
        vecRefinedNoes.addAll(vecNoeNewT);
        vecNoeRefine2 = new Vector();
        Vector<Noe> vecNoeUniq = new Vector<Noe>();
        i = 0;
        while (i < vecRefinedNoes.size()) {
            Noe noe3 = (Noe)vecRefinedNoes.elementAt(i);
            int pkID = noe3.getPeakID();
            boolean isUniq = true;
            j = 0;
            while (j < vecRefinedNoes.size()) {
                Noe noeT;
                int pkIDT;
                if (i != j && pkID == (pkIDT = (noeT = (Noe)vecRefinedNoes.elementAt(j)).getPeakID())) {
                    isUniq = false;
                }
                ++j;
            }
            if (isUniq) {
                vecNoeUniq.add(noe3);
            }
            ++i;
        }
        double[] number = new double[4];
        if (strIsCheck.equalsIgnoreCase("1")) {
            Noe noe_temp = new Noe();
            String pdbFileXray = String.valueOf(src) + strRefPdb;
            Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
            Vector<Object> vecTempPdbBB2 = new Vector();
            if (strRefNameSchem.equalsIgnoreCase("PDB-OLD")) {
                vecTempPdbBB2 = pp.nameConvertOrder(vecTempPdbBB);
            } else if (strRefNameSchem.equalsIgnoreCase("BMRB-NEW")) {
                vecTempPdbBB2 = pp.nameConvert2PDBNew(vecTempPdbBB);
            } else {
                vecTempPdbBB2.addAll(vecTempPdbBB);
            }
            System.out.println("============================================ ");
            System.out.println("====Comparisons with reference structure===== ");
            noe_temp.CompareAsgToRefStr(vecRefinedNoes, vecTempPdbBB2, 6.0, 2.5, number);
            System.out.println("Number of correct assignments in reference structure=  " + number[0]);
            System.out.println("Number of wrong assignments in reference structure=  " + number[1]);
            System.out.println("Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
            System.out.println("Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
            System.out.println("============================================ ");
        }
        if (strOutOrFormat.equalsIgnoreCase("0")) {
            String fileName = String.valueOf(userDirTemp) + stroutName;
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of NOESY cross peaks is " + (vecNoesy.size() + vecNoesy4D.size()));
                out.println("!REMARK: Total number of NOEs is " + vecRefinedNoes.size());
                out.println("!REMARK: the number of unique NOE assignments is " + vecNoeUniq.size());
                out.println("!REMARK: the number of multiple NOE assignments is " + (vecRefinedNoes.size() - vecNoeUniq.size()));
                out.println("!REMARK: Number of correct assignments in reference structure=  " + number[0]);
                out.println("!REMARK: Number of wrong assignments in reference structure=  " + number[1]);
                out.println("!REMARK: Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
                out.println("!REMARK: Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
                out.println("");
                out.println("");
                i = 0;
                while (i < vecRefinedNoes.size()) {
                    Noe noe4 = (Noe)vecRefinedNoes.elementAt(i);
                    int resNo1 = noe4.getResidueNoA();
                    int resNo2 = noe4.getResidueNoB();
                    String res1 = noe4.getResidueA();
                    String res2 = noe4.getResidueB();
                    String atom1 = noe4.getAtomA();
                    String atom2 = noe4.getAtomB();
                    double distUpper = noe4.getUpper();
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    if (isDebug) {
                        System.out.println(xplorNoeStr);
                    }
                    out.println(xplorNoeStr);
                    ++i;
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        } else if (strOutOrFormat.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecRefinedNoes);
            String fileName = String.valueOf(strOut) + stroutName;
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Total time for NOE assignment:  " + totalTime + " minutes");
    }

    public void doCompareTwoNOETables(String src, String strOut, String strInput) {
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        String strSeq = "";
        String strNoeFormat = "";
        String strNOETable = "";
        String strRefNOETalbe = "";
        String strRefNoeFormat = "";
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("REFNOEFORMAT")) {
                strRefNoeFormat = paraMap.get("REFNOEFORMAT");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("REF-NOE-TABLE")) {
                strRefNOETalbe = paraMap.get("REF-NOE-TABLE");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader2(manualAsgFile, 0.0);
            vecManAsgNew.addAll(vecManAsg);
        }
        Vector vecRefManAsg = new Vector();
        Vector vecRefManAsgNew = new Vector();
        String manualRefAsgFile = String.valueOf(src) + strRefNOETalbe;
        if (strRefNoeFormat.equalsIgnoreCase("CYANA")) {
            vecRefManAsg = noe_temp.LongRangeNoeReader(manualRefAsgFile, 0.0, "PDB-NEW");
            vecRefManAsgNew.addAll(vecRefManAsg);
        } else {
            vecRefManAsg = noe_temp.noeReader2(manualRefAsgFile, 0.0);
            vecRefManAsgNew.addAll(vecManAsg);
        }
        double[] number = new double[4];
        System.out.println("============================================ ");
        System.out.println("============Comparisons with reference NOE assignment result================== ");
        noe_temp.CompareAsgToManualAsg(vecManAsgNew, vecRefManAsgNew, number);
        double numCorrect = number[0];
        double numWrong = number[1];
        System.out.println("Total number of reference NOEs = " + vecRefManAsgNew.size());
        System.out.println("Number of correct assignments=  " + numCorrect);
        System.out.println("Number of wrong assignments=  " + numWrong);
        System.out.println("Number of correct Long-Rang NOE assignments=  " + number[2]);
        System.out.println("Number of wrong Long-Rang NOE assignments=  " + number[3]);
        System.out.println("============================================ ");
    }

    public void doExtractNOEs(String src, String strOut, String strInput) {
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        double SSE1_first = 0.0;
        double SSE1_second = 0.0;
        double SSE2_first = 0.0;
        double SSE2_second = 0.0;
        int nIsoriginalUp = 0;
        String strSeq = "";
        String strNoeFormat = "";
        String strNOETable = "";
        String stroutName = "";
        String strIsLongRange = "";
        String strIsInMultiAsg = "";
        String strIsOutMultiAsg = "";
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("ISLONGRANGE")) {
                strIsLongRange = paraMap.get("ISLONGRANGE");
            }
            if (paraMap.containsKey("SSE1START")) {
                SSE1_first = Double.parseDouble(paraMap.get("SSE1START"));
            }
            if (paraMap.containsKey("SSE1END")) {
                SSE1_second = Double.parseDouble(paraMap.get("SSE1END"));
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("ISINMULTIASSIGNMENT")) {
                strIsInMultiAsg = paraMap.get("ISINMULTIASSIGNMENT");
            }
            if (paraMap.containsKey("ISOUTMULTIASGFORMAT")) {
                strIsOutMultiAsg = paraMap.get("ISOUTMULTIASGFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            if (strIsInMultiAsg.equalsIgnoreCase("1")) {
                vecManAsg = noe_temp.noeReaderMultiAsg(manualAsgFile, vecSeq);
                Vector vecTemp = noe_temp.ConvertMultiToSingleAsg(vecManAsg);
                vecManAsg = new Vector();
                vecManAsg.addAll(vecTemp);
            } else {
                vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0, vecSeq);
            }
            vecManAsgNew.addAll(vecManAsg);
        }
        int firstResNo = 0;
        int secondResNo = 0;
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        int i2 = 0;
        while (i2 < vecManAsgNew.size()) {
            boolean isIn = false;
            Noe noe = new Noe();
            noe = (Noe)vecManAsgNew.elementAt(i2);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first) {
                isIn = true;
            }
            if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first) {
                isIn = true;
            }
            if (strIsLongRange.equalsIgnoreCase("1") && Math.abs(firstResNo - secondResNo) <= 3) {
                isIn = false;
            }
            if (strIsLongRange.equalsIgnoreCase("2") && Math.abs(firstResNo - secondResNo) >= 4) {
                isIn = false;
            }
            if (isIn) {
                vecNewNoes.add(noe);
            }
            ++i2;
        }
        String fileName = String.valueOf(strOut) + stroutName;
        Peak pk = new Peak();
        if (strIsOutMultiAsg.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecNewNoes);
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        } else {
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of NOEs is " + vecNewNoes.size());
                out.println("");
                out.println("");
                int i3 = 0;
                while (i3 < vecNewNoes.size()) {
                    Noe noe = vecNewNoes.elementAt(i3);
                    int resNo1 = noe.getResidueNoA();
                    int resNo2 = noe.getResidueNoB();
                    String res1 = noe.getResidueA();
                    String res2 = noe.getResidueB();
                    String atom1 = noe.getAtomA();
                    String atom2 = noe.getAtomB();
                    double distUpper = noe.getUpper();
                    if (nIsoriginalUp == 0) {
                        distUpper = 6.0;
                    }
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    System.out.println(xplorNoeStr);
                    out.println(xplorNoeStr);
                    ++i3;
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for ExtractNOEs is:  " + totalTime + " minutes");
    }

    public void doLongNOEsAsgWOStructureNew(String src, String strOut, String strInput) {
        String atom2;
        String atom1;
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        double SSE1_first = 0.0;
        double SSE1_second = 0.0;
        int nIsoriginalUp = 0;
        String strSeq = "";
        String strNoeFormat = "";
        String strNOETable = "";
        String stroutName = "";
        String strIsFragement = "";
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("ISFRAGMENT")) {
                strIsFragement = paraMap.get("ISFRAGMENT");
            }
            if (paraMap.containsKey("SSE1START")) {
                SSE1_first = Double.parseDouble(paraMap.get("SSE1START"));
            }
            if (paraMap.containsKey("SSE1END")) {
                SSE1_second = Double.parseDouble(paraMap.get("SSE1END"));
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0, vecSeq);
            vecManAsgNew.addAll(vecManAsg);
        }
        int firstResNo = 0;
        int secondResNo = 0;
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        int i2 = 0;
        while (i2 < vecManAsgNew.size()) {
            boolean isIn = true;
            Noe noe = new Noe();
            noe = (Noe)vecManAsgNew.elementAt(i2);
            firstResNo = noe.getResidueNoA();
            if (Math.abs(firstResNo - (secondResNo = noe.getResidueNoB())) <= 3) {
                isIn = false;
            }
            if (isIn) {
                vecNewNoes.add(noe);
            }
            ++i2;
        }
        Vector<Noe> vecRefNoes = new Vector<Noe>();
        int i3 = 0;
        while (i3 < vecNewNoes.size()) {
            boolean isIn = true;
            boolean isInFragment = false;
            boolean isLegal = true;
            Noe noe = new Noe();
            noe = (Noe)vecNewNoes.elementAt(i3);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            String resA = noe.getResidueA();
            String resB = noe.getResidueB();
            atom1 = noe.getAtomA();
            atom2 = noe.getAtomB();
            double upper_dist = noe.getUpper();
            if (atom1.equalsIgnoreCase("H")) {
                atom1 = "HN";
            }
            if (atom2.equalsIgnoreCase("H")) {
                atom2 = "HN";
            }
            String atom1_new = "";
            String atom2_new = "";
            atom1_new = atom1.length() >= 2 ? atom1.substring(0, 2) : atom1;
            atom2_new = atom2.length() >= 2 ? atom2.substring(0, 2) : atom2;
            if ((atom1_new.equalsIgnoreCase("HN") || atom1_new.equalsIgnoreCase("HA") || atom1_new.equalsIgnoreCase("HB")) && (atom2_new.equalsIgnoreCase("HN") || atom2_new.equalsIgnoreCase("HA") || atom2_new.equalsIgnoreCase("HB")) && upper_dist < 3.5) {
                isIn = false;
            }
            if (strIsFragement.equalsIgnoreCase("1")) {
                if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first) {
                    isInFragment = true;
                }
                if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first) {
                    isInFragment = true;
                }
            } else {
                isInFragment = true;
            }
            boolean isHydrophobicA = false;
            boolean isHydrophobicB = false;
            Peak pk = new Peak();
            if (!atom1_new.equalsIgnoreCase("HN") && !atom1_new.equalsIgnoreCase("HA") && !atom1_new.equalsIgnoreCase("HB") && pk.isHydrophobic(resA)) {
                isHydrophobicA = true;
            }
            if (!atom2_new.equalsIgnoreCase("HN") && !atom2_new.equalsIgnoreCase("HA") && !atom2_new.equalsIgnoreCase("HB") && pk.isHydrophobic(resB)) {
                isHydrophobicB = true;
            }
            boolean isChargedA = false;
            boolean isChargedB = false;
            if (!atom1_new.equalsIgnoreCase("HN") && !atom1_new.equalsIgnoreCase("HA") && !atom1_new.equalsIgnoreCase("HB") && pk.isCharged(resA)) {
                isChargedA = true;
            }
            if (!atom2_new.equalsIgnoreCase("HN") && !atom2_new.equalsIgnoreCase("HA") && !atom2_new.equalsIgnoreCase("HB") && pk.isCharged(resB)) {
                isChargedB = true;
            }
            if (isHydrophobicA && isChargedB) {
                isLegal = false;
            }
            if (isChargedA && isHydrophobicB) {
                isLegal = false;
            }
            if (isIn && isInFragment && isLegal) {
                vecRefNoes.add(noe);
            }
            ++i3;
        }
        int ResNo1Ref = 0;
        int ResNo2Ref = 0;
        Vector<Noe> vecFinalNoes = new Vector<Noe>();
        int i4 = 0;
        while (i4 < vecRefNoes.size()) {
            boolean isSym = false;
            int counter = 0;
            Noe noe = new Noe();
            noe = (Noe)vecRefNoes.elementAt(i4);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            atom1 = noe.getAtomA();
            atom2 = noe.getAtomB();
            int j = 0;
            while (j < vecRefNoes.size()) {
                if (i4 != j) {
                    Noe noeRef = new Noe();
                    noeRef = (Noe)vecRefNoes.elementAt(j);
                    ResNo1Ref = noeRef.getResidueNoA();
                    ResNo2Ref = noeRef.getResidueNoB();
                    if (ResNo1Ref == secondResNo && ResNo2Ref == firstResNo) {
                        ++counter;
                    } else if (firstResNo == ResNo1Ref && secondResNo == ResNo2Ref) {
                        ++counter;
                    }
                }
                ++j;
            }
            if (counter >= 3) {
                vecFinalNoes.add(noe);
            }
            ++i4;
        }
        String fileName = String.valueOf(strOut) + stroutName;
        Peak pk = new Peak();
        String xplorNoeStr = "";
        double[] disUpper = new double[1];
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("!REMARK: Total number of NOEs is " + vecFinalNoes.size());
            out.println("");
            out.println("");
            int i5 = 0;
            while (i5 < vecFinalNoes.size()) {
                Noe noe = (Noe)vecFinalNoes.elementAt(i5);
                int resNo1 = noe.getResidueNoA();
                int resNo2 = noe.getResidueNoB();
                String res1 = noe.getResidueA();
                String res2 = noe.getResidueB();
                String atom12 = noe.getAtomA();
                String atom22 = noe.getAtomB();
                double distUpper = noe.getUpper();
                if (nIsoriginalUp == 0) {
                    distUpper = 6.0;
                }
                xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom12, resNo2, res2, atom22, distUpper);
                System.out.println(xplorNoeStr);
                out.println(xplorNoeStr);
                ++i5;
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void doLongNOEsAsgWOStructure(String src, String strOut, String strInput) {
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        double SSE1_first = 0.0;
        double SSE1_second = 0.0;
        int nIsoriginalUp = 0;
        String strSeq = "";
        String strNoeFormat = "";
        String strNOETable = "";
        String stroutName = "";
        String strIsFragement = "";
        String strSurfResidues = "";
        String strNotLoopResidues = "";
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("ISFRAGMENT")) {
                strIsFragement = paraMap.get("ISFRAGMENT");
            }
            if (paraMap.containsKey("SSE1START")) {
                SSE1_first = Double.parseDouble(paraMap.get("SSE1START"));
            }
            if (paraMap.containsKey("SSE1END")) {
                SSE1_second = Double.parseDouble(paraMap.get("SSE1END"));
            }
            if (paraMap.containsKey("SURFRESIDUES")) {
                strSurfResidues = paraMap.get("SURFRESIDUES");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("HYDROPHOBICLOOPRESIDUES")) {
                strNotLoopResidues = paraMap.get("HYDROPHOBICLOOPRESIDUES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0, vecSeq);
            vecManAsgNew.addAll(vecManAsg);
        }
        int firstResNo = 0;
        int secondResNo = 0;
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        int i2 = 0;
        while (i2 < vecManAsgNew.size()) {
            boolean isIn = true;
            Noe noe = new Noe();
            noe = (Noe)vecManAsgNew.elementAt(i2);
            firstResNo = noe.getResidueNoA();
            if (Math.abs(firstResNo - (secondResNo = noe.getResidueNoB())) <= 3) {
                isIn = false;
            }
            if (isIn) {
                vecNewNoes.add(noe);
            }
            ++i2;
        }
        Vector vecSurfResidues = asg.getOrder(strSurfResidues);
        Vector<Noe> vecRefNoes = new Vector<Noe>();
        int i3 = 0;
        while (i3 < vecNewNoes.size()) {
            int ResNo;
            String strSurResNo;
            int t;
            boolean isIn = true;
            boolean isInFragment = false;
            boolean isInSurface = false;
            Noe noe = new Noe();
            noe = (Noe)vecNewNoes.elementAt(i3);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            double upper_dist = noe.getUpper();
            if ((atom1.equalsIgnoreCase("HN") || atom1.equalsIgnoreCase("H") || atom1.equalsIgnoreCase("HA")) && (atom2.equalsIgnoreCase("HN") || atom2.equalsIgnoreCase("H") || atom2.equalsIgnoreCase("HA"))) {
                isIn = false;
            }
            if ((atom1.equalsIgnoreCase("HN") || atom1.equalsIgnoreCase("H") || atom1.equalsIgnoreCase("HA") || atom1.substring(0, 2).equalsIgnoreCase("HB")) && (atom2.equalsIgnoreCase("HN") || atom2.equalsIgnoreCase("H") || atom2.equalsIgnoreCase("HA") || atom2.substring(0, 2).equalsIgnoreCase("HB")) && upper_dist < 3.5) {
                isIn = false;
            }
            if (strIsFragement.equalsIgnoreCase("1")) {
                if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first) {
                    isInFragment = true;
                }
                if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first) {
                    isInFragment = true;
                }
            } else {
                isInFragment = true;
            }
            if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first) {
                if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first) {
                    isInSurface = true;
                }
                t = 0;
                while (t < vecSurfResidues.size()) {
                    strSurResNo = (String)vecSurfResidues.elementAt(t);
                    ResNo = Integer.parseInt(strSurResNo);
                    if (ResNo == secondResNo) {
                        isInSurface = true;
                        break;
                    }
                    ++t;
                }
            }
            if ((double)secondResNo <= SSE1_second && (double)secondResNo >= SSE1_first) {
                if ((double)firstResNo <= SSE1_second && (double)firstResNo >= SSE1_first) {
                    isInSurface = true;
                }
                t = 0;
                while (t < vecSurfResidues.size()) {
                    strSurResNo = (String)vecSurfResidues.elementAt(t);
                    ResNo = Integer.parseInt(strSurResNo);
                    if (ResNo == firstResNo) {
                        isInSurface = true;
                        break;
                    }
                    ++t;
                }
            }
            if (isIn && isInFragment && isInSurface) {
                vecRefNoes.add(noe);
            }
            ++i3;
        }
        Vector<Noe> vecFinalNoes = new Vector<Noe>();
        int ResNo1Ref = 0;
        int ResNo2Ref = 0;
        int i4 = 0;
        while (i4 < vecRefNoes.size()) {
            boolean isSym = false;
            double sc = 0.0;
            Noe noe = new Noe();
            noe = (Noe)vecRefNoes.elementAt(i4);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            int j = 0;
            while (j < vecRefNoes.size()) {
                Noe noeRef = new Noe();
                noeRef = (Noe)vecRefNoes.elementAt(j);
                ResNo1Ref = noeRef.getResidueNoA();
                ResNo2Ref = noeRef.getResidueNoB();
                if (ResNo1Ref == secondResNo && ResNo2Ref == firstResNo) {
                    isSym = true;
                    sc += 1.0;
                } else if (firstResNo == ResNo1Ref && secondResNo == ResNo2Ref) {
                    sc += 1.0;
                }
                ++j;
            }
            if (sc >= 1.0 && isSym) {
                vecFinalNoes.add(noe);
            }
            System.out.println("the score in " + i4 + "th NOE is: " + sc);
            ++i4;
        }
        Vector vecNotLoopResidues = asg.getOrder(strNotLoopResidues);
        Vector<Noe> vecFinalNew = new Vector<Noe>();
        int i5 = 0;
        while (i5 < vecFinalNoes.size()) {
            Noe noe = (Noe)vecFinalNoes.elementAt(i5);
            int resNo1 = noe.getResidueNoA();
            int resNo2 = noe.getResidueNoB();
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            boolean isInLoop = true;
            int t = 0;
            while (t < vecNotLoopResidues.size()) {
                String strSurResNo = (String)vecNotLoopResidues.elementAt(t);
                int ResNo = Integer.parseInt(strSurResNo);
                if (ResNo == resNo1) {
                    if (!(atom1.equalsIgnoreCase("HN") || atom1.equalsIgnoreCase("HA") || atom1.equalsIgnoreCase("HB1") || atom1.equalsIgnoreCase("HB2") || atom1.equalsIgnoreCase("HB3"))) {
                        isInLoop = false;
                        break;
                    }
                } else if (!(ResNo != resNo2 || atom2.equalsIgnoreCase("HN") || atom2.equalsIgnoreCase("HA") || atom2.equalsIgnoreCase("HB1") || atom2.equalsIgnoreCase("HB2") || atom2.equalsIgnoreCase("HB3"))) {
                    isInLoop = false;
                    break;
                }
                ++t;
            }
            if (isInLoop) {
                vecFinalNew.add(noe);
            }
            ++i5;
        }
        String fileName = String.valueOf(strOut) + stroutName;
        Peak pk = new Peak();
        String xplorNoeStr = "";
        double[] disUpper = new double[1];
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("!REMARK: Total number of NOEs is " + vecFinalNew.size());
            out.println("");
            out.println("");
            int i6 = 0;
            while (i6 < vecFinalNew.size()) {
                Noe noe = (Noe)vecFinalNew.elementAt(i6);
                int resNo1 = noe.getResidueNoA();
                int resNo2 = noe.getResidueNoB();
                String res1 = noe.getResidueA();
                String res2 = noe.getResidueB();
                String atom1 = noe.getAtomA();
                String atom2 = noe.getAtomB();
                double distUpper = noe.getUpper();
                if (nIsoriginalUp == 0) {
                    distUpper = 6.0;
                }
                xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                System.out.println(xplorNoeStr);
                out.println(xplorNoeStr);
                ++i6;
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void doRefineNOEsWBB(String src, String strOut, String strInput) {
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noe_upper = 6.0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strBB = "";
        String stroutName = "";
        String strNoeFormat = "";
        String strNOETable = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("NOE-UPPER")) {
                noe_upper = Double.parseDouble(paraMap.get("NOE-UPPER"));
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = pp.residueNameUpdate(vecSeq, pdbVecBB);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector<Noe> vecManAsgNew = new Vector<Noe>();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader2(manualAsgFile, 0.0);
            vecManAsgNew.addAll(vecManAsg);
        }
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, pdbVecNew, assignVec, rotSrc, vecNewNoesy, 6.0, 1, 0.0);
        Vector<Object> vecRefinedNoes = new Vector();
        vecRefinedNoes = asg.PrunAmbgNoeAsg(vecRotStructure, vecManAsgNew, noe_upper, 2.5, 0);
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        String fileName = String.valueOf(strOut) + stroutName;
        String xplorNoeStr = "";
        double[] disUpper = new double[1];
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("!REMARK: The number of original NOEs is " + vecManAsgNew.size());
            out.println("!REMARK: Total number of NOEs is " + vecRefinedNoes.size());
            out.println("");
            out.println("");
            i = 0;
            while (i < vecRefinedNoes.size()) {
                Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                int resNo1 = noe.getResidueNoA();
                int resNo2 = noe.getResidueNoB();
                String res1 = noe.getResidueA();
                String res2 = noe.getResidueB();
                String atom1 = noe.getAtomA();
                String atom2 = noe.getAtomB();
                double distUpper = noe.getUpper();
                xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                if (isDebug) {
                    System.out.println(xplorNoeStr);
                }
                out.println(xplorNoeStr);
                ++i;
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Total time for NOE assignment:  " + totalTime + " minutes");
    }

    public static class assignComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            Assign n1 = (Assign)o1;
            Assign n2 = (Assign)o2;
            int d1 = n1.getResidueNo();
            if (d1 < (d2 = n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class caComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Assign n1 = (Assign)o1;
            Assign n2 = (Assign)o2;
            Map map1 = n1.getMap();
            Map map2 = n2.getMap();
            double d1 = (Double)map1.get("CA");
            if (d1 < (d2 = ((Double)map2.get("CA")).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class haComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Assign n1 = (Assign)o1;
            Assign n2 = (Assign)o2;
            Map map1 = n1.getMap();
            Map map2 = n2.getMap();
            double d1 = (Double)map1.get("HA");
            if (d1 < (d2 = ((Double)map2.get("HA")).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class hnComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Assign n1 = (Assign)o1;
            Assign n2 = (Assign)o2;
            Map map1 = n1.getMap();
            Map map2 = n2.getMap();
            double d1 = (Double)map1.get("H");
            if (d1 < (d2 = ((Double)map2.get("H")).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

