/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/
package libprotnmr.protein.tools;

import java.util.Iterator;
import java.util.List;

import libprotnmr.geom.Vector3;
import libprotnmr.protein.AtomAddressInternal;
import libprotnmr.protein.HasAtoms;


public class AtomPositionIterator implements Iterator<Vector3>
{
	/**************************
	 *   Data Members
	 **************************/
	
	private HasAtoms m_protein;
	private Iterator<AtomAddressInternal> m_iter;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public AtomPositionIterator( HasAtoms protein )
	{
		this( protein, protein.atoms() );
	}
	
	public AtomPositionIterator( HasAtoms protein, List<AtomAddressInternal> addresses )
	{
		m_protein = protein;
		m_iter = addresses.iterator();
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public boolean hasNext( )
	{
		return m_iter.hasNext();
	}
	
	public Vector3 next( )
	{
		return m_protein.getAtom( m_iter.next() ).getPosition();
	}
	
	public void remove( )
	{
		m_iter.remove();
	}
}
