/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.util.LinkedList;
import mpi.Comm;
import mpi.Datatype;
import mpi.Errhandler;
import mpi.Freeable;
import mpi.Group;
import mpi.Intracomm;
import mpi.MPIException;
import mpi.Maxloc;
import mpi.Minloc;
import mpi.Op;
import mpi.Request;

public class MPI {
    static int MAX_PROCESSOR_NAME = 256;
    public static Intracomm COMM_WORLD;
    public static Comm COMM_SELF;
    public static int GRAPH;
    public static int CART;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op LAND;
    public static Op BAND;
    public static Op LOR;
    public static Op BOR;
    public static Op LXOR;
    public static Op BXOR;
    public static Op MINLOC;
    public static Op MAXLOC;
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype PACKED;
    public static Datatype LB;
    public static Datatype UB;
    public static Datatype OBJECT;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Request REQUEST_NULL;
    public static Group GROUP_EMPTY;
    public static int PROC_NULL;
    public static int BSEND_OVERHEAD;
    public static int UNDEFINED;
    public static int IDENT;
    public static int CONGRUENT;
    public static int SIMILAR;
    public static int UNEQUAL;
    public static int TAG_UB;
    public static int HOST;
    public static int IO;
    static Errhandler ERRORS_ARE_FATAL;
    static Errhandler ERRORS_RETURN;
    private static byte[] buffer;
    static LinkedList freeList;

    private static native void saveSignalHandlers();

    private static native void restoreSignalHandlers();

    public static String[] Init(String[] stringArray) throws MPIException {
        String[] stringArray2 = MPI.InitNative(stringArray);
        MPI.restoreSignalHandlers();
        BYTE.setBasic(1);
        CHAR.setBasic(2);
        SHORT.setBasic(3);
        BOOLEAN.setBasic(4);
        INT.setBasic(5);
        LONG.setBasic(6);
        FLOAT.setBasic(7);
        DOUBLE.setBasic(8);
        PACKED.setBasic(9);
        LB.setBasic(10);
        UB.setBasic(11);
        OBJECT.setBasic(12);
        SHORT2.setContiguous(2, SHORT);
        INT2.setContiguous(2, INT);
        LONG2.setContiguous(2, LONG);
        FLOAT2.setContiguous(2, FLOAT);
        DOUBLE2.setContiguous(2, DOUBLE);
        SHORT2.Commit();
        INT2.Commit();
        LONG2.Commit();
        FLOAT2.Commit();
        DOUBLE2.Commit();
        COMM_WORLD.setType(2);
        return stringArray2;
    }

    private static native String[] InitNative(String[] var0);

    private static native void SetConstant();

    public static native void Finalize() throws MPIException;

    public static native double Wtime();

    public static native double Wtick();

    public static String Get_processor_name() throws MPIException {
        byte[] byArray = new byte[MAX_PROCESSOR_NAME];
        int n = MPI.Get_processor_name(byArray);
        return new String(byArray, 0, n);
    }

    private static native int Get_processor_name(byte[] var0);

    public static native boolean Initialized() throws MPIException;

    public static void Buffer_attach(byte[] byArray) throws MPIException {
        buffer = byArray;
        MPI.Buffer_attach_native(byArray);
    }

    private static native void Buffer_attach_native(byte[] var0);

    public static byte[] Buffer_detach() throws MPIException {
        MPI.Buffer_detach_native(buffer);
        byte[] byArray = buffer;
        buffer = null;
        return byArray;
    }

    private static native void Buffer_detach_native(byte[] var0);

    static synchronized void clearFreeList() {
        while (!freeList.isEmpty()) {
            ((Freeable)freeList.removeFirst()).free();
        }
    }

    static {
        System.loadLibrary("savesignals");
        MPI.saveSignalHandlers();
        System.loadLibrary("mpijava");
        MPI.restoreSignalHandlers();
        try {
            BYTE = new Datatype();
            CHAR = new Datatype();
            SHORT = new Datatype();
            BOOLEAN = new Datatype();
            INT = new Datatype();
            LONG = new Datatype();
            FLOAT = new Datatype();
            DOUBLE = new Datatype();
            PACKED = new Datatype();
            LB = new Datatype();
            UB = new Datatype();
            OBJECT = new Datatype();
            SHORT2 = new Datatype();
            INT2 = new Datatype();
            LONG2 = new Datatype();
            FLOAT2 = new Datatype();
            DOUBLE2 = new Datatype();
            MAX = new Op(1);
            MIN = new Op(2);
            SUM = new Op(3);
            PROD = new Op(4);
            LAND = new Op(5);
            BAND = new Op(6);
            LOR = new Op(7);
            BOR = new Op(8);
            LXOR = new Op(9);
            BXOR = new Op(10);
            MINLOC = new Op(new Minloc(), true);
            MAXLOC = new Op(new Maxloc(), true);
            GROUP_EMPTY = new Group(0);
            REQUEST_NULL = new Request(0);
            MPI.SetConstant();
            ERRORS_ARE_FATAL = new Errhandler(1);
            ERRORS_RETURN = new Errhandler(0);
            COMM_WORLD = new Intracomm();
        }
        catch (MPIException mPIException) {
            System.out.println(mPIException.getMessage());
            System.exit(1);
        }
        buffer = null;
        freeList = new LinkedList();
    }
}

