/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.nmr;

import java.util.HashSet;
import java.util.Set;

import edu.duke.donaldLab.share.io.HashCalculator;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;

public class MappedChemicalShift
{
	/**************************
	 *   Data Members
	 **************************/
	
	private Set<AtomAddressInternal> m_addresses;
	private double m_value;
	private double m_error;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public MappedChemicalShift( )
	{
		m_addresses = new HashSet<AtomAddressInternal>();
		m_value = Double.NaN;
		m_error = Double.NaN;
	}
	
	public MappedChemicalShift( MappedChemicalShift other )
	{
		m_addresses = new HashSet<AtomAddressInternal>( other.m_addresses.size() );
		for( AtomAddressInternal address : other.m_addresses )
		{
			m_addresses.add( new AtomAddressInternal( address ) );
		}
		m_value = other.m_value;
		m_error = other.m_error;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public Set<AtomAddressInternal> getAddresses( )
	{
		return m_addresses;
	}
	public void setAddresses( Set<AtomAddressInternal> val )
	{
		m_addresses = val;
	}
	
	public double getValue( )
	{
		return m_value;
	}
	public void setValue( double val )
	{
		m_value = val;
	}
	
	public double getError( )
	{
		return m_error;
	}
	public void setError( double val )
	{
		m_error = val;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	@Override
	public String toString( )
	{
		StringBuffer buf = new StringBuffer();
		
		buf.append( "[MappedChemicalShift] " );
		buf.append( m_value );
		buf.append( "," );
		buf.append( m_error );
		buf.append( "\t(" );
		
		boolean renderComma = false;
		for( AtomAddressInternal address : m_addresses )
		{
			if( renderComma )
			{
				buf.append( "," );
			}
			buf.append( address );
			renderComma = true;
		}
		buf.append( ")" );
		
		return buf.toString();
	}
	
	@Override
	public boolean equals( Object other )
	{
		if( other == null )
		{
            return false;
		}
        if( other == this )
        {
            return true;
        }
        if( other.getClass() != getClass() )
        {
            return false;
        }
        
        return equals( (MappedChemicalShift)other );
	}
	
	public boolean equals( MappedChemicalShift other )
	{
		return
			m_value == other.m_value
			&& m_error == other.m_error;
	}
	
	@Override
	public int hashCode( )
	{
		return HashCalculator.combineHashes(
			Double.valueOf( m_value ).hashCode(),
			Double.valueOf( m_error ).hashCode()
		);
	}
}
