/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.math;

public class Distribution
{
	/**************************
	 *   Data Members
	 **************************/
	
	private String m_name;
	private double m_min;
	private double m_max;
	private double m_sum;
	private long m_count;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public Distribution( )
	{
		this( "Distribution" );
	}
	
	public Distribution( String name )
	{
		m_name = name;
		reset();
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public double getMin( )
	{
		return m_min;
	}
	
	public double getMax( )
	{
		return m_max;
	}
	
	public double getSum( )
	{
		return m_sum;
	}
	
	public long getCount( )
	{
		return m_count;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public String toString( )
	{
		StringBuffer buf = new StringBuffer();
		buf.append( "[Distribution] " );
		buf.append( m_name );
		buf.append( "\n\tcount: " );
		buf.append( m_count );
		buf.append( "\n\tmin:   " );
		buf.append( m_min );
		buf.append( "\n\tmax:   " );
		buf.append( m_max );
		buf.append( "\n\tmean:  " );
		buf.append( getMean() );
		return buf.toString();
	}
	
	public void reset( )
	{
		m_min = Double.POSITIVE_INFINITY;
		m_max = Double.NEGATIVE_INFINITY;
		m_sum = 0.0;
		m_count = 0;
	}
	
	public void add( double value )
	{
		m_sum += value;
		m_count++;
		
		if( value < m_min )
		{
			m_min = value;
		}
		if( value > m_max )
		{
			m_max = value;
		}
	}
	
	public double getMean( )
	{
		return m_sum / (double)m_count;
	}
}
