/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.kinemage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.apache.log4j.Logger;

import edu.duke.donaldLab.share.io.Logging;

public class KinemageWriter
{
	/**************************
	 *   Data Members
	 **************************/
	
	private static final Logger m_log = Logging.getLog( KinemageWriter.class );
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public void showAndWait( Kinemage kinemage )
	{
		File file = null;
		try
		{
			// write the kinemage to a temp file
			file = File.createTempFile( "KinemageWriter.", ".kin" );
			write( kinemage, file );
			
			// launch King and wait
			Process process = Runtime.getRuntime().exec( "king " + file.getAbsolutePath() );
			process.waitFor();
		}
		catch( InterruptedException ex )
		{
			ex.printStackTrace( System.err );
		}
		catch( IOException ex )
		{
			ex.printStackTrace( System.err );
		}
		finally
		{
			// cleanup
			if( file != null && file.exists() )
			{
				file.delete();
			}
		}
	}

	public void write( Kinemage kinemage, String path )
	throws IOException
	{
		write( kinemage, new File( path ) );
	}
	
	public void write( Kinemage kinemage, File file )
	throws IOException
	{
		// open the file for writing
		BufferedWriter writer = new BufferedWriter( new FileWriter( file ) );
		
		// write out the document
		writeNode( writer, kinemage.getRoot() );
		
		// cleanup
		writer.close();
		writer = null;
		
		m_log.info( "Wrote kinemage to:\n\t" + file.getAbsolutePath() );
	}
	
	private void writeNode( BufferedWriter writer, Node node )
	throws IOException
	{
		// write this node
		writer.write( node.getText() );
		writer.write( "\n" );
		
		// recurse
		for( Node child : node.getChildren() )
		{
			writeNode( writer, child );
		}
	}
}
