/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.search;

import java.util.ArrayList;

import edu.duke.donaldLab.jdshot.TestMain;
import edu.duke.donaldLab.jdshot.search.SearchContext;
import edu.duke.donaldLab.jdshot.search.SubunitType;
import edu.duke.donaldLab.jdshot.test.ExtendedTestCase;
import edu.duke.donaldLab.share.nmr.DistanceRestraint;
import edu.duke.donaldLab.share.nmr.Assignment;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;

public class TestSearchContext extends ExtendedTestCase
{
	public void testMonomer( )
	{
		SearchContext searchContext = TestMain.getSearchContext();
		
		// just make sure we have a monomer with subunits and atoms, etc.
		assertNotNull( searchContext.getMonomer() );
		assertGte( 1, searchContext.getMonomer().getAtomIndex().size() );
	}
	
	public void testRestraints( )
	{
		SearchContext searchContext = TestMain.getSearchContext();
		ArrayList<DistanceRestraint<AtomAddressInternal>> restraints = searchContext.getRestraints();
		
		// make sure we have a reasonable number of restraints
		int numAtoms = searchContext.getMonomer().getAtomIndex().size();
		assertInRange( 1, numAtoms * numAtoms, restraints.size() );
		
		// make sure each restraint has the main subunit on the left
		for( DistanceRestraint<AtomAddressInternal> restraint : restraints )
		{			
			// for each assignment...
			for( Assignment<AtomAddressInternal> assignment : restraint )
			{
				// shortcuts
				int mainId = searchContext.getSubunitId( SubunitType.Main );
				int leftId = assignment.getLeft().getSubunitId();
				int rightId = assignment.getRight().getSubunitId();
				
				assertEquals( mainId, leftId );
				assertTrue( mainId != rightId );
			}
		}
	}
	
	// UNDONE: write a test to make sure no NOEs were incorrectly missed during mapping
}
