/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.grid;

import edu.duke.donaldLab.jdshot.grid.dn.DnGridPoint;
import edu.duke.donaldLab.jdshot.test.ExtendedTestCase;

public class TestDnGridPoint extends ExtendedTestCase
{
	public void testAssignemntConstructor( )
	{
		DnGridPoint p = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		assertEquals( 1.0, p.x );
		assertEquals( 2.0, p.y );
		assertEquals( 3.0, p.z );
		assertEquals( 4.0, p.phi );
		assertEquals( 5.0, p.theta );
		assertEquals( 6.0, p.rho );
	}
	
	public void testCopyConstructor( )
	{
		DnGridPoint p = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		DnGridPoint q = new DnGridPoint( p );
		assertEquals( 1.0, q.x );
		assertEquals( 2.0, q.y );
		assertEquals( 3.0, q.z );
		assertEquals( 4.0, q.phi );
		assertEquals( 5.0, q.theta );
		assertEquals( 6.0, q.rho );
	}
	
	public void testGet( )
	{
		DnGridPoint p = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		assertEquals( 1.0, p.get( 0 ) );
		assertEquals( 2.0, p.get( 1 ) );
		assertEquals( 3.0, p.get( 2 ) );
		assertEquals( 4.0, p.get( 3 ) );
		assertEquals( 5.0, p.get( 4 ) );
		assertEquals( 6.0, p.get( 5 ) );
	}
	
	public void testSet( )
	{
		DnGridPoint p = new DnGridPoint();
		
		p.set( 0, 1 );
		p.set( 1, 2 );
		p.set( 2, 3 );
		p.set( 3, 4 );
		p.set( 4, 5 );
		p.set( 5, 6 );
		
		assertEquals( 1.0, p.get( 0 ) );
		assertEquals( 2.0, p.get( 1 ) );
		assertEquals( 3.0, p.get( 2 ) );
		assertEquals( 4.0, p.get( 3 ) );
		assertEquals( 5.0, p.get( 4 ) );
		assertEquals( 6.0, p.get( 5 ) );
	}
	
	public void testAdd( )
	{
		DnGridPoint p = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		DnGridPoint q = new DnGridPoint( 10, 11, 12, 13, 14, 15 );
		
		p.add( q );
		
		assertEquals( 11.0, p.x );
		assertEquals( 13.0, p.y );
		assertEquals( 15.0, p.z );
		assertEquals( 17.0, p.phi );
		assertEquals( 19.0, p.theta );
		assertEquals( 21.0, p.rho );
	}
	
	public void testSubtract( )
	{
		DnGridPoint p = new DnGridPoint( 15, 14, 13, 12, 11, 10 );
		DnGridPoint q = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		
		p.subtract( q );
		
		assertEquals( 14.0, p.x );
		assertEquals( 12.0, p.y );
		assertEquals( 10.0, p.z );
		assertEquals( 8.0, p.phi );
		assertEquals( 6.0, p.theta );
		assertEquals( 4.0, p.rho );
	}
	
	public void testScale( )
	{
		DnGridPoint p = new DnGridPoint( 1, 2, 3, 4, 5, 6 );
		
		p.scale( 2.0 );
		
		assertEquals( 2.0, p.x );
		assertEquals( 4.0, p.y );
		assertEquals( 6.0, p.z );
		assertEquals( 8.0, p.phi );
		assertEquals( 10.0, p.theta );
		assertEquals( 12.0, p.rho );		
	}
}
