/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.grid;

import edu.duke.donaldLab.jdshot.grid.dn.DnGridCell;
import edu.duke.donaldLab.jdshot.grid.dn.DnGridPoint;
import edu.duke.donaldLab.jdshot.test.ExtendedTestCase;
import edu.duke.donaldLab.share.geom.Vector3;
import edu.duke.donaldLab.share.math.CompareReal;

public class TestDnGridCell extends ExtendedTestCase
{
	public void testAssignmentConstructor( )
	{
		DnGridCell c = new DnGridCell(
			new DnGridPoint( 1, 2, 3, 4, 5, 6 ),
			new DnGridPoint( 2, 3, 4, 5, 6, 7 )
		);
		
		assertEquals( 1.0, c.min.x );
		assertEquals( 2.0, c.max.x );
	}
	
	public void testCopyConstructor( )
	{
		DnGridCell c = new DnGridCell(
			new DnGridPoint( 1, 2, 3, 4, 5, 6 ),
			new DnGridPoint( 2, 3, 4, 5, 6, 7 )
		);
		DnGridCell d = new DnGridCell( c );
		
		assertEquals( 1.0, d.min.x );
		assertEquals( 2.0, d.max.x );
		
		// check object references
		assertNotSame( c.min, d.min );
		assertNotSame( c.max, d.max );
	}
	
	public void testCenter( )
	{
		DnGridCell c = new DnGridCell(
			new DnGridPoint( 1, 2, 3, 4, 5, 6 ),
			new DnGridPoint( 2, 3, 4, 5, 6, 7 )
		);
		
		assertEquals( new DnGridPoint( 1.5, 2.5, 3.5, 4.5, 5.5, 6.5 ), c.getCenter() );
	}
	
	public void testVolume( )
	{
		DnGridCell c = new DnGridCell(
			new DnGridPoint( 1, 2, 3, Math.PI / 2.0, Math.PI / 2.0, Math.PI / 2.0 ),
			new DnGridPoint( 12, 11, 10, Math.PI, Math.PI, Math.PI )
		);
		
		double expected =
			( 12 - 1 ) * ( 11 - 2 ) * ( 10 - 3 )
			* Math.PI / 2.0
			* Math.PI / 2.0;
		assertEquals( expected, c.getVolume(), CompareReal.getEpsilon() );
	}
		
	public void testSplit( )
	{
		DnGridCell start = null;
		DnGridCell left = new DnGridCell();
		DnGridCell right = new DnGridCell();
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 2, 1, 1, 1, 1, 1 ) );
		start.split( left, right, 0 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 1, 0, 0, 0, 0, 0 ), new DnGridPoint( 2, 1, 1, 1, 1, 1 ) ), right );

		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 2, 1, 1, 1, 1 ) );
		start.split( left, right, 1 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 1, 0, 0, 0, 0 ), new DnGridPoint( 1, 2, 1, 1, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 2, 1, 1, 1 ) );
		start.split( left, right, 2 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 1, 0, 0, 0 ), new DnGridPoint( 1, 1, 2, 1, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 2, 1, 1 ) );
		start.split( left, right, 3 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 1, 0, 0 ), new DnGridPoint( 1, 1, 1, 2, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 2, 1 ) );
		start.split( left, right, 4 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 0, 1, 0 ), new DnGridPoint( 1, 1, 1, 1, 2, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 2 ) );
		start.split( left, right, 5 );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 0, 0, 1 ), new DnGridPoint( 1, 1, 1, 1, 1, 2 ) ), right );
	}
	
	public void testGetACorner( )
	{
		DnGridCell cell = new DnGridCell(
			new DnGridPoint( 0.0, 0.0, 0.0, 3.0, 5.0, 7.0 ),
			new DnGridPoint( 0.0, 0.0, 0.0, 4.0, 6.0, 8.0 )
		);
		
		Vector3 c = new Vector3();
		
		cell.getACorner( c, 0 );
		assertEquals( new Vector3( 3, 5, 7 ), c );
		cell.getACorner( c, 1 );
		assertEquals( new Vector3( 3, 5, 8 ), c );
		cell.getACorner( c, 2 );
		assertEquals( new Vector3( 3, 6, 7 ), c );
		cell.getACorner( c, 3 );
		assertEquals( new Vector3( 3, 6, 8 ), c );
		cell.getACorner( c, 4 );
		assertEquals( new Vector3( 4, 5, 7 ), c );
		cell.getACorner( c, 5 );
		assertEquals( new Vector3( 4, 5, 8 ), c );
		cell.getACorner( c, 6 );
		assertEquals( new Vector3( 4, 6, 7 ), c );
		cell.getACorner( c, 7 );
		assertEquals( new Vector3( 4, 6, 8 ), c );
	}
	
	public void testGetTCorner( )
	{
		DnGridCell cell = new DnGridCell(
			new DnGridPoint( 3.0, 5.0, 7.0, 0.0, 0.0, 0.0 ),
			new DnGridPoint( 4.0, 6.0, 8.0, 0.0, 0.0, 0.0 )
		);
		
		Vector3 c = new Vector3();
		
		cell.getTCorner( c, 0 );
		assertEquals( new Vector3( 3, 5, 7 ), c );
		cell.getTCorner( c, 1 );
		assertEquals( new Vector3( 3, 5, 8 ), c );
		cell.getTCorner( c, 2 );
		assertEquals( new Vector3( 3, 6, 7 ), c );
		cell.getTCorner( c, 3 );
		assertEquals( new Vector3( 3, 6, 8 ), c );
		cell.getTCorner( c, 4 );
		assertEquals( new Vector3( 4, 5, 7 ), c );
		cell.getTCorner( c, 5 );
		assertEquals( new Vector3( 4, 5, 8 ), c );
		cell.getTCorner( c, 6 );
		assertEquals( new Vector3( 4, 6, 7 ), c );
		cell.getTCorner( c, 7 );
		assertEquals( new Vector3( 4, 6, 8 ), c );
	}
}
