/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.grid;

import edu.duke.donaldLab.jdshot.TestMain;
import edu.duke.donaldLab.jdshot.grid.Symmetry;
import edu.duke.donaldLab.jdshot.grid.dn.DnCellSplitter;
import edu.duke.donaldLab.jdshot.grid.dn.DnGridCell;
import edu.duke.donaldLab.jdshot.grid.dn.DnGridPoint;
import edu.duke.donaldLab.jdshot.test.ExtendedTestCase;

public class TestDnCellSplitter extends ExtendedTestCase
{
	// UNDONE: test split deltas
	
	public void testSplitSubspace( )
	{
		// just in case...
		assert( TestMain.getSearchContext().getSymmetry() == Symmetry.Dn );
		
		DnGridCell start = null;
		DnGridCell left = new DnGridCell();
		DnGridCell right = new DnGridCell();
		DnCellSplitter splitter = new DnCellSplitter( TestMain.getSearchContext().getSearchSpace() );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 2, 1, 1, 1, 1, 1 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Translations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 1, 0, 0, 0, 0, 0 ), new DnGridPoint( 2, 1, 1, 1, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 2, 1, 1, 1, 1 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Translations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 1, 0, 0, 0, 0 ), new DnGridPoint( 1, 2, 1, 1, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 2, 1, 1, 1 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Translations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 1, 0, 0, 0 ), new DnGridPoint( 1, 1, 2, 1, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 2, 1, 1 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Rotations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 1, 0, 0 ), new DnGridPoint( 1, 1, 1, 2, 1, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 2, 1 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Rotations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 0, 1, 0 ), new DnGridPoint( 1, 1, 1, 1, 2, 1 ) ), right );
		
		start = new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 2 ) );
		splitter.splitSubspace( left, right, start, DnCellSplitter.Subspace.Rotations );
		assertEquals( new DnGridCell( new DnGridPoint(), new DnGridPoint( 1, 1, 1, 1, 1, 1 ) ), left );
		assertEquals( new DnGridCell( new DnGridPoint( 0, 0, 0, 0, 0, 1 ), new DnGridPoint( 1, 1, 1, 1, 1, 2 ) ), right );
	}
}
