/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.grid.dn;

import java.io.File;
import java.util.Iterator;

import edu.duke.donaldLab.jdshot.grid.PointIterator;
import edu.duke.donaldLab.jdshot.grid.PointReader;
import edu.duke.donaldLab.jdshot.grid.Symmetry;

public class DnPointIterator implements Iterator<DnGridPoint>
{
	/**************************
	 *   Data Members
	 **************************/
	
	private PointIterator m_iter;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public DnPointIterator( PointIterator iter )
	{
		m_iter = iter;
	}
	
	public DnPointIterator( PointReader reader )
	{
		m_iter = new PointIterator( reader );
	}
	
	
	/**************************
	 *   Static Methods
	 **************************/
	
	public static DnPointIterator newFromPath( String inPath )
	throws Exception
	{
		return newFromPath( new File( inPath ) );
	}
	
	public static DnPointIterator newFromPath( File inFile )
	throws Exception
	{
		return new DnPointIterator( PointIterator.newFromPath( inFile, Symmetry.Dn ) );
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	@Override
	public boolean hasNext( )
	{
		return m_iter.hasNext();
	}

	@Override
	public DnGridPoint next( )
	{
		// let's hope this is a safe cast
		return (DnGridPoint)m_iter.next();
	}
	
	@Override
	public void remove( )
	{
		m_iter.remove();
	}
	
	public int getNumServed( )
	{
		return m_iter.getNumServed();
	}
	
	public long getNumPoints( )
	{
		return m_iter.getNumPoints();
	}
}
