/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.grid.cn;

import java.util.ArrayList;

import edu.duke.donaldLab.jdshot.grid.SearchSpace;

public class CnSearchSpace implements SearchSpace
{
	/**************************
	 *   Data Members
	 **************************/
	
	private double m_monomerRadius;
	private double m_maxDistance;
	private int m_numSubunits;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public CnSearchSpace( double monomerRadius, double maxDistance, int numSubunits )
	{
		m_monomerRadius = monomerRadius;
		m_maxDistance = maxDistance;
		m_numSubunits = numSubunits;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	@Override
	public CnGridCell getConfigurationSpace( )
	{
		// create a cell representing the entire search space
		double tBound = m_monomerRadius + 0.5 * m_maxDistance;
		
		// for c_2 dimers, we can use a smaller search space
		if( m_numSubunits == 2 )
		{
			return new CnGridCell(
				new CnGridPoint( -tBound, -tBound, 0.0, 0.0 ),
				new CnGridPoint( tBound, tBound, 2.0 * Math.PI, Math.PI / 2.0 )
			);
		}
		
		return new CnGridCell(
			new CnGridPoint( -tBound, -tBound, 0.0, 0.0 ),
			new CnGridPoint( tBound, tBound, 2.0 * Math.PI, Math.PI )
		);
	}
	
	@Override
	public ArrayList<CnGridCell> getInitialCells( )
	{
		CnGridCell configurationSpace = getConfigurationSpace();
		
		// but split it up into smaller cells that satisfy our constraint:
		// phi1 - phi0 <= PI
		ArrayList<CnGridCell> cells = new ArrayList<CnGridCell>( 2 ); // this will always be 2 because we're using S^2
		
		CnGridCell cell = new CnGridCell( configurationSpace );
		cell.max.phi = Math.PI;
		cells.add( cell );
		
		cell = new CnGridCell( configurationSpace );
		cell.min.phi = Math.PI;
		cells.add( cell );
		
		return cells;
	}
}
