#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import share
import jdshot
import jpype

jdshot.getJvm().start()

SubunitOrder = share.f.protein.SubunitOrder


def visualizeReference( pathOutKinemage, pathInOligomer, pathInNoes ):
	
	oligomer = share.loadProtein( pathInOligomer )
	noesContext = jdshot.f.context.NoesContext( oligomer, pathInNoes )
	
	# filter down to one restraint: A:70:CA
	selectedAddress = share.f.protein.ReadableAtomAddress( 'A', 70, "CA" )
	restraints = noesContext.getRestraints()
	oneRestraint = None
	for restraint in restraints:
		
		# for each assignment (sadly, jpype cannot iterate over Java Iterables)
		iter = share.f.nmr.AssignmentIterator( restraint );
		while iter.hasNext():
			assignment = iter.next()
			isLeft = share.f.mapping.AddressMapper.mapAddress( oligomer, assignment.getLeft() ).equals( selectedAddress )
			isRight = share.f.mapping.AddressMapper.mapAddress( oligomer, assignment.getRight() ).equals( selectedAddress )
			if isLeft or isRight:
				oneRestraint = restraint
				break
			
	if oneRestraint is None:
		print "Error finding restraint with atom: " + selectedAddress.toString()
		return
	
	restraints.clear()
	restraints.add( oneRestraint )
	print share.f.nmr.DistanceRestraintMapper.mapDistanceRestraint( oneRestraint, oligomer ).toAssignString()
	
	# build a kinemage
	#share.saveStructureKinemage( pathOutKinemage, oligomer, restraints )
	#share.runKing( pathOutKinemage )


dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results"
dirInput = "/home/jeff/duke/donaldLab/dshot/input"

# DAGK
dirResultsDagk = dirResults + "/DAGK"
visualizeReference(
	dirResultsDagk + "/visualization.kin",
	dirInput + "/2KDC.oligomer.protein",
	dirInput + "/2KDC.experimental.onlyDisulfideBonds.noe"
)
