#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import jvm, share, jpype

share.getJvm().start()

Protein = share.f.protein.Protein
Subunit = share.f.protein.Subunit
Residue = share.f.protein.Residue

def run( pathOutEnsemble, pathInEnsemble, minResidueNumber, maxResidueNumber ):

    # read inputs
    ensemble = share.loadProteins( pathInEnsemble )
    reference = ensemble.get( 0 )
    
    # splice out the residues we want
    newProteins = []
    for protein in ensemble:
        newProtein = Protein()
        for subunit in protein.getSubunits():
            newSubunit = Subunit()
            newProtein.getSubunits().add( newSubunit )
            for residue in subunit.getResidues():
                if residue.getNumber() >= minResidueNumber and residue.getNumber() <= maxResidueNumber:
                    newSubunit.getResidues().add( Residue( residue ) )
            newSubunit.updateAtomIndices()
        newProteins.append( newProtein )
    
    # write out the new ensemble
    share.writeProteins( jvm.newFile( pathOutEnsemble ), jvm.toArrayList( newProteins ) )

try:
    
    dirResults = "/home/jeff/duke/donaldLab/mper/results"
    dirInput = "/home/jeff/duke/donaldLab/mper/data"
    
    # MPER
    run(
        #dirResults + "/ensembleCns.pdb",
        dirResults + "/ensembleCyana.pdb",
        dirInput + "/cyana-09272010.pdb",
        #dirInput + "/cns-10262010.pdb",
        38, #38,
        46 #59
    )

except jpype.JavaException as ex:
    import sys
    print >> sys.stderr, "Java Exception: %s\n" % ex
    print >> sys.stderr, ex.stacktrace()
    raise
