#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import sys
sys.path.insert( 1, "lib" )
import disco


###########################
# Input Parameters
###########################

# folder in which to write generated output files
outputFolder = "output/proteinScienceDagk"

# path to the PDB file describing the subunit structure ensemble
pathInSubunitEnsemble = "input/2KDC.subunitEnsemble.pdb"

# number of subunits in the oligomeric state
numSubunits = 3

# path to the MR file describing the RDCs
#-- this file must only contain RDCs
pathInRdcs = "input/2KDC.rdcs.mr"

# path to the MR file describing the distance restraints
#-- this file must only contain distance restraints
pathInDistanceRestraints = "input/2KDC.disulfideBonds.mr"

# resolution (in degrees) of search grid for symmetry axis orientation
#-- smaller resolutions can evaluate more orientations, which can take much longer
#-- a value of 0 disables the local orientation search
orientationSamplingResolution = 1.0

# resolution (in Angstroms) of search grid for symmetry axis position
#-- smaller resolutions can result in a greater number of more similar oligomer structures
positionSamplingResolution = 0.75

# number of threads/processes to be used for parallel computations
#-- Structure minimization and MSR calculation can be computationally-expensive.
#-- Compute time can be reduced by using multiple threads or processes to take advantage of parallel hardware.
#-- For best performance, the number of threads should equal the number of CPU cores (or slightly fewer)
numProcesses = 2


###########################
# run DISCO
###########################

import jpype
try:
	disco.run(
		outputFolder,
		pathInSubunitEnsemble,
		numSubunits,
		pathInRdcs,
		pathInDistanceRestraints,
		orientationSamplingResolution,
		positionSamplingResolution,
		numMinimizationProcesses = numProcesses,
		numMsrsProcesses = numProcesses
	)

except jpype.JavaException as ex:
	import sys
	print >> sys.stderr, "Java Exception: %s\n" % ex
	print >> sys.stderr, ex.stacktrace()
	raise
