#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import share
import jdshot
import jpype

jdshot.getJvm().start()

SubunitOrder = share.f.protein.SubunitOrder


def run( pathKinemage, pathMonomer, symmetry, subunitOrder, pathPoints, pathNoes ):
	
	subunit = share.loadProtein( pathMonomer ).getSubunit( 0 )
	symmetryContext = jdshot.f.context.SymmetryContext( symmetry, pathMonomer, subunitOrder )
	noesContext = jdshot.f.context.NoesContext( symmetryContext, pathNoes )
	
	# convert the grid points into a list of oligomers
	oligomers = [symmetryContext.getOligomer( gridPoint ) for gridPoint in jdshot.f.grid.PointIterator( jdshot.f.grid.PointReader( pathPoints, symmetry ) )]
	
	# calculate restraint satisfaction
	for oligomer in oligomers:
		restraintCalculator = share.f.analysis.RestraintCalculator()
		noeRmsd = restraintCalculator.getNoeRmsd( oligomer, noesContext.getRestraints() )
		numNoesSatisfied = restraintCalculator.getNumSatisfied( oligomer, noesContext.getRestraints() )
		print "%0.2f\t%d" % ( noeRmsd, numNoesSatisfied )
		
	# build a kinemage
	#share.saveStructureKinemage( pathKinemage, oligomers[0], noesContext.getRestraints() )


dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results"
try:

	# DAGK
	run(
		dirResults + "/DAGK/oligomers.kin",
		dirResults + "/DAGK/transformedMonomer.protein",
		jdshot.Cn,
		SubunitOrder( "ACB" ),
		dirResults + "/DAGK/out.points",
		dirResults + "/DAGK/consistent.noe"
	)
	
except jpype.JavaException as ex:
	import sys
	print >> sys.stderr, "Java Exception: %s\n" % ex
	print >> sys.stderr, ex.stacktrace()
	raise

