/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.nmr;

import java.util.Set;

import edu.duke.donaldLab.share.io.Transformer;
import edu.duke.donaldLab.share.nmr.DistanceRestraint;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestDistanceRestraint extends ExtendedTestCase
{
	public void testCopyConstructor( )
	{
		DistanceRestraint<AtomAddressInternal> restraint = new DistanceRestraint<AtomAddressInternal>();
		restraint.setMinDistance( 1.0 );
		restraint.setMaxDistance( 2.0 );
		restraint.setLefts( new AtomAddressInternal( 1, 2, 3 ) );
		restraint.setRights( new AtomAddressInternal( 6, 5, 4 ) );
		
		DistanceRestraint<AtomAddressInternal> newRestraint = new DistanceRestraint<AtomAddressInternal>( restraint );
		assertNotSame( restraint, newRestraint );
		assertEquals( restraint, newRestraint );
	}
	
	public void testEquals( )
	{
		DistanceRestraint<AtomAddressInternal> a = new DistanceRestraint<AtomAddressInternal>();
		a.setMinDistance( 1.0 );
		a.setMaxDistance( 2.0 );
		a.setLefts( new AtomAddressInternal( 1, 2, 3 ) );
		a.setRights( new AtomAddressInternal( 6, 5, 4 ) );
		
		DistanceRestraint<AtomAddressInternal> b = new DistanceRestraint<AtomAddressInternal>();
		b.setMinDistance( 1.0 );
		b.setMaxDistance( 2.0 );
		b.setLefts( new AtomAddressInternal( 1, 2, 3 ) );
		b.setRights( new AtomAddressInternal( 6, 5, 4 ) );
		
		assertNotSame( a, b );
		assertTrue( a.equals( b ) );
		assertTrue( b.equals( a ) );
		
		b.setMaxDistance( 3.0 );
		
		assertFalse( a.equals( b ) );
		assertFalse( b.equals( a ) );
	}
	
	public void testEqualsAddresses( )
	{
		assertTrue(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 2, 2, 3 )
			) ).equals(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 2, 2, 3 )
			) ) )
		);

		// swap sides
		assertTrue(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 2, 2, 3 )
			) ).equals(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 2, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			) ) )
		);
		
		assertFalse(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 2, 2, 3 )
			) ).equals(
			newRestraint( Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			), Transformer.toTreeSet(
				new AtomAddressInternal( 1, 2, 3 )
			) ) )
		);
	}
	
	private DistanceRestraint<AtomAddressInternal> newRestraint( Set<AtomAddressInternal> lefts, Set<AtomAddressInternal> rights )
	{
		DistanceRestraint<AtomAddressInternal> restraint = new DistanceRestraint<AtomAddressInternal>();
		restraint.setMinDistance( 1.0 );
		restraint.setMaxDistance( 2.0 );
		restraint.setLefts( lefts );
		restraint.setRights( rights );
		return restraint;
	}
}
