/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.protein.tools;

import java.util.Iterator;

import edu.duke.donaldLab.share.geom.Vector3;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.protein.Protein;
import edu.duke.donaldLab.share.protein.Subunit;

public class AtomPositionIterator implements Iterator<Vector3>
{
	/**************************
	 *   Data Members
	 **************************/
	
	private Protein m_protein;
	private Subunit m_subunit;
	private Iterator<AtomAddressInternal> m_iter;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public AtomPositionIterator( Protein protein )
	{
		this( protein, protein.getAtomIndex() );
	}
	
	public AtomPositionIterator( Protein protein, Iterator<AtomAddressInternal> iter )
	{
		m_protein = protein;
		m_subunit = null;
		m_iter = iter;
	}
	
	public AtomPositionIterator( Subunit subunit )
	{
		this( subunit, subunit.getAtomIndex().iterator() );
	}
	
	public AtomPositionIterator( Subunit subunit, Iterator<AtomAddressInternal> iter )
	{
		m_protein = null;
		m_subunit = subunit;
		m_iter = iter;
	}
	

	
	/**************************
	 *   Methods
	 **************************/
	
	public boolean hasNext( )
	{
		return m_iter.hasNext();
	}
	
	public Vector3 next( )
	{
		if( m_protein != null )
		{
			return m_protein.getAtom( m_iter.next() ).getPosition();
		}
		
		if( m_subunit != null )
		{
			return m_subunit.getAtom( m_iter.next() ).getPosition();
		}
		
		return null;
	}
	
	public void remove( )
	{
		m_iter.remove();
	}
}
