/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.nmr;

import java.util.ArrayList;
import java.util.List;

import edu.duke.donaldLab.share.mapping.AddressMapper;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.protein.AtomAddressReadable;
import edu.duke.donaldLab.share.protein.Protein;

public class RdcMapper
{
	/**************************
	 *   Static Methods
	 **************************/
	
	public static ArrayList<Rdc<AtomAddressInternal>> mapReadableToInternal( Protein protein, List<Rdc<AtomAddressReadable>> readables )
	{
		return mapReadableToInternal( protein, readables, false );
	}
	
	public static ArrayList<Rdc<AtomAddressInternal>> mapReadableToInternal( Protein protein, List<Rdc<AtomAddressReadable>> readables, boolean addNulls )
	{
		ArrayList<Rdc<AtomAddressInternal>> internals = new ArrayList<Rdc<AtomAddressInternal>>( readables.size() );
		for( Rdc<AtomAddressReadable> readable : readables )
		{
			Rdc<AtomAddressInternal> rdc = mapReadableToInternal( protein, readable );
			if( rdc != null || addNulls )
			{
				internals.add( rdc );
			}
		}
		return internals;
	}
	
	public static Rdc<AtomAddressInternal> mapReadableToInternal( Protein protein, Rdc<AtomAddressReadable> readable )
	{
		List<AtomAddressInternal> froms = AddressMapper.mapAddress( protein, readable.getFrom() );
		List<AtomAddressInternal> tos = AddressMapper.mapAddress( protein, readable.getTo() );
		if( froms.size() != 1 || tos.size() != 1 )
		{
			return null;
		}
		Rdc<AtomAddressInternal> internal = new Rdc<AtomAddressInternal>( froms.get( 0 ), tos.get( 0 ) );
		internal.setValue( readable.getValue() );
		internal.setError( readable.getError() );
		return internal;
	}
	
	public static ArrayList<Rdc<AtomAddressReadable>> mapInternalToReadable( Protein protein, List<Rdc<AtomAddressInternal>> internals )
	{
		ArrayList<Rdc<AtomAddressReadable>> readables = new ArrayList<Rdc<AtomAddressReadable>>( internals.size() );
		for( Rdc<AtomAddressInternal> internal : internals )
		{
			readables.add( mapInternalToReadable( protein, internal ) );
		}
		return readables;
	}	
	
	public static Rdc<AtomAddressReadable> mapInternalToReadable( Protein protein, Rdc<AtomAddressInternal> internal )
	{
		Rdc<AtomAddressReadable> readable = new Rdc<AtomAddressReadable>(
			AddressMapper.mapAddress( protein, internal.getFrom() ),
			AddressMapper.mapAddress( protein, internal.getTo() )
		);
		readable.setValue( internal.getValue() );
		readable.setError( internal.getError() );
		return readable;
	}
}
