/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test;

import java.util.ArrayList;

import edu.duke.donaldLab.jdshot.TestMain;
import edu.duke.donaldLab.jdshot.grid.GridCell;
import edu.duke.donaldLab.jdshot.grid.GridPoint;
import edu.duke.donaldLab.jdshot.grid.Symmetry;
import edu.duke.donaldLab.share.math.CompareReal;

public class ExtendedTestCase extends edu.duke.donaldLab.share.test.ExtendedTestCase
{
	protected void assertEquals( GridPoint expected, GridPoint observed )
	{
		assertEquals( expected.getClass(), observed.getClass() );
		for( int i=0; i<expected.getSymmetry().getNumDimensions(); i++ )
		{
			assertEquals( expected.get( i ), observed.get( i ), CompareReal.getEpsilon() );
		}
	}
	
	protected void assertEquals( GridCell expected, GridCell observed )
	{
		assertEquals( expected.getMin(), observed.getMin() );
		assertEquals( expected.getMax(), observed.getMax() );
	}
	
	protected void assertEqualsAngle( double expected, double observed )
	{
		// normalize the angles
		if( CompareReal.gte( expected, 2.0 * Math.PI ) )
		{
			expected -= 2.0 * Math.PI;
		}
		if( CompareReal.gte( observed, 2.0 * Math.PI ) )
		{
			observed -= 2.0 * Math.PI;
		}
		
		assertEquals( expected, observed, CompareReal.getEpsilon() );
	}
	
	protected GridPoint getRandomGridPoint( )
	{
		Symmetry symmetry = TestMain.getSearchContext().getSymmetry();
		GridPoint point = symmetry.newGridPoint();
		
		// get our scs
		GridCell bound = TestMain.getSearchContext().getSearchSpace().getConfigurationSpace();
		for( int i=0; i<symmetry.getNumDimensions(); i++ )
		{
			point.set( i, getRandomDouble( bound.getMin().get( i ), bound.getMax().get( i ) ) );
		}
		
		return point;
	}
	
	protected GridCell getRandomGridCell( )
	{
		Symmetry symmetry = TestMain.getSearchContext().getSymmetry();
		GridCell cell = symmetry.newGridCell();
		cell.setMin( getRandomGridPoint( ) );
		cell.setMax( getRandomGridPoint( ) );
		return cell;
	}
	
	protected ArrayList<GridCell> getRandomGridCells( int numCells )
	{
		ArrayList<GridCell> cells = new ArrayList<GridCell>( numCells );
		for( int i=0; i<numCells; i++ )
		{
			cells.add( getRandomGridCell() );
		}
		return cells;
	}
}
