/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.minimize.messages;

import java.io.Serializable;

import edu.duke.donaldLab.share.mpi.Message;

public class ScoreReport extends Message
{
	/**************************
	 *   Definitions
	 **************************/
	
	private static final long serialVersionUID = 6672499923049784504L;
	
	public class Sample implements Serializable
	{
		private static final long serialVersionUID = -4612076406952862005L;
		
		public double vdwEnergy;
		public double restraintRmsd;
		public int numSatisfied;
		
		public Sample( )
		{
			vdwEnergy = Double.NaN;
			restraintRmsd = Double.NaN;
			numSatisfied = -1;
		}
	}
	

	/**************************
	 *   Fields
	 **************************/
	
	public int id;
	public Sample before;
	public Sample after;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public ScoreReport( )
	{
		id = -1;
		before = new Sample();
		after = new Sample();
	}
}
