/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.disco.cgal;

import java.util.Iterator;

public class HalfedgeIterator extends AbstractCleanable implements Iterator<Halfedge>
{
	/**************************
	 *   Data Members
	 **************************/
	
	private static Cleaner m_cleaner;
	
	@SuppressWarnings( "unused" )
	private Face m_face;
	@SuppressWarnings("unused")
	private Hole m_hole;
	private boolean m_isTransient;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	static
	{
		m_cleaner = new Cleaner( )
		{
			@Override
			public void cleanup( int id )
			{
				HalfedgeIterator.cleanup( id );
			}
		};
	}
	
	public HalfedgeIterator( Face face )
	{
		this( face, false );
	}
	
	public HalfedgeIterator( Face face, boolean isTransient )
	{
		super( m_cleaner );
		m_face = face;
		m_hole = null;
		m_isTransient = isTransient;
		ShotCgal.addReference( this, m_cleaner );
		init();
	}
	
	public HalfedgeIterator( Hole hole )
	{
		this( hole, false );
	}
	
	public HalfedgeIterator( Hole hole, boolean isTransient )
	{
		super( m_cleaner );
		m_face = null;
		m_hole = hole;
		m_isTransient = isTransient;
		ShotCgal.addReference( this, m_cleaner );
		init();
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public boolean isTransient( )
	{
		return m_isTransient;
	}
	

	/**************************
	 *   Static Methods
	 **************************/
	
	public static native void cleanup( int id );
	
	
	/**************************
	 *   Methods
	 **************************/
	
	@Override
	public native boolean hasNext( );

	@Override
	public native Halfedge next( );
	
	@Override
	public void remove( )
	{
		throw new UnsupportedOperationException();
	}
	
	
	/**************************
	 *   Functions
	 **************************/
	
	private native void init( );
}
