#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import numpy
from Struct import Struct
from figure import Figure


def loadData( pathIn ):
	( a, b, c ) = numpy.loadtxt( pathIn, usecols=(4,5,6), unpack=True )
	return Struct(
		energies = a,
		rmsds = b,
		satisfied = c
	)


def run( pathOutRmsd, pathOutSatisfied, pathInComputed, pathInReference ):
	
	# read in data
	computed = loadData( pathInComputed )
	reference = loadData( pathInReference )
	
	# do energy vs rmsd
	fig = Figure()
	fig.plot.scatter( computed.energies, computed.rmsds, marker='d', c="#004586", s=160, label="Computed", zorder=4 ) 
	fig.plot.scatter( reference.energies, reference.rmsds, marker='^', c="#ff420e", s=210, label="Reference", zorder=4 )
	fig.plot.legend( scatterpoints=1, fancybox=True, loc="lower right", handletextpad=0 )
	fig.plot.grid( c="#999999" )
	fig.plot.set_xlabel( "van der Waals Energy (kcal/mol)" )
	fig.plot.set_ylabel( u"Distance Restraint RMSD (\u212B)" )
	fig.save( pathOutRmsd )
	
	# calculate the xticks so they look good
	minY = int( min( computed.satisfied.min(), reference.satisfied.min() ) )
	maxY = int( max( computed.satisfied.max(), reference.satisfied.max() ) )
	maxY = maxY + 2
	minY = minY - 1
	yticks = range( minY, maxY )
	
	# energy vs num satisfied
	fig = Figure()
	fig.plot.scatter( computed.energies, computed.satisfied, marker='d', c="#004586", s=40, label="Computed", zorder=4 ) 
	fig.plot.scatter( reference.energies, reference.satisfied, marker='^', c="#ff420e", s=80, label="Reference", zorder=4 )
	fig.plot.legend( scatterpoints=1, fancybox=True, loc="lower right", handletextpad=0 )
	fig.plot.grid( c="#999999" )
	fig.plot.set_xlabel( "van der Waals Energy (kcal/mol)" )
	fig.plot.set_ylabel( u"Number of Distance Restraints Satisfied" )
	fig.plot.set_yticks( yticks )
	fig.save( pathOutSatisfied )
	
	print "Done!"
	

# set up paths
dirResults = "/home/jeff/duke/donaldLab/workspace/jdshot/output"

# DAGK
path = dirResults + "/dagk/minimized"
run(
	path + "/energyVsNoeRmsd.pdf",
	path + "/energyVsNoeSatisfied.pdf",
	path + "/scores.txt",
	path + "/scoresReference.txt"
)

# GB1
#path = dirResults + "/gb1/minimized"
#run(
#	path + "/energyVsNoeRmsd.pdf",
#	path + "/energyVsNoeSatisfied.pdf",
#	path + "/scores.txt",
#	path + "/scoresReference.txt"
#)
