#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import sys
sys.path.insert( 1, "lib" )
import disco


###########################
# Input Parameters
###########################

# folder in which to write generated output files
outputFolder = "output/recombGb1"

# path to the PDB file describing the subunit structure ensemble
pathInSubunitEnsemble = "input/1Q10.subunitEnsemble.pdb"

# number of subunits in the oligomeric state
numSubunits = 2

# path to the MR file describing the RDCs
#-- this file must only contain RDCs
pathInRdcs = "input/1Q10.rdcs.mr"

# path to the MR file describing the distance restraints
#-- this file must only contain distance restraints
pathInDistanceRestraints = "input/1Q10.noes.reassigned.mr"

# resolution (in degrees) of search grid for symmetry axis orientation
#-- smaller resolutions can evaluate more orientations, which can take much longer
#-- a value of 0 disables the local orientation search
orientationSamplingResolution = 0.0

# resolution (in Angstroms) of search grid for symmetry axis position
#-- smaller resolutions can result in a greater number of more similar oligomer structures
positionSamplingResolution = 0.005

# for dimers, supply the axis of the alignment tensor (x, y, or z) to use as the symmetry axis orientation
#-- the discoDimerAlignmentTensorAxis.py script can help you choose the best axis
alignmentTensorAxis = disco.AlignmentTensorAxis.X

# padding method to apply to the trusted distance restraints:
# a value of None calculates the padding automatically from the variation in the subunit ensemble
# a value of 0.0 uses the distance restraints without padding
# a number greater than 0.0 up to 1.0 applies a fixed percentage padding
#-- The padding percentage (a) alters the upper (u) and lower (l) bounds of each
#-- distance restraint in the following way:
#-- l *= ( 1 - a )
#-- u *= ( 1 + a )
trustedPaddingPercent = 0.0

# number of threads/processes to be used for parallel computations
#-- Structure minimization and MSR calculation can be computationally-expensive.
#-- Compute time can be reduced by using multiple threads or processes to take advantage of parallel hardware.
#-- For best performance, the number of threads should equal the number of CPU cores (or slightly fewer)
numProcesses = 2


###########################
# run DISCO
###########################

import jpype
try:
	disco.run(
		outputFolder,
		pathInSubunitEnsemble,
		numSubunits,
		pathInRdcs,
		pathInDistanceRestraints,
		orientationSamplingResolution,
		positionSamplingResolution,
		alignmentTensorAxis = alignmentTensorAxis,
		trustedPaddingPercent = trustedPaddingPercent,
		numMinimizationProcesses = numProcesses,
		numMsrsProcesses = numProcesses
	)
	
except jpype.JavaException as ex:
	import sys
	print >> sys.stderr, "Java Exception: %s\n" % ex
	print >> sys.stderr, ex.stacktrace()
	raise
