#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import sys
sys.path.insert( 1, "lib" )
import disco


###########################
# Input Parameters
###########################

# folder in which to write generated output files
pathOutReassignedNoes = "output/gb1ReassignedNoes/1Q10.noes.reassigned.mr"

# path to the PDB file describing the subunit structure
pathInSubunit = "input/1Q10.subunitEnsemble.pdb"

# path to the MR file describing the NOEs
#-- this file must only contain NOEs
pathInNoes = "input/1Q10.noes.fixed.mr"

# path to the file describing the chemical shifts
#-- this file must only contain records such as the following:
#-- 4  1 MET HB3  H   2.2144 0.02 2 
pathInChemicalShifts = "input/1Q10.chemicalShifts"

# number of subunits in the oligomeric state
numSubunits = 2

# similarity thresholds for chemical shifts in ppm
#-- two chemical shifts a,b are considered similar if |a-b| < x, where x is the window size
hydrogenWindowSize = 0.05
carbonWindowSize = 0.5
nitrogenWindowSize = 0.5


###########################
# run DISCO
###########################

import jpype
try:
	disco.reassignNoes(
		pathOutReassignedNoes,
		pathInSubunit,
		pathInNoes,
		pathInChemicalShifts,
		numSubunits,
		hydrogenWindowSize,
		carbonWindowSize,
		nitrogenWindowSize
	)
	
except jpype.JavaException as ex:
	import sys
	print >> sys.stderr, "Java Exception: %s\n" % ex
	print >> sys.stderr, ex.stacktrace()
	raise
